/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.ResultSetNode;
import com.akiban.sql.parser.TableOperatorNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;
import java.util.Properties;

public class JoinNode
extends TableOperatorNode {
    private boolean naturalJoin;
    private ValueNode joinClause;
    private ResultColumnList usingClause;
    private Properties joinOrderStrategyProperties;

    @Override
    public void init(Object leftResult, Object rightResult, Object onClause, Object usingClause, Object selectList, Object tableProperties, Object joinOrderStrategyProperties) throws StandardException {
        super.init(leftResult, rightResult, tableProperties);
        this.resultColumns = (ResultColumnList)selectList;
        this.joinClause = (ValueNode)onClause;
        this.usingClause = (ResultColumnList)usingClause;
        this.joinOrderStrategyProperties = (Properties)joinOrderStrategyProperties;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        JoinNode other = (JoinNode)node;
        this.naturalJoin = other.naturalJoin;
        this.joinClause = (ValueNode)this.getNodeFactory().copyNode(other.joinClause, this.getParserContext());
        this.usingClause = (ResultColumnList)this.getNodeFactory().copyNode(other.usingClause, this.getParserContext());
        this.joinOrderStrategyProperties = other.joinOrderStrategyProperties;
    }

    public static String joinTypeToString(JoinType joinType) {
        switch (joinType) {
            case INNER: {
                return "INNER JOIN";
            }
            case CROSS: {
                return "CROSS JOIN";
            }
            case LEFT_OUTER: {
                return "LEFT OUTER JOIN";
            }
            case RIGHT_OUTER: {
                return "RIGHT OUTER JOIN";
            }
            case FULL_OUTER: {
                return "FULL OUTER JOIN";
            }
            case UNION: {
                return "UNION JOIN";
            }
        }
        assert (false) : "Unexpected joinType";
        return null;
    }

    public ValueNode getJoinClause() {
        return this.joinClause;
    }

    public void setJoinClause(ValueNode joinClause) {
        this.joinClause = joinClause;
    }

    public ResultColumnList getUsingClause() {
        return this.usingClause;
    }

    public void setUsingClause(ResultColumnList usingClause) {
        this.usingClause = usingClause;
    }

    @Override
    public String toString() {
        String str = super.toString();
        if (this.naturalJoin) {
            str = "naturalJoin: " + this.naturalJoin + "\n" + str;
        }
        if (this.joinOrderStrategyProperties != null) {
            str = "joinOrderStrategyProperties: " + this.joinOrderStrategyProperties + "\n" + str;
        }
        return str;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.joinClause != null) {
            this.printLabel(depth, "joinClause: ");
            this.joinClause.treePrint(depth + 1);
        }
        if (this.usingClause != null) {
            this.printLabel(depth, "usingClause: ");
            this.usingClause.treePrint(depth + 1);
        }
    }

    void setNaturalJoin() {
        this.naturalJoin = true;
    }

    public boolean isNaturalJoin() {
        return this.naturalJoin;
    }

    public ResultSetNode getLogicalLeftResultSet() {
        return this.leftResultSet;
    }

    public ResultSetNode getLogicalRightResultSet() {
        return this.rightResultSet;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.resultColumns != null) {
            this.resultColumns = (ResultColumnList)this.resultColumns.accept(v);
        }
        if (this.joinClause != null) {
            this.joinClause = (ValueNode)this.joinClause.accept(v);
        }
        if (this.usingClause != null) {
            this.usingClause = (ResultColumnList)this.usingClause.accept(v);
        }
    }

    public static enum JoinType {
        INNER,
        CROSS,
        LEFT_OUTER,
        RIGHT_OUTER,
        FULL_OUTER,
        UNION,
        STRAIGHT;

    }
}

