/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.AggregateNode;
import com.akiban.sql.parser.OrderByList;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;

public class GroupConcatNode
extends AggregateNode {
    private String sep;
    private OrderByList orderCols;

    @Override
    public void init(Object value, Object aggClass, Object distinct, Object aggName, Object orderCols, Object sep) throws StandardException {
        super.init(value, aggClass, distinct, aggName);
        this.orderCols = (OrderByList)orderCols;
        this.sep = (String)sep;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        GroupConcatNode other = (GroupConcatNode)node;
        this.sep = other.sep;
        this.orderCols = (OrderByList)this.getNodeFactory().copyNode(other.orderCols, this.getParserContext());
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.orderCols != null) {
            this.orderCols.acceptChildren(v);
        }
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeType(o)) {
            return false;
        }
        GroupConcatNode other = (GroupConcatNode)o;
        return this.sep.equals(other.sep) && this.orderCols.equals(other.orderCols);
    }

    @Override
    public String toString() {
        return super.toString() + "\nseparator: " + this.sep + "\norderyByList: " + this.orderCols;
    }

    public String getSeparator() {
        return this.sep;
    }

    public OrderByList getOrderBy() {
        return this.orderCols;
    }
}

