/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.ValueNodeList;
import com.akiban.sql.parser.Visitor;

public abstract class BinaryListOperatorNode
extends ValueNode {
    protected String methodName;
    protected String operator;
    protected ValueNode leftOperand;
    protected ValueNodeList rightOperandList;

    @Override
    public void init(Object leftOperand, Object rightOperandList, Object operator, Object methodName) {
        this.leftOperand = (ValueNode)leftOperand;
        this.rightOperandList = (ValueNodeList)rightOperandList;
        this.operator = (String)operator;
        this.methodName = (String)methodName;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        BinaryListOperatorNode other = (BinaryListOperatorNode)node;
        this.methodName = other.methodName;
        this.operator = other.operator;
        this.leftOperand = (ValueNode)this.getNodeFactory().copyNode(other.leftOperand, this.getParserContext());
        this.rightOperandList = (ValueNodeList)this.getNodeFactory().copyNode(other.rightOperandList, this.getParserContext());
    }

    @Override
    public String toString() {
        return "operator: " + this.operator + "\n" + "methodName: " + this.methodName + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.rightOperandList != null) {
            this.printLabel(depth, "rightOperandList: ");
            this.rightOperandList.treePrint(depth + 1);
        }
    }

    public void setLeftOperand(ValueNode newLeftOperand) {
        this.leftOperand = newLeftOperand;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperandList(ValueNodeList newRightOperandList) {
        this.rightOperandList = newRightOperandList;
    }

    public ValueNodeList getRightOperandList() {
        return this.rightOperandList;
    }

    @Override
    public boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperandList.isConstantExpression();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        if (this.rightOperandList != null) {
            this.rightOperandList = (ValueNodeList)this.rightOperandList.accept(v);
        }
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeType(o)) {
            return false;
        }
        BinaryListOperatorNode other = (BinaryListOperatorNode)o;
        if (!this.operator.equals(other.operator) || !this.leftOperand.isEquivalent(other.getLeftOperand())) {
            return false;
        }
        return this.rightOperandList.isEquivalent(other.rightOperandList);
    }
}

