/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config;

import com.neeve.config.ConfigObject;
import com.neeve.config.ConfigProviderRegistry;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.env.Env;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class ConfigRepositoryFactory
extends ConfigObject {
    private static final ConfigRepositoryFactory instance;
    private IConfigRepository defaultRepo;
    public static final String DEFAULT_REPO_DESCRIPTOR;
    private static final String MEMORY_CONFIG_DESCRIPTOR = "mem://.";

    private ConfigRepositoryFactory() {
    }

    public static final ConfigRepositoryFactory getInstance() {
        return instance;
    }

    private final List<BufferedInputStream> getEmbeddedRepositories() {
        ArrayList<BufferedInputStream> repos = new ArrayList<BufferedInputStream>();
        try {
            this.tracer.log("Looking for config repositories in the classpath", Tracer.Level.VERBOSE);
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource resource : resolver.getResources("classpath*:/META-INF/repo/*.repo")) {
                this.tracer.log("...found repo '" + resource.getFilename() + "'.", Tracer.Level.VERBOSE);
                repos.add(new BufferedInputStream(resource.getURL().openStream()));
            }
            this.tracer.log("...found a total of " + repos.size() + " repo(s)", Tracer.Level.VERBOSE);
        }
        catch (IOException e) {
            this.tracer.log("Failure encountered while getting embedded repositories [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
            e.printStackTrace();
            System.exit(0);
        }
        return repos;
    }

    private final byte[] toByteArray(BufferedInputStream bin) throws IOException {
        int len;
        byte[] array = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((len = bin.read(array, 0, array.length)) >= 0) {
            baos.write(array, 0, len);
        }
        return baos.toByteArray();
    }

    final IConfigRepository createRepository(String descriptorStr) throws EConfigException {
        if (descriptorStr == null) {
            throw new IllegalArgumentException("descriptor string cannot be null");
        }
        UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse(descriptorStr, null);
        return ConfigProviderRegistry.getInstance().getProvider(descriptor.type).createRepository(descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IConfigRepository openRepository(String descriptorStr, boolean initializeFromEmbedded) throws EConfigException {
        List<BufferedInputStream> bins;
        if (descriptorStr == null) {
            throw new IllegalArgumentException("descriptor string cannot be null");
        }
        UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse(descriptorStr, null);
        IConfigRepository repo = ConfigProviderRegistry.getInstance().getProvider(descriptor.type).openRepository(descriptor);
        if (initializeFromEmbedded && (bins = this.getEmbeddedRepositories()).size() > 0) {
            try {
                this.tracer.log("Initializing configuration repository using the " + bins.size() + " embedded repositories found on classpath.", Tracer.Level.INFO);
                for (BufferedInputStream bin : bins) {
                    try {
                        repo.deserialize(new String(this.toByteArray(bin), "UTF-8"), false);
                    }
                    finally {
                        bin.close();
                    }
                }
            }
            catch (Exception e) {
                this.tracer.log("Failed to initialize config repository '" + descriptorStr + "' using embedded repositories [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                e.printStackTrace();
                System.exit(0);
            }
        }
        return repo;
    }

    final IConfigRepository openRepository(String descriptorStr) throws EConfigException {
        return this.openRepository(descriptorStr, true);
    }

    final boolean repositoryExists(String descriptorStr) throws EConfigException {
        if (descriptorStr == null) {
            throw new IllegalArgumentException("descriptor string cannot be null");
        }
        UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse(descriptorStr, null);
        return ConfigProviderRegistry.getInstance().getProvider(descriptor.type).repositoryExists(descriptor);
    }

    final synchronized IConfigRepository getDefaultRepository() {
        if (this.defaultRepo != null) {
            return this.defaultRepo;
        }
        if (this.tracer.debug) {
            this.tracer.log("Initializing default configuration repository...", Tracer.Level.DEBUG);
        }
        try {
            boolean defaultRepoExists;
            try {
                defaultRepoExists = this.repositoryExists(DEFAULT_REPO_DESCRIPTOR);
                if (this.tracer.debug) {
                    this.tracer.log("Default repository exists = " + defaultRepoExists + ".", Tracer.Level.DEBUG);
                }
            }
            catch (EConfigException e) {
                this.tracer.log("Failure encountered while checking for existence of default repository '" + DEFAULT_REPO_DESCRIPTOR + "' [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                throw new Error(e);
            }
            String defaultRepoDescriptor = defaultRepoExists ? DEFAULT_REPO_DESCRIPTOR : MEMORY_CONFIG_DESCRIPTOR;
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Opening single configuration repository '" + defaultRepoDescriptor + "'...", Tracer.Level.DEBUG);
                }
                this.defaultRepo = this.openRepository(defaultRepoDescriptor);
            }
            catch (EConfigException e) {
                this.tracer.log("Failed to open default configuration repository '" + defaultRepoDescriptor + "' [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                throw new Error(e);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(0);
        }
        return this.defaultRepo;
    }

    final synchronized void resetDefaultRepository() {
        this.defaultRepo = null;
    }

    static {
        DEFAULT_REPO_DESCRIPTOR = Env.getValue("nv.config.descriptor", MEMORY_CONFIG_DESCRIPTOR);
        instance = new ConfigRepositoryFactory();
    }
}

