/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.runtime;

import com.neeve.adm.runtime.AdmRuntimeConfig;
import com.neeve.adm.runtime.EAdmCompatibilityException;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.config.Config;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;

public class AdmCompatibility {
    public static final String PROP_DISABLE_COMPATIBILITY_CHECKS = "nv.adm.disablecompatcheck";
    public static final String COMPATIBILITY_LEVEL = "5.0.0";
    private static final Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)AdmRuntimeConfig.getConfig());
    private static final ProductInfo PLATFORM_INFO = ManifestProductInfo.loadProductInfo((String)"nvx-rumi-adm");
    private static final boolean DISABLE_COMPAT_CHECK = Config.getValue((String)"nv.adm.disablecompatcheck", (boolean)false);

    public static final void assertRuntimeCompatibility(String platformCompatLevel, Class<?> type) {
        AdmGenerated annotation = type.getAnnotation(AdmGenerated.class);
        if (annotation != null) {
            if (!AdmCompatibility.isRuntimeCompatible(platformCompatLevel, annotation.compatLevel())) {
                String error = type.getCanonicalName() + " generated with ADM '" + annotation.admVersion() + "' and a compatibility level of '" + annotation.compatLevel() + "' is not compatible with platform version '" + PLATFORM_INFO.getComponentVersionString() + "' with a compatibility level of '" + platformCompatLevel + "'";
                if (!DISABLE_COMPAT_CHECK) {
                    throw new EAdmCompatibilityException(error);
                }
                tracer.log(error, Tracer.Level.WARNING);
            }
        } else {
            tracer.log(type.getCanonicalName() + " is not an ADM generated class ... skipping ADM compatibility check.", Tracer.Level.VERBOSE);
        }
    }

    public static final void assertRuntimeCompatibility(String platformCompatLevel, Object object) {
        AdmCompatibility.assertRuntimeCompatibility(platformCompatLevel, object.getClass());
    }

    public static final boolean isRuntimeCompatible(String platformCompatLevel, String admCompatLevel) {
        int aMinor;
        String[] admParts;
        if (platformCompatLevel == null) {
            throw new IllegalArgumentException("Platform compatibility level can't be null");
        }
        if (admCompatLevel == null) {
            throw new IllegalArgumentException("ADM compatibility level can't be null");
        }
        String[] platformParts = platformCompatLevel.split("\\.");
        if (platformParts[0].compareTo((admParts = admCompatLevel.split("\\."))[0]) != 0) {
            return false;
        }
        int pMinor = Integer.parseInt(platformParts.length > 1 ? platformParts[1] : "0");
        return pMinor >= (aMinor = Integer.parseInt(admParts.length > 1 ? admParts[1] : "0"));
    }

    public static void getAdmGenerationDetails(Class<?> candidate, StringBuilder builder) {
        AdmGenerated admGenerated = candidate.getAnnotation(AdmGenerated.class);
        if (admGenerated != null) {
            builder.append("ADM generated (");
            builder.append("encoding=").append(admGenerated.encoding());
            builder.append(", compatLevel=").append(admGenerated.compatLevel());
            builder.append(", buildDate=").append(admGenerated.date());
            builder.append(", admVersion=").append(admGenerated.admVersion());
            builder.append(", buildInfo=").append(admGenerated.buildInfo());
            builder.append(")");
        } else {
            builder.append("Not ADM generated.");
        }
    }
}

