/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmArray;
import com.neeve.adm.AdmBooleanArray;
import com.neeve.adm.AdmByteArray;
import com.neeve.adm.AdmCharArray;
import com.neeve.adm.AdmCurrencyArray;
import com.neeve.adm.AdmDateArray;
import com.neeve.adm.AdmDoubleArray;
import com.neeve.adm.AdmFloatArray;
import com.neeve.adm.AdmIntegerArray;
import com.neeve.adm.AdmLongArray;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmShortArray;
import com.neeve.adm.AdmStringArray;
import com.neeve.adm.AdmType;
import com.neeve.adm.AdmUUIDArray;

public abstract class AdmPrimitiveArray
extends AdmArray {
    private final AdmPrimitive.Type type;

    protected AdmPrimitiveArray(String name, AdmPrimitive.Type type) {
        super(null, name);
        this.type = type;
    }

    @Override
    public final AdmType getComponentType() {
        return AdmPrimitive.toPrimitiveType(this.type);
    }

    public static final AdmPrimitiveArray toPrimitiveArrayType(AdmPrimitive.Type type) {
        switch (type) {
            case Byte: {
                return new AdmByteArray();
            }
            case Short: {
                return new AdmShortArray();
            }
            case Integer: {
                return new AdmIntegerArray();
            }
            case Long: {
                return new AdmLongArray();
            }
            case Float: {
                return new AdmFloatArray();
            }
            case Double: {
                return new AdmDoubleArray();
            }
            case Boolean: {
                return new AdmBooleanArray();
            }
            case String: {
                return new AdmStringArray();
            }
            case Char: {
                return new AdmCharArray();
            }
            case Date: {
                return new AdmDateArray();
            }
            case Currency: {
                return new AdmCurrencyArray();
            }
            case UUID: {
                return new AdmUUIDArray();
            }
        }
        throw new IllegalArgumentException("unknown primitive type '" + (Object)((Object)type) + "'");
    }

    public final AdmPrimitive.Type getType() {
        return this.type;
    }

    @Override
    public String getJavaTypeName() {
        if (this.type == AdmPrimitive.Type.Char) {
            return "Character[]";
        }
        return this.getName();
    }

    @Override
    public String getPrimitiveTypeName() {
        switch (this.type) {
            case Boolean: {
                return "boolean[]";
            }
            case Byte: {
                return "byte[]";
            }
            case Char: {
                return "char[]";
            }
            case Double: {
                return "double[]";
            }
            case Float: {
                return "float[]";
            }
            case Integer: {
                return "int[]";
            }
            case Long: {
                return "long[]";
            }
            case Short: {
                return "short[]";
            }
        }
        return this.getJavaTypeName();
    }

    @Override
    public String getTemplatedPrimitiveTypeName() {
        switch (this.type) {
            case Byte: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case Char: {
                return this.getPrimitiveTypeName();
            }
        }
        return this.type.getTemplatedPrimitiveTypeName() + "[]";
    }

    public boolean isWrappedPrimitive() {
        switch (this.type) {
            case Byte: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case Char: {
                return true;
            }
        }
        return false;
    }
}

