/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmScopedType;
import com.neeve.adm.EAdmException;

public abstract class AdmFactoryType
extends AdmScopedType {
    private final AdmFactory factory;
    private final int id;

    protected AdmFactoryType(AdmModel model, String namespace, String name, AdmFactory factory, int id) throws EAdmException {
        super(model, namespace, name);
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (id < 0 || id > Short.MAX_VALUE) {
            throw new EAdmException("a type's id must be between 0 and 32767 both inclusive", this.getCodeSource());
        }
        this.factory = factory;
        this.id = id;
    }

    public static final String toFirstLetterUppercase(String str) {
        return str.length() == 1 ? str.toUpperCase() : str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    public static final String toFirstLetterLowercase(String str) {
        return str.length() == 1 ? str.toLowerCase() : str.substring(0, 1).toLowerCase() + str.substring(1, str.length());
    }

    public static final String interfaceName(AdmFactoryType type) {
        return "I" + AdmFactoryType.toFirstLetterUppercase(type.getName());
    }

    public final AdmFactory getFactory() {
        return this.factory;
    }

    public final int getId() {
        return this.id;
    }
}

