/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmModelElement;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.util.UtlText;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class AdmDocumentation
extends AdmModelElement {
    private String brief;
    private String full;
    private String modelType;

    AdmDocumentation(String modelType) {
        this.modelType = modelType;
    }

    public final String getBrief() {
        return this.brief;
    }

    public final void setBrief(String brief) {
        this.brief = brief;
    }

    public final String getFull() {
        return this.full;
    }

    public final void setFull(String full) {
        this.full = full;
    }

    public final void writeJavadocComment(AdmSourceCodeBuilder codeBuilder, String indent, String headingText, boolean newParagraph) {
        this.writeHtml(codeBuilder, indent + " * ", headingText, newParagraph);
    }

    public final void writeHtml(AdmSourceCodeBuilder codeBuilder, String linePrefix, String headingText, boolean newParagraph) {
        if (UtlText.isNullOrEmpty((String)this.brief) && UtlText.isNullOrEmpty((String)this.full)) {
            codeBuilder.last().append(linePrefix).append("Undocumented.");
            return;
        }
        if (headingText != null) {
            codeBuilder.last().append(linePrefix).append("<h2>" + headingText + "</h2>");
            codeBuilder.last().appendln();
        }
        boolean summaryClosed = false;
        if (!UtlText.isNullOrEmpty((String)this.brief)) {
            codeBuilder.last().append(linePrefix).append(UtlText.toFirstLetterUppercase((String)UtlText.removeLineBreaks((String)this.brief)));
            if (this.brief.indexOf(".") == -1) {
                codeBuilder.last().append(".");
            }
            codeBuilder.last().appendln();
            summaryClosed = true;
        }
        if (!UtlText.isNullOrEmpty((String)this.full)) {
            if (!UtlText.isNullOrEmpty((String)this.brief)) {
                codeBuilder.last().append(linePrefix).append("<p>");
                codeBuilder.last().appendln();
            }
            BufferedReader reader = new BufferedReader(new StringReader(this.full.trim()));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    codeBuilder.last().append(linePrefix).append(line.trim());
                    codeBuilder.last().appendln();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!summaryClosed && this.full.indexOf(46) == -1) {
                codeBuilder.last().append(".");
            }
        }
    }

    public final String toString() {
        StringBuilder writer = new StringBuilder();
        if (!UtlText.isNullOrEmpty((String)this.brief) || !UtlText.isNullOrEmpty((String)this.full)) {
            if (this.modelType != null) {
                writer.append(this.modelType).append(" ");
            }
            writer.append("Description:\n");
        }
        if (!UtlText.isNullOrEmpty((String)this.brief)) {
            writer.append(" " + UtlText.toFirstLetterUppercase((String)UtlText.removeLineBreaks((String)this.brief))).append("\n");
        }
        if (!UtlText.isNullOrEmpty((String)this.full)) {
            writer.append("\n");
            BufferedReader reader = new BufferedReader(new StringReader(this.full.trim()));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    writer.append(" ").append(line.trim());
                    writer.append("\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return writer.toString();
    }
}

