/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.controller;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepBusBindingDownEvent;
import com.neeve.aep.event.AepBusBindingUpEvent;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepUnhandledMessageEvent;
import com.neeve.config.Config;
import com.neeve.emx.EmxActionExecutor;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.lang.XString;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogMessage;
import com.neeve.server.admin.AdminSessionFactory;
import com.neeve.server.admin.EAdminException;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvController;
import com.neeve.server.controller.SrvControllerAdminApp;
import com.neeve.server.controller.SrvControllerObject;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.cnc.ISrvMonXvmRequest;
import com.neeve.server.mon.cnc.ISrvMonXvmResponse;
import com.neeve.server.mon.cnc.SrvMonGetLoadedAppsRequest;
import com.neeve.server.mon.cnc.SrvMonGetTraceHistoryRequest;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandRequest;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandResponse;
import com.neeve.server.mon.cnc.SrvMonListCommandsRequest;
import com.neeve.server.mon.cnc.SrvMonStartAppWatchCommand;
import com.neeve.server.mon.cnc.SrvMonStartTraceWatchRequest;
import com.neeve.server.mon.cnc.SrvMonStopAppWatchCommand;
import com.neeve.server.mon.cnc.SrvMonStopTraceWatchRequest;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.server.mon.cnc.SrvMonXvmInfoRequest;
import com.neeve.server.mon.common.ISrvMonEvent;
import com.neeve.sma.MessageBusBindingFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.SmaException;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPlist;
import com.neeve.util.UtlThrowable;
import java.lang.reflect.Array;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class SrvControllerAdminSmaClientContext
extends SrvControllerObject
implements SrvControllerAdminApp.AdminClientContext {
    private final Stats stats = new Stats();
    private final IEmxDispatcher flusher;
    private final EmxActionExecutor<Object, Object> actionExecutor;
    private final OutboundQueue oq;
    private final SrvAppLoader loader;
    private final SrvController controller;
    private final FlushAction flushAction;
    private AepEngine engine;
    private boolean flushScheduled;
    private volatile MessageChannel smaResponseChannel;
    private volatile MessageChannel smaHeartbeatsChannel;
    private volatile MessageChannel smaTraceChannel;
    private volatile MessageChannel smaEventChannel;
    private MessageChannel.RawKeyResolutionTable adminKeyResolutionTable = MessageBusBindingFactory.createRawKeyResolutionTable();
    private SrvConfigDescriptor.Admin.Sma adminOverSmaConfig;
    private boolean passiveMonitoringOnly;

    SrvControllerAdminSmaClientContext(SrvAppLoader loader) {
        this.loader = loader;
        this.controller = SrvController.getInstance(loader.getServerDescriptor());
        this.flusher = this.controller.getThreadManager().getThreadPool().getMainThread().getDispatcher();
        this.flushAction = new FlushAction();
        this.actionExecutor = new EmxActionExecutor();
        this.oq = new OutboundQueue(loader.getServerDescriptor());
    }

    @Override
    public final Stats getStats() {
        return this.stats;
    }

    @Override
    public final String getName() {
        return "Admin Over SMA";
    }

    @Override
    public final String getClientName(ISrvMonXvmRequest request) {
        if (!request.hasAdminClientId()) {
            return this.getName();
        }
        return request.getAdminClientId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <RequestType extends IRogMessage & ISrvMonXvmRequest, ResponseType extends IRogMessage & ISrvMonXvmResponse> void sendResponse(RequestType request, ResponseType response) {
        ((ISrvMonXvmResponse)response).lendXvmHeader(this.controller.getXvmMessageHeader());
        ((ISrvMonXvmResponse)response).setAdminClientIdFrom(((ISrvMonXvmRequest)request).getAdminClientIdUnsafe());
        ((ISrvMonXvmResponse)response).setCorrelationId(((ISrvMonXvmRequest)request).getCorrelationId());
        SrvControllerAdminSmaClientContext srvControllerAdminSmaClientContext = this;
        synchronized (srvControllerAdminSmaClientContext) {
            if (this.smaResponseChannel != null && this.oq.offerResponse(response)) {
                ++this.stats.responsesSent;
                this.flushUnprotected();
            } else {
                response.dispose();
                ++this.stats.responsesDropped;
                this.flushUnprotected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <RequestType extends IRogMessage & ISrvMonXvmRequest> void sendErrorResponse(RequestType request, Exception error) {
        SrvMonInvokeCommandResponse response = SrvMonInvokeCommandResponse.create();
        response.setAdminClientIdFrom(((ISrvMonXvmRequest)request).getAdminClientIdUnsafe());
        response.setCorrelationId(((ISrvMonXvmRequest)request).getCorrelationId());
        response.setErrorMessage(error.toString());
        SrvControllerAdminSmaClientContext srvControllerAdminSmaClientContext = this;
        synchronized (srvControllerAdminSmaClientContext) {
            if (this.smaResponseChannel != null && this.oq.offerResponse(response)) {
                ++this.stats.responsesSent;
                this.flushUnprotected();
            } else {
                response.dispose();
                ++this.stats.responsesDropped;
                this.flushUnprotected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean publishTraceRecord(SrvMonTraceRecord traceRecord) {
        SrvControllerAdminSmaClientContext srvControllerAdminSmaClientContext = this;
        synchronized (srvControllerAdminSmaClientContext) {
            if (this.smaTraceChannel != null && this.oq.offerTraceRecord(traceRecord)) {
                ++this.stats.tracesSent;
                this.flushUnprotected();
                return true;
            }
            traceRecord.dispose();
            ++this.stats.tracesDropped;
            this.flushUnprotected();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean publishHeartbeat(SrvMonHeartbeatMessage heartbeat) {
        SrvControllerAdminSmaClientContext srvControllerAdminSmaClientContext = this;
        synchronized (srvControllerAdminSmaClientContext) {
            if (this.smaHeartbeatsChannel != null && this.oq.offerHeartbeat(heartbeat)) {
                ++this.stats.heartbeatsSent;
                this.flushUnprotected();
                return true;
            }
            heartbeat.dispose();
            ++this.stats.heartbeatsDropped;
            this.flushUnprotected();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <RequestType extends IRogMessage & ISrvMonEvent> boolean publishEvent(RequestType event, boolean flush, boolean dropIfCongested) {
        SrvControllerAdminSmaClientContext srvControllerAdminSmaClientContext = this;
        synchronized (srvControllerAdminSmaClientContext) {
            if (this.smaEventChannel != null && this.oq.offerEvent(event, dropIfCongested)) {
                ++this.stats.eventsSent;
                if (flush) {
                    this.flushUnprotected();
                }
                return true;
            }
            event.dispose();
            ++this.stats.eventsDropped;
            if (flush) {
                this.flushUnprotected();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush() {
        SrvControllerAdminSmaClientContext srvControllerAdminSmaClientContext = this;
        synchronized (srvControllerAdminSmaClientContext) {
            this.flushUnprotected();
        }
    }

    private final void flushUnprotected() {
        if (!this.flushScheduled) {
            try {
                this.actionExecutor.invoke(this.flusher, (IEmxAction)this.flushAction, null, 0);
                this.flushScheduled = true;
                ++this.stats.flushesScheduled;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    final void onAdminAppEngineDecriptorInjected(AepEngineDescriptor descriptor) throws EAdminException {
        this.adminOverSmaConfig = this.loader.getServerDescriptor().getAdmin().getSma();
        this.passiveMonitoringOnly = this.loader.getServerDescriptor().getAdmin().getPassiveMonitoringOnly();
        if (this.adminOverSmaConfig.isEnabled()) {
            Properties props = new Properties();
            Config.getPropertiesTo((Properties)props);
            if (this.adminOverSmaConfig.getBusName() != null) {
                props.put("nv.server.admin.sma.bus.name", this.adminOverSmaConfig.getBusName());
            }
            MessageBusDescriptor adminBusDescriptor = AdminSessionFactory.loadAdminBusDescriptor(props);
            try {
                adminBusDescriptor.save();
            }
            catch (SmaException e) {
                throw new EAdminException("Error saving admin bus [" + e.getMessage() + "]", e);
            }
            descriptor.addBus(adminBusDescriptor.getName());
            descriptor.setBusConnectionProperties(adminBusDescriptor.getName(), new Properties());
            descriptor.getBusConnectionProperties(adminBusDescriptor.getName()).setProperty("user_name", descriptor.getName() + "-" + this.loader.getServerDescriptor().getName());
            for (SrvConfigDescriptor.Admin.Sma.Channel adminChannelConfig : this.adminOverSmaConfig.getAdminChannels()) {
                if (!adminChannelConfig.isEnabled()) continue;
                AepEngineDescriptor.ChannelConfig adminChannel = new AepEngineDescriptor.ChannelConfig();
                adminChannel.setJoin(adminChannelConfig.getJoin() && !this.passiveMonitoringOnly);
                adminChannel.setFilter("xvmName=" + this.loader.getServerDescriptor().getName());
                descriptor.addChannel(this.adminOverSmaConfig.getBusName(), adminChannelConfig.getChannelName(), adminChannel);
            }
            this.adminKeyResolutionTable.put("xvmName", XString.create((String)this.loader.getServerDescriptor().getName()));
        }
    }

    final void onAdminAppEngineInjected(AepEngine engine) {
        this.engine = engine;
    }

    @EventHandler
    public final void onBusUp(AepBusBindingUpEvent event) {
        if (this.adminOverSmaConfig != null && event.getMessageBusBinding().getName().equals(this.adminOverSmaConfig.getBusName())) {
            this.controller.onClientConnect(this);
        }
    }

    @EventHandler
    public final void onBusDown(AepBusBindingDownEvent event) {
        if (this.adminOverSmaConfig != null && event.getMessageBusBinding().getName().equals(this.adminOverSmaConfig.getBusName())) {
            this.controller.onClientDisconnect(this);
        }
    }

    @EventHandler
    public final void onChannelUp(AepChannelUpEvent event) {
        if (this.adminOverSmaConfig != null && this.adminOverSmaConfig.isEnabled() && event.getMessageBusBinding().getName().equals(this.adminOverSmaConfig.getBusName())) {
            String channelName = event.getMessageChannel().getName();
            MessageChannel adminChannel = null;
            if (channelName.equals("xvm-request")) {
                adminChannel = event.getMessageChannel();
                if (this.adminOverSmaConfig.getRequestChannel().isEnabled()) {
                    this.tracer.log("SMA admin request channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + ")", Tracer.Level.INFO);
                } else {
                    this.tracer.log("SMA admin request channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + "), but is disabled", Tracer.Level.WARNING);
                }
            } else if (channelName.equals("xvm-response")) {
                adminChannel = this.smaResponseChannel = event.getMessageChannel();
                if (this.adminOverSmaConfig.getResponseChannel().isEnabled()) {
                    this.smaResponseChannel = adminChannel;
                    this.tracer.log("SMA admin response monitoring channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + ")", Tracer.Level.INFO);
                } else {
                    this.tracer.log("SMA admin response monitoring channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + "), but is disabled", Tracer.Level.WARNING);
                }
            } else if (channelName.equals("xvm-heartbeat")) {
                adminChannel = event.getMessageChannel();
                if (this.adminOverSmaConfig.getHeartbeatChannel().isEnabled()) {
                    this.smaHeartbeatsChannel = adminChannel;
                    this.tracer.log("SMA admin heartbeat monitoring channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + ")", Tracer.Level.INFO);
                } else {
                    this.tracer.log("SMA admin heartbeat monitoring channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + "), but is disabled", Tracer.Level.WARNING);
                }
            } else if (channelName.equals("xvm-trace")) {
                adminChannel = event.getMessageChannel();
                if (this.adminOverSmaConfig.getTraceChannel().isEnabled()) {
                    this.smaTraceChannel = adminChannel;
                    this.tracer.log("SMA admin trace monitoring channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + ")", Tracer.Level.INFO);
                } else {
                    this.tracer.log("SMA admin trace monitoring channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + "), but is disabled", Tracer.Level.WARNING);
                }
            } else if (channelName.equals("xvm-event")) {
                adminChannel = event.getMessageChannel();
                if (this.adminOverSmaConfig.getEventChannel().isEnabled()) {
                    this.smaEventChannel = adminChannel;
                    this.tracer.log("SMA admin lifecycle monitoring channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + ")", Tracer.Level.INFO);
                } else {
                    this.tracer.log("SMA admin lifecycle monitoring channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + "), but is disabled", Tracer.Level.WARNING);
                }
            } else {
                this.tracer.log("Ignoring unused admin monitoring channel: " + channelName + "@" + event.getMessageBusBinding().getName(), Tracer.Level.WARNING);
            }
            if (adminChannel != null) {
                adminChannel.setRawKeyResolutionTable(this.adminKeyResolutionTable);
            }
        }
    }

    @EventHandler
    public final void onChannelDown(AepChannelDownEvent event) {
        if (this.adminOverSmaConfig != null && this.adminOverSmaConfig.isEnabled() && event.getMessageBusBinding().getName().equals(this.adminOverSmaConfig.getBusName())) {
            String channelName = event.getMessageChannel().getName();
            if (channelName.equals(this.adminOverSmaConfig.getRequestChannel().getChannelName())) {
                this.tracer.log("SMA admin request channel is down (" + channelName + "@" + event.getMessageBusBinding().getName() + ")", this.engine.getState() == AepEngine.State.Stopping ? Tracer.Level.INFO : Tracer.Level.WARNING);
            } else if (channelName.equals(this.adminOverSmaConfig.getResponseChannel().getChannelName())) {
                this.smaResponseChannel = null;
                this.tracer.log("SMA admin response channel is down (" + channelName + "@" + event.getMessageBusBinding().getName() + ")", this.engine.getState() == AepEngine.State.Stopping ? Tracer.Level.INFO : Tracer.Level.WARNING);
            } else if (channelName.equals(this.adminOverSmaConfig.getTraceChannel().getChannelName())) {
                this.smaTraceChannel = null;
                this.tracer.log("SMA trace monitoring channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + ")", this.engine.getState() == AepEngine.State.Stopping ? Tracer.Level.INFO : Tracer.Level.WARNING);
            } else if (channelName.equals(this.adminOverSmaConfig.getHeartbeatChannel().getChannelName())) {
                this.smaHeartbeatsChannel = null;
                this.tracer.log("SMA heartbeat monitoring channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + ")", this.engine.getState() == AepEngine.State.Stopping ? Tracer.Level.INFO : Tracer.Level.WARNING);
            } else if (channelName.equals(this.adminOverSmaConfig.getEventChannel().getChannelName())) {
                this.smaEventChannel = null;
                this.tracer.log("SMA event event channel is up (" + channelName + "@" + event.getMessageBusBinding().getName() + ")", this.engine.getState() == AepEngine.State.Stopping ? Tracer.Level.INFO : Tracer.Level.WARNING);
            }
        }
    }

    private final void sendMessage(MessageChannel channel, IRogMessage message) {
        if (channel != null && this.engine.getMessagingState() == AepEngine.MessagingState.Started) {
            try {
                this.engine.sendMessage(channel, message);
            }
            catch (IllegalStateException e) {
                if (this.engine.getState() == AepEngine.State.Started) {
                    throw e;
                }
                this.tracer.log("Dropping published '" + channel.getName() + "' event'" + message.getClass().getSimpleName() + "' because admin app is in " + this.engine.getState() + " state.", Tracer.Level.INFO);
            }
        } else {
            message.dispose();
        }
    }

    @EventHandler
    public final void onUnhandledMessageEvent(AepUnhandledMessageEvent event) {
        this.tracer.log("Received unhandled admin request: " + event.getTriggeringMessage(), Tracer.Level.WARNING);
    }

    @EventHandler
    public final void onSrvMonGetLoadedAppsRequest(SrvMonGetLoadedAppsRequest request) throws Exception {
        if (this.smaResponseChannel == null) {
            this.tracer.log("SMA admin request received, but server-response channel is not up; request ignoring", Tracer.Level.WARNING);
            return;
        }
        try {
            this.controller.onSrvMonGetLoadedAppsRequest(this, request);
        }
        catch (Exception e) {
            this.tracer.log("Failed to invoke Admin over SMA command '" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
        }
    }

    @EventHandler
    public final void SrvMonGetTraceHistoryRequest(SrvMonGetTraceHistoryRequest request) throws Exception {
        if (this.smaResponseChannel == null) {
            this.tracer.log("SMA admin request received, but server-response channel is not up; request ignoring", Tracer.Level.WARNING);
            return;
        }
        try {
            this.controller.onSrvMonGetTraceHistoryRequest(this, request);
        }
        catch (Exception e) {
            this.tracer.log("Failed to invoke Admin over SMA command '" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
        }
    }

    @EventHandler
    public final void onSrvMonInvokeCommandRequest(SrvMonInvokeCommandRequest request) throws Exception {
        if (this.smaResponseChannel == null) {
            this.tracer.log("SMA admin request received, but server-response channel is not up; request ignoring", Tracer.Level.WARNING);
            return;
        }
        try {
            this.controller.onSrvMonInvokeCommandRequest(this, request);
        }
        catch (Exception e) {
            this.tracer.log("Failed to invoke Admin over SMA command '" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
        }
    }

    @EventHandler
    public final void onSrvMonXvmInfoRequest(SrvMonXvmInfoRequest request) throws Exception {
        if (this.smaResponseChannel == null) {
            this.tracer.log("SMA admin request received, but server-response channel is not up; request ignoring", Tracer.Level.WARNING);
            return;
        }
        try {
            this.controller.onSrvMonXvmInfoRequest(this, request);
        }
        catch (Exception e) {
            this.tracer.log("Failed to invoke Admin over SMA command '" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
        }
    }

    @EventHandler
    public final void onSrvMonListCommandsRequest(SrvMonListCommandsRequest request) throws Exception {
        if (this.smaResponseChannel == null) {
            this.tracer.log("SMA admin request received, but server-response channel is not up; request ignoring", Tracer.Level.WARNING);
            return;
        }
        try {
            this.controller.onSrvMonListCommandsRequest(this, request);
        }
        catch (Exception e) {
            this.tracer.log("Failed to invoke Admin over SMA command '" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
        }
    }

    @EventHandler
    public final void onSrvMonStartTraceWatchRequest(SrvMonStartTraceWatchRequest request) throws Exception {
        this.tracer.log("Received unsupported start trace watch command from admin client using SMA transport (" + request.getAdminClientId() + ")", Tracer.Level.WARNING);
    }

    @EventHandler
    public final void onSrvMonStopTraceWatchRequest(SrvMonStopTraceWatchRequest request) throws Exception {
        this.tracer.log("Received unsupported stop trace watch command from admin client using SMA transport (" + request.getAdminClientId() + ")", Tracer.Level.WARNING);
    }

    @EventHandler
    public final void onSrvMonStartAppWatchCommand(SrvMonStartAppWatchCommand request) throws Exception {
        this.tracer.log("Received unsupported start app watch command from admin client using SMA transport (" + request.getAdminClientId() + ")", Tracer.Level.WARNING);
    }

    @EventHandler
    public final void onSrvMonStartAppWatchCommand(SrvMonStopAppWatchCommand request) throws Exception {
        this.tracer.log("Received unsupported stop app watch command from admin client using SMA transport (" + request.getAdminClientId() + ")", Tracer.Level.WARNING);
    }

    private final class FlushAction
    implements IEmxAction<Object, Object> {
        private FlushAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            SrvControllerAdminSmaClientContext srvControllerAdminSmaClientContext = SrvControllerAdminSmaClientContext.this;
            synchronized (srvControllerAdminSmaClientContext) {
                SrvControllerAdminSmaClientContext.this.flushScheduled = false;
                ++((SrvControllerAdminSmaClientContext)SrvControllerAdminSmaClientContext.this).stats.flushesExecuted;
                try {
                    SrvControllerAdminSmaClientContext.this.oq.dispatch();
                }
                catch (Throwable thrown) {
                    SrvControllerAdminSmaClientContext.this.tracer.log("Error flushing Admin over SMA output queue: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
                }
            }
            return null;
        }
    }

    final class OutboundQueue {
        private final int RESPONSE = 0;
        private final int EVENT = 1;
        private final int HEARTBEAT = 2;
        private final int TRACE = 3;
        UtlPlist<IRogMessage>[] lists = (UtlPlist[])Array.newInstance(UtlPlist.class, 4);
        private final AtomicInteger[] listSizes;
        private final int capacityPerList;
        private AtomicInteger count;
        private AtomicInteger size;
        private AtomicLong flushCount;
        private AtomicLong flushSize;

        OutboundQueue(SrvConfigDescriptor serverConfig) {
            int i;
            for (i = 0; i < this.lists.length; ++i) {
                this.lists[i] = UtlPlist.create();
            }
            this.capacityPerList = serverConfig.getAdminClientOutputQueueCapacity();
            this.listSizes = new AtomicInteger[4];
            for (i = 0; i < this.listSizes.length; ++i) {
                this.listSizes[i] = new AtomicInteger(0);
            }
            this.count = new AtomicInteger(0);
            this.size = new AtomicInteger(0);
            this.flushCount = new AtomicLong(0L);
            this.flushSize = new AtomicLong(0L);
        }

        private final boolean drop(int priority, int serializedLength) {
            return this.listSizes[priority].get() + serializedLength > this.capacityPerList;
        }

        final int capacity() {
            return this.capacityPerList * 4;
        }

        final int count() {
            return this.count.get();
        }

        final int size() {
            return this.size.get();
        }

        final long flushCount() {
            return this.flushCount.get();
        }

        final long flushSize() {
            return this.flushSize.get();
        }

        final boolean offerTraceRecord(SrvMonTraceRecord traceRecord) {
            return this.offer(traceRecord, 3, true);
        }

        final <ResponseType extends IRogMessage & ISrvMonXvmResponse> boolean offerResponse(ResponseType response) {
            return this.offer(response, 0, false);
        }

        final boolean offerHeartbeat(SrvMonHeartbeatMessage heartbeat) {
            return this.offer(heartbeat, 2, true);
        }

        final <EventType extends IRogMessage & ISrvMonEvent> boolean offerEvent(EventType event, boolean dropIfCongested) {
            return this.offer(event, 1, dropIfCongested);
        }

        private final boolean offer(IRogMessage view, int listId, boolean dropIfCongested) {
            UtlPlist<IRogMessage> list = this.lists[listId];
            PktPacket packet = view.serializeToPacket();
            int packetSerializedLength = packet.getSerializedLength();
            packet.dispose();
            if (!dropIfCongested || !this.drop(listId, packetSerializedLength)) {
                list.append((Object)view);
                this.listSizes[listId].addAndGet(packetSerializedLength);
                this.size.addAndGet(packetSerializedLength);
                this.count.incrementAndGet();
                return true;
            }
            return false;
        }

        final void dispatch() throws EAdminException {
            for (int i = 0; i < this.lists.length; ++i) {
                UtlPlist<IRogMessage> list = this.lists[i];
                MessageChannel channel = null;
                switch (i) {
                    case 0: {
                        channel = SrvControllerAdminSmaClientContext.this.smaResponseChannel;
                        break;
                    }
                    case 1: {
                        channel = SrvControllerAdminSmaClientContext.this.smaEventChannel;
                        break;
                    }
                    case 2: {
                        channel = SrvControllerAdminSmaClientContext.this.smaHeartbeatsChannel;
                        break;
                    }
                    case 3: {
                        channel = SrvControllerAdminSmaClientContext.this.smaTraceChannel;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid admin over sma dispatch queue id: " + i);
                    }
                }
                while (list.count() > 0) {
                    UtlPlist.Element first = list.first();
                    IRogMessage view = (IRogMessage)first.getObject();
                    PktPacket packet = view.serializeToPacket();
                    int packetSerializedLength = packet.getSerializedLength();
                    packet.dispose();
                    this.listSizes[i].addAndGet(-1 * packetSerializedLength);
                    this.size.addAndGet(-1 * packetSerializedLength);
                    this.flushSize.addAndGet(packetSerializedLength);
                    this.count.decrementAndGet();
                    this.flushCount.incrementAndGet();
                    first.unlink();
                    try {
                        SrvControllerAdminSmaClientContext.this.sendMessage(channel, view);
                    }
                    catch (Throwable smae) {
                        throw new EAdminException("Failed to send '" + view.getClass().getSimpleName() + "': " + smae.getMessage(), smae);
                    }
                }
            }
        }
    }

    private final class Stats
    implements SrvControllerAdminApp.AdminClientContext.Stats {
        volatile long responsesSent;
        volatile long responsesDropped;
        volatile long eventsSent;
        volatile long eventsDropped;
        volatile long heartbeatsSent;
        volatile long heartbeatsDropped;
        volatile long tracesSent;
        volatile long tracesDropped;
        volatile long flushesScheduled;
        volatile long flushesExecuted;

        private Stats() {
        }

        @Override
        public final long getResponsesSent() {
            return this.responsesSent;
        }

        @Override
        public final long getResponsesDropped() {
            return this.responsesDropped;
        }

        @Override
        public final long getEventsSent() {
            return this.eventsSent;
        }

        @Override
        public final long getEventsDropped() {
            return this.eventsDropped;
        }

        @Override
        public final long getHeartbeatsSent() {
            return this.heartbeatsSent;
        }

        @Override
        public final long getHeartbeatsDropped() {
            return this.heartbeatsDropped;
        }

        @Override
        public final long getTracesSent() {
            return this.tracesSent;
        }

        @Override
        public final long getTracesDropped() {
            return this.tracesDropped;
        }

        @Override
        public final long getFlushesScheduled() {
            return this.flushesScheduled;
        }

        @Override
        public final long getFlushesExecuted() {
            return this.flushesExecuted;
        }

        @Override
        public final SrvControllerAdminApp.AdminClientContext getClient() {
            return SrvControllerAdminSmaClientContext.this;
        }

        @Override
        public final int getOutboundQueueCapacity() {
            return SrvControllerAdminSmaClientContext.this.oq.capacity();
        }

        @Override
        public final int getOutboundQueueSize() {
            return SrvControllerAdminSmaClientContext.this.oq.size();
        }

        @Override
        public final int getOutboundQueueCount() {
            return SrvControllerAdminSmaClientContext.this.oq.count();
        }

        @Override
        public final long getOutboundQueueFlushSize() {
            return SrvControllerAdminSmaClientContext.this.oq.flushSize();
        }

        @Override
        public final long getOutboundQueueFlushCount() {
            return SrvControllerAdminSmaClientContext.this.oq.flushCount();
        }
    }
}

