/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.admin.impl;

import com.neeve.config.Config;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.rog.IRogMessage;
import com.neeve.server.admin.AdminObject;
import com.neeve.server.admin.AdminSession;
import com.neeve.server.admin.EAdminException;
import com.neeve.server.admin.EAdminOpFailedException;
import com.neeve.server.admin.EAdminOpServerErrorException;
import com.neeve.server.admin.EAdminOpTimeoutException;
import com.neeve.server.mon.SrvMonAppBusBindingInfo;
import com.neeve.server.mon.SrvMonAppBusBindingState;
import com.neeve.server.mon.SrvMonAppBusChannelInfo;
import com.neeve.server.mon.SrvMonAppClientInfo;
import com.neeve.server.mon.SrvMonAppFlowInfo;
import com.neeve.server.mon.SrvMonAppInfo;
import com.neeve.server.mon.SrvMonAppState;
import com.neeve.server.mon.SrvMonHeartbeatFactory;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.alert.SrvMonAlertFactory;
import com.neeve.server.mon.cnc.ISrvMonXvmRequest;
import com.neeve.server.mon.cnc.SrvMonCncFactory;
import com.neeve.server.mon.cnc.SrvMonCommandDescription;
import com.neeve.server.mon.cnc.SrvMonGetLoadedAppsResponse;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandRequest;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandResponse;
import com.neeve.server.mon.cnc.SrvMonListCommandsRequest;
import com.neeve.server.mon.cnc.SrvMonListCommandsResponse;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.server.mon.common.ISrvMonEvent;
import com.neeve.server.mon.common.SrvMonCommonFactory;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingCreatedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingDestroyedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingStateChangeMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelUpMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppClientConnectMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppClientDisconnectMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppFlowCreateMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppLoadedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStateChangeMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppUnloadedMessage;
import com.neeve.server.mon.lifecycle.SrvMonLifecycleFactory;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlText;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AdminSessionBase
extends AdminObject
implements AdminSession {
    private final AdminSession.EventHandler eventHandler;
    private final AppWatchHandler appWatchHandler;
    private final boolean passiveMonitoringOnly;
    protected final String adminClientId;
    protected final String xvmName;
    protected final String tracePrefix;
    protected final int defaultCommandTimeout;
    protected final int connectHandshakeTimeout;
    protected volatile State state = State.Init;
    protected int adminCompatVersion = -1;
    protected String systemName;
    protected String systemVersion;

    protected AdminSessionBase(String adminClientId, String xvmName, AdminSession.EventHandler eventHandler, Properties sessionProps, Tracer tracer) {
        super(tracer);
        this.adminClientId = adminClientId;
        this.xvmName = xvmName;
        this.eventHandler = eventHandler;
        this.tracePrefix = "[AdminSession-" + this.adminClientId + "<->" + xvmName + " (" + this.getTransportType() + ")] ";
        this.appWatchHandler = new AppWatchHandler();
        this.defaultCommandTimeout = Math.max(1000, (int)UtlUnit.parseDuration((String)Config.getValue((String)"nv.server.admin.commandtimeout", (String)"30s"), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MILLISECONDS));
        this.passiveMonitoringOnly = UtlProps.getValue((Properties)sessionProps, (String)"nv.server.admin.passivemonitoringonly", (boolean)false);
        this.connectHandshakeTimeout = (int)UtlUnit.parseDuration((String)UtlProps.getValue((Properties)sessionProps, (String)"nv.server.admin.connecthandshaketimeout", (String)"15s"), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private final void assertOpen() {
        if (this.state != State.Open) {
            throw new IllegalStateException("Session is " + (Object)((Object)this.state));
        }
    }

    protected void onAdminSessionFailure(Exception failure) {
        this.state = State.Failed;
        this.appWatchHandler.onAdminSessionClosed();
        if (this.eventHandler != null) {
            this.eventHandler.onFail(failure);
        }
        try {
            this.doClose();
        }
        catch (EAdminException e) {
            this.tracer.log(this.tracePrefix + "Error closing session on failure: " + e.getMessage(), Tracer.Level.WARNING);
        }
    }

    protected void onMessageReceived(MessageView messageView) {
        block29: {
            block28: {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "received: " + messageView, Tracer.Level.DEBUG);
                }
                if (messageView.getVfid() != 36) break block28;
                switch (messageView.getMessageType()) {
                    case 5: {
                        if (this.eventHandler != null) {
                            this.eventHandler.onTraceRecord((SrvMonTraceRecord)messageView);
                            break;
                        }
                        break block29;
                    }
                    case 13: {
                        this.appWatchHandler.onGetLoadedAppsResponse((SrvMonGetLoadedAppsResponse)messageView);
                        break;
                    }
                    case 11: {
                        if (this.tracer.fine) {
                            this.tracer.log(this.tracePrefix + "Ignoring late cnc response: " + messageView, Tracer.Level.FINE);
                            break;
                        }
                        break block29;
                    }
                    default: {
                        this.tracer.log(this.tracePrefix + "Ignoring unimplemented admin cnc message type: " + messageView.getClass().getName(), Tracer.Level.WARNING);
                        break;
                    }
                }
                break block29;
            }
            if (messageView.getVfid() == 32) {
                switch (messageView.getMessageType()) {
                    case 99: {
                        SrvMonHeartbeatMessage heartbeat = (SrvMonHeartbeatMessage)messageView;
                        this.appWatchHandler.onHeartbeat(heartbeat);
                        break;
                    }
                    default: {
                        this.tracer.log(this.tracePrefix + "Ignoring unimplemented heartbeat message type: " + messageView.getClass().getName(), Tracer.Level.WARNING);
                        break;
                    }
                }
            } else if (messageView.getVfid() == 34) {
                switch (messageView.getMessageType()) {
                    case 301: {
                        this.appWatchHandler.onAppLoaded((SrvMonAppLoadedMessage)messageView);
                        break;
                    }
                    case 308: {
                        this.appWatchHandler.onAppUnloaded((SrvMonAppUnloadedMessage)messageView);
                        break;
                    }
                    case 302: {
                        this.appWatchHandler.onAppStateChanged((SrvMonAppStateChangeMessage)messageView);
                        break;
                    }
                    case 1: {
                        this.appWatchHandler.onAppBusBindingCreated((SrvMonAppBusBindingCreatedMessage)messageView);
                        break;
                    }
                    case 304: {
                        this.appWatchHandler.onAppBusBindingStateChanged((SrvMonAppBusBindingStateChangeMessage)messageView);
                        break;
                    }
                    case 22: {
                        this.appWatchHandler.onAppBusBindingDestroyed((SrvMonAppBusBindingDestroyedMessage)messageView);
                        break;
                    }
                    case 10: {
                        this.appWatchHandler.onAppBusChannelUp((SrvMonAppChannelUpMessage)messageView);
                        break;
                    }
                    case 19: {
                        this.appWatchHandler.onAppBusChannelDown((SrvMonAppChannelDownMessage)messageView);
                        break;
                    }
                    case 305: {
                        this.appWatchHandler.onAppClientConnected((SrvMonAppClientConnectMessage)messageView);
                        break;
                    }
                    case 306: {
                        this.appWatchHandler.onAppClientDisconnected((SrvMonAppClientDisconnectMessage)messageView);
                        break;
                    }
                    case 307: {
                        this.appWatchHandler.onAppFlowCreated((SrvMonAppFlowCreateMessage)messageView);
                        break;
                    }
                    default: {
                        if (!this.tracer.verbose) break;
                        this.tracer.log(this.tracePrefix + "Ignoring unimplemented lifecycle message type: " + messageView.getClass().getName(), Tracer.Level.VERBOSE);
                    }
                }
            }
        }
        if (this.eventHandler != null && messageView instanceof ISrvMonEvent) {
            this.eventHandler.onMonitoringEvent(messageView);
        }
    }

    protected abstract void doConnect() throws EAdminException;

    protected int doGetAdminCompatLevel() throws EAdminOpFailedException {
        if (this.adminCompatVersion == -1) {
            String compatibilityResponse = null;
            try {
                compatibilityResponse = String.valueOf(this.invokeCommand(this.defaultCommandTimeout, "server", "get_admin_compat_level", new Object[0]));
                this.setAdminCompatVersion(compatibilityResponse);
                return this.adminCompatVersion;
            }
            catch (EAdminOpServerErrorException e) {
                return 1;
            }
            catch (EAdminException e) {
                throw new EAdminOpFailedException("Error handling XVM compatibility response " + e.getMessage(), (Throwable)((Object)e));
            }
        }
        return this.adminCompatVersion;
    }

    protected void setAdminCompatVersion(String compatibilityResponse) throws EAdminException {
        try {
            int dot = compatibilityResponse.indexOf(46);
            this.adminCompatVersion = dot == -1 ? Integer.parseInt(compatibilityResponse) : Integer.parseInt(compatibilityResponse.substring(0, dot));
        }
        catch (NumberFormatException nfe) {
            throw new EAdminException("XVM returned invalid compatibility level: " + compatibilityResponse + " admin capability may be limited");
        }
    }

    protected abstract void doClose() throws EAdminException;

    protected abstract void doStartAppWatch() throws EAdminOpFailedException;

    protected abstract void doStopAppWatch() throws EAdminOpFailedException;

    protected abstract void doStartTraceWatch() throws EAdminOpFailedException;

    protected abstract void doStopTraceWatch() throws EAdminOpFailedException;

    protected abstract <RequestType extends IRogMessage & ISrvMonXvmRequest, ResponseType extends IRogMessage> ResponseType sendRequest(RequestType var1, int var2) throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doInvokeCommand(int timeoutInMillis, String target, String command, Object ... params) throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException {
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        if (command == null) {
            throw new IllegalArgumentException("command cannot be null");
        }
        SrvMonInvokeCommandRequest request = SrvMonInvokeCommandRequest.create();
        request.setTarget(target);
        request.setCommandName(command);
        request.setAdminClientCompatLevel("5");
        for (int i = 0; i < params.length; ++i) {
            request.addParameters((String)UtlDataTypes.convert(String.class, (Object)params[i]));
        }
        SrvMonInvokeCommandResponse response = (SrvMonInvokeCommandResponse)this.sendRequest(request, timeoutInMillis);
        try {
            if (response == null) {
                Object var7_8 = null;
                return var7_8;
            }
            if (response.hasErrorMessage()) {
                throw new EAdminOpServerErrorException(response.getErrorMessage());
            }
            Object object = SrvMonUtil.getResponseValue(response);
            return object;
        }
        finally {
            if (response != null) {
                response.dispose();
            }
        }
    }

    @Override
    public final void open() throws EAdminException {
        if (this.state != State.Init) {
            throw new IllegalStateException("Open called while in state " + (Object)((Object)this.state));
        }
        try {
            this.doConnect();
            if (!this.isPassiveMonitoringOnly()) {
                if (this.systemName != null && this.systemVersion != null) {
                    this.tracer.log(this.tracePrefix + "Connected [system=" + this.systemName + " v" + this.systemVersion + " compatLevel=" + this.adminCompatVersion + "]", Tracer.Level.FINE);
                } else {
                    this.tracer.log(this.tracePrefix + "Connected [system=unknown, compatLevel=" + this.adminCompatVersion + "]", Tracer.Level.FINE);
                }
            }
            this.state = State.Open;
        }
        catch (EAdminException e) {
            this.doClose();
            this.state = State.Failed;
            throw e;
        }
        catch (RuntimeException e) {
            this.doClose();
            this.state = State.Failed;
            throw e;
        }
        catch (Error e) {
            this.doClose();
            this.state = State.Failed;
            throw e;
        }
    }

    @Override
    public final boolean isPassiveMonitoringOnly() {
        return this.passiveMonitoringOnly;
    }

    @Override
    public final String getSystemName() {
        return this.systemName;
    }

    @Override
    public final String getSystemVersion() {
        return this.systemVersion;
    }

    @Override
    public final void startTraceWatch() throws Exception {
        this.doStartTraceWatch();
    }

    @Override
    public final void stopTraceWatch() throws Exception {
        this.doStopTraceWatch();
        this.appWatchHandler.onAppWatchStop();
    }

    @Override
    public final void startAppWatch() throws EAdminOpFailedException {
        if (this.appWatchHandler.onAppWatchStart()) {
            this.doStartAppWatch();
        }
    }

    @Override
    public final void stopAppWatch() throws EAdminOpFailedException {
        this.doStopAppWatch();
        this.appWatchHandler.onAppWatchStop();
    }

    @Override
    public void waitForAppWatchJoin(int timeoutMillis) throws IllegalStateException, EAdminException, EAdminOpTimeoutException, InterruptedException {
        this.assertOpen();
        this.appWatchHandler.waitForAppWatchJoin(timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void withAppTableLock(Runnable runnable) {
        Object object = this.appWatchHandler.getAppTableSynchronizer();
        synchronized (object) {
            runnable.run();
        }
    }

    @Override
    public final String[] getWatchedApps() {
        return this.appWatchHandler.getWatchedApps();
    }

    @Override
    public final SrvMonAppState getWatchedAppState(String app) {
        return this.appWatchHandler.getWatchedAppState(app);
    }

    @Override
    public final String[] getWatchedAppBuses(String app) {
        return this.appWatchHandler.getWatchedAppBuses(app);
    }

    @Override
    public final SrvMonAppBusBindingState getWatchedAppBusBindingState(String app, String bus) {
        return this.appWatchHandler.getWatchedAppBusBindingState(app, bus);
    }

    @Override
    public final String[] getWatchedAppBusChannels(String app, String bus) {
        return this.appWatchHandler.getWatchedAppBusChannels(app, bus);
    }

    @Override
    public final String[] getWatchedAppClients(String app) {
        return this.appWatchHandler.getWatchedAppClients(app);
    }

    @Override
    public final int[] getWatchedAppFlows(String app) {
        return this.appWatchHandler.getWatchedAppFlows(app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SrvMonCommandDescription[] getCommands(String app) throws EAdminOpFailedException {
        if (this.isPassiveMonitoringOnly()) {
            throw new EAdminOpFailedException("Cannot commands when configured for passive monitoring only.");
        }
        if (this.adminCompatVersion >= 4) {
            SrvMonListCommandsRequest listCommandsRequest = SrvMonListCommandsRequest.create();
            listCommandsRequest.setEntity(app);
            SrvMonListCommandsResponse response = (SrvMonListCommandsResponse)this.sendRequest(listCommandsRequest, this.defaultCommandTimeout);
            try {
                if (response == null) {
                    SrvMonCommandDescription[] srvMonCommandDescriptionArray = null;
                    return srvMonCommandDescriptionArray;
                }
                ArrayList<SrvMonCommandDescription> ret = new ArrayList<SrvMonCommandDescription>();
                XIterator<SrvMonCommandDescription> iterator = response.getCommandsIterator();
                while (iterator.hasNext()) {
                    ret.add(((SrvMonCommandDescription)iterator.next()).copy());
                }
                SrvMonCommandDescription[] srvMonCommandDescriptionArray = ret.toArray(new SrvMonCommandDescription[ret.size()]);
                return srvMonCommandDescriptionArray;
            }
            finally {
                if (response != null) {
                    response.dispose();
                }
            }
        }
        return new SrvMonCommandDescription[0];
    }

    @Override
    public final void loadApp(String appName) throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException {
        if (appName == null) {
            throw new IllegalArgumentException("the app name cannot be null");
        }
        this.doInvokeCommand(this.defaultCommandTimeout, "admin", "app_load", appName);
    }

    @Override
    public final void unloadApp(String appName) throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException {
        if (appName == null) {
            throw new IllegalArgumentException("the app name cannot be null");
        }
        this.invokeCommand("admin", "app_unload", appName);
    }

    @Override
    public final void stopServer() throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException {
        this.doInvokeCommand(-1, "server", "stop", new Object[0]);
    }

    @Override
    public final void restartServer() throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException {
        this.doInvokeCommand(-1, "server", "restart", new Object[0]);
    }

    @Override
    public final void killServer() throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException {
        this.doInvokeCommand(-1, "server", "kill", new Object[0]);
    }

    @Override
    public final Object invokeCommandLine(String target, String commandLine) throws EAdminOpFailedException {
        return this.invokeCommandLine(this.defaultCommandTimeout, target, commandLine);
    }

    @Override
    public final Object invokeCommandLine(int timeout, String app, String commandLine) throws EAdminOpFailedException {
        String[] parsed = UtlText.parseAsArgs((String)commandLine, (boolean)false);
        if (parsed.length == 0) {
            throw new IllegalArgumentException("invalid command format '" + commandLine + "' [expected format=\"<command> <args>\"]");
        }
        String command = parsed[0];
        if (this.isPassiveMonitoringOnly()) {
            throw new EAdminOpFailedException("Cannot invoke '" + command + "'. Session is configured for passive monitoring only.");
        }
        if (parsed.length > 1) {
            return this.doInvokeCommand(timeout, app, command, Arrays.copyOfRange(parsed, 1, parsed.length));
        }
        return this.doInvokeCommand(timeout, app, command, new Object[0]);
    }

    @Override
    public final Object invokeCommand(String app, String command, Object ... params) throws EAdminOpFailedException {
        return this.invokeCommand(this.defaultCommandTimeout, app, command, params);
    }

    @Override
    public final Object invokeCommand(int timeoutMillis, String app, String command, Object ... params) throws EAdminOpFailedException {
        if (this.isPassiveMonitoringOnly()) {
            throw new EAdminOpFailedException("Cannot invoke '" + command + "'. Session is configured for passive monitoring only.");
        }
        return this.doInvokeCommand(timeoutMillis, app, command, params);
    }

    public final void setAppVersion(String appName, int version) throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException {
        if (appName == null) {
            throw new IllegalArgumentException("the app name cannot be null");
        }
        if (version < 0) {
            throw new IllegalArgumentException("the app version must be >= 0");
        }
        this.doInvokeCommand(this.defaultCommandTimeout, "server", "app_setver", appName, version);
    }

    public final void setAppMessageHandlingPolicy(String appName, String policy) throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException {
        if (appName == null) {
            throw new IllegalArgumentException("the app name cannot be null");
        }
        this.doInvokeCommand(this.defaultCommandTimeout, "server", "app_set_message_handling_policy", appName, policy);
    }

    @Override
    public final void close() {
        switch (this.state) {
            case Closed: 
            case Closing: 
            case Failed: {
                return;
            }
            case Init: {
                this.state = State.Closed;
                break;
            }
            case Open: {
                try {
                    this.state = State.Closing;
                    this.doClose();
                    this.state = State.Closed;
                    this.appWatchHandler.onAdminSessionClosed();
                    break;
                }
                catch (Throwable e) {
                    this.tracer.log("Failure closing admin session: " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                    this.state = State.Failed;
                    this.appWatchHandler.onAdminSessionClosed();
                }
            }
        }
    }

    public String toString() {
        return "AdminSession[" + this.getTransportType() + ", " + this.adminClientId + "<->" + this.xvmName + "]";
    }

    static {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)new SrvMonCommonFactory());
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)new SrvMonCncFactory());
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)new SrvMonHeartbeatFactory());
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)new SrvMonAlertFactory());
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)new SrvMonLifecycleFactory());
    }

    private final class AppWatchHandler {
        private final Map<String, SrvMonAppInfo> appsInfo;
        private final AtomicBoolean appWatchStarted = new AtomicBoolean(false);
        private final AtomicBoolean appWatchStartPending = new AtomicBoolean(false);

        AppWatchHandler() {
            this.appsInfo = new XLinkedHashMap();
        }

        public Object getAppTableSynchronizer() {
            return this.appsInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAdminSessionClosed() {
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                this.appsInfo.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean onAppWatchStart() {
            if (this.appWatchStarted.compareAndSet(false, true)) {
                Map<String, SrvMonAppInfo> map = this.appsInfo;
                synchronized (map) {
                    this.appsInfo.clear();
                }
                this.appWatchStartPending.set(true);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppWatchStop() {
            if (this.appWatchStarted.compareAndSet(false, true)) {
                this.appWatchStartPending.set(false);
                Map<String, SrvMonAppInfo> map = this.appsInfo;
                synchronized (map) {
                    this.appsInfo.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void waitForAppWatchJoin(int timeoutMillis) throws IllegalStateException, InterruptedException, EAdminException, EAdminOpTimeoutException {
            if (!this.appWatchStarted.get()) {
                throw new IllegalStateException("waitForAppWatchJoin called while app watch not started");
            }
            if (!this.appWatchStartPending.get()) {
                return;
            }
            long deadline = System.currentTimeMillis() + (long)timeoutMillis;
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                long timeLeft = deadline - System.currentTimeMillis();
                while (this.appWatchStartPending.get() && AdminSessionBase.this.state == State.Open && timeLeft > 0L) {
                    this.appsInfo.wait(timeLeft);
                    timeLeft = deadline - System.currentTimeMillis();
                }
            }
            if (!this.appWatchStarted.get()) {
                throw new IllegalStateException("app watch was stopped.");
            }
            if (this.appWatchStartPending.get()) {
                throw new EAdminOpTimeoutException("Timeout waiting for app watch start");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onHeartbeat(SrvMonHeartbeatMessage heartbeat) {
            if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received heartbeart...", Tracer.Level.DEBUG);
            }
            if (this.appWatchStartPending.compareAndSet(true, false)) {
                if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received first heartbeart during pending app watch start ... dispatching app loaded events", Tracer.Level.DEBUG);
                }
                XIterator<SrvMonAppInfo> appInfos = heartbeat.getAppsInfoIterator();
                while (appInfos.hasNext()) {
                    this.onAppLoaded((SrvMonAppInfo)appInfos.next());
                }
                Map<String, SrvMonAppInfo> map = this.appsInfo;
                synchronized (map) {
                    this.appsInfo.notifyAll();
                }
            }
            if (this.appWatchStarted.get() && AdminSessionBase.this.eventHandler != null) {
                AdminSessionBase.this.eventHandler.onHeartbeat(heartbeat);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onGetLoadedAppsResponse(SrvMonGetLoadedAppsResponse message) {
            if (this.appWatchStarted.get()) {
                XIterator<SrvMonAppInfo> appInfos = message.getLoadedAppsIterator();
                while (appInfos.hasNext()) {
                    this.onAppLoaded((SrvMonAppInfo)appInfos.next());
                }
                if (this.appWatchStartPending.compareAndSet(true, false)) {
                    Map<String, SrvMonAppInfo> map = this.appsInfo;
                    synchronized (map) {
                        this.appsInfo.notifyAll();
                    }
                }
            }
        }

        final void onAppLoaded(SrvMonAppLoadedMessage message) {
            if (this.appWatchStarted.get()) {
                this.onAppLoaded(message.getAppInfo());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppLoaded(SrvMonAppInfo appInfo) {
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appInfo.getName() + "' loaded.", Tracer.Level.DEBUG);
                }
                if (this.appsInfo.put(appInfo.getName(), (SrvMonAppInfo)appInfo.clone()) == null) {
                    if (AdminSessionBase.this.eventHandler != null) {
                        AdminSessionBase.this.eventHandler.onAppLoaded(appInfo.getName());
                    }
                } else if (((AdminSessionBase)AdminSessionBase.this).tracer.fine) {
                    AdminSessionBase.this.tracer.log("Got duplicate app load event for app '" + appInfo.getName(), Tracer.Level.FINE);
                }
            }
        }

        final void onAppStateChanged(SrvMonAppStateChangeMessage message) {
            if (this.appWatchStarted.get()) {
                this.onAppStateChanged(message.getEventSource(), message.getAppState());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppStateChanged(String appName, SrvMonAppState newState) {
            if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appName + "' state has changed to '" + (Object)((Object)newState) + "'.", Tracer.Level.DEBUG);
            }
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    appInfo.setState(newState);
                    if (AdminSessionBase.this.eventHandler != null) {
                        AdminSessionBase.this.eventHandler.onAppStateChanged(appName);
                    }
                } else {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received an app state change notification for a non-existent app (app=" + appName + ", state=" + (Object)((Object)newState) + ")", Tracer.Level.WARNING);
                }
            }
        }

        final void onAppBusBindingCreated(SrvMonAppBusBindingCreatedMessage message) {
            if (this.appWatchStarted.get()) {
                this.onAppBusBindingCreated(message.getEventSource(), message.getBusBindingInfo());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppBusBindingCreated(String appName, SrvMonAppBusBindingInfo busBindingInfo) {
            if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appName + "' has created a binding to bus '" + busBindingInfo.getName() + "'.", Tracer.Level.DEBUG);
            }
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    if (SrvMonUtil.addMonAppBusBindingInfo(appInfo, busBindingInfo)) {
                        if (AdminSessionBase.this.eventHandler != null) {
                            AdminSessionBase.this.eventHandler.onAppBusBindingCreated(appName, busBindingInfo.getName());
                        }
                    } else {
                        AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appName + "' has exceeded the monitoring storage quota for buses. Some app bus bindings will not be reported in an app watcher monitoring stream.", Tracer.Level.WARNING);
                    }
                } else {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received an app bus binding creation notification for a non-existent app (app=" + appName + ", bus=" + busBindingInfo.getName() + ")", Tracer.Level.WARNING);
                }
            }
        }

        final void onAppBusBindingStateChanged(SrvMonAppBusBindingStateChangeMessage message) {
            if (this.appWatchStarted.get()) {
                this.onAppBusBindingStateChanged(message.getEventSource(), message.getBusBindingName(), message.getBusBindingState());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppBusBindingStateChanged(String appName, String busName, SrvMonAppBusBindingState newState) {
            if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appName + "' binding to bus '" + busName + "' has changed state to '" + (Object)((Object)newState) + "'.", Tracer.Level.DEBUG);
            }
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    if (SrvMonUtil.updateMonAppBusBindingState(appInfo, busName, newState)) {
                        if (AdminSessionBase.this.eventHandler != null) {
                            AdminSessionBase.this.eventHandler.onAppBusBindingStateChanged(appName, busName);
                        }
                    } else {
                        AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "New state reported for binding to bus '" + busName + "' in app '" + appName + " but no bus with that name exists for that app!", Tracer.Level.WARNING);
                    }
                } else {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received an app bus binding state change notification for a non-existent app (app=" + appName + ", bus=" + busName + ", state=" + (Object)((Object)newState) + ")", Tracer.Level.WARNING);
                }
            }
        }

        final void onAppBusBindingDestroyed(SrvMonAppBusBindingDestroyedMessage message) {
            if (this.appWatchStarted.get()) {
                this.onAppBusBindingDestroyed(message.getEventSource(), message.getBusBindingName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppBusBindingDestroyed(String appName, String busName) {
            if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appName + "' binding to bus '" + busName + "' has been destroyed.", Tracer.Level.DEBUG);
            }
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    if (SrvMonUtil.removeMonAppBusBindingInfo(appInfo, busName)) {
                        if (AdminSessionBase.this.eventHandler != null) {
                            AdminSessionBase.this.eventHandler.onAppBusBindingDestroyed(appName, busName);
                        }
                    } else {
                        AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Binding to bus '" + busName + "' in app '" + appName + " was reported destroyed but no bus with that name exists for that app!", Tracer.Level.WARNING);
                    }
                } else {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received an app bus binding destroy notification for a non-existent app (app=" + appName + ", bus=" + busName + ")", Tracer.Level.WARNING);
                }
            }
        }

        final void onAppBusChannelUp(SrvMonAppChannelUpMessage message) {
            if (this.appWatchStarted.get()) {
                this.onAppBusChannelUp(message.getEventSource(), message.getBusBindingName(), message.getChannelName(), message.getIsJoined());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppBusChannelUp(String appName, String busName, String channelName, boolean joined) {
            if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appName + "' has opened the channel '" + channelName + "' in bus '" + busName + "'.", Tracer.Level.DEBUG);
            }
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                SrvMonAppBusChannelInfo channelInfo = SrvMonUtil.createMonAppBusChannelInfo(channelName, joined);
                if (appInfo != null) {
                    if (SrvMonUtil.addMonAppBusChannelInfo(appInfo, busName, channelInfo)) {
                        if (AdminSessionBase.this.eventHandler != null) {
                            AdminSessionBase.this.eventHandler.onAppBusChannelOpened(appName, busName, channelInfo.getName());
                        }
                    } else {
                        AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appName + "' has exceeded the monitoring storage quota for channels in bus '" + busName + "'. Some app channels will not be reported in an app watcher monitoring stream.", Tracer.Level.WARNING);
                    }
                } else {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received an app channel opened notification for a non-existent app (app=" + appName + ", bus=" + busName + ", channel=" + channelInfo.getName() + ")", Tracer.Level.WARNING);
                }
            }
        }

        final void onAppBusChannelDown(SrvMonAppChannelDownMessage message) {
            if (this.appWatchStarted.get()) {
                this.onAppBusChannelDown(message.getEventSource(), message.getBusBindingName(), message.getChannelName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppBusChannelDown(String appName, String busName, String channelName) {
            if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appName + "' has closed the channel '" + channelName + "' in bus '" + busName + "'.", Tracer.Level.DEBUG);
            }
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    if (SrvMonUtil.removeMonAppBusChannelInfo(appInfo, busName, channelName)) {
                        if (AdminSessionBase.this.eventHandler != null) {
                            AdminSessionBase.this.eventHandler.onAppBusChannelClosed(appName, busName, channelName);
                        }
                    } else {
                        AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received a channel closed event for a non-existent channel (app=" + appName + ", bus=" + busName + ", channel=" + channelName + ")!", Tracer.Level.WARNING);
                    }
                } else {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received an app channel closed notification for a non-existent app (app=" + appName + ", bus=" + busName + ", channel=" + channelName + ")", Tracer.Level.WARNING);
                }
            }
        }

        final void onAppClientConnected(SrvMonAppClientConnectMessage message) {
            if (this.appWatchStarted.get()) {
                this.onAppClientConnected(message.getEventSource(), message.getClientInfo());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppClientConnected(String appName, SrvMonAppClientInfo monAppClient) {
            if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Client '" + monAppClient.getName() + "' has connected to app '" + appName + "'.", Tracer.Level.DEBUG);
            }
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    if (SrvMonUtil.addMonAppClientInfo(appInfo, monAppClient)) {
                        if (AdminSessionBase.this.eventHandler != null) {
                            AdminSessionBase.this.eventHandler.onAppClientConnected(appName, monAppClient.getName());
                        }
                    } else {
                        AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appName + "' has exceeded the monitoring storage quota for clients. Some app clients will not be reported in an app watcher monitoring stream.", Tracer.Level.WARNING);
                    }
                } else {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received an app client connected notification for a non-existent app (app=" + appName + ", bus=" + monAppClient.getName() + ")", Tracer.Level.WARNING);
                }
            }
        }

        final void onAppClientDisconnected(SrvMonAppClientDisconnectMessage message) {
            if (this.appWatchStarted.get()) {
                this.onAppClientDisconnected(message.getEventSource(), message.getClientName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppClientDisconnected(String appName, String appClientName) {
            if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Client '" + appClientName + "' has disconnected from app '" + appName + "'.", Tracer.Level.DEBUG);
            }
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    if (SrvMonUtil.removeMonAppClientInfo(appInfo, appClientName)) {
                        if (AdminSessionBase.this.eventHandler != null) {
                            AdminSessionBase.this.eventHandler.onAppClientDisconnected(appName, appClientName);
                        }
                    } else {
                        AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received a disconnected client event for a non-existent client (app=" + appName + ", client=" + appClientName + "!", Tracer.Level.WARNING);
                    }
                } else {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received an app client disconnected notification for a non-existent app (app=" + appName + ", bus=" + appClientName + ")", Tracer.Level.WARNING);
                }
            }
        }

        final void onAppFlowCreated(SrvMonAppFlowCreateMessage message) {
            if (this.appWatchStarted.get()) {
                this.onAppFlowCreated(message.getEventSource(), message.getFlowInfo());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppFlowCreated(String appName, SrvMonAppFlowInfo flowInfo) {
            if (((AdminSessionBase)AdminSessionBase.this).tracer.debug) {
                AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appName + "' has discovered flow '" + flowInfo.getId() + "'.", Tracer.Level.DEBUG);
            }
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    if (SrvMonUtil.addMonAppFlowInfo(appInfo, flowInfo)) {
                        if (AdminSessionBase.this.eventHandler != null) {
                            AdminSessionBase.this.eventHandler.onAppFlowCreated(appName, flowInfo.getId());
                        }
                    } else {
                        AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "App '" + appName + "' has exceeded the monitoring storage quota for flows. Some app flows will not be reported in an app watcher monitoring stream.", Tracer.Level.WARNING);
                    }
                } else {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received an app flow created notification for a non-existent app (app=" + appName + ", flow=" + flowInfo.getId() + ")", Tracer.Level.WARNING);
                }
            }
        }

        final void onAppUnloaded(SrvMonAppUnloadedMessage message) {
            if (this.appWatchStarted.get()) {
                this.onAppUnloaded(message.getEventSource());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onAppUnloaded(String appName) {
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                if (this.appsInfo.remove(appName) != null) {
                    if (AdminSessionBase.this.eventHandler != null) {
                        AdminSessionBase.this.eventHandler.onAppUnloaded(appName);
                    }
                } else {
                    AdminSessionBase.this.tracer.log(AdminSessionBase.this.tracePrefix + "Received an app unloaded notification for a non-existent app (app=" + appName + ")", Tracer.Level.WARNING);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getWatchedApps() {
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                return this.appsInfo.keySet().toArray(new String[0]);
            }
        }

        public final SrvMonAppState getWatchedAppState(String appName) {
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    return appInfo.getState();
                }
                throw new IllegalArgumentException("invalid app name");
            }
        }

        public final String[] getWatchedAppBuses(String appName) {
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    SrvMonAppBusBindingInfo[] busBindingsInfo = appInfo.getBusBindingsInfo();
                    String[] busNames = busBindingsInfo == null || busBindingsInfo.length == 0 ? new String[]{} : new String[busBindingsInfo.length];
                    for (int i = 0; i < busNames.length; ++i) {
                        busNames[i] = busBindingsInfo[i] != null ? busBindingsInfo[i].getName() : null;
                    }
                    return busNames;
                }
                throw new IllegalArgumentException("invalid app name");
            }
        }

        public final SrvMonAppBusBindingState getWatchedAppBusBindingState(String appName, String busName) {
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    SrvMonAppBusBindingInfo busBindingInfo = SrvMonUtil.getMonAppBusBindingInfo(appInfo, busName);
                    if (busBindingInfo != null) {
                        return busBindingInfo.getState();
                    }
                    throw new IllegalArgumentException("invalid bus name");
                }
                throw new IllegalArgumentException("invalid app name");
            }
        }

        public final String[] getWatchedAppBusChannels(String appName, String busName) {
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    SrvMonAppBusBindingInfo busBindingInfo = SrvMonUtil.getMonAppBusBindingInfo(appInfo, busName);
                    if (busBindingInfo != null) {
                        SrvMonAppBusChannelInfo[] channelsInfo = busBindingInfo.getChannelsInfo();
                        String[] channelNames = channelsInfo == null || channelsInfo.length == 0 ? new String[]{} : new String[channelsInfo.length];
                        for (int i = 0; i < channelNames.length; ++i) {
                            channelNames[i] = channelsInfo[i] != null ? channelsInfo[i].getName() : null;
                        }
                        return channelNames;
                    }
                    throw new IllegalArgumentException("invalid bus name");
                }
                throw new IllegalArgumentException("invalid app name");
            }
        }

        public final String[] getWatchedAppClients(String appName) {
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    SrvMonAppClientInfo[] clientsInfo = appInfo.getClientsInfo();
                    String[] clientNames = clientsInfo == null || clientsInfo.length == 0 ? new String[]{} : new String[clientsInfo.length];
                    for (int i = 0; i < clientNames.length; ++i) {
                        clientNames[i] = clientsInfo[i] != null ? clientsInfo[i].getName() : null;
                    }
                    return clientNames;
                }
                throw new IllegalArgumentException("invalid app name");
            }
        }

        public final int[] getWatchedAppFlows(String appName) {
            Map<String, SrvMonAppInfo> map = this.appsInfo;
            synchronized (map) {
                SrvMonAppInfo appInfo = this.appsInfo.get(appName);
                if (appInfo != null) {
                    SrvMonAppFlowInfo[] flowsInfo = appInfo.getFlowsInfo();
                    int[] flowids = flowsInfo == null || flowsInfo.length == 0 ? new int[]{} : new int[flowsInfo.length];
                    for (int i = 0; i < flowids.length; ++i) {
                        flowids[i] = flowsInfo[i] != null ? flowsInfo[i].getId() : -1;
                    }
                    return flowids;
                }
                throw new IllegalArgumentException("invalid app name");
            }
        }
    }

    protected static enum State {
        Init,
        Open,
        Closing,
        Closed,
        Failed;

    }
}

