/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.types;

import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBodyVariable;
import java.util.Properties;

public class PktBodyServerClientConnectRequest
extends PktBodyVariable {
    private int APPVER_POS;
    private int THRAFF_POS;
    private int APPNAMELEN_POS;
    private int APPNAME_POS;
    private int RESERVEDLEN_POS;
    private int RESERVED_POS;
    private int CLIENTNAMELEN_POS;
    private int CLIENTNAME_POS;
    private int CLIENTGROUPLEN_POS;
    private int CLIENTGROUP_POS;
    private short appNameLen;
    private byte[] appName;
    private short reservedLen;
    private byte[] reserved;
    private short clientNameLen;
    private byte[] clientName;
    private short clientGroupLen;
    private byte[] clientGroup;
    private boolean readOnly;

    private PktBodyServerClientConnectRequest(Properties props) {
        super(556);
    }

    public static PktBody create(Properties props) {
        return new PktBodyServerClientConnectRequest(props);
    }

    public static PktBody create() {
        return PktBodyServerClientConnectRequest.create(null);
    }

    private final void updateFieldOffsets() {
        this.APPVER_POS = 0;
        this.THRAFF_POS = this.APPVER_POS + 2;
        this.APPNAMELEN_POS = this.THRAFF_POS + 2;
        this.APPNAME_POS = this.APPNAMELEN_POS + 2;
        this.RESERVEDLEN_POS = this.APPNAME_POS + Math.max(0, this.appNameLen);
        this.RESERVED_POS = this.RESERVEDLEN_POS + 2;
        this.CLIENTNAMELEN_POS = this.RESERVED_POS + Math.max(0, this.reservedLen);
        this.CLIENTNAME_POS = this.CLIENTNAMELEN_POS + 2;
        this.CLIENTGROUPLEN_POS = this.CLIENTNAME_POS + Math.max(0, this.clientNameLen);
        this.CLIENTGROUP_POS = this.CLIENTGROUPLEN_POS + 2;
    }

    private final void init() {
        this.appNameLen = 0;
        this.appName = null;
        this.reservedLen = 0;
        this.reserved = null;
        this.clientNameLen = 0;
        this.clientName = null;
        this.clientGroupLen = 0;
        this.clientGroup = null;
        this.updateFieldOffsets();
        this.readOnly = false;
    }

    private final void initAppNameFromBuffer(boolean onlyOffset) {
        if (this.appName == null) {
            this.appNameLen = this.buffer.getShort(this.APPNAMELEN_POS);
            if (!onlyOffset) {
                if (this.appNameLen == 0) {
                    this.appName = null;
                } else if (this.appNameLen < 0) {
                    this.appName = new byte[0];
                } else {
                    this.appName = new byte[this.appNameLen];
                    this.buffer.getTo(this.APPNAME_POS, this.appName, 0, (int)this.appNameLen);
                }
            }
        }
    }

    private final void initReservedFromBuffer(boolean onlyOffset) {
        if (this.reserved == null) {
            this.reservedLen = this.buffer.getShort(this.RESERVEDLEN_POS);
            if (!onlyOffset) {
                if (this.reservedLen == 0) {
                    this.reserved = null;
                } else if (this.reservedLen < 0) {
                    this.reserved = new byte[0];
                } else {
                    this.reserved = new byte[this.reservedLen];
                    this.buffer.getTo(this.RESERVED_POS, this.reserved, 0, (int)this.reservedLen);
                }
            }
        }
    }

    private final void initClientNameFromBuffer(boolean onlyOffset) {
        if (this.clientName == null) {
            this.clientNameLen = this.buffer.getShort(this.CLIENTNAMELEN_POS);
            if (!onlyOffset) {
                if (this.clientNameLen == 0) {
                    this.clientName = null;
                } else if (this.clientNameLen < 0) {
                    this.clientName = new byte[0];
                } else {
                    this.clientName = new byte[this.clientNameLen];
                    this.buffer.getTo(this.CLIENTNAME_POS, this.clientName, 0, (int)this.clientNameLen);
                }
            }
        }
    }

    private final void initClientGroupFromBuffer(boolean onlyOffset) {
        if (this.clientGroup == null) {
            this.clientGroupLen = this.buffer.getShort(this.CLIENTGROUPLEN_POS);
            if (!onlyOffset) {
                if (this.clientGroupLen == 0) {
                    this.clientGroup = null;
                } else if (this.clientGroupLen < 0) {
                    this.clientGroup = new byte[0];
                } else {
                    this.clientGroup = new byte[this.clientGroupLen];
                    this.buffer.getTo(this.CLIENTGROUP_POS, this.clientGroup, 0, (int)this.clientGroupLen);
                }
            }
        }
    }

    public final void initialize() {
        this.init();
    }

    protected final boolean isResettable() {
        return true;
    }

    protected final void doReset() {
        this.init();
    }

    public final int doGetSerializedLength() {
        return 4 + (2 + Math.max(0, this.appNameLen)) + (2 + Math.max(0, this.reservedLen)) + (2 + Math.max(0, this.clientNameLen)) + (2 + Math.max(0, this.clientGroupLen));
    }

    public final void doDesync(int len) {
        this.initAppNameFromBuffer(true);
        this.updateFieldOffsets();
        this.initReservedFromBuffer(true);
        this.updateFieldOffsets();
        this.initClientNameFromBuffer(true);
        this.updateFieldOffsets();
        this.initClientGroupFromBuffer(true);
        this.readOnly = true;
    }

    public final void setAppVersion(short version) {
        if (this.readOnly) {
            throw new IllegalStateException("body is ready only");
        }
        this.buffer.putShort(this.APPVER_POS, version);
    }

    public final short getAppVersion() {
        return this.buffer.getShort(this.APPVER_POS);
    }

    public final void setThreadAffinity(short threadId) {
        if (this.readOnly) {
            throw new IllegalStateException("body is ready only");
        }
        this.buffer.putShort(this.THRAFF_POS, threadId);
    }

    public final short getThreadAffinity() {
        return this.buffer.getShort(this.THRAFF_POS);
    }

    public final void setAppName(String appName) {
        if (this.readOnly) {
            throw new IllegalStateException("body is ready only");
        }
        if (appName == null) {
            this.appName = null;
            this.appNameLen = 0;
        } else {
            try {
                this.appName = appName.getBytes("UTF-8");
                this.appNameLen = (short)(this.appName.length == 0 ? -1 : this.appName.length);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.updateFieldOffsets();
        this.buffer.putShort(this.APPNAMELEN_POS, this.appNameLen);
        if (this.appName != null && this.appName.length > 0) {
            this.buffer.putFrom(this.APPNAME_POS, this.appName, 0, (int)this.appNameLen);
        }
        this.buffer.putShort(this.RESERVEDLEN_POS, this.reservedLen);
        if (this.reserved != null && this.reserved.length > 0) {
            this.buffer.putFrom(this.RESERVED_POS, this.reserved, 0, (int)this.reservedLen);
        }
        this.buffer.putShort(this.CLIENTNAMELEN_POS, this.clientNameLen);
        if (this.clientName != null && this.clientName.length > 0) {
            this.buffer.putFrom(this.CLIENTNAME_POS, this.clientName, 0, (int)this.clientNameLen);
        }
        this.buffer.putShort(this.CLIENTGROUPLEN_POS, this.clientGroupLen);
        if (this.clientGroup != null && this.clientGroup.length > 0) {
            this.buffer.putFrom(this.CLIENTGROUP_POS, this.clientGroup, 0, (int)this.clientGroupLen);
        }
    }

    public final String getAppName() {
        if (this.appName == null) {
            this.initAppNameFromBuffer(false);
        }
        if (this.appName == null) {
            return null;
        }
        try {
            return new String(this.appName, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void setClientName(String clientName) {
        if (this.readOnly) {
            throw new IllegalStateException("body is ready only");
        }
        if (clientName == null) {
            this.clientName = null;
            this.clientNameLen = 0;
        } else {
            try {
                this.clientName = clientName.getBytes("UTF-8");
                this.clientNameLen = (short)(this.clientName.length == 0 ? -1 : this.clientName.length);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.updateFieldOffsets();
        this.buffer.putShort(this.CLIENTNAMELEN_POS, this.clientNameLen);
        if (this.clientName != null && this.clientName.length > 0) {
            this.buffer.putFrom(this.CLIENTNAME_POS, this.clientName, 0, (int)this.clientNameLen);
        }
        this.buffer.putShort(this.CLIENTGROUPLEN_POS, this.clientGroupLen);
        if (this.clientGroup != null && this.clientGroup.length > 0) {
            this.buffer.putFrom(this.CLIENTGROUP_POS, this.clientGroup, 0, (int)this.clientGroupLen);
        }
    }

    public final String getClientName() {
        if (this.clientName == null) {
            this.initClientNameFromBuffer(false);
        }
        if (this.clientName == null) {
            return null;
        }
        try {
            return new String(this.clientName, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void setClientGroup(String clientGroup) {
        if (this.readOnly) {
            throw new IllegalStateException("body is ready only");
        }
        if (clientGroup == null) {
            this.clientGroup = null;
            this.clientGroupLen = 0;
        } else {
            try {
                this.clientGroup = clientGroup.getBytes("UTF-8");
                this.clientGroupLen = (short)(this.clientGroup.length == 0 ? -1 : this.clientGroup.length);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.updateFieldOffsets();
        this.buffer.putShort(this.CLIENTGROUPLEN_POS, this.clientGroupLen);
        if (this.clientGroup != null && this.clientGroup.length > 0) {
            this.buffer.putFrom(this.CLIENTGROUP_POS, this.clientGroup, 0, (int)this.clientGroupLen);
        }
    }

    public final String getClientGroup() {
        if (this.clientGroup == null) {
            this.initClientGroupFromBuffer(false);
        }
        if (this.clientGroup == null) {
            return null;
        }
        try {
            return new String(this.clientGroup, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final String toString() {
        return "<appver=" + this.getAppVersion() + " thraff=" + this.getThreadAffinity() + " appname=" + this.getAppName() + " clientname=" + this.getClientName() + " clientgroup=" + this.getClientGroup() + ">";
    }
}

