/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.jms.activemq;

import com.neeve.event.IEventHandler;
import com.neeve.jms.JmsMessageBusBinding;
import com.neeve.jms.activemq.ActiveMQMessageChannel;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaPermanentException;
import com.neeve.trace.Tracer;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.TopicConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;

final class ActiveMQMessageBusBinding
extends JmsMessageBusBinding {
    ActiveMQMessageBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        super(userName, descriptor, eventHandler);
    }

    @Override
    protected MessageChannel doGetMessageChannel(MessageChannelDescriptor descriptor) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Creating new channel '" + descriptor.getName() + "'.", Tracer.Level.DEBUG);
        }
        return new ActiveMQMessageChannel(descriptor, this);
    }

    @Override
    protected TopicConnectionFactory createTopicConnectionFactory(String address, Properties providerConfig) throws Exception {
        if (!address.startsWith("tcp://")) {
            address = "tcp://" + address;
        }
        if (this.jndi) {
            TopicConnectionFactory factory = super.createTopicConnectionFactory(address, providerConfig);
            if (!(factory instanceof ActiveMQConnectionFactory)) {
                throw new SmaPermanentException("Factory loaded via JNDI is not an instanceof ActiveMQConnectionFactory. Found: " + factory.getClass().getName());
            }
            return factory;
        }
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.userName, providerConfig.getProperty("password"), address);
        return factory;
    }

    @Override
    protected final boolean supportsGuaranteedQos() {
        return true;
    }

    @Override
    protected final int getDeliveryMode(MessageChannel.Qos qos) {
        switch (qos) {
            case BestEffort: {
                return 1;
            }
            case Guaranteed: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    protected final int getAcknowledgementMode(MessageChannel.Qos qos) {
        switch (qos) {
            case BestEffort: {
                return 1;
            }
            case Guaranteed: {
                return 4;
            }
        }
        return 1;
    }

    @Override
    public final void onException(JMSException e) {
        if (e.getMessage().startsWith("Could not correlate")) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Ignoring ack correlation error [" + e.toString() + "]", Tracer.Level.DEBUG);
            }
        } else {
            super.onException(e);
        }
    }
}

