/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.serialization.rumi.protobuf.serial;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XStringDeserializer;
import com.neeve.perf.serialization.Provider;
import com.neeve.perf.serialization.rumi.protobuf.Acceleration;
import com.neeve.perf.serialization.rumi.protobuf.BooleanType;
import com.neeve.perf.serialization.rumi.protobuf.Car;
import com.neeve.perf.serialization.rumi.protobuf.Code;
import com.neeve.perf.serialization.rumi.protobuf.Engine;
import com.neeve.perf.serialization.rumi.protobuf.FuelFigure;
import com.neeve.perf.serialization.rumi.protobuf.OptionalExtras;
import com.neeve.perf.serialization.rumi.protobuf.PerformanceFigure;
import com.neeve.sma.MessageView;
import com.neeve.util.UtlTime;
import java.io.UnsupportedEncodingException;

public class CarBenchmark
implements Provider<Car> {
    private static final byte[] MANUFACTURER;
    private static final byte[] MODEL;
    private static final byte[] ENG_MAN_CODE;
    private static final byte[] VEHICLE_CODE;
    private static final int[] SOME_NUMBERS;
    private static final OptionalExtras[] EXTRAS;
    private final Car.Serializer carSerializer = Car.Serializer.create();
    private final Car.Deserializer carDeserializer = Car.Deserializer.create();
    private final Engine.Serializer engineSerializer = Engine.Serializer.create();
    private final PerformanceFigure.Serializer performanceFigureSerializer = PerformanceFigure.Serializer.create();
    private final FuelFigure.Serializer fuelFigureSerializer = FuelFigure.Serializer.create();
    private final Acceleration.Serializer accelerationSerializer = Acceleration.Serializer.create();
    private final CarDeserializationCallback cb = new CarDeserializationCallback();
    private final IOBuffer carEncodeBuffer = IOBuffer.create((int)1024);
    private int carEncodedLength;
    private final IOBuffer carDecodeBuffer = IOBuffer.create((int)1024);
    private final int carDecodeLength;
    private final IOBuffer tempBuffer1 = IOBuffer.create((int)32);
    private final IOBuffer tempBuffer2 = IOBuffer.create((int)128);

    public CarBenchmark() {
        this.carDecodeLength = this.serializeTo(this.carDecodeBuffer);
    }

    private static final int serializeTo(Car.Serializer carSerializer, Engine.Serializer engineSerializer, PerformanceFigure.Serializer performanceFigureSerializer, FuelFigure.Serializer fuelFigureSerializer, Acceleration.Serializer accelerationSerializer, IOBuffer tempBuffer1, IOBuffer tempBuffer2) {
        int i;
        carSerializer.serialNumber(12345).modelYear((short)2005).available(BooleanType.T).code(Code.A).vehicleCode(VEHICLE_CODE);
        for (i = 0; i < SOME_NUMBERS.length; ++i) {
            carSerializer.someNumbers(SOME_NUMBERS[i]);
        }
        for (i = 0; i < EXTRAS.length; ++i) {
            carSerializer.extras(EXTRAS[i]);
        }
        engineSerializer.init(tempBuffer1).capacity((short)4200).numCylinders((byte)8).manufacturerCode(ENG_MAN_CODE).done();
        carSerializer.engine(engineSerializer);
        fuelFigureSerializer.init(tempBuffer1).speed((short)30).mpg(35.9f).done();
        carSerializer.fuelFigure(fuelFigureSerializer);
        fuelFigureSerializer.init(tempBuffer1).speed((short)55).mpg(49.0f).done();
        carSerializer.fuelFigure(fuelFigureSerializer);
        fuelFigureSerializer.init(tempBuffer1).speed((short)75).mpg(40.0f).done();
        carSerializer.fuelFigure(fuelFigureSerializer);
        performanceFigureSerializer.init(tempBuffer1).octaneRating((byte)95);
        accelerationSerializer.init(tempBuffer2).mph((short)30).seconds(4.0f).done();
        performanceFigureSerializer.acceleration(accelerationSerializer);
        accelerationSerializer.init(tempBuffer2).mph((short)60).seconds(7.5f).done();
        performanceFigureSerializer.acceleration(accelerationSerializer);
        accelerationSerializer.init(tempBuffer2).mph((short)100).seconds(12.2f).done();
        performanceFigureSerializer.acceleration(accelerationSerializer);
        performanceFigureSerializer.done();
        carSerializer.performanceFigure(performanceFigureSerializer);
        performanceFigureSerializer.init(tempBuffer1).octaneRating((byte)99);
        accelerationSerializer.init(tempBuffer2).mph((short)30).seconds(3.8f).done();
        performanceFigureSerializer.acceleration(accelerationSerializer);
        accelerationSerializer.init(tempBuffer2).mph((short)60).seconds(7.1f).done();
        performanceFigureSerializer.acceleration(accelerationSerializer);
        accelerationSerializer.init(tempBuffer2).mph((short)100).seconds(11.8f).done();
        performanceFigureSerializer.acceleration(accelerationSerializer);
        performanceFigureSerializer.done();
        carSerializer.performanceFigure(performanceFigureSerializer);
        return carSerializer.manufacturer(MANUFACTURER).model(MODEL).done();
    }

    public static final int serializeTo(Car.Serializer carSerializer, Engine.Serializer engineSerializer, PerformanceFigure.Serializer performanceFigureSerializer, FuelFigure.Serializer fuelFigureSerializer, Acceleration.Serializer accelerationSerializer, IOBuffer carEncodeBuffer, IOBuffer tempBuffer1, IOBuffer tempBuffer2) {
        return CarBenchmark.serializeTo(carSerializer.init(carEncodeBuffer), engineSerializer, performanceFigureSerializer, fuelFigureSerializer, accelerationSerializer, tempBuffer1, tempBuffer2);
    }

    private final int serializeTo(IOBuffer buffer) {
        return CarBenchmark.serializeTo(this.carSerializer, this.engineSerializer, this.performanceFigureSerializer, this.fuelFigureSerializer, this.accelerationSerializer, buffer, this.tempBuffer1, this.tempBuffer2);
    }

    private final int serializeTo(Car car) {
        return CarBenchmark.serializeTo(car.serializer(1024), this.engineSerializer, this.performanceFigureSerializer, this.fuelFigureSerializer, this.accelerationSerializer, this.tempBuffer1, this.tempBuffer2);
    }

    private final int serializeTo(Car.Serializer carSerializer) {
        return CarBenchmark.serializeTo(carSerializer, this.engineSerializer, this.performanceFigureSerializer, this.fuelFigureSerializer, this.accelerationSerializer, this.tempBuffer1, this.tempBuffer2);
    }

    private final void deserializeFrom(IOBuffer buffer, int len) {
        this.carDeserializer.init(buffer, 0, len).run((Car.Deserializer.Callback)this.cb);
    }

    private final void deserializeFrom(Car car) {
        car.deserializer().run((Car.Deserializer.Callback)this.cb);
    }

    @Override
    public String name() {
        return "rumi.protobuf.serial";
    }

    @Override
    public short vfid() {
        return -2;
    }

    @Override
    public short otype() {
        return 1;
    }

    @Override
    public int encoding() {
        return 4;
    }

    @Override
    public Car create(boolean encode) {
        Car car = Car.create();
        Car.Serializer serializer = car.serializer(1024);
        serializer.timestamp(UtlTime.now());
        if (encode) {
            this.carEncodedLength = this.serializeTo(serializer);
        }
        return car;
    }

    @Override
    public void prepareToEncode() {
    }

    @Override
    public void encode(Car car) {
        this.carEncodedLength = this.serializeTo(car);
    }

    @Override
    public void encode() {
        this.carEncodedLength = this.serializeTo(this.carEncodeBuffer);
    }

    @Override
    public int encodedLength() {
        return this.carEncodedLength;
    }

    @Override
    public void postEncode() {
    }

    @Override
    public void prepareToDecode() {
    }

    @Override
    public void decode(Car car) {
        this.deserializeFrom(car);
    }

    @Override
    public void decode() {
        this.deserializeFrom(this.carDecodeBuffer, this.carDecodeLength);
    }

    @Override
    public int decodedLength() {
        return this.carDecodeLength;
    }

    @Override
    public void postDecode() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long dispose(MessageView view) {
        Car car = (Car)view;
        try {
            this.cb.ts = 0L;
            this.decode(car);
            long l = this.cb.ts;
            return l;
        }
        finally {
            car.dispose();
        }
    }

    static {
        try {
            MANUFACTURER = "MANUFACTURER".getBytes("UTF-8");
            MODEL = "MODEL".getBytes("UTF-8");
            ENG_MAN_CODE = "abc".getBytes("UTF-8");
            VEHICLE_CODE = "abcdef".getBytes("UTF-8");
            SOME_NUMBERS = new int[]{0, 1, 2, 3, 4};
            EXTRAS = new OptionalExtras[]{OptionalExtras.sportsPack, OptionalExtras.sunRoof};
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static final class AccelerationDeserializationCallback
    implements Acceleration.Deserializer.Callback {
        private AccelerationDeserializationCallback() {
        }

        public void handleMph(short val) {
        }

        public void handleSeconds(float val) {
        }
    }

    private static final class PerformanceFigureDeserializationCallback
    implements PerformanceFigure.Deserializer.Callback {
        private final AccelerationDeserializationCallback accelerationDeserializationCallback = new AccelerationDeserializationCallback();

        private PerformanceFigureDeserializationCallback() {
        }

        public final void handleOctaneRating(byte val) {
        }

        public final void handleAcceleration(Acceleration.Deserializer val) {
            val.run((Acceleration.Deserializer.Callback)this.accelerationDeserializationCallback);
        }
    }

    private static final class FuelFigureDeserializationCallback
    implements FuelFigure.Deserializer.Callback {
        private FuelFigureDeserializationCallback() {
        }

        public void handleSpeed(short val) {
        }

        public void handleMpg(float val) {
        }
    }

    private static final class EngineDeserializationCallback
    implements Engine.Deserializer.Callback {
        private final byte[] tempBuffer = new byte[128];

        private EngineDeserializationCallback() {
        }

        public void handleCapacity(short val) {
        }

        public void handleNumCylinders(byte val) {
        }

        public void handleMaxRpm(short val) {
        }

        public void handleManufacturerCode(XStringDeserializer val) {
            val.getTo(this.tempBuffer, 0);
        }

        public void handleFuel(XStringDeserializer val) {
        }
    }

    private static final class CarDeserializationCallback
    implements Car.Deserializer.Callback {
        private final byte[] tempBuffer = new byte[128];
        private final EngineDeserializationCallback engineDeserializationCallback = new EngineDeserializationCallback();
        private final FuelFigureDeserializationCallback fuelFigureDeserializationCallback = new FuelFigureDeserializationCallback();
        private final PerformanceFigureDeserializationCallback performanceFigureDeserializationCallback = new PerformanceFigureDeserializationCallback();
        long ts;

        private CarDeserializationCallback() {
        }

        public void handleTimestamp(long val) {
            this.ts = val;
        }

        public void handleSerialNumber(int val) {
        }

        public void handleModelYear(short val) {
        }

        public void handleAvailable(BooleanType val) {
        }

        public void handleCode(Code val) {
        }

        public void handleVehicleCode(XStringDeserializer val) {
            val.getTo(this.tempBuffer, 0);
        }

        public void handleSomeNumbers(int val) {
        }

        public void handleExtras(OptionalExtras val) {
        }

        public void handleEngine(Engine.Deserializer val) {
            val.run((Engine.Deserializer.Callback)this.engineDeserializationCallback);
        }

        public void handlePerformanceFigure(PerformanceFigure.Deserializer val) {
            val.run((PerformanceFigure.Deserializer.Callback)this.performanceFigureDeserializationCallback);
        }

        public void handleFuelFigure(FuelFigure.Deserializer val) {
            val.run((FuelFigure.Deserializer.Callback)this.fuelFigureDeserializationCallback);
        }

        public void handleManufacturer(XStringDeserializer val) {
            val.getTo(this.tempBuffer, 0);
        }

        public void handleModel(XStringDeserializer val) {
            val.getTo(this.tempBuffer, 0);
        }
    }
}

