/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.serialization.rumi.protobuf.random;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XIntIterator;
import com.neeve.lang.XIterator;
import com.neeve.perf.serialization.Provider;
import com.neeve.perf.serialization.rumi.protobuf.Acceleration;
import com.neeve.perf.serialization.rumi.protobuf.BooleanType;
import com.neeve.perf.serialization.rumi.protobuf.Car;
import com.neeve.perf.serialization.rumi.protobuf.Code;
import com.neeve.perf.serialization.rumi.protobuf.Engine;
import com.neeve.perf.serialization.rumi.protobuf.FuelFigure;
import com.neeve.perf.serialization.rumi.protobuf.OptionalExtras;
import com.neeve.perf.serialization.rumi.protobuf.PerformanceFigure;
import com.neeve.sma.MessageView;
import com.neeve.util.UtlTime;
import java.io.UnsupportedEncodingException;

public class CarBenchmark
implements Provider<Car> {
    private final byte[] tempBuffer = new byte[128];
    private final int[] tempIntBuffer = new int[128];
    private static final byte[] MANUFACTURER;
    private static final byte[] MODEL;
    private static final byte[] ENG_MAN_CODE;
    private static final byte[] VEHICLE_CODE;
    private static final int[] SOME_NUMBERS;
    private static final OptionalExtras[] EXTRAS;
    private final Car encodeCar = Car.create();
    private final Car decodeCar = Car.create();
    private final IOBuffer decodeBuffer = IOBuffer.create((int)1024);
    private final int decodeLength = com.neeve.perf.serialization.rumi.protobuf.serial.CarBenchmark.serializeTo(Car.Serializer.create(), Engine.Serializer.create(), PerformanceFigure.Serializer.create(), FuelFigure.Serializer.create(), Acceleration.Serializer.create(), this.decodeBuffer, IOBuffer.create((int)32), IOBuffer.create((int)128));
    private int encodedLength;

    private Car populate(Car car) {
        Car.Pojo pojo = car.pojo();
        pojo.setSerialNumber(12345);
        pojo.setModelYear((short)2005);
        pojo.setAvailable(BooleanType.T);
        pojo.setCode(Code.A);
        pojo.setVehicleCodeFrom(VEHICLE_CODE, 0, VEHICLE_CODE.length);
        pojo.setSomeNumbersFrom(SOME_NUMBERS, 0, SOME_NUMBERS.length);
        pojo.setExtrasFrom(EXTRAS, 0, EXTRAS.length);
        Engine engine = Engine.create();
        Engine.Pojo epojo = engine.pojo();
        epojo.setCapacity((short)4200);
        epojo.setNumCylinders((byte)8);
        epojo.setManufacturerCodeFrom(ENG_MAN_CODE, 0, ENG_MAN_CODE.length);
        pojo.setEngine(engine);
        FuelFigure fuelFigure = FuelFigure.create();
        FuelFigure.Pojo fpojo = fuelFigure.pojo();
        fpojo.setSpeed((short)30);
        fpojo.setMpg(35.9f);
        pojo.addToFuelFigure(fuelFigure);
        fuelFigure = FuelFigure.create();
        fpojo = fuelFigure.pojo();
        fpojo.setSpeed((short)55);
        fpojo.setMpg(49.0f);
        pojo.addToFuelFigure(fuelFigure);
        fuelFigure = FuelFigure.create();
        fpojo = fuelFigure.pojo();
        fpojo.setSpeed((short)75);
        fpojo.setMpg(40.0f);
        pojo.addToFuelFigure(fuelFigure);
        PerformanceFigure performanceFigure = PerformanceFigure.create();
        PerformanceFigure.Pojo ppojo = performanceFigure.pojo();
        ppojo.setOctaneRating((byte)95);
        Acceleration acceleration = Acceleration.create();
        Acceleration.Pojo apojo = acceleration.pojo();
        apojo.setMph((short)30);
        apojo.setSeconds(4.0f);
        ppojo.addToAcceleration(acceleration);
        acceleration = Acceleration.create();
        apojo = acceleration.pojo();
        apojo.setMph((short)60);
        apojo.setSeconds(7.5f);
        ppojo.addToAcceleration(acceleration);
        acceleration = Acceleration.create();
        apojo = acceleration.pojo();
        apojo.setMph((short)100);
        apojo.setSeconds(12.2f);
        ppojo.addToAcceleration(acceleration);
        pojo.addToPerformanceFigure(performanceFigure);
        performanceFigure = PerformanceFigure.create();
        ppojo = performanceFigure.pojo();
        ppojo.setOctaneRating((byte)99);
        acceleration = Acceleration.create();
        apojo = acceleration.pojo();
        apojo.setMph((short)30);
        apojo.setSeconds(3.8f);
        ppojo.addToAcceleration(acceleration);
        acceleration = Acceleration.create();
        apojo = acceleration.pojo();
        apojo.setMph((short)60);
        apojo.setSeconds(7.1f);
        ppojo.addToAcceleration(acceleration);
        acceleration = Acceleration.create();
        apojo = acceleration.pojo();
        apojo.setMph((short)100);
        apojo.setSeconds(11.8f);
        ppojo.addToAcceleration(acceleration);
        pojo.addToPerformanceFigure(performanceFigure);
        pojo.setManufacturerFrom(MANUFACTURER, 0, MANUFACTURER.length);
        pojo.setModelFrom(MODEL, 0, MODEL.length);
        return car;
    }

    private void extract(Car car) {
        Car.Pojo pojo = car.pojo();
        pojo.getSerialNumber();
        pojo.getModelYear();
        pojo.getAvailable();
        pojo.getCode();
        pojo.getVehicleCode();
        XIntIterator someNumbersIterator = pojo.getSomeNumbersIterator();
        while (someNumbersIterator.hasNext()) {
            someNumbersIterator.next();
        }
        XIterator extrasIterator = pojo.getExtrasIterator();
        while (extrasIterator.hasNext()) {
            extrasIterator.next();
        }
        Engine engine = pojo.getEngine();
        Engine.Pojo epojo = engine.pojo();
        epojo.getCapacity();
        epojo.getNumCylinders();
        epojo.getManufacturerCode();
        XIterator fuelFigureIterator = pojo.getFuelFigureIterator();
        while (fuelFigureIterator.hasNext()) {
            FuelFigure fuelFigure = (FuelFigure)fuelFigureIterator.next();
            FuelFigure.Pojo fpojo = fuelFigure.pojo();
            fpojo.getSpeed();
            fpojo.getMpg();
        }
        XIterator performanceFigureIterator = pojo.getPerformanceFigureIterator();
        while (performanceFigureIterator.hasNext()) {
            PerformanceFigure performanceFigure = (PerformanceFigure)performanceFigureIterator.next();
            PerformanceFigure.Pojo ppojo = performanceFigure.pojo();
            ppojo.getOctaneRating();
            XIterator accelerationIterator = ppojo.getAccelerationIterator();
            while (accelerationIterator.hasNext()) {
                Acceleration acceleration = (Acceleration)accelerationIterator.next();
                Acceleration.Pojo apojo = acceleration.pojo();
                apojo.getMph();
                apojo.getSeconds();
            }
        }
        pojo.getManufacturer();
        pojo.getModel();
    }

    @Override
    public String name() {
        return "rumi.protobuf.random";
    }

    @Override
    public short vfid() {
        return -2;
    }

    @Override
    public short otype() {
        return 1;
    }

    @Override
    public int encoding() {
        return 4;
    }

    @Override
    public Car create(boolean encode) {
        Car car = Car.create();
        car.setTimestamp(UtlTime.now());
        if (encode) {
            this.encode(car);
        }
        return car;
    }

    @Override
    public void prepareToEncode() {
        this.encodeCar.clear(false);
    }

    @Override
    public void encode(Car car) {
        this.populate(car).sync();
        this.encodedLength = this.encodeCar.getSerializedBufferLength();
    }

    @Override
    public void encode() {
        this.populate(this.encodeCar).sync();
        this.encodedLength = this.encodeCar.getSerializedBufferLength();
    }

    @Override
    public int encodedLength() {
        return this.encodedLength;
    }

    @Override
    public void postEncode() {
    }

    @Override
    public void prepareToDecode() {
        this.decodeCar.clear(false);
    }

    @Override
    public void decode(Car car) {
        this.extract(car);
    }

    @Override
    public void decode() {
        this.decodeBuffer.acquire();
        this.decodeCar.wrap(this.decodeBuffer, this.decodeLength);
        this.extract(this.decodeCar);
    }

    @Override
    public int decodedLength() {
        return this.decodeLength;
    }

    @Override
    public void postDecode() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long dispose(MessageView view) {
        Car car = (Car)view;
        try {
            long l = car.getTimestamp();
            return l;
        }
        finally {
            car.dispose();
        }
    }

    static {
        try {
            MANUFACTURER = "MANUFACTURER".getBytes("UTF-8");
            MODEL = "MODEL".getBytes("UTF-8");
            ENG_MAN_CODE = "abc".getBytes("UTF-8");
            VEHICLE_CODE = "abcdef".getBytes("UTF-8");
            SOME_NUMBERS = new int[]{0, 1, 2, 3, 4};
            EXTRAS = new OptionalExtras[]{OptionalExtras.sportsPack, OptionalExtras.sunRoof};
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

