/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.eaio.uuid.UUID;
import com.neeve.util.UtlTableFormatter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;

public class UtlObjectGraph {
    private static int maxCycleDepth = 2;
    private static boolean verbose = false;
    private static final BuiltInHandler builtInHandler = new BuiltInHandler();

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        UtlObjectGraph.verbose = verbose;
    }

    public static final void populateObject(Object o) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        UtlObjectGraph.populateObject(o, System.currentTimeMillis(), Arrays.asList(Object.class), null);
    }

    public static final void populateObject(Object o, Class<?> ... consideredClasses) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        UtlObjectGraph.populateObject(o, System.currentTimeMillis(), Arrays.asList(consideredClasses), null);
    }

    public static final void populateObject(Object o, Collection<Class<?>> consideredClasses) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        UtlObjectGraph.populateObject(o, System.currentTimeMillis(), consideredClasses, null);
    }

    public static final void populateObject(Object o, Collection<Class<?>> consideredClasses, PopulationHelper helper) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        UtlObjectGraph.populateObject(o, System.currentTimeMillis(), consideredClasses, helper);
    }

    public static final void populateObject(Object o, long seed, Collection<Class<?>> consideredClasses, PopulationHelper helper) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Collection<?> factorySet;
        Random random = new Random(seed);
        HashMap<String, Object> factories = new HashMap<String, Object>();
        if (helper != null && (factorySet = helper.getFactoryObjects()) != null) {
            for (Object factory : factorySet) {
                for (Method creator : factory.getClass().getMethods()) {
                    if (creator.getReturnType() == null || !creator.getName().startsWith("create") || creator.getParameterTypes().length > 0 || (creator.getModifiers() & 1) == 0) continue;
                    factories.put(creator.getReturnType().getName(), factory);
                }
            }
        }
        Stack<String> stack = new Stack<String>();
        stack.push(o.getClass().getSimpleName());
        UtlObjectGraph.populateObjectInternal(o, random, new HashMap(), stack, consideredClasses, factories, helper);
    }

    public static final <T> Object createRandomArray(Class<T> clazz, int maxLength, Random random) {
        if (clazz.isPrimitive()) {
            return builtInHandler.createRandomPrimitiveArray(clazz, maxLength, random);
        }
        Object[] newArray = (Object[])Array.newInstance(clazz, random.nextInt(maxLength));
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = BuiltInHandler.getRandomValue(clazz, random);
        }
        return newArray;
    }

    private static Integer incrementCycleDepth(Class<?> clazz, HashMap<Class<?>, Integer> visited) {
        Integer cycleDepth = visited.get(clazz);
        if (cycleDepth == null) {
            cycleDepth = 0;
            visited.put(clazz, 1);
        } else {
            visited.put(clazz, cycleDepth + 1);
        }
        return cycleDepth;
    }

    private static Integer decrementCycleDepth(Class<?> clazz, HashMap<Class<?>, Integer> visited) {
        Integer cycleDepth = visited.get(clazz);
        if (cycleDepth == null || cycleDepth == 0) {
            throw new IllegalStateException("Negative cycle depth");
        }
        if (cycleDepth == 1) {
            visited.remove(clazz);
        }
        visited.put(clazz, cycleDepth - 1);
        return cycleDepth;
    }

    private static final void populateObjectInternal(Object o, Random random, HashMap<Class<?>, Integer> visited, Stack<String> stack, Collection<Class<?>> consideredClasses, HashMap<String, Object> objectFactories, PopulationHelper helper) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (builtInHandler.handlesParam(o.getClass())) {
            return;
        }
        if (o.getClass().isArray()) {
            Object[] array = (Object[])o;
            for (int i = 0; i < array.length; ++i) {
                stack.push("[" + i + "]");
                if (array[i] == null) {
                    array[i] = UtlObjectGraph.getRandomParameterValue(o.getClass().getComponentType(), objectFactories, stack, helper, random);
                }
                UtlObjectGraph.populateObjectInternal(array[i], random, visited, stack, consideredClasses, objectFactories, helper);
                stack.pop();
            }
        } else {
            if (o instanceof Collection) {
                Collection c = (Collection)o;
                if (c.isEmpty()) {
                    Iterator params;
                    int size = random.nextInt(10);
                    Object object = params = helper == null ? null : helper.getTypeParameters(o, Collection.class, stack);
                    if (params != null) {
                        for (int i = 0; i < size; ++i) {
                            c.add(UtlObjectGraph.getRandomParameterValue(params[0], objectFactories, stack, helper, random));
                        }
                    }
                }
                int i = 0;
                for (Object e : c) {
                    if (e == null) continue;
                    stack.push("{" + i + "}");
                    UtlObjectGraph.populateObjectInternal(e, random, visited, stack, consideredClasses, objectFactories, helper);
                    stack.pop();
                    ++i;
                }
                return;
            }
            if (o instanceof Map) {
                Map map = (Map)o;
                if (map.isEmpty()) {
                    Class<?>[] params;
                    int size = random.nextInt(10);
                    Class<?>[] classArray = params = helper == null ? null : helper.getTypeParameters(o, Map.class, stack);
                    if (params != null) {
                        for (int i = 0; i < size; ++i) {
                            Object key = UtlObjectGraph.getRandomParameterValue(params[0], objectFactories, stack, helper, random);
                            Object value = UtlObjectGraph.getRandomParameterValue(params[1], objectFactories, stack, helper, random);
                            stack.push("{Key " + i + "}");
                            UtlObjectGraph.populateObjectInternal(key, random, visited, stack, consideredClasses, objectFactories, helper);
                            stack.pop();
                            map.put(key, value);
                        }
                    }
                }
                int i = 0;
                for (Object e : map.values()) {
                    if (e == null) continue;
                    stack.push("{value " + i + "}");
                    UtlObjectGraph.populateObjectInternal(e, random, visited, stack, consideredClasses, objectFactories, helper);
                    stack.pop();
                    ++i;
                }
                return;
            }
            for (Class<?> intf : consideredClasses) {
                if (!intf.isAssignableFrom(o.getClass())) continue;
                for (Method getter : intf.getDeclaredMethods()) {
                    Object child;
                    if (getter.getReturnType() == null || !getter.getName().startsWith("get") || getter.getParameterTypes().length > 0 || (getter.getModifiers() & 1) == 0 || getter.getName().endsWith("AsRaw") || getter.getName().endsWith("OrThrow") || getter.getName().endsWith("EmptyIfNull")) continue;
                    Method setter = null;
                    try {
                        setter = intf.getMethod("set" + getter.getName().substring(3), getter.getReturnType());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean builtIn = builtInHandler.handlesParam(getter.getReturnType());
                    Class<?> paramClass = getter.getReturnType();
                    stack.push(getter.getName() + "()");
                    Integer cycleDepth = UtlObjectGraph.incrementCycleDepth(paramClass, visited);
                    if (cycleDepth >= maxCycleDepth) {
                        UtlObjectGraph.decrementCycleDepth(paramClass, visited);
                        stack.pop();
                        continue;
                    }
                    if (setter != null) {
                        Object parameter = UtlObjectGraph.getRandomParameterValue(paramClass, objectFactories, stack, helper, random);
                        if (parameter != null) {
                            if (verbose) {
                                if (paramClass.isArray() && builtIn) {
                                    System.out.println("Setting " + UtlObjectGraph.unwindStack(new StringBuffer(), stack) + "." + setter.getName() + "( new" + UtlObjectGraph.builtInHandler.arrayToList(parameter) + ")");
                                } else if (builtIn) {
                                    System.out.println("Setting " + UtlObjectGraph.unwindStack(new StringBuffer(), stack) + "." + setter.getName() + "(" + parameter + ")");
                                } else if (paramClass.isArray()) {
                                    System.out.println("Setting " + UtlObjectGraph.unwindStack(new StringBuffer(), stack) + "." + setter.getName() + "(new " + paramClass.getComponentType().getSimpleName() + "[" + Arrays.asList((Object[])parameter).size() + "]))");
                                } else {
                                    System.out.println("Setting " + UtlObjectGraph.unwindStack(new StringBuffer(), stack) + "." + setter.getName() + "(new " + paramClass.getSimpleName() + "())");
                                }
                            }
                            try {
                                setter.invoke(o, parameter);
                            }
                            catch (IllegalAccessException iae) {
                                iae.printStackTrace();
                            }
                        } else if (verbose) {
                            System.out.println("SKIPPED " + UtlObjectGraph.unwindStack(new StringBuffer(), stack) + "." + setter.getName() + "(" + setter.getParameterTypes()[0].getSimpleName() + ")");
                        }
                    }
                    if (!builtIn && (child = getter.invoke(o, new Object[0])) != null) {
                        UtlObjectGraph.populateObjectInternal(child, random, visited, stack, consideredClasses, objectFactories, helper);
                    }
                    UtlObjectGraph.decrementCycleDepth(paramClass, visited);
                    stack.pop();
                }
            }
        }
    }

    private static Object getRandomParameterValue(Class<?> paramClass, HashMap<String, Object> objectFactories, Stack<String> stack, PopulationHelper helper, Random random) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object o;
        if (helper != null && (o = helper.getNewInstance(paramClass, stack, random)) != null) {
            return o;
        }
        boolean builtIn = builtInHandler.handlesParam(paramClass);
        if (builtIn) {
            return BuiltInHandler.getRandomValue(paramClass, random);
        }
        if (paramClass.isArray()) {
            return Array.newInstance(paramClass.getComponentType(), random.nextInt(10));
        }
        Object factory = objectFactories.get(paramClass.getName());
        Method factoryMethod = null;
        Class<?> factoryClass = null;
        if (factory != null) {
            try {
                factoryClass = factory.getClass();
                factoryMethod = factoryClass.getMethod("create" + paramClass.getSimpleName(), new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (factoryMethod == null) {
            factory = null;
            try {
                factoryClass = paramClass;
                factoryMethod = factoryClass.getMethod("create", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (factoryMethod != null) {
            return factoryMethod.invoke(factory, new Object[0]);
        }
        if (factoryMethod == null) {
            try {
                Constructor<?> constructor = paramClass.getConstructor(new Class[0]);
                if (constructor != null) {
                    return paramClass.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Map.class.isAssignableFrom(paramClass)) {
            return new HashMap();
        }
        if (List.class.isAssignableFrom(paramClass)) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(paramClass)) {
            return new HashSet();
        }
        if (Queue.class.isAssignableFrom(paramClass)) {
            return new LinkedBlockingQueue();
        }
        return null;
    }

    public static <T> String diffObjects(T o1, T o2) {
        StringBuffer diffs = new StringBuffer();
        UtlObjectGraph.diffObjects(diffs, "", o1, o2);
        return diffs.toString();
    }

    private static <T> boolean diffObjects(StringBuffer diffs, String prepend, T o1, T o2) {
        Stack<String> stack = new Stack<String>();
        stack.push(o1 != null ? o1.getClass().getSimpleName() : (o2.getClass() != null ? o2.getClass().getSimpleName() : "Object"));
        return UtlObjectGraph.deepEquals(o1, o2, new HashSet(), stack, new DiffRecorder(UtlTableFormatter.Format.TABULAR, diffs));
    }

    public static <T> boolean deepApiEquals(T o1, T o2, StringBuffer diffSummary, Collection<Class<?>> consideredClasses) throws Exception {
        return UtlObjectGraph.deepApiEquals(o1, o2, diffSummary, consideredClasses, null);
    }

    public static <T> boolean deepApiEquals(T o1, T o2, StringBuffer diffSummary, Collection<Class<?>> consideredClasses, ComparatorFactory comparatorFactory) throws Exception {
        return UtlObjectGraph.deepApiEquals(o1, o2, diffSummary, UtlTableFormatter.Format.TABULAR, consideredClasses, comparatorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean deepApiEquals(T o1, T o2, StringBuffer diffSummary, UtlTableFormatter.Format format, Collection<Class<?>> consideredClasses, ComparatorFactory comparatorFactory) throws Exception {
        Stack<String> stack = new Stack<String>();
        DiffRecorder recorder = new DiffRecorder(format, diffSummary);
        try {
            boolean bl = UtlObjectGraph.deepApiEqualsInternal(o1, o2, new HashMap<Object, HashSet<Object>>(), stack, recorder, consideredClasses, comparatorFactory);
            return bl;
        }
        finally {
            recorder.flush();
        }
    }

    private static <T> boolean deepApiEqualsInternal(T o1, T o2, HashMap<Object, HashSet<Object>> alreadyCompared, Stack<String> stack, DiffRecorder summary, Collection<Class<?>> consideredClasses, ComparatorFactory comparatorFactory) throws Exception {
        if (verbose) {
            System.out.println("Comparing: " + UtlObjectGraph.unwindStack(new StringBuffer(), stack));
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        boolean treatNullAndEmptyArraysAsSame = false;
        if (comparatorFactory != null) {
            Comparator<?> comparator = comparatorFactory.getComparator(o1 == null ? o2.getClass() : o1.getClass(), stack);
            if (comparator != null) {
                if (comparator.compare(o1, o2) != 0) {
                    summary.recordDiff("Values Differ", stack, o1, o2);
                    return false;
                }
                return true;
            }
            treatNullAndEmptyArraysAsSame = comparatorFactory.treatEmptyAndNullArraysAsSame();
        }
        if (o1 == null != (o2 == null)) {
            if (treatNullAndEmptyArraysAsSame) {
                if (o1 != null && o1.getClass().isArray() && UtlObjectGraph.builtInHandler.arrayToList(o1).isEmpty()) {
                    return true;
                }
                if (o2 != null && o2.getClass().isArray() && UtlObjectGraph.builtInHandler.arrayToList(o2).isEmpty()) {
                    return true;
                }
            }
            summary.recordDiff("Null Mismatch", stack, o1, o2);
            return false;
        }
        if (o1 == null) {
            return true;
        }
        boolean same = true;
        if (o1.getClass() != o2.getClass()) {
            summary.recordDiff("Type Mismatch", stack, o1.getClass(), o2.getClass());
            return false;
        }
        if (o1.getClass().isArray()) {
            List l1 = UtlObjectGraph.builtInHandler.arrayToList(o1);
            List l2 = UtlObjectGraph.builtInHandler.arrayToList(o2);
            if (l1.size() != l2.size()) {
                summary.recordDiff("Array Sizes Differ", stack, l1.size(), l2.size());
                return false;
            }
            for (int i = 0; i < l1.size(); ++i) {
                stack.push("[" + i + "]");
                Object le1 = l1.get(i);
                Object le2 = l2.get(i);
                if (!UtlObjectGraph.deepApiEqualsInternal(le1, le2, alreadyCompared, stack, summary, consideredClasses, comparatorFactory)) {
                    if (summary == null) {
                        return false;
                    }
                    same = false;
                }
                stack.pop();
            }
        } else if (builtInHandler.handlesParam(o1.getClass())) {
            if (!UtlObjectGraph.builtInHandler.equals(o1, o2)) {
                summary.recordDiff("Values Differ", stack, o1, o2);
                if (!summary.continueRecording()) {
                    return false;
                }
                same = false;
            }
        } else if (o1.getClass().isEnum()) {
            if (o1 != o2) {
                summary.recordDiff("Values Differ", stack, o1, o2);
                if (!summary.continueRecording()) {
                    return false;
                }
                same = false;
            }
        } else if (o1 instanceof List) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1.size() != l2.size()) {
                summary.recordDiff("List Sizes Differ", stack, l1.size(), l2.size());
                if (!summary.continueRecording()) {
                    return false;
                }
                same = false;
            } else {
                for (int i = 0; i < l1.size(); ++i) {
                    stack.push("get(" + i + ")");
                    Object le1 = l1.get(i);
                    Object le2 = l2.get(i);
                    if (!UtlObjectGraph.deepApiEqualsInternal(le1, le2, alreadyCompared, stack, summary, consideredClasses, comparatorFactory)) {
                        if (!summary.continueRecording()) {
                            return false;
                        }
                        same = false;
                    }
                    stack.pop();
                }
            }
        } else if (o1 instanceof Queue) {
            Queue q1 = (Queue)o1;
            Queue q2 = (Queue)o2;
            if (q1.size() != q2.size()) {
                summary.recordDiff("Queue Sizes Differ", stack, q1.size(), q2.size());
                if (!summary.continueRecording()) {
                    return false;
                }
                same = false;
            } else {
                Iterator q1I = q1.iterator();
                Iterator q2I = q2.iterator();
                int i = 0;
                while (q1I.hasNext()) {
                    stack.push("[" + i + "]");
                    Object qe1 = q1I.next();
                    Object qe2 = q2I.next();
                    if (!UtlObjectGraph.deepApiEqualsInternal(qe1, qe2, alreadyCompared, stack, summary, consideredClasses, comparatorFactory)) {
                        if (!summary.continueRecording()) {
                            return false;
                        }
                        same = false;
                    }
                    ++i;
                    stack.pop();
                }
            }
        } else if (o1 instanceof Set) {
            Set s1 = (Set)o1;
            Set s2 = (Set)o2;
            if (s1.size() != s2.size()) {
                summary.recordDiff("Set Sizes Differ", stack, s1.size(), s2.size());
                if (!summary.continueRecording()) {
                    return false;
                }
                same = false;
            } else if (!s1.equals(s2)) {
                summary.recordDiff("Sets differ", stack, s1, s2);
            }
        } else if (o1 instanceof Map) {
            Map m1 = (Map)o1;
            Map m2 = (Map)o2;
            if (m1.size() != m2.size()) {
                summary.recordDiff("Map Sizes Differ", stack, m1.size(), m2.size());
                if (!summary.continueRecording()) {
                    return false;
                }
                same = false;
            } else {
                for (Map.Entry entry : m1.entrySet()) {
                    stack.push("get(" + entry.getKey() + ")");
                    Object mv2 = m2.get(entry.getKey());
                    if (!UtlObjectGraph.deepApiEqualsInternal(entry.getValue(), mv2, alreadyCompared, stack, summary, consideredClasses, comparatorFactory)) {
                        if (!summary.continueRecording()) {
                            return false;
                        }
                        same = false;
                    }
                    stack.pop();
                }
            }
        } else {
            boolean matchIntf = false;
            HashSet<Object> previousComparisons = alreadyCompared.get(o1);
            if (previousComparisons == null) {
                previousComparisons = new HashSet();
                alreadyCompared.put(o1, previousComparisons);
            }
            if (!previousComparisons.add(o2)) {
                if (verbose) {
                    System.out.println("Already compared: " + UtlObjectGraph.unwindStack(new StringBuffer(), stack) + ": " + o1);
                }
                return same;
            }
            for (Class<?> intf : consideredClasses) {
                if (!intf.isAssignableFrom(o1.getClass())) continue;
                matchIntf = true;
                for (Method method : intf.getDeclaredMethods()) {
                    if (method.getReturnType() == null || !method.getName().startsWith("get") || method.getName().endsWith("OrThrow") || method.getName().endsWith("Buffer") || method.getParameterTypes().length > 0 || (method.getModifiers() & 1) == 0) continue;
                    Object f1 = method.invoke(o1, new Object[0]);
                    Object f2 = method.invoke(o2, new Object[0]);
                    stack.push(method.getName() + "()");
                    if (!UtlObjectGraph.deepApiEqualsInternal(f1, f2, alreadyCompared, stack, summary, consideredClasses, comparatorFactory)) {
                        if (summary == null) {
                            return false;
                        }
                        same = false;
                    }
                    stack.pop();
                }
            }
            if (!matchIntf && verbose) {
                System.out.println("SKIPPED " + UtlObjectGraph.unwindStack(new StringBuffer(), stack) + " No matching interfaces to consider");
            }
        }
        return same;
    }

    public static String unwindStack(Stack<String> stack) {
        StringBuffer sb = new StringBuffer();
        UtlObjectGraph.unwindStack(sb, stack);
        return sb.toString();
    }

    private static StringBuffer unwindStack(StringBuffer buf, Stack<String> stack) {
        boolean first = true;
        for (String m : stack) {
            if (!first && !m.startsWith("[")) {
                buf.append(".");
            }
            first = false;
            if (m.endsWith("()")) {
                if (m.startsWith("get") && m.length() > 3) {
                    m = m.substring(3);
                    m = m.substring(0, 1).toLowerCase().concat(m.substring(1, m.length() - 2));
                } else if (m.startsWith("is") && m.length() > 2) {
                    m = m.substring(3);
                    m = m.substring(0, 1).toLowerCase().concat(m.substring(1, m.length() - 1));
                }
            }
            buf.append(m);
        }
        return buf;
    }

    public static <T> boolean deepEquals(T o1, T o2) {
        Stack<String> stack = new Stack<String>();
        return UtlObjectGraph.deepEquals(o1, o2, new HashSet(), stack, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> boolean deepEquals(T o1, T o2, HashSet<?> visited, Stack<String> stack, DiffRecorder summary) {
        if (verbose) {
            System.out.println("Comparing: " + UtlObjectGraph.unwindStack(new StringBuffer(), stack));
        }
        if (o1 == null != (o2 == null)) {
            if (summary != null) {
                summary.recordDiff("Values Differ", stack, o1, o2);
            }
            return false;
        }
        if (o1 == null) {
            return true;
        }
        for (Field field : o1.getClass().getDeclaredFields()) {
            if ((field.getModifiers() & 8) != 0) continue;
            field.setAccessible(true);
            try {
                stack.push(field.getName());
                Object f1 = field.get(o1);
                Object f2 = field.get(o2);
                if (field.getType().isPrimitive()) {
                    if (verbose) {
                        System.out.println("Comparing: " + UtlObjectGraph.unwindStack(new StringBuffer(), stack));
                    }
                    if (UtlObjectGraph.equals(f1, f2)) continue;
                    if (summary != null) {
                        summary.recordDiff("Values Differ", stack, o1, o2);
                    }
                    boolean bl = false;
                    return bl;
                }
                if (field.getType().isEnum()) {
                    if (verbose) {
                        System.out.println("Comparing: " + UtlObjectGraph.unwindStack(new StringBuffer(), stack));
                    }
                    if (f1 == f2) continue;
                    if (summary != null) {
                        summary.recordDiff("Values Differ", stack, o1, o2);
                    }
                    boolean bl = false;
                    return bl;
                }
                if (field.getType().isArray()) {
                    if (verbose) {
                        System.out.println("Comparing: " + UtlObjectGraph.unwindStack(new StringBuffer(), stack));
                    }
                    List<Object> l1 = Arrays.asList(f1);
                    List<Object> l2 = Arrays.asList(f2);
                    if (l1.size() != l2.size()) {
                        if (summary != null) {
                            summary.recordDiff("Values Differ", stack, o1, o2);
                        }
                        boolean bl = false;
                        return bl;
                    }
                    for (int i = 0; i < l1.size(); ++i) {
                        stack.push("[" + i + "]");
                        if (!UtlObjectGraph.deepEquals(l1.get(i), l2.get(i), visited, stack, summary)) {
                            if (summary != null) {
                                summary.recordDiff("Values Differ", stack, o1, o2);
                            }
                            stack.pop();
                            boolean bl = false;
                            return bl;
                        }
                        stack.pop();
                    }
                    continue;
                }
                if (UtlObjectGraph.deepEquals(f1, f2, visited, stack, summary)) continue;
                if (summary != null) {
                    summary.recordDiff("Values Differ", stack, o1, o2);
                }
                boolean bl = false;
                return bl;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            finally {
                stack.pop();
            }
        }
        return true;
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static String getLastGetter(Stack<String> stack) {
        if (stack.isEmpty()) {
            return "";
        }
        if (stack.peek().startsWith("{") || stack.peek().startsWith("[")) {
            return (String)stack.get(stack.size() - 2);
        }
        return stack.peek();
    }

    public static String createRandomString(int length, Random random) {
        return BuiltInHandler.randomString(length, random);
    }

    public static final void visitBeanFields(Class<?> type, FieldAccessorVisitor visitor) {
        UtlObjectGraph.visitFieldsInternal(type, new Stack<String>(), new Stack<Method>(), visitor);
    }

    private static final void visitFieldsInternal(Class<?> type, Stack<String> beanPathStack, Stack<Method> methodStack, FieldAccessorVisitor visitor) {
        if (!beanPathStack.isEmpty() && !visitor.visit(UtlObjectGraph.unwindStack(beanPathStack), methodStack)) {
            return;
        }
        if (builtInHandler.handlesParam(type)) {
            return;
        }
        if (type.isArray()) {
            return;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return;
        }
        if (Map.class.isAssignableFrom(type)) {
            return;
        }
        for (Method getter : type.getMethods()) {
            if (getter.getReturnType() == null || !getter.getName().startsWith("get") && !getter.getName().startsWith("is") || getter.getParameterTypes().length > 0 || (getter.getModifiers() & 1) == 0 || getter.getName().endsWith("AsRaw")) continue;
            Method setter = null;
            try {
                setter = type.getMethod("set" + getter.getName().substring(3), getter.getReturnType());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Class<?> paramClass = getter.getReturnType();
            beanPathStack.push(getter.getName() + "()");
            methodStack.push(getter);
            if (setter != null) {
                UtlObjectGraph.visitFieldsInternal(paramClass, beanPathStack, methodStack, visitor);
            }
            beanPathStack.pop();
            methodStack.pop();
        }
    }

    private static class DiffRecorder
    extends UtlTableFormatter {
        final UtlTableFormatter.Format format;
        int numDiffs = 0;
        final StringBuffer summary;
        static final String[] columnHeaders = new String[]{"Field", "Source", "Target", "Comment"};

        DiffRecorder(UtlTableFormatter.Format format, StringBuffer summary) {
            super(true);
            this.format = format;
            this.summary = summary;
        }

        final boolean continueRecording() {
            return this.summary != null;
        }

        final void recordDiff(String description, Stack<String> stack, Object value1, Object value2) {
            ++this.numDiffs;
            if (this.summary == null) {
                return;
            }
            if (this.numDiffs == 1) {
                this.writeHeader();
            }
            Object[] values = new Object[]{UtlObjectGraph.unwindStack(stack), value1, value2, description};
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.formatColumn(columnHeaders[i], values[i] == null ? String.class : values[i].getClass(), values[i], this.format);
            }
            String formatStr = this.getRowFormatString(values, this.format);
            if (this.format == UtlTableFormatter.Format.TABULAR) {
                String[] stringValues = new String[values.length];
                int lines = 1;
                for (int i = 0; i < values.length; ++i) {
                    stringValues[i] = String.format(this.getColumnFormat(columnHeaders[i], values[i] != null ? values[i].getClass() : String.class, 25), values[i]);
                    lines = Math.max(lines, (int)Math.ceil((double)stringValues[i].length() / 25.0));
                }
                if (lines > 1) {
                    for (int line = 0; line < lines; ++line) {
                        Object[] lineValues = new String[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            lineValues[i] = stringValues[i].length() > line * 25 ? stringValues[i].substring(line * 25, Math.min((line + 1) * 25, stringValues[i].length())) : "";
                        }
                        this.summary.append(String.format(formatStr, lineValues));
                    }
                } else {
                    this.summary.append(String.format(formatStr, values));
                }
            } else {
                this.summary.append(String.format(formatStr, values));
            }
        }

        final void flush() {
            if (this.numDiffs > 0) {
                this.writeFooter();
            }
        }

        final String writeHeader() {
            boolean first = true;
            this.summary.append("\n");
            if (this.format == UtlTableFormatter.Format.HTML) {
                this.summary.append("<table border=\"1\" style=\"table-layout: fixed; width: 100%; word-wrap: break-word\">").append(newline);
                this.summary.append("  <thead>\n").append(newline);
                this.summary.append("     <tr>").append(newline);
            }
            for (String columnHeader : columnHeaders) {
                switch (this.format) {
                    case CSV: {
                        if (!first) {
                            this.summary.append(',');
                        }
                        this.summary.append(columnHeader);
                        break;
                    }
                    case TABULAR: {
                        this.summary.append('|');
                        this.summary.append(String.format("%25s", columnHeader));
                        break;
                    }
                    case HTML: {
                        this.summary.append("<th>").append(columnHeader).append("</th>");
                    }
                }
                first = false;
            }
            switch (this.format) {
                case CSV: {
                    this.summary.append(newline);
                    break;
                }
                case HTML: {
                    this.summary.append("     </tr>").append(newline);
                    this.summary.append("  </thead>").append(newline);
                    this.summary.append("  <tbody>").append(newline);
                    break;
                }
                case TABULAR: {
                    this.summary.append("|\n");
                    for (int c = 0; c < columnHeaders.length; ++c) {
                        this.summary.append('+');
                        for (int i = 0; i < 25; ++i) {
                            this.summary.append("-");
                        }
                    }
                    this.summary.append("+").append(newline);
                }
            }
            return this.summary.toString();
        }

        final String writeFooter() {
            StringBuilder sb = new StringBuilder();
            switch (this.format) {
                case CSV: {
                    break;
                }
                case HTML: {
                    sb.append("</table>").append(newline);
                    break;
                }
                case TABULAR: {
                    for (int c = 0; c < columnHeaders.length; ++c) {
                        this.summary.append('+');
                        for (int i = 0; i < 25; ++i) {
                            this.summary.append("-");
                        }
                    }
                    this.summary.append("+").append(newline);
                }
            }
            return sb.toString();
        }

        public final String getRowFormatString(Object[] values, UtlTableFormatter.Format format) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (format == UtlTableFormatter.Format.HTML) {
                sb.append("     <tr>");
            }
            for (int i = 0; i < values.length; ++i) {
                switch (format) {
                    case CSV: {
                        if (!first) {
                            sb.append(',');
                        }
                        sb.append("%s");
                        break;
                    }
                    case HTML: {
                        sb.append("<td>%s</td>");
                        break;
                    }
                    case TABULAR: {
                        sb.append('|');
                        sb.append("%25s");
                    }
                }
                first = false;
            }
            switch (format) {
                case CSV: {
                    sb.append(newline);
                    break;
                }
                case HTML: {
                    sb.append("</tr>").append(newline);
                    break;
                }
                case TABULAR: {
                    sb.append("|").append(newline);
                }
            }
            return sb.toString();
        }

        @Override
        public int calculateFieldLength(String columnHeader, Class<?> columnType) {
            return 25;
        }
    }

    public static class BuiltInHandler {
        private static final ArrayList<Locale> LOCALES = new ArrayList();
        private static final HashSet<Class<?>> PRIMITIVE_WRAPPERS = new HashSet();
        private static final HashSet<Class<?>> BUILT_IN_TYPES;

        boolean handlesParam(Class<?> paramClass) {
            if (paramClass.isArray()) {
                paramClass = paramClass.getComponentType();
            }
            return paramClass.isEnum() || paramClass.isPrimitive() || PRIMITIVE_WRAPPERS.contains(paramClass) || BUILT_IN_TYPES.contains(paramClass);
        }

        public static <T> T getRandomValue(Class<T> paramClass, Random random) {
            if (paramClass.isPrimitive() || PRIMITIVE_WRAPPERS.contains(paramClass)) {
                return (T)BuiltInHandler.getRandomPrimitiveValue(paramClass, random);
            }
            if (paramClass.isArray()) {
                if (paramClass.getComponentType().isPrimitive()) {
                    return (T)builtInHandler.createRandomPrimitiveArray(paramClass.getComponentType(), 10, random);
                }
                Object[] newArray = (Object[])Array.newInstance(paramClass.getComponentType(), random.nextInt(10));
                for (int i = 0; i < newArray.length; ++i) {
                    newArray[i] = BuiltInHandler.getRandomValue(paramClass.getComponentType(), random);
                }
                return (T)newArray;
            }
            if (paramClass.isEnum()) {
                try {
                    Method valuesMethod = paramClass.getMethod("values", new Class[0]);
                    Object[] values = (Object[])valuesMethod.invoke(null, new Object[0]);
                    return (T)values[random.nextInt(values.length)];
                }
                catch (Exception e) {
                    throw new RuntimeException("Error introspecting enumeration", e);
                }
            }
            if (paramClass == String.class) {
                return (T)BuiltInHandler.randomString(random.nextInt(9) + 1, random);
            }
            if (paramClass == Date.class) {
                return (T)new Date(random.nextInt(Integer.MAX_VALUE));
            }
            if (paramClass == Currency.class) {
                return (T)Currency.getInstance(LOCALES.get(random.nextInt(LOCALES.size() - 1)));
            }
            if (paramClass == BigInteger.class) {
                int signum = random.nextInt(2) - 1;
                byte[] mag = null;
                if (signum == 0) {
                    mag = new byte[random.nextInt(3)];
                } else {
                    mag = BuiltInHandler.createRandomByteArray(20, random);
                    if (mag.length == 0) {
                        mag = new byte[]{(byte)random.nextInt(127)};
                    }
                    if (mag[0] == 0) {
                        mag[0] = (byte)(mag[0] + 1);
                    }
                }
                return (T)new BigInteger(signum, mag);
            }
            if (paramClass == BigDecimal.class) {
                BigInteger bigInt = BuiltInHandler.getRandomValue(BigInteger.class, random);
                return (T)new BigDecimal(bigInt, random.nextInt(10) * (random.nextBoolean() ? -1 : 1));
            }
            if (paramClass == UUID.class) {
                UUID uuid = new UUID();
                return (T)uuid;
            }
            throw new IllegalArgumentException("Unable to generate value for type " + paramClass.getName());
        }

        public static final String randomString(int len, Random random) {
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < len; ++i) {
                sb.append((char)(32 + random.nextInt(95)));
            }
            return sb.toString();
        }

        static final Object getRandomPrimitiveValue(Class<?> paramClass, Random random) {
            if (paramClass == Integer.TYPE || paramClass == Integer.class) {
                return random.nextInt();
            }
            if (paramClass == Boolean.TYPE || paramClass == Boolean.class) {
                return random.nextBoolean();
            }
            if (paramClass == Double.TYPE || paramClass == Double.class) {
                return random.nextDouble();
            }
            if (paramClass == Float.TYPE || paramClass == Float.class) {
                return Float.valueOf(random.nextFloat());
            }
            if (paramClass == Long.TYPE || paramClass == Long.class) {
                return random.nextLong();
            }
            if (paramClass == Byte.TYPE || paramClass == Byte.class) {
                return (byte)(random.nextInt(127) * (random.nextBoolean() ? -1 : 1));
            }
            if (paramClass == Short.TYPE || paramClass == Short.class) {
                return (short)(random.nextInt(Short.MAX_VALUE) * (random.nextBoolean() ? -1 : 1));
            }
            if (paramClass == Character.TYPE || paramClass == Character.class) {
                return Character.valueOf((char)random.nextInt(0x10FFFF));
            }
            throw new IllegalArgumentException(paramClass + " is not a primitive type");
        }

        final Object createRandomPrimitiveArray(Class<?> paramClass, int maxLength, Random random) {
            if (paramClass == Integer.TYPE) {
                return this.createRandomIntArray(maxLength, random);
            }
            if (paramClass == Boolean.TYPE) {
                return this.createRandomBooleanArray(maxLength, random);
            }
            if (paramClass == Double.TYPE) {
                return this.createRandomDoubleArray(maxLength, random);
            }
            if (paramClass == Float.TYPE) {
                return this.createRandomFloatArray(maxLength, random);
            }
            if (paramClass == Long.TYPE) {
                return this.createRandomLongArray(maxLength, random);
            }
            if (paramClass == Byte.TYPE) {
                return BuiltInHandler.createRandomByteArray(maxLength, random);
            }
            if (paramClass == Short.TYPE) {
                return BuiltInHandler.createRandomShortArray(maxLength, random);
            }
            if (paramClass == Character.TYPE) {
                return this.createRandomCharArray(maxLength, random);
            }
            throw new IllegalArgumentException(paramClass + " is not a primitive type");
        }

        private List<?> arrayToList(Object o) {
            if (!o.getClass().isArray()) {
                throw new IllegalArgumentException("Not an array:" + o.getClass());
            }
            Class<?> paramClass = o.getClass().getComponentType();
            if (paramClass == Integer.TYPE) {
                int[] p = (int[])o;
                Integer[] rc = new Integer[p.length];
                for (int i = 0; i < p.length; ++i) {
                    rc[i] = p[i];
                }
                return Arrays.asList(rc);
            }
            if (paramClass == Boolean.TYPE) {
                boolean[] p = (boolean[])o;
                Boolean[] rc = new Boolean[p.length];
                for (int i = 0; i < p.length; ++i) {
                    rc[i] = p[i];
                }
                return Arrays.asList(rc);
            }
            if (paramClass == Double.TYPE) {
                double[] p = (double[])o;
                Double[] rc = new Double[p.length];
                for (int i = 0; i < p.length; ++i) {
                    rc[i] = p[i];
                }
                return Arrays.asList(rc);
            }
            if (paramClass == Float.TYPE) {
                float[] p = (float[])o;
                Float[] rc = new Float[p.length];
                for (int i = 0; i < p.length; ++i) {
                    rc[i] = Float.valueOf(p[i]);
                }
                return Arrays.asList(rc);
            }
            if (paramClass == Long.TYPE) {
                long[] p = (long[])o;
                Long[] rc = new Long[p.length];
                for (int i = 0; i < p.length; ++i) {
                    rc[i] = p[i];
                }
                return Arrays.asList(rc);
            }
            if (paramClass == Byte.TYPE) {
                byte[] p = (byte[])o;
                Byte[] rc = new Byte[p.length];
                for (int i = 0; i < p.length; ++i) {
                    rc[i] = p[i];
                }
                return Arrays.asList(rc);
            }
            if (paramClass == Short.TYPE) {
                short[] p = (short[])o;
                Short[] rc = new Short[p.length];
                for (int i = 0; i < p.length; ++i) {
                    rc[i] = p[i];
                }
                return Arrays.asList(rc);
            }
            if (paramClass == Character.TYPE) {
                char[] p = (char[])o;
                Character[] rc = new Character[p.length];
                for (int i = 0; i < p.length; ++i) {
                    rc[i] = Character.valueOf(p[i]);
                }
                return Arrays.asList(rc);
            }
            return Arrays.asList((Object[])o);
        }

        final char[] createRandomCharArray(int maxLength, Random random) {
            char[] array = new char[random.nextInt(maxLength)];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (char)random.nextInt(0x10FFFF);
            }
            return array;
        }

        final long[] createRandomLongArray(int maxLength, Random random) {
            long[] array = new long[random.nextInt(maxLength)];
            for (int i = 0; i < array.length; ++i) {
                array[i] = random.nextLong();
            }
            return array;
        }

        final float[] createRandomFloatArray(int maxLength, Random random) {
            float[] array = new float[random.nextInt(maxLength)];
            for (int i = 0; i < array.length; ++i) {
                array[i] = random.nextFloat();
            }
            return array;
        }

        final double[] createRandomDoubleArray(int maxLength, Random random) {
            double[] array = new double[random.nextInt(maxLength)];
            for (int i = 0; i < array.length; ++i) {
                array[i] = random.nextDouble();
            }
            return array;
        }

        final int[] createRandomIntArray(int maxLength, Random random) {
            int[] array = new int[random.nextInt(maxLength)];
            for (int i = 0; i < array.length; ++i) {
                array[i] = random.nextInt();
            }
            return array;
        }

        final boolean[] createRandomBooleanArray(int maxLength, Random random) {
            boolean[] array = new boolean[random.nextInt(maxLength)];
            for (int i = 0; i < array.length; ++i) {
                array[i] = random.nextBoolean();
            }
            return array;
        }

        public static final byte[] createRandomByteArray(int maxLength, Random random) {
            byte[] array = new byte[random.nextInt(maxLength)];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (byte)(random.nextInt(127) * (random.nextBoolean() ? -1 : 1));
            }
            return array;
        }

        public static final short[] createRandomShortArray(int maxLength, Random random) {
            short[] array = new short[random.nextInt(maxLength)];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (short)(random.nextInt(Short.MAX_VALUE) * (random.nextBoolean() ? -1 : 1));
            }
            return array;
        }

        private boolean equals(Object o1, Object o2) {
            return o1.equals(o2);
        }

        static {
            PRIMITIVE_WRAPPERS.add(Boolean.class);
            PRIMITIVE_WRAPPERS.add(Character.class);
            PRIMITIVE_WRAPPERS.add(Byte.class);
            PRIMITIVE_WRAPPERS.add(Short.class);
            PRIMITIVE_WRAPPERS.add(Integer.class);
            PRIMITIVE_WRAPPERS.add(Long.class);
            PRIMITIVE_WRAPPERS.add(Float.class);
            PRIMITIVE_WRAPPERS.add(Double.class);
            PRIMITIVE_WRAPPERS.add(Void.class);
            for (Locale locale : Locale.getAvailableLocales()) {
                if (locale.getCountry() == null || locale.getCountry().length() != 2) continue;
                LOCALES.add(locale);
            }
            BUILT_IN_TYPES = new HashSet();
            BUILT_IN_TYPES.add(String.class);
            BUILT_IN_TYPES.add(Date.class);
            BUILT_IN_TYPES.add(Currency.class);
            BUILT_IN_TYPES.add(BigInteger.class);
            BUILT_IN_TYPES.add(BigDecimal.class);
            BUILT_IN_TYPES.add(UUID.class);
        }
    }

    public static interface ComparatorFactory {
        public Comparator<?> getComparator(Class<?> var1, Stack<String> var2);

        public boolean treatEmptyAndNullArraysAsSame();
    }

    public static class BasePopulationHelper
    implements PopulationHelper {
        @Override
        public Collection<?> getFactoryObjects() {
            return null;
        }

        @Override
        public Class<?>[] getTypeParameters(Object o, Class<?> parameterizedType, Stack<String> getterStack) {
            return null;
        }

        @Override
        public boolean shouldPopulate(Class<?> type, Stack<String> getterStack, Random random) {
            return true;
        }

        @Override
        public Object getNewInstance(Class<?> type, Stack<String> getterStack, Random random) {
            return null;
        }
    }

    public static interface PopulationHelper {
        public Collection<?> getFactoryObjects();

        public Class<?>[] getTypeParameters(Object var1, Class<?> var2, Stack<String> var3);

        public boolean shouldPopulate(Class<?> var1, Stack<String> var2, Random var3);

        public Object getNewInstance(Class<?> var1, Stack<String> var2, Random var3);
    }

    public static interface FieldAccessorVisitor {
        public boolean visit(String var1, Stack<Method> var2);
    }
}

