/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.NativeKernel;
import com.neeve.config.Config;
import com.neeve.util.UtlThrowable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public final class UtlBuffer {
    private static final boolean USE_UNSAFE;
    private static final Unsafe UNSAFE;
    private static final int BYTES_OFFSET;
    private static final int CHARS_OFFSET;
    private static final int SHORTS_OFFSET;
    private static final int INTS_OFFSET;
    private static final int LONGS_OFFSET;
    private static final int FLOATS_OFFSET;
    private static final int DOUBLES_OFFSET;
    private static final ByteBuffer CLEAR_BUFFER;
    private static final int CLEAR_BUFFER_SIZE;
    private static final long CLEAR_BUFFER_ADDRESS;
    private static final ByteOrder nativeOrder;
    private static final boolean USE_NATIVE;
    private static final Method directBufferCleanerAccessorMethod;
    private static final Method directBufferCleanerMethod;

    public static final boolean isNativeBufferManagementEnabled() {
        return USE_NATIVE;
    }

    public static final boolean isUnsafeBufferManagementEnabled() {
        return USE_UNSAFE;
    }

    private static final native void nativeWipe(ByteBuffer var0, int var1);

    private static final native void nativeCopy(ByteBuffer var0, int var1, ByteBuffer var2, int var3, int var4);

    private static final native void nativeCopy(byte[] var0, int var1, ByteBuffer var2, int var3, int var4);

    private static final native void nativeCopy(ByteBuffer var0, int var1, byte[] var2, int var3, int var4);

    private static final native void nativeCopy(byte[] var0, int var1, byte[] var2, int var3, int var4);

    private static final native void nativeCopy(char[] var0, int var1, ByteBuffer var2, int var3, int var4);

    private static final native void nativeCopy(ByteBuffer var0, int var1, char[] var2, int var3, int var4);

    private static final native void nativeCopy(char[] var0, int var1, byte[] var2, int var3, int var4);

    private static final native void nativeCopy(byte[] var0, int var1, char[] var2, int var3, int var4);

    private static final native void nativeCopy(short[] var0, int var1, ByteBuffer var2, int var3, int var4);

    private static final native void nativeCopy(ByteBuffer var0, int var1, short[] var2, int var3, int var4);

    private static final native void nativeCopy(short[] var0, int var1, byte[] var2, int var3, int var4);

    private static final native void nativeCopy(byte[] var0, int var1, short[] var2, int var3, int var4);

    private static final native void nativeCopy(int[] var0, int var1, ByteBuffer var2, int var3, int var4);

    private static final native void nativeCopy(ByteBuffer var0, int var1, int[] var2, int var3, int var4);

    private static final native void nativeCopy(int[] var0, int var1, byte[] var2, int var3, int var4);

    private static final native void nativeCopy(byte[] var0, int var1, int[] var2, int var3, int var4);

    private static final native void nativeCopy(float[] var0, int var1, ByteBuffer var2, int var3, int var4);

    private static final native void nativeCopy(ByteBuffer var0, int var1, float[] var2, int var3, int var4);

    private static final native void nativeCopy(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static final native void nativeCopy(byte[] var0, int var1, float[] var2, int var3, int var4);

    private static final native void nativeCopy(long[] var0, int var1, ByteBuffer var2, int var3, int var4);

    private static final native void nativeCopy(ByteBuffer var0, int var1, long[] var2, int var3, int var4);

    private static final native void nativeCopy(long[] var0, int var1, byte[] var2, int var3, int var4);

    private static final native void nativeCopy(byte[] var0, int var1, long[] var2, int var3, int var4);

    private static final native void nativeCopy(double[] var0, int var1, ByteBuffer var2, int var3, int var4);

    private static final native void nativeCopy(ByteBuffer var0, int var1, double[] var2, int var3, int var4);

    private static final native void nativeCopy(double[] var0, int var1, byte[] var2, int var3, int var4);

    private static final native void nativeCopy(byte[] var0, int var1, double[] var2, int var3, int var4);

    private static final void copyFromNative(long srcAddress, int srcOffset, ByteBuffer destBuffer, int destOffset, int length) {
        if (destBuffer == null) {
            throw new IllegalArgumentException("dest buffer cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (destOffset + length > destBuffer.capacity()) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest buffer capacity (" + destBuffer.capacity() + ")");
        }
        if (destBuffer.isDirect()) {
            UNSAFE.copyMemory(srcAddress + (long)srcOffset, ((DirectBuffer)((Object)destBuffer)).address() + (long)destOffset, length);
        } else {
            byte[] array = destBuffer.array();
            UNSAFE.copyMemory(null, srcAddress + (long)srcOffset, array, BYTES_OFFSET + destOffset, length);
        }
    }

    private static final void copyToNative(ByteBuffer srcBuffer, int srcOffset, long destAddress, int destOffset, int length) {
        if (srcBuffer == null) {
            throw new IllegalArgumentException("source buffer cannot be null");
        }
        if (srcOffset + length > srcBuffer.capacity()) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source buffer capacity (" + srcBuffer.capacity() + ")");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcBuffer.isDirect()) {
            UNSAFE.copyMemory(((DirectBuffer)((Object)srcBuffer)).address() + (long)srcOffset, destAddress + (long)destOffset, length);
        } else {
            byte[] array = srcBuffer.array();
            UNSAFE.copyMemory(array, BYTES_OFFSET + srcOffset, null, destAddress + (long)destOffset, length);
        }
    }

    public static final ByteBuffer clone(ByteBuffer buffer) {
        ByteBuffer clone = buffer.isDirect() ? ByteBuffer.allocateDirect(buffer.capacity()) : ByteBuffer.allocate(buffer.capacity());
        int pos = buffer.position();
        int limit = buffer.limit();
        clone.put((ByteBuffer)buffer.position(0).limit(buffer.capacity()));
        buffer.position(pos).limit(limit);
        clone.position(pos).limit(limit);
        return clone;
    }

    public static final long getNativeBufferAddress(ByteBuffer directBuffer) {
        try {
            return ((DirectBuffer)((Object)directBuffer)).address();
        }
        catch (ClassCastException cce) {
            if (!directBuffer.isDirect()) {
                throw new IllegalArgumentException("Can only return native address for a direct byte buffer");
            }
            throw new UnsupportedOperationException("Unable to determine the address of the buffer on this JVM", cce);
        }
    }

    public static final void copy(ByteBuffer srcBuffer, int srcOffset, ByteBuffer destBuffer, int destOffset, int length) {
        if (srcBuffer == null) {
            throw new IllegalArgumentException("source buffer cannot be null");
        }
        if (destBuffer == null) {
            throw new IllegalArgumentException("dest buffer cannot be null");
        }
        if (srcBuffer == destBuffer) {
            throw new IllegalArgumentException("source and dest buffers cannot be the same");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length > srcBuffer.capacity()) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source buffer capacity (" + srcBuffer.capacity() + ")");
        }
        if (destOffset + length > destBuffer.capacity()) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest buffer capacity (" + destBuffer.capacity() + ")");
        }
        if (!srcBuffer.isDirect() && !destBuffer.isDirect()) {
            System.arraycopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
        } else if (USE_UNSAFE) {
            if (srcBuffer.isDirect()) {
                long srcAddress = ((DirectBuffer)((Object)srcBuffer)).address();
                UtlBuffer.copyFromNative(srcAddress, srcOffset, destBuffer, destOffset, length);
            } else if (destBuffer.isDirect()) {
                long destAddress = ((DirectBuffer)((Object)destBuffer)).address();
                UNSAFE.copyMemory(srcBuffer.array(), BYTES_OFFSET + srcBuffer.arrayOffset() + srcOffset, null, destAddress + (long)destOffset, length);
            } else {
                System.arraycopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
            }
        } else if (USE_NATIVE) {
            if (srcBuffer.isDirect() && destBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcBuffer, srcOffset, destBuffer, destOffset, length);
            } else if (srcBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcBuffer, srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destBuffer, destOffset, length);
            }
        } else {
            ByteBuffer dupSrcBuffer = srcBuffer.duplicate();
            dupSrcBuffer.order(srcBuffer.order());
            ByteBuffer dupDestBuffer = destBuffer.duplicate();
            dupDestBuffer.order(destBuffer.order());
            dupDestBuffer.limit(dupDestBuffer.capacity());
            dupDestBuffer.position(destOffset);
            dupSrcBuffer.limit(dupSrcBuffer.capacity());
            dupSrcBuffer.position(srcOffset);
            dupSrcBuffer.limit(srcOffset + length);
            dupDestBuffer.put(dupSrcBuffer);
        }
    }

    public static final void copy(byte[] srcArray, int srcOffset, ByteBuffer destBuffer, int destOffset, int length) {
        if (srcArray == null) {
            throw new IllegalArgumentException("source array cannot be null");
        }
        if (destBuffer == null) {
            throw new IllegalArgumentException("dest buffer cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length > srcArray.length) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source array length (" + srcArray.length + ")");
        }
        if (destOffset + length > destBuffer.capacity()) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest buffer capacity (" + destBuffer.capacity() + ")");
        }
        if (USE_UNSAFE) {
            if (destBuffer.isDirect()) {
                long destAddress = ((DirectBuffer)((Object)destBuffer)).address();
                UNSAFE.copyMemory(srcArray, BYTES_OFFSET + srcOffset, null, destAddress + (long)destOffset, length);
            } else {
                System.arraycopy(srcArray, srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
            }
        } else if (USE_NATIVE) {
            if (destBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
            }
        } else {
            ByteBuffer dupDestBuffer = destBuffer.duplicate();
            dupDestBuffer.order(destBuffer.order());
            dupDestBuffer.limit(dupDestBuffer.capacity());
            dupDestBuffer.position(destOffset);
            dupDestBuffer.put(srcArray, srcOffset, length);
        }
    }

    public static final void copy(ByteBuffer srcBuffer, int srcOffset, byte[] destArray, int destOffset, int length) {
        if (srcBuffer == null) {
            throw new IllegalArgumentException("source buffer cannot be null");
        }
        if (destArray == null) {
            throw new IllegalArgumentException("dest array cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length > srcBuffer.capacity()) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source buffer capacity (" + srcBuffer.capacity() + ")");
        }
        if (destOffset + length > destArray.length) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest array length (" + destArray.length + ")");
        }
        if (USE_UNSAFE) {
            if (srcBuffer.isDirect()) {
                long srcAddress = ((DirectBuffer)((Object)srcBuffer)).address();
                UNSAFE.copyMemory(null, srcAddress + (long)srcOffset, destArray, BYTES_OFFSET + destOffset, length);
            } else {
                System.arraycopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destArray, destOffset, length);
            }
        } else if (USE_NATIVE) {
            if (srcBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcBuffer, srcOffset, destArray, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destArray, destOffset, length);
            }
        } else {
            ByteBuffer dupSrcBuffer = srcBuffer.duplicate();
            dupSrcBuffer.order(srcBuffer.order());
            dupSrcBuffer.limit(dupSrcBuffer.capacity());
            dupSrcBuffer.position(srcOffset);
            dupSrcBuffer.get(destArray, destOffset, length);
        }
    }

    public static final void copy(char[] srcArray, int srcOffset, ByteBuffer destBuffer, int destOffset, int length) {
        if (srcArray == null) {
            throw new IllegalArgumentException("source array cannot be null");
        }
        if (destBuffer == null) {
            throw new IllegalArgumentException("dest buffer cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length > srcArray.length) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source array length (" + srcArray.length + ")");
        }
        if (destOffset + length * 2 > destBuffer.capacity()) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest buffer capacity (" + destBuffer.capacity() + ")");
        }
        if (USE_UNSAFE && destBuffer.order() == nativeOrder && destBuffer.isDirect()) {
            long destAddress = ((DirectBuffer)((Object)destBuffer)).address();
            UNSAFE.copyMemory(srcArray, CHARS_OFFSET + srcOffset, null, destAddress + (long)destOffset, length * 2);
        } else if (USE_NATIVE && destBuffer.order() == nativeOrder) {
            if (destBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
            }
        } else {
            ByteBuffer dupDestBuffer = destBuffer.duplicate();
            dupDestBuffer.order(destBuffer.order());
            dupDestBuffer.limit(dupDestBuffer.capacity());
            dupDestBuffer.position(destOffset);
            dupDestBuffer.asCharBuffer().put(srcArray, srcOffset, length);
        }
    }

    public static final void copy(ByteBuffer srcBuffer, int srcOffset, char[] destArray, int destOffset, int length) {
        if (srcBuffer == null) {
            throw new IllegalArgumentException("source buffer cannot be null");
        }
        if (destArray == null) {
            throw new IllegalArgumentException("dest array cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length * 2 > srcBuffer.capacity()) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source buffer capacity (" + srcBuffer.capacity() + ")");
        }
        if (destOffset + length > destArray.length) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest array length (" + destArray.length + ")");
        }
        if (USE_UNSAFE && srcBuffer.isDirect() && srcBuffer.order() == nativeOrder) {
            long srcAddress = ((DirectBuffer)((Object)srcBuffer)).address();
            UNSAFE.copyMemory(null, srcAddress + (long)srcOffset, destArray, CHARS_OFFSET + destOffset, length * 2);
        } else if (USE_NATIVE && srcBuffer.order() == nativeOrder) {
            if (srcBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcBuffer, srcOffset, destArray, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destArray, destOffset, length);
            }
        } else {
            ByteBuffer dupSrcBuffer = srcBuffer.duplicate();
            dupSrcBuffer.order(srcBuffer.order());
            dupSrcBuffer.limit(dupSrcBuffer.capacity());
            dupSrcBuffer.position(srcOffset);
            dupSrcBuffer.asCharBuffer().get(destArray, destOffset, length);
        }
    }

    public static final void copy(short[] srcArray, int srcOffset, ByteBuffer destBuffer, int destOffset, int length) {
        if (srcArray == null) {
            throw new IllegalArgumentException("source array cannot be null");
        }
        if (srcArray == null || destBuffer == null) {
            throw new IllegalArgumentException("dest buffer cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length > srcArray.length) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source array length (" + srcArray.length + ")");
        }
        if (destOffset + length * 2 > destBuffer.capacity()) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest buffer capacity (" + destBuffer.capacity() + ")");
        }
        if (USE_UNSAFE && destBuffer.order() == nativeOrder && destBuffer.isDirect()) {
            long destAddress = ((DirectBuffer)((Object)destBuffer)).address();
            UNSAFE.copyMemory(srcArray, SHORTS_OFFSET + srcOffset, null, destAddress + (long)destOffset, length * 2);
        } else if (USE_NATIVE && destBuffer.order() == nativeOrder) {
            if (destBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
            }
        } else {
            ByteBuffer dupDestBuffer = destBuffer.duplicate();
            dupDestBuffer.order(destBuffer.order());
            dupDestBuffer.limit(dupDestBuffer.capacity());
            dupDestBuffer.position(destOffset);
            dupDestBuffer.asShortBuffer().put(srcArray, srcOffset, length);
        }
    }

    public static final void copy(ByteBuffer srcBuffer, int srcOffset, short[] destArray, int destOffset, int length) {
        if (srcBuffer == null) {
            throw new IllegalArgumentException("source buffer cannot be null");
        }
        if (destArray == null) {
            throw new IllegalArgumentException("dest array cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length * 2 > srcBuffer.capacity()) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source buffer capacity (" + srcBuffer.capacity() + ")");
        }
        if (destOffset + length > destArray.length) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest array length (" + destArray.length + ")");
        }
        if (USE_UNSAFE && srcBuffer.isDirect() && srcBuffer.order() == nativeOrder) {
            long srcAddress = ((DirectBuffer)((Object)srcBuffer)).address();
            UNSAFE.copyMemory(null, srcAddress + (long)srcOffset, destArray, SHORTS_OFFSET + destOffset, length * 2);
        } else if (USE_NATIVE && ByteOrder.nativeOrder() == srcBuffer.order()) {
            if (srcBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcBuffer, srcOffset, destArray, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destArray, destOffset, length);
            }
        } else {
            ByteBuffer dupSrcBuffer = srcBuffer.duplicate();
            dupSrcBuffer.order(srcBuffer.order());
            dupSrcBuffer.limit(dupSrcBuffer.capacity());
            dupSrcBuffer.position(srcOffset);
            dupSrcBuffer.asShortBuffer().get(destArray, destOffset, length);
        }
    }

    public static final void copy(int[] srcArray, int srcOffset, ByteBuffer destBuffer, int destOffset, int length) {
        if (srcArray == null) {
            throw new IllegalArgumentException("source array cannot be null");
        }
        if (destBuffer == null) {
            throw new IllegalArgumentException("dest buffer cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length > srcArray.length) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source array length (" + srcArray.length + ")");
        }
        if (destOffset + length * 4 > destBuffer.capacity()) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest buffer capacity (" + destBuffer.capacity() + ")");
        }
        if (USE_UNSAFE && destBuffer.order() == nativeOrder && destBuffer.isDirect()) {
            long destAddress = ((DirectBuffer)((Object)destBuffer)).address();
            UNSAFE.copyMemory(srcArray, INTS_OFFSET + srcOffset, null, destAddress + (long)destOffset, length * 4);
        } else if (USE_NATIVE && destBuffer.order() == nativeOrder) {
            if (destBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
            }
        } else {
            ByteBuffer dupDestBuffer = destBuffer.duplicate();
            dupDestBuffer.order(destBuffer.order());
            dupDestBuffer.limit(dupDestBuffer.capacity());
            dupDestBuffer.position(destOffset);
            dupDestBuffer.asIntBuffer().put(srcArray, srcOffset, length);
        }
    }

    public static final void copy(ByteBuffer srcBuffer, int srcOffset, int[] destArray, int destOffset, int length) {
        if (srcBuffer == null) {
            throw new IllegalArgumentException("source buffer cannot be null");
        }
        if (destArray == null) {
            throw new IllegalArgumentException("dest array cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length * 4 > srcBuffer.capacity()) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source buffer capacity (" + srcBuffer.capacity() + ")");
        }
        if (destOffset + length > destArray.length) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest array length (" + destArray.length + ")");
        }
        if (USE_UNSAFE && srcBuffer.isDirect() && srcBuffer.order() == nativeOrder) {
            long srcAddress = ((DirectBuffer)((Object)srcBuffer)).address();
            UNSAFE.copyMemory(null, srcAddress + (long)srcOffset, destArray, INTS_OFFSET + destOffset, length * 4);
        } else if (USE_NATIVE && srcBuffer.order() == nativeOrder) {
            if (srcBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcBuffer, srcOffset, destArray, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destArray, destOffset, length);
            }
        } else {
            ByteBuffer dupSrcBuffer = srcBuffer.duplicate();
            dupSrcBuffer.order(srcBuffer.order());
            dupSrcBuffer.limit(dupSrcBuffer.capacity());
            dupSrcBuffer.position(srcOffset);
            dupSrcBuffer.asIntBuffer().get(destArray, destOffset, length);
        }
    }

    public static final void copy(float[] srcArray, int srcOffset, ByteBuffer destBuffer, int destOffset, int length) {
        if (srcArray == null) {
            throw new IllegalArgumentException("source array cannot be null");
        }
        if (destBuffer == null) {
            throw new IllegalArgumentException("dest buffer cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length > srcArray.length) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source array length (" + srcArray.length + ")");
        }
        if (destOffset + length * 4 > destBuffer.capacity()) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest buffer capacity (" + destBuffer.capacity() + ")");
        }
        if (USE_UNSAFE && destBuffer.order() == nativeOrder && destBuffer.isDirect()) {
            long destAddress = ((DirectBuffer)((Object)destBuffer)).address();
            UNSAFE.copyMemory(srcArray, FLOATS_OFFSET + srcOffset, null, destAddress + (long)destOffset, length * 4);
        } else if (USE_NATIVE && destBuffer.order() == nativeOrder) {
            if (destBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
            }
        } else {
            ByteBuffer dupDestBuffer = destBuffer.duplicate();
            dupDestBuffer.order(destBuffer.order());
            dupDestBuffer.limit(dupDestBuffer.capacity());
            dupDestBuffer.position(destOffset);
            dupDestBuffer.asFloatBuffer().put(srcArray, srcOffset, length);
        }
    }

    public static final void copy(ByteBuffer srcBuffer, int srcOffset, float[] destArray, int destOffset, int length) {
        if (srcBuffer == null) {
            throw new IllegalArgumentException("source buffer cannot be null");
        }
        if (destArray == null) {
            throw new IllegalArgumentException("dest array cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length * 4 > srcBuffer.capacity()) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source buffer capacity (" + srcBuffer.capacity() + ")");
        }
        if (destOffset + length > destArray.length) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest array length (" + destArray.length + ")");
        }
        if (USE_UNSAFE && srcBuffer.isDirect() && srcBuffer.order() == nativeOrder) {
            long srcAddress = ((DirectBuffer)((Object)srcBuffer)).address();
            UNSAFE.copyMemory(null, srcAddress + (long)srcOffset, destArray, FLOATS_OFFSET + destOffset, length * 4);
        } else if (USE_NATIVE && srcBuffer.order() == nativeOrder) {
            if (srcBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcBuffer, srcOffset, destArray, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destArray, destOffset, length);
            }
        } else {
            ByteBuffer dupSrcBuffer = srcBuffer.duplicate();
            dupSrcBuffer.order(srcBuffer.order());
            dupSrcBuffer.limit(dupSrcBuffer.capacity());
            dupSrcBuffer.position(srcOffset);
            dupSrcBuffer.asFloatBuffer().get(destArray, destOffset, length);
        }
    }

    public static final void copy(long[] srcArray, int srcOffset, ByteBuffer destBuffer, int destOffset, int length) {
        if (srcArray == null) {
            throw new IllegalArgumentException("source array cannot be null");
        }
        if (srcArray == null || destBuffer == null) {
            throw new IllegalArgumentException("dest buffer cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length > srcArray.length) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source array length (" + srcArray.length + ")");
        }
        if (destOffset + length * 8 > destBuffer.capacity()) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest buffer capacity (" + destBuffer.capacity() + ")");
        }
        if (USE_UNSAFE && destBuffer.order() == nativeOrder && destBuffer.isDirect()) {
            long destAddress = ((DirectBuffer)((Object)destBuffer)).address();
            UNSAFE.copyMemory(srcArray, LONGS_OFFSET + srcOffset, null, destAddress + (long)destOffset, length * 8);
        } else if (USE_NATIVE && destBuffer.order() == nativeOrder) {
            if (destBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
            }
        } else {
            ByteBuffer dupDestBuffer = destBuffer.duplicate();
            dupDestBuffer.order(destBuffer.order());
            dupDestBuffer.limit(dupDestBuffer.capacity());
            dupDestBuffer.position(destOffset);
            dupDestBuffer.asLongBuffer().put(srcArray, srcOffset, length);
        }
    }

    public static final void copy(ByteBuffer srcBuffer, int srcOffset, long[] destArray, int destOffset, int length) {
        if (srcBuffer == null) {
            throw new IllegalArgumentException("source buffer cannot be null");
        }
        if (destArray == null) {
            throw new IllegalArgumentException("dest array cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length * 8 > srcBuffer.capacity()) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source buffer capacity (" + srcBuffer.capacity() + ")");
        }
        if (destOffset + length > destArray.length) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest array length (" + destArray.length + ")");
        }
        if (USE_UNSAFE && srcBuffer.isDirect() && srcBuffer.order() == nativeOrder) {
            long srcAddress = ((DirectBuffer)((Object)srcBuffer)).address();
            UNSAFE.copyMemory(null, srcAddress + (long)srcOffset, destArray, LONGS_OFFSET + destOffset, length * 8);
        } else if (USE_NATIVE && srcBuffer.order() == nativeOrder) {
            if (srcBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcBuffer, srcOffset, destArray, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destArray, destOffset, length);
            }
        } else {
            ByteBuffer dupSrcBuffer = srcBuffer.duplicate();
            dupSrcBuffer.order(srcBuffer.order());
            dupSrcBuffer.limit(dupSrcBuffer.capacity());
            dupSrcBuffer.position(srcOffset);
            dupSrcBuffer.asLongBuffer().get(destArray, destOffset, length);
        }
    }

    public static final void copy(double[] srcArray, int srcOffset, ByteBuffer destBuffer, int destOffset, int length) {
        if (srcArray == null) {
            throw new IllegalArgumentException("source array cannot be null");
        }
        if (destBuffer == null) {
            throw new IllegalArgumentException("dest buffer cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length > srcArray.length) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source array length (" + srcArray.length + ")");
        }
        if (destOffset + length * 8 > destBuffer.capacity()) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest buffer capacity (" + destBuffer.capacity() + ")");
        }
        if (USE_UNSAFE && destBuffer.order() == nativeOrder && destBuffer.isDirect()) {
            long destAddress = ((DirectBuffer)((Object)destBuffer)).address();
            UNSAFE.copyMemory(srcArray, DOUBLES_OFFSET + srcOffset, null, destAddress + (long)destOffset, length * 8);
        } else if (USE_NATIVE && destBuffer.order() == nativeOrder) {
            if (destBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcArray, srcOffset, destBuffer.array(), destBuffer.arrayOffset() + destOffset, length);
            }
        } else {
            ByteBuffer dupDestBuffer = destBuffer.duplicate();
            dupDestBuffer.order(destBuffer.order());
            dupDestBuffer.limit(dupDestBuffer.capacity());
            dupDestBuffer.position(destOffset);
            dupDestBuffer.asDoubleBuffer().put(srcArray, srcOffset, length);
        }
    }

    public static final void copy(ByteBuffer srcBuffer, int srcOffset, double[] destArray, int destOffset, int length) {
        if (srcBuffer == null) {
            throw new IllegalArgumentException("source buffer cannot be null");
        }
        if (destArray == null) {
            throw new IllegalArgumentException("dest array cannot be null");
        }
        if (srcOffset < 0 || destOffset < 0 || length < 0) {
            throw new IllegalArgumentException("source and dest offsets (" + srcOffset + "/" + destOffset + ") and copy length (" + length + ") must be >= 0");
        }
        if (srcOffset + length * 8 > srcBuffer.capacity()) {
            throw new IllegalArgumentException("source offset (" + srcOffset + ") plus length (" + length + ") exceeds source buffer capacity (" + srcBuffer.capacity() + ")");
        }
        if (destOffset + length > destArray.length) {
            throw new IllegalArgumentException("dest offset (" + destOffset + ") plus length (" + length + ") exceeds dest array length (" + destArray.length + ")");
        }
        if (USE_UNSAFE && srcBuffer.isDirect() && srcBuffer.order() == nativeOrder) {
            long srcAddress = ((DirectBuffer)((Object)srcBuffer)).address();
            UNSAFE.copyMemory(null, srcAddress + (long)srcOffset, destArray, DOUBLES_OFFSET + destOffset, length * 8);
        } else if (USE_NATIVE && srcBuffer.order() == nativeOrder) {
            if (srcBuffer.isDirect()) {
                UtlBuffer.nativeCopy(srcBuffer, srcOffset, destArray, destOffset, length);
            } else {
                UtlBuffer.nativeCopy(srcBuffer.array(), srcBuffer.arrayOffset() + srcOffset, destArray, destOffset, length);
            }
        } else {
            ByteBuffer dupSrcBuffer = srcBuffer.duplicate();
            dupSrcBuffer.order(srcBuffer.order());
            dupSrcBuffer.limit(dupSrcBuffer.capacity());
            dupSrcBuffer.position(srcOffset);
            dupSrcBuffer.asDoubleBuffer().get(destArray, destOffset, length);
        }
    }

    public static final void wipe(ByteBuffer buffer, int offset, int len) {
        int lenToWipe;
        int n = lenToWipe = len > 0 ? len : buffer.capacity() - offset;
        if (buffer.isDirect()) {
            if (USE_UNSAFE) {
                if (buffer.isDirect()) {
                    long destAddress = ((DirectBuffer)((Object)buffer)).address();
                    if (lenToWipe < CLEAR_BUFFER_SIZE) {
                        UNSAFE.copyMemory(CLEAR_BUFFER_ADDRESS, destAddress + (long)offset, lenToWipe);
                    } else {
                        for (int cleared = 0; cleared > 0; cleared += CLEAR_BUFFER_SIZE) {
                            UNSAFE.copyMemory(CLEAR_BUFFER_ADDRESS, destAddress + (long)offset + (long)cleared, Math.min(CLEAR_BUFFER_SIZE, lenToWipe - cleared));
                        }
                    }
                } else if (lenToWipe < CLEAR_BUFFER_SIZE) {
                    UtlBuffer.copy(CLEAR_BUFFER, 0, buffer.array(), offset, lenToWipe);
                } else {
                    for (int cleared = 0; cleared > 0; cleared += CLEAR_BUFFER_SIZE) {
                        UtlBuffer.copy(CLEAR_BUFFER, 0, buffer.array(), offset + cleared, Math.min(CLEAR_BUFFER_SIZE, lenToWipe - cleared));
                    }
                }
            } else if (USE_NATIVE) {
                UtlBuffer.nativeWipe(buffer, lenToWipe);
            } else {
                buffer.clear();
                for (int i = 0; i < lenToWipe; ++i) {
                    buffer.put(i, (byte)0);
                }
            }
        } else {
            Arrays.fill(buffer.array(), buffer.arrayOffset(), lenToWipe, (byte)0);
        }
        buffer.clear();
    }

    public static final void wipe(ByteBuffer buffer, int len) {
        UtlBuffer.wipe(buffer, 0, len);
    }

    public static final InputStream inputStream(final ByteBuffer buffer) {
        return new InputStream(){

            @Override
            public final int read() throws IOException {
                if (!buffer.hasRemaining()) {
                    return -1;
                }
                return buffer.get() & 0xFF;
            }

            @Override
            public final int read(byte[] bytes, int off, int len) throws IOException {
                if (!buffer.hasRemaining()) {
                    return -1;
                }
                len = Math.min(len, buffer.remaining());
                buffer.get(bytes, off, len);
                return len;
            }
        };
    }

    public static final OutputStream outputStream(final ByteBuffer buffer) {
        return new OutputStream(){

            @Override
            public final void write(int b) throws IOException {
                buffer.put((byte)b);
            }

            @Override
            public final void write(byte[] bytes, int off, int len) throws IOException {
                buffer.put(bytes, off, len);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String dump(ByteBuffer buffer) {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(System.identityHashCode(buffer));
        str.append(",");
        str.append(buffer.toString());
        str.append("]");
        str.append("<");
        int i = 0;
        int pos = buffer.position();
        try {
            while (buffer.remaining() > 0) {
                String hexStr = Integer.toHexString(0xFF & buffer.get());
                str.append(hexStr.length() == 1 ? "0" + hexStr : hexStr);
                if (++i % 4 != 0 || buffer.remaining() <= 0) continue;
                str.append(" ");
            }
            str.append(">");
            String string = str.toString();
            return string;
        }
        finally {
            buffer.position(pos);
        }
    }

    public static final ByteBuffer fromDump(String hexDump) {
        String toDecode;
        if (hexDump == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        int start = hexDump.indexOf(60);
        start = start == -1 ? 0 : ++start;
        int end = hexDump.indexOf(62, start);
        if (end == -1) {
            end = hexDump.length();
        }
        if ((toDecode = hexDump.substring(start, end).replace(" ", "")).length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid input ... expected even number of hex digits");
        }
        ByteBuffer buffer = ByteBuffer.allocate(toDecode.length());
        try {
            buffer.put(Hex.decodeHex((char[])toDecode.toCharArray()));
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Input couldn't be decoded: " + e.getMessage(), e);
        }
        buffer.flip();
        return buffer;
    }

    public static final String dump(String prefix, ByteBuffer buffer, int offset, int len) {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(prefix);
        str.append(",");
        str.append(System.identityHashCode(buffer));
        str.append(",");
        str.append(buffer.toString());
        str.append("]");
        str.append("<");
        for (int i = offset; i < offset + len; ++i) {
            String hexStr = Integer.toHexString(0xFF & buffer.get(i));
            str.append(hexStr.length() == 1 ? "0" + hexStr : hexStr);
            if ((i - offset + 1) % 4 != 0 || i >= offset + len - 1) continue;
            str.append(" ");
        }
        str.append(">");
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String flipAndDump(ByteBuffer buffer) {
        int pos = buffer.position();
        int limit = buffer.limit();
        buffer.flip();
        try {
            String string = UtlBuffer.dump(buffer);
            return string;
        }
        finally {
            buffer.limit(limit);
            buffer.position(pos);
        }
    }

    public static final String toString(ByteBuffer buffer) {
        return "[" + System.identityHashCode(buffer) + ",pos=" + buffer.position() + ",lim=" + buffer.limit() + ",cap=" + buffer.capacity() + "]";
    }

    public static final void writeLong(long value, byte[] target, int offset, boolean bigEndian) {
        if (bigEndian) {
            target[offset + 0] = (byte)(value >> 56);
            target[offset + 1] = (byte)(value >> 48);
            target[offset + 2] = (byte)(value >> 40);
            target[offset + 3] = (byte)(value >> 32);
            target[offset + 4] = (byte)(value >> 24);
            target[offset + 5] = (byte)(value >> 16);
            target[offset + 6] = (byte)(value >> 8);
            target[offset + 7] = (byte)(value >> 0);
        } else {
            target[offset + 7] = (byte)(value >> 56);
            target[offset + 6] = (byte)(value >> 48);
            target[offset + 5] = (byte)(value >> 40);
            target[offset + 4] = (byte)(value >> 32);
            target[offset + 3] = (byte)(value >> 24);
            target[offset + 2] = (byte)(value >> 16);
            target[offset + 1] = (byte)(value >> 8);
            target[offset + 0] = (byte)(value >> 0);
        }
    }

    public static final long readLong(byte[] source, int offset, boolean bigEndian) {
        long rc = 0L;
        if (bigEndian) {
            rc |= ((long)source[0 + offset] & 0xFFL) << 56;
            rc |= ((long)source[1 + offset] & 0xFFL) << 48;
            rc |= ((long)source[2 + offset] & 0xFFL) << 40;
            rc |= ((long)source[3 + offset] & 0xFFL) << 32;
            rc |= ((long)source[4 + offset] & 0xFFL) << 24;
            rc |= ((long)source[5 + offset] & 0xFFL) << 16;
            rc |= ((long)source[6 + offset] & 0xFFL) << 8;
            rc |= ((long)source[7 + offset] & 0xFFL) << 0;
        } else {
            rc |= ((long)source[7 + offset] & 0xFFL) << 56;
            rc |= ((long)source[6 + offset] & 0xFFL) << 48;
            rc |= ((long)source[5 + offset] & 0xFFL) << 40;
            rc |= ((long)source[4 + offset] & 0xFFL) << 32;
            rc |= ((long)source[3 + offset] & 0xFFL) << 24;
            rc |= ((long)source[2 + offset] & 0xFFL) << 16;
            rc |= ((long)source[1 + offset] & 0xFFL) << 8;
            rc |= ((long)source[0 + offset] & 0xFFL) << 0;
        }
        return rc;
    }

    static final boolean isDirectBufferCleaningAvailable() {
        return directBufferCleanerMethod != null;
    }

    public static final void releaseBuffer(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect() || buffer.capacity() == 0) {
            return;
        }
        if (directBufferCleanerMethod != null) {
            try {
                directBufferCleanerMethod.invoke(directBufferCleanerAccessorMethod.invoke((Object)buffer, new Object[0]), new Object[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error invoking direct buffer cleaner [" + t.getMessage() + "]", t);
            }
        } else {
            throw new UnsupportedOperationException("DirectBuffer cleaner is unavailable");
        }
    }

    static {
        Unsafe unsafeObject;
        block11: {
            nativeOrder = ByteOrder.nativeOrder();
            boolean enableUnsafe = Config.getValue((String)"nv.buffermanagement.useunsafe", (boolean)true);
            Field theUnsafe = null;
            unsafeObject = null;
            try {
                if (enableUnsafe) {
                    theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                    theUnsafe.setAccessible(true);
                    unsafeObject = (Unsafe)theUnsafe.get(null);
                }
            }
            catch (Throwable thrown) {
                System.err.println("Error loading unsafe: " + thrown.getMessage());
                if (!Config.getValue((String)"nv.native.configtrace", (boolean)false)) break block11;
                thrown.printStackTrace();
            }
        }
        if (unsafeObject != null) {
            UNSAFE = unsafeObject;
            BYTES_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            CHARS_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
            SHORTS_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
            INTS_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
            LONGS_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
            FLOATS_OFFSET = UNSAFE.arrayBaseOffset(float[].class);
            DOUBLES_OFFSET = UNSAFE.arrayBaseOffset(double[].class);
            CLEAR_BUFFER = ByteBuffer.allocateDirect(UNSAFE.pageSize());
            CLEAR_BUFFER_SIZE = CLEAR_BUFFER.capacity();
            CLEAR_BUFFER_ADDRESS = ((DirectBuffer)((Object)CLEAR_BUFFER)).address();
            USE_UNSAFE = true;
        } else {
            UNSAFE = null;
            BYTES_OFFSET = -1;
            CHARS_OFFSET = -1;
            SHORTS_OFFSET = -1;
            INTS_OFFSET = -1;
            LONGS_OFFSET = -1;
            FLOATS_OFFSET = -1;
            DOUBLES_OFFSET = -1;
            CLEAR_BUFFER = null;
            CLEAR_BUFFER_SIZE = -1;
            CLEAR_BUFFER_ADDRESS = -1L;
            USE_UNSAFE = false;
        }
        boolean nativeKernelLoaded = false;
        try {
            NativeKernel.initialize();
            nativeKernelLoaded = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        USE_NATIVE = nativeKernelLoaded && Config.getValue((String)"nv.buffermanagement.usenative", (boolean)false);
        ByteBuffer b = ByteBuffer.allocateDirect(32);
        Method directBufferCleanerAccessorMethodCandidate = null;
        Method directBufferCleanerMethodCandidate = null;
        try {
            directBufferCleanerAccessorMethodCandidate = b.getClass().getMethod("cleaner", new Class[0]);
            directBufferCleanerAccessorMethodCandidate.setAccessible(true);
            Object cleaner = directBufferCleanerAccessorMethodCandidate.invoke((Object)b, new Object[0]);
            if (cleaner instanceof Runnable) {
                directBufferCleanerMethodCandidate = Runnable.class.getMethod("run", new Class[0]);
            } else {
                directBufferCleanerMethodCandidate = cleaner.getClass().getMethod("clean", new Class[0]);
                directBufferCleanerMethodCandidate.setAccessible(true);
            }
            directBufferCleanerMethodCandidate.invoke(directBufferCleanerAccessorMethodCandidate.invoke((Object)b, new Object[0]), new Object[0]);
        }
        catch (Throwable thrown) {
            directBufferCleanerAccessorMethodCandidate = null;
            directBufferCleanerMethodCandidate = null;
            System.err.println("WARNING: Unable to load direct buffer cleaner, file locks and memory may not be released properly. Error trace: " + UtlThrowable.prepareStackTrace((Throwable)thrown));
        }
        directBufferCleanerAccessorMethod = directBufferCleanerAccessorMethodCandidate;
        directBufferCleanerMethod = directBufferCleanerMethodCandidate;
    }
}

