/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XDateIterator;
import java.util.Date;
import java.util.NoSuchElementException;

public final class XDateSequence
implements XDateIterator {
    private static final byte FLG_INITIALIZED = 1;
    private static final byte FLG_OWNED = 2;
    private byte _flags;
    private long _addr;
    private int _offset;
    private int _nelem;
    private int _index;

    private XDateSequence() {
    }

    public static final XDateSequence create() {
        return new XDateSequence();
    }

    private final XDateSequence setInitialized(boolean val) {
        this._flags = val ? (byte)(this._flags | 1) : (byte)(this._flags & 0xFFFFFFFE);
        return this;
    }

    public final boolean isInitialized() {
        return (this._flags & 1) != 0;
    }

    private final XDateSequence setOwned(boolean val) {
        this._flags = val ? (byte)(this._flags | 2) : (byte)(this._flags & 0xFFFFFFFD);
        return this;
    }

    public final boolean isOwned() {
        return (this._flags & 2) != 0;
    }

    public static final long getAtAsTimestamp(IOBuffer buffer, int index) {
        int offset = index * 8;
        if (offset < 0 || offset > buffer.getLength() - 8) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return buffer.getLong(offset);
    }

    public XDateIterator toFirst() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        this._index = 0;
        return this;
    }

    @Override
    public final boolean hasNext() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._index < this._nelem;
    }

    @Override
    public final Date next() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return new Date(this.nextAsTimestamp());
    }

    @Override
    public final long nextAsTimestamp() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._nelem) {
            throw new NoSuchElementException("no more elements");
        }
        return IOBuffer.getLong(this._addr, this._offset + this._index++ * 8);
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public final XDateSequence wrap(long addr, int offset, int len) {
        this.reset();
        this._addr = addr;
        this._offset = offset;
        this._nelem = len / 8;
        this._index = 0;
        this.setInitialized(true).setOwned(false);
        return this;
    }

    public final XDateSequence wrap(IOBuffer buffer, int offset, int len) {
        return this.wrap(buffer.getNativeAddress(), offset, len);
    }

    public final XDateSequence setFrom(long addr, int offset, int len) {
        this.reset();
        this._addr = IOBuffer.allocateMemoryBlock(len, false);
        IOBuffer.copy(addr, offset, this._addr, 0, len);
        this._nelem = len / 8;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XDateSequence setFrom(IOBuffer buffer, int offset, int len) {
        this.reset();
        this._addr = IOBuffer.allocateMemoryBlock(len, false);
        IOBuffer.copy(buffer.getNativeAddress(), offset, this._addr, 0, len);
        this._nelem = len / 8;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XDateSequence setFrom(XDateSequence sequence) {
        this.reset();
        if (sequence.isInitialized()) {
            int serializedLength = sequence.serializedLength();
            this._addr = IOBuffer.allocateMemoryBlock(serializedLength, false);
            IOBuffer.copy(sequence._addr, sequence._offset, this._addr, 0, serializedLength);
            this._nelem = sequence.numElements();
            this._offset = 0;
            this._index = 0;
            this.setInitialized(true).setOwned(true);
        }
        return this;
    }

    public final XDateSequence setFrom(XDateIterator iterator) {
        this.reset();
        if (iterator instanceof XDateSequence) {
            return this.setFrom((XDateSequence)iterator);
        }
        throw new IllegalArgumentException("iterator implementations other than XDateSequence are not currently supported");
    }

    public final int numElements() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._nelem;
    }

    public final int serializedLength() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._nelem * 8;
    }

    public final Date getAt(int index) {
        return new Date(this.getAtAsTimestamp(index));
    }

    public final long getAtAsTimestamp(int index) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (index < 0 || index > this._nelem - 1) {
            throw new IllegalArgumentException("invalid index");
        }
        return IOBuffer.getLong(this._addr, this._offset + this._index * 8);
    }

    public final int getTo(Date[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        XDateIterator iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            val[offset + i] = (Date)iterator.next();
            ++i;
        }
        return this.serializedLength();
    }

    public final int getTo(long[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        IOBuffer.getTo(this._addr, this._offset, val, offset, this._nelem);
        return this.serializedLength();
    }

    public final int getTo(byte[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        IOBuffer.getTo(this._addr, this._offset, val, offset, serializedLength);
        return serializedLength;
    }

    public final int getTo(long addr, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        IOBuffer.copy(this._addr, this._offset, addr, offset, serializedLength);
        return serializedLength;
    }

    public final int getTo(IOBuffer val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        val.putFrom(offset, this._addr, this._offset, serializedLength);
        return serializedLength;
    }

    public final XDateIterator iterator() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this.toFirst();
    }

    public final XDateSequence reset() {
        if (this.isInitialized()) {
            if (this.isOwned() && this._addr != 0L) {
                IOBuffer.freeMemoryBlock(this._addr, this.serializedLength());
            }
            this.setInitialized(false);
        }
        return this;
    }
}

