/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.neeve.rog.log.RogLogReader;
import com.neeve.trace.Tracer;
import java.util.Iterator;
import java.util.LinkedHashMap;

public final class RogLogTailer
implements Runnable {
    private final RogLogReader reader;
    private final Tracer tracer;
    private volatile long lastStableVersion = -1L;
    private volatile boolean done = false;

    public RogLogTailer(RogLogReader reader, Tracer tracer) throws Exception {
        if (reader == null) {
            throw new IllegalArgumentException("reader cannot be null");
        }
        this.reader = reader;
        this.tracer = tracer;
    }

    private void tail() throws Exception {
        LinkedHashMap<Long, Long> unstableVersionTxnIds = new LinkedHashMap<Long, Long>();
        block0: while (!this.done) {
            RogLogReader.Entry entry = null;
            while ((entry = this.reader.next()) == null) {
                if (this.done) {
                    return;
                }
                Thread.sleep(100L);
                if (!this.done) continue;
                return;
            }
            unstableVersionTxnIds.put(entry.getCheckpointVersion(), entry.getTransactionId());
            Iterator iter = unstableVersionTxnIds.keySet().iterator();
            while (iter.hasNext()) {
                long version = (Long)iter.next();
                if (entry.getCheckpointVersion() <= version || entry.getStableTransactionId() < (Long)unstableVersionTxnIds.get(version)) continue block0;
                this.lastStableVersion = version;
                iter.remove();
                if (this.tracer == null || !this.tracer.debug) continue;
                this.tracer.log("Log tailer - stable checkpoint v" + this.lastStableVersion + ", tx" + entry.getStableTransactionId(), Tracer.Level.DEBUG);
            }
        }
    }

    private void close() {
        block2: {
            try {
                this.reader.close();
            }
            catch (Exception ex) {
                if (this.tracer == null) break block2;
                this.tracer.log("Error closing the tailer log reader - " + ex, Tracer.Level.SEVERE);
            }
        }
    }

    public final long getLastStableCheckpointVersion() {
        return this.lastStableVersion;
    }

    @Override
    public void run() {
        try {
            this.tail();
        }
        catch (Exception ex) {
            if (this.tracer != null) {
                this.tracer.log("Error reading the log in tailer log reader - " + ex, Tracer.Level.SEVERE);
            }
        }
        finally {
            this.close();
        }
    }

    public void shutdown() {
        this.done = true;
    }
}

