/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index;

import com.neeve.query.impl.index.IdxUniqueBaseIndex;
import com.neeve.query.index.IdxRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;

public class IdxUniqueTreeIndex<T, ID>
extends IdxUniqueBaseIndex<T, ID> {
    public IdxUniqueTreeIndex(String name, Map<Object, ID> backingMap) {
        super(name, backingMap);
    }

    @Override
    protected NavigableMap<Object, ID> getBackingMap() {
        return (NavigableMap)super.getBackingMap();
    }

    @Override
    protected NavigableMap<Object, ID> getBackingMap(boolean ascending) {
        NavigableMap backingMap = this.getBackingMap();
        return ascending ? backingMap : backingMap.descendingMap();
    }

    @Override
    public Iterable<ID> allIds(boolean ascending) {
        Map backingMap = this.getBackingMap(ascending);
        return new IdxUniqueBaseIndex.LazyValues(backingMap);
    }

    @Override
    public <KEY extends Comparable<KEY>> Iterable<ID> getIds(IdxRange<KEY> range) {
        return this.getIds(range, null);
    }

    private <KEY extends Comparable<KEY>> NavigableMap<Object, ID> getSubMap(IdxRange<KEY> range) {
        NavigableMap subMap;
        if (range.isBoundBelow() && range.isBoundAbove()) {
            KEY fromValue = range.getStart();
            Object fromKey = this.getIndexKey(fromValue);
            KEY toValue = range.getEnd();
            Object toKey = this.getIndexKey(toValue);
            subMap = this.getBackingMap().subMap(fromKey, range.includeStart(), toKey, range.includeEnd());
        } else if (range.isBoundBelow()) {
            KEY fromValue = range.getStart();
            Object fromKey = this.getIndexKey(fromValue);
            subMap = this.getBackingMap().tailMap(fromKey, range.includeStart());
        } else if (range.isBoundAbove()) {
            KEY toValue = range.getEnd();
            Object toKey = this.getIndexKey(toValue);
            subMap = this.getBackingMap().headMap(toKey, range.includeEnd());
        } else {
            subMap = this.getBackingMap();
        }
        return subMap;
    }

    @Override
    public <KEY extends Comparable<KEY>> Iterable<ID> getIds(IdxRange<KEY> range, Comparator<ID> recordIdSorter) {
        NavigableMap<Object, ID> subMap = this.getSubMap(range);
        if (recordIdSorter != null) {
            ArrayList sorted = new ArrayList(subMap.values());
            Collections.sort(sorted, recordIdSorter);
            return sorted;
        }
        return new IdxUniqueBaseIndex.LazyValues<Object, ID>(subMap);
    }

    @Override
    public <KEY extends Comparable<KEY>> Iterable<Map.Entry<T, ID>> getEntries(IdxRange<KEY> range, boolean ascending) {
        NavigableMap<Object, ID> subMap = this.getSubMap(range);
        if (!ascending) {
            subMap = subMap.descendingMap();
        }
        NavigableMap<Object, ID> rawMap = subMap;
        return rawMap.entrySet();
    }

    @Override
    public T getLowestKey() {
        if (this.getBackingMap().isEmpty()) {
            return null;
        }
        Object firstKey = this.getBackingMap().firstKey();
        return this.getFieldValue(firstKey);
    }

    @Override
    public T getHighestKey() {
        if (this.getBackingMap().isEmpty()) {
            return null;
        }
        Object lastKey = this.getBackingMap().lastKey();
        return this.getFieldValue(lastKey);
    }
}

