/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.neeve.query.impl.index.IdxBaseIndex;
import com.neeve.query.impl.util.collect.UtlSorted;
import com.neeve.query.index.IdxNonUniqueIndex;
import com.neeve.query.index.IdxRange;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import org.mapdb.Fun;

public class IdxNonUniqueTreeIndex<T, ID>
extends IdxBaseIndex<T, ID>
implements IdxNonUniqueIndex<T, ID> {
    private NavigableSet<Fun.Tuple2<Object, ID>> backingSet;
    private NavigableSet<Object> keySet;

    public IdxNonUniqueTreeIndex(String name, NavigableSet<Object> keySet, NavigableSet<Fun.Tuple2<Object, ID>> set) {
        super(name, false);
        this.keySet = keySet;
        this.backingSet = set;
    }

    @Override
    public void put(T fieldValue, ID value) {
        Object indexKey = this.getIndexKey(fieldValue);
        if (this.backingSet.add(Fun.t2((Object)indexKey, value))) {
            if (this.keySet.add(indexKey)) {
                this.stats.onKeyAdded(fieldValue);
            }
            this.stats.onValueAdded();
        }
    }

    @Override
    public void remove(T fieldValue, ID value) {
        Object indexKey = this.getIndexKey(fieldValue);
        if (this.backingSet.remove(Fun.t2((Object)indexKey, value))) {
            NavigableSet<Fun.Tuple2<Object, ID>> untyped = this.backingSet;
            if (untyped.subSet(Fun.t2(fieldValue, null), true, Fun.t2(fieldValue, (Object)Fun.HI), true).isEmpty()) {
                this.keySet.remove(fieldValue);
                this.stats.onKeyRemoved(fieldValue, this);
            }
            this.stats.onValueRemoved();
        }
    }

    private Iterable<ID> getInternal(Object indexKey) {
        return Fun.filter(this.backingSet, (Object)indexKey);
    }

    @Override
    public Iterable<ID> get(T fieldValue) {
        Object indexKey = this.getIndexKey(fieldValue);
        return this.getInternal(indexKey);
    }

    @Override
    public boolean containsKey(T key) {
        return this.keySet.contains(key);
    }

    @Override
    public <KEY extends Comparable<KEY>> Iterable<ID> getIds(IdxRange<KEY> range) {
        return this.getIds(range, null);
    }

    private <KEY extends Comparable<KEY>> NavigableSet<Object> getKeySubset(IdxRange<KEY> range) {
        NavigableSet<Object> keySubSet;
        if (range.isBoundBelow() && range.isBoundAbove()) {
            KEY fromValue = range.getStart();
            Object fromKey = this.getIndexKey(fromValue);
            KEY toValue = range.getEnd();
            Object toKey = this.getIndexKey(toValue);
            keySubSet = this.keySet.subSet(fromKey, range.includeStart(), toKey, range.includeEnd());
        } else if (range.isBoundBelow()) {
            KEY fromValue = range.getStart();
            Object fromKey = this.getIndexKey(fromValue);
            keySubSet = this.keySet.tailSet(fromKey, range.includeStart());
        } else if (range.isBoundAbove()) {
            KEY toValue = range.getEnd();
            Object toKey = this.getIndexKey(toValue);
            keySubSet = this.keySet.headSet(toKey, range.includeEnd());
        } else {
            keySubSet = this.keySet;
        }
        return keySubSet;
    }

    @Override
    public <KEY extends Comparable<KEY>> Iterable<ID> getIds(IdxRange<KEY> range, final Comparator<ID> sorter) {
        final NavigableSet<Object> keySubSet = this.getKeySubset(range);
        final Iterable values = new Iterable<Iterable<ID>>(){

            @Override
            public Iterator<Iterable<ID>> iterator() {
                final Iterator keyIter = keySubSet.iterator();
                return new Iterator<Iterable<ID>>(){

                    @Override
                    public boolean hasNext() {
                        return keyIter.hasNext();
                    }

                    @Override
                    public Iterable<ID> next() {
                        Object key = keyIter.next();
                        return IdxNonUniqueTreeIndex.this.getInternal(key);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        return new Iterable<ID>(){

            @Override
            public Iterator<ID> iterator() {
                if (sorter != null) {
                    return UtlSorted.merge(values, sorter).iterator();
                }
                return Iterables.concat((Iterable)values).iterator();
            }
        };
    }

    private <KEY extends Comparable<KEY>> NavigableSet<Fun.Tuple2<Object, ID>> getSubSet(IdxRange<KEY> range) {
        NavigableSet<Fun.Tuple2<Object, ID>> subSet;
        if (range.isBoundBelow() && range.isBoundAbove()) {
            KEY fromValue = range.getStart();
            Object fromKey = this.getIndexKey(fromValue);
            Fun.Tuple2 fromPair = new Fun.Tuple2(fromKey, null);
            KEY toValue = range.getEnd();
            Object toKey = this.getIndexKey(toValue);
            Fun.Tuple2 toPair = new Fun.Tuple2(toKey, Fun.HI);
            subSet = this.backingSet.subSet(fromPair, range.includeStart(), toPair, range.includeEnd());
        } else if (range.isBoundBelow()) {
            KEY fromValue = range.getStart();
            Object fromKey = this.getIndexKey(fromValue);
            Fun.Tuple2 fromPair = new Fun.Tuple2(fromKey, null);
            subSet = this.backingSet.tailSet(fromPair, range.includeStart());
        } else if (range.isBoundAbove()) {
            KEY toValue = range.getEnd();
            Object toKey = this.getIndexKey(toValue);
            Fun.Tuple2 toPair = new Fun.Tuple2(toKey, Fun.HI);
            subSet = this.backingSet.headSet(toPair, range.includeEnd());
        } else {
            subSet = this.backingSet;
        }
        return subSet;
    }

    @Override
    public <KEY extends Comparable<KEY>> Iterable<Map.Entry<T, ID>> getEntries(final IdxRange<KEY> range, final boolean ascending) {
        return new Iterable<Map.Entry<T, ID>>(){
            final NavigableSet<Fun.Tuple2<Object, ID>> subSet;
            {
                this.subSet = IdxNonUniqueTreeIndex.this.getSubSet(range);
            }

            @Override
            public Iterator<Map.Entry<T, ID>> iterator() {
                return new Iterator<Map.Entry<T, ID>>(){
                    Iterator<Fun.Tuple2<Object, ID>> iter;
                    {
                        this.iter = ascending ? subSet.iterator() : subSet.descendingIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Map.Entry<T, ID> next() {
                        Fun.Tuple2 pair = this.iter.next();
                        return new AbstractMap.SimpleEntry<Object, Object>(pair.a, pair.b);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public void computeStats() {
        this.stats.setCardinality(this.backingSet.size());
        this.stats.setKeyCardinality(this.keySet.size());
        Object lowFieldValue = this.getFieldValue(this.keySet.first());
        this.stats.setLowKey(lowFieldValue);
        Object highFieldValue = this.getFieldValue(this.keySet.last());
        this.stats.setHighKey(highFieldValue);
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public int valueCount(Iterable<? extends Object> keys) {
        int count = 0;
        for (Object object : keys) {
            Object indexKey = this.getIndexKey(object);
            if (object == null || !this.keySet.contains(indexKey)) continue;
            count += this.backingSet.subSet(Fun.t2((Object)indexKey, null), Fun.t2((Object)indexKey, (Object)Fun.HI)).size();
        }
        return count;
    }

    @Override
    public T getLowestKey() {
        if (this.keySet.isEmpty()) {
            return null;
        }
        return this.getFieldValue(this.keySet.first());
    }

    @Override
    public T getHighestKey() {
        if (this.keySet.isEmpty()) {
            return null;
        }
        return this.getFieldValue(this.keySet.last());
    }

    @Override
    public Iterable<Map.Entry<T, ID>> allEntries(final boolean ascending) {
        return new Iterable<Map.Entry<T, ID>>(){

            @Override
            public Iterator<Map.Entry<T, ID>> iterator() {
                return new AbstractIterator<Map.Entry<T, ID>>(){
                    private Iterator<Fun.Tuple2<Object, ID>> entryIter;
                    {
                        this.entryIter = ascending ? IdxNonUniqueTreeIndex.this.backingSet.iterator() : IdxNonUniqueTreeIndex.this.backingSet.descendingIterator();
                    }

                    protected Map.Entry<T, ID> computeNext() {
                        if (this.entryIter.hasNext()) {
                            Fun.Tuple2 entry = this.entryIter.next();
                            return new AbstractMap.SimpleEntry<Object, Object>(entry.a, entry.b);
                        }
                        return (Map.Entry)this.endOfData();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<ID> allIds(final boolean ascending) {
        return new Iterable<ID>(){

            @Override
            public Iterator<ID> iterator() {
                return new AbstractIterator<ID>(){
                    private Iterator<Fun.Tuple2<Object, ID>> entryIter;
                    {
                        this.entryIter = ascending ? IdxNonUniqueTreeIndex.this.backingSet.iterator() : IdxNonUniqueTreeIndex.this.backingSet.descendingIterator();
                    }

                    protected ID computeNext() {
                        if (this.entryIter.hasNext()) {
                            Fun.Tuple2 entry = this.entryIter.next();
                            return entry.b;
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }
}

