/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryAbstractField;
import com.neeve.query.impl.QueryConfig;
import com.neeve.query.impl.QueryFieldResolver;
import com.neeve.query.impl.QueryObject;
import com.neeve.query.impl.QueryParser;
import com.neeve.query.impl.QueryReflectionField;
import com.neeve.query.impl.index.IdxMappable;
import com.neeve.query.impl.util.UtlQueryReflection;
import com.neeve.query.index.IdxField;
import com.neeve.query.predicates.Predicate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mapdb.Fun;

public class QueryDefaultFieldResolver<REC>
extends QueryObject
implements QueryFieldResolver<REC> {
    public static final String REPOSITORY_NAME = "x_repository_name";
    private String defaultPackage;
    private List<WellKnownPath> wellKnownPaths = Lists.newArrayList();
    private Map<Key, IdxField<?, ?>> fieldCache = Maps.newConcurrentMap();
    private boolean cacheEnabled = false;
    private Map<Fun.Tuple2<Class<?>, String>, Class<?>> returnTypeCache = Maps.newHashMap();
    public final IdxField<REC, String> REPOSITORY_NAME_FIELD;
    public final IdxField<REC, REC> RECORD_FIELD;
    public final IdxField<REC, Object> SELECT_ALL_FIELD;

    public QueryDefaultFieldResolver(Class<REC> concreteBaseType) {
        super(QueryConfig.getConfig());
        this.registerWellKnownPath("", concreteBaseType);
        this.REPOSITORY_NAME_FIELD = new RepoNameField(concreteBaseType, "x.repositoryName", String.class, new Class[0]);
        this.RECORD_FIELD = new RecordField(concreteBaseType);
        this.SELECT_ALL_FIELD = this.RECORD_FIELD;
    }

    protected void registerWellKnownPath(String path, Class<?> type) {
        this.wellKnownPaths.add(new WellKnownPath(path, type));
    }

    @Override
    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    protected Class<?> resolveType(String name) throws QueryException {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        if (name.equals("Object")) {
            return Object.class;
        }
        if (name.equals("nvx:record")) {
            return this.RECORD_FIELD.getRecordType();
        }
        Class<?> resolved = this.resolveClass(name);
        Iterator<WellKnownPath> pathIter = this.wellKnownPaths.iterator();
        while (resolved == null && pathIter.hasNext()) {
            WellKnownPath path = pathIter.next();
            Class<?> type = path.getType();
            if (!name.equals(type.getSimpleName())) continue;
            resolved = type;
        }
        if (resolved == null && !Strings.isNullOrEmpty((String)this.defaultPackage)) {
            resolved = this.resolveClass(this.defaultPackage + "." + name);
        }
        return resolved;
    }

    private Class<?> resolveClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected void cacheReturnType(Class<?> objectType, String fieldPath, Class<?> returnType) {
        Fun.Tuple2 key = new Fun.Tuple2(objectType, (Object)fieldPath);
        this.returnTypeCache.put(key, returnType);
    }

    protected Class<?> findReturnType(Class<?> objectType, String fieldPath) {
        Fun.Tuple2 key = new Fun.Tuple2(objectType, (Object)fieldPath);
        return this.returnTypeCache.get(key);
    }

    protected Class<?> resolveFieldType(Class<?> objectType, String fieldPath) {
        Class<Object> returnType = this.findReturnType(objectType, fieldPath);
        if (returnType == null) {
            Class<?> containerType;
            int nestedFieldDelim;
            returnType = UtlQueryReflection.getReturnType(objectType, fieldPath);
            if (returnType == null && (nestedFieldDelim = fieldPath.lastIndexOf(46)) > 0 && (containerType = UtlQueryReflection.getReturnType(objectType, fieldPath.substring(0, nestedFieldDelim))) != null && IdxMappable.class.isAssignableFrom(containerType)) {
                returnType = Object.class;
            }
            if (returnType != null) {
                this.cacheReturnType(objectType, fieldPath, returnType);
            }
        }
        return returnType;
    }

    @Override
    public <T> IdxField<REC, T> getField(String recordTypeName, String fieldPath) {
        if (recordTypeName == null || recordTypeName.length() == 0 && fieldPath != null) {
            if ("nvx:record".equals(fieldPath)) {
                return this.getRecordField();
            }
            if (QueryParser.SELECT_ALL.getColumnName().equals(fieldPath)) {
                return this.getSelectAllField();
            }
            if (REPOSITORY_NAME.equals(fieldPath)) {
                return this.getRepositoryNameField();
            }
        }
        Class<?> objectType = null;
        String resolvedPath = fieldPath;
        if (!Strings.isNullOrEmpty((String)recordTypeName)) {
            objectType = this.resolveType(recordTypeName);
            if (objectType == null) {
                resolvedPath = recordTypeName + (!Strings.isNullOrEmpty((String)fieldPath) ? "." + fieldPath : "");
            }
        } else {
            objectType = this.resolveType(fieldPath);
            if (objectType != null) {
                resolvedPath = "";
            }
        }
        if (objectType == null) {
            objectType = this.findTypeForPath(resolvedPath);
        }
        if (objectType == null && !Strings.isNullOrEmpty((String)recordTypeName)) {
            throw new QueryException("Cannot resolve [" + recordTypeName + "]");
        }
        return this.getField(objectType, resolvedPath);
    }

    protected Class<?> findTypeForPath(String fieldPath) {
        for (WellKnownPath path : this.wellKnownPaths) {
            Class<?> type = path.getType();
            if (!UtlQueryReflection.hasPath(type, (String)fieldPath)) continue;
            return type;
        }
        return Object.class;
    }

    @Override
    public <T> IdxField<REC, T> getField(Class<?> objectType, String fieldPath) {
        String resolvedFieldPath = fieldPath;
        if (resolvedFieldPath == null) {
            resolvedFieldPath = "";
        }
        if (resolvedFieldPath.equals("nvx:record")) {
            return this.getRecordField();
        }
        Class<?> fieldType = this.resolveFieldType(objectType, resolvedFieldPath);
        if (fieldType == null) {
            throw new QueryException("Cannot resolve field " + objectType.getSimpleName() + "." + fieldPath);
        }
        return this.getField(objectType, resolvedFieldPath, fieldType, new Class[0]);
    }

    @Override
    public <T> IdxField<REC, T> getField(Class<?> recordType, String fieldPath, Class<T> fieldType, Class<?> ... pathTypes) {
        if (this.cacheEnabled) {
            IdxField<?, ?> field;
            Key key = new Key(recordType, fieldPath, fieldType, pathTypes);
            if (this.fieldCache.containsKey(key)) {
                field = this.fieldCache.get(key);
            } else {
                field = new QueryReflectionField(recordType, fieldType, fieldPath, pathTypes);
                this.fieldCache.put(key, field);
            }
            return field;
        }
        return new QueryReflectionField(recordType, fieldType, fieldPath, pathTypes);
    }

    @Override
    public IdxField<REC, REC> getRecordField() {
        return this.RECORD_FIELD;
    }

    @Override
    public IdxField<REC, Object> getSelectAllField() {
        return this.SELECT_ALL_FIELD;
    }

    @Override
    public IdxField<REC, String> getRepositoryNameField() {
        return this.REPOSITORY_NAME_FIELD;
    }

    protected final class WellKnownPath {
        private final String path;
        private final Class<?> type;

        private WellKnownPath(String path, Class<?> type) {
            this.path = path;
            this.type = type;
        }

        public String getPath() {
            return this.path;
        }

        public Class<?> getType() {
            return this.type;
        }
    }

    private static class Key {
        private Class<?> recordType;
        private String fieldPath;
        private Class<?> fieldType;
        private Class<?>[] pathSelector;
        private int hashCode = 0;

        public Key(Class<?> recordType, String fieldPath, Class<?> fieldType, Class<?>[] pathSelector) {
            this.recordType = recordType;
            this.fieldPath = fieldPath;
            this.fieldType = fieldType;
            this.pathSelector = pathSelector;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equal(this.fieldType, other.fieldType) && Objects.equal((Object)this.fieldPath, (Object)other.fieldPath) && Arrays.equals(this.pathSelector, other.pathSelector);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int calc = Objects.hashCode((Object[])this.pathSelector);
                calc = calc * 31 + Objects.hashCode((Object[])new Object[]{this.fieldPath});
                calc = calc * 31 + Objects.hashCode((Object[])new Object[]{this.fieldType});
                this.hashCode = calc = calc * 31 + Objects.hashCode((Object[])new Object[]{this.recordType});
            }
            return this.hashCode;
        }
    }

    private static final class RecordField<REC>
    extends QueryAbstractField<REC, REC> {
        private static final long serialVersionUID = 1L;

        private RecordField(Class<REC> recType) {
            super(recType, "", recType, new Class[0]);
        }

        public REC apply(REC record) {
            return record;
        }

        @Override
        public List<Predicate<REC>> getPathTypePredicates() {
            return null;
        }
    }

    private final class RepoNameField
    extends QueryAbstractField<REC, String> {
        private static final long serialVersionUID = 1L;

        private RepoNameField(Class<? extends REC> recordType, String fieldPath, Class<String> fieldType, Class<?>[] pathSelector) {
            super(recordType, fieldPath, fieldType, pathSelector);
        }

        public String apply(REC record) {
            return this.getName();
        }

        @Override
        public List<Predicate<REC>> getPathTypePredicates() {
            return null;
        }

        @Override
        public String getName() {
            return QueryDefaultFieldResolver.REPOSITORY_NAME;
        }

        @Override
        public String getFieldPath() {
            return this.getName();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof IdxField)) {
                return false;
            }
            IdxField other = (IdxField)obj;
            return this.getName().equals(other.getName());
        }
    }
}

