/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreInterClusterReplicatorDescriptor;
import com.neeve.ods.impl.StorePacketPersisterBase;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusBindingFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.SmaException;
import com.neeve.sma.event.MessageBusBindingFailedEvent;
import com.neeve.sma.event.MessageEvent;
import com.neeve.trace.Tracer;

abstract class StoreSenderReceiver
extends StorePacketPersisterBase
implements IEventHandler {
    private final CloseContext closeContext = new CloseContext();
    private volatile ErrorHandler errorHandler;
    private volatile long eventHandlingThread;
    protected final String storeName;
    protected final StoreInterClusterReplicatorDescriptor descriptor;
    protected final MessageBusDescriptor busDescriptor;
    protected final String channelName;
    protected MessageBusBinding binding;
    protected MessageChannel channel;
    protected volatile State state;

    protected StoreSenderReceiver(String idSuffix, String storeName, StoreInterClusterReplicatorDescriptor descriptor) throws OdsException {
        super(idSuffix, descriptor.getProperties());
        this.storeName = storeName;
        this.descriptor = descriptor;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Creating ICR replicator (name='" + descriptor.getName() + ", store='" + storeName + "', role=" + (Object)((Object)descriptor.getRole()) + "')...", Tracer.Level.DEBUG);
        }
        try {
            this.busDescriptor = MessageBusDescriptor.create((String)("icr-" + storeName));
            this.channelName = "$XICR$/" + storeName;
            MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create((String)this.channelName, (MessageBusDescriptor)this.busDescriptor);
            channelDescriptor.setChannelQos(MessageChannel.Qos.Guaranteed);
            channelDescriptor.setChannelId((short)1);
            this.busDescriptor.addChannel(channelDescriptor);
            this.busDescriptor.setProviderConfig(descriptor.getUrl());
        }
        catch (SmaException e) {
            throw new OdsException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeCore(boolean preserveChannelJoins) {
        block8: {
            try {
                super.stop();
                if (this.binding == null) break block8;
                try {
                    this.binding.close(preserveChannelJoins ? 1 : 0);
                }
                catch (Exception e) {
                    this.tracer.log(this.tracePrefix() + "Failed to close binding [" + e.toString() + "].", Tracer.Level.WARNING);
                }
                finally {
                    this.binding = null;
                }
            }
            finally {
                this.state = State.Closed;
            }
        }
    }

    final String getName() {
        return this.descriptor.getName();
    }

    final StoreInterClusterReplicatorDescriptor getDescriptor() {
        return this.descriptor;
    }

    final void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    final ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    final void open() throws Exception {
        if (this.state != null) {
            throw new IllegalStateException("already open");
        }
        this.state = State.Opening;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Opening (url=" + this.descriptor.getUrl() + ")...", Tracer.Level.DEBUG);
        }
        try {
            this.binding = MessageBusBindingFactory.getInstance().createBinding(this.descriptor.getName() + "-" + this.descriptor.getRole().toString(), this.busDescriptor, (IEventHandler)this);
            this.channel = this.binding.getMessageChannel(this.channelName);
            if (this.descriptor.getRole() != IStoreBinding.InterClusterReplicationRole.Sender) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix() + "Joining channel '" + this.channelName + "'...", Tracer.Level.DEBUG);
                }
                this.channel.join(0);
            } else if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "Not joining channel since ICR sender.", Tracer.Level.DEBUG);
            }
            this.binding.start();
            this.state = State.Open;
        }
        catch (Exception e) {
            this.tracer.log(this.tracePrefix() + "Failed to open binding [" + e.toString() + "].", Tracer.Level.SEVERE);
            throw new OdsException(e);
        }
    }

    final boolean isOpen() {
        return this.state == State.Open || this.state == State.Opening || this.state == State.Failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close(boolean preserveChannelJoins) {
        if (this.state == null || this.state == State.Opening || this.state == State.Open || this.state == State.Failed) {
            this.state = State.Closing;
            if (this.eventHandlingThread != 0L) {
                StoreSenderReceiver storeSenderReceiver = this;
                synchronized (storeSenderReceiver) {
                    if (this.eventHandlingThread != 0L) {
                        this.closeContext.set(true, preserveChannelJoins);
                    } else {
                        this.closeContext.set(false, preserveChannelJoins);
                    }
                }
            } else {
                this.closeContext.set(false, preserveChannelJoins);
            }
            if (!this.closeContext.closeByEventHandler) {
                this.closeCore(this.closeContext.preserveChannelJoins);
            }
        }
    }

    @Override
    protected final void doFail(Exception cause) {
        this.state = State.Failed;
        this.onFailure(cause);
        ErrorHandler errorHandler = this.errorHandler;
        if (errorHandler != null) {
            errorHandler.onError(cause);
        }
    }

    @Override
    protected final String tracePrefix() {
        if (this.descriptor != null) {
            return this.descriptor.getRole() == IStoreBinding.InterClusterReplicationRole.Sender ? "[StoreSender->'" + this.getName() + "'] " : "[StoreReceiver->'" + this.getName() + "'] ";
        }
        return "[StoreSenderReceiver->'?'] ";
    }

    protected abstract void onMessageEvent(MessageEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onEvent(Event event) {
        this.eventHandlingThread = Thread.currentThread().getId();
        try {
            if (this.state == State.Open || this.state == State.Opening) {
                switch (event.getType()) {
                    case 105: {
                        this.onMessageEvent((MessageEvent)event);
                        return;
                    }
                    case 104: {
                        return;
                    }
                    case 102: {
                        this.doFail(((MessageBusBindingFailedEvent)event).getCause());
                        return;
                    }
                }
                return;
            }
            switch (event.getType()) {
                case 105: {
                    this.tracer.log("Received ICR Message while in " + (Object)((Object)this.state), Tracer.Level.WARNING);
                    event.acquire();
                    return;
                }
            }
            return;
        }
        finally {
            StoreSenderReceiver storeSenderReceiver = this;
            synchronized (storeSenderReceiver) {
                this.eventHandlingThread = 0L;
                if (this.closeContext.closeByEventHandler) {
                    this.closeCore(this.closeContext.preserveChannelJoins);
                }
            }
        }
    }

    public static interface ErrorHandler {
        public void onError(Exception var1);
    }

    protected static enum State {
        Open,
        Opening,
        Failed,
        Closing,
        Closed;

    }

    private class CloseContext {
        boolean closeByEventHandler;
        boolean preserveChannelJoins;

        private CloseContext() {
        }

        final void set(boolean closeByEventHandler, boolean preserveChannelJoins) {
            this.closeByEventHandler = closeByEventHandler;
            this.preserveChannelJoins = preserveChannelJoins;
        }
    }
}

