/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.StoreInterClusterReplicatorDescriptor;
import com.neeve.ods.impl.StoreSenderReceiver;
import com.neeve.pkt.PktPacket;
import com.neeve.sma.event.MessageEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public final class StoreReceiver
extends StoreSenderReceiver {
    private static final AtomicInteger counter = new AtomicInteger();
    private final StoreCommitEntry commitEntry = StoreCommitEntry.create();
    private final UnackedEvents unackedEvents = new UnackedEvents();
    private final StoreCommitEntryHandler entryHandler;

    private StoreReceiver(String storeName, StoreInterClusterReplicatorDescriptor descriptor, StoreCommitEntryHandler entryHandler) throws OdsException {
        super("ICR-Receiver-" + storeName + "-" + counter.incrementAndGet(), storeName, descriptor);
        this.entryHandler = entryHandler;
    }

    private final boolean onMessage(PktPacket packet) throws Exception {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Received packet " + packet + "...", Tracer.Level.DEBUG);
        }
        packet.acquire();
        if (!this.depacketize(packet, this.commitEntry)) {
            throw new InternalError("Recieved 'packet not for dispatch' error code for packet received via ICR!");
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Dispatching for processing...", Tracer.Level.DEBUG);
        }
        this.entryHandler.onEntry(this.commitEntry);
        return this.commitEntry.commitEnd;
    }

    public static final StoreReceiver create(String storeName, StoreInterClusterReplicatorDescriptor descriptor, StoreCommitEntryHandler entryHandler) throws OdsException {
        if (storeName == null) {
            throw new IllegalArgumentException("store name cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        if (entryHandler == null) {
            throw new IllegalArgumentException("store commit entry handler cannot be null");
        }
        return new StoreReceiver(storeName, descriptor, entryHandler);
    }

    @Override
    protected final void doWritePersisterMetadata(IOElasticBuffer metadata, int metadataOffset) throws Exception {
        throw new InternalError("doWritePersisterMetadata() called for an ICR receiver");
    }

    @Override
    protected final void doWrite(PktPacket packet) {
        throw new InternalError("doWrite() called for an ICR receiver");
    }

    @Override
    protected final boolean hasBufferedDataToFlush() {
        throw new InternalError("hasBufferedDataToFlush() called for an ICR receiver");
    }

    @Override
    protected final void doFlush(boolean sync) {
        throw new InternalError("doFlush() called for an ICR receiver");
    }

    @Override
    protected final void onMessageEvent(MessageEvent messageEvent) {
        block6: {
            this.unackedEvents.append(messageEvent);
            Object object = messageEvent.getMessageView().getMessage();
            if (object instanceof PktPacket) {
                try {
                    if (this.onMessage((PktPacket)object)) {
                        this.unackedEvents.ack();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (e instanceof Error) {
                        this.doFail(new RuntimeException(e));
                        break block6;
                    }
                    this.doFail((Exception)e);
                }
            } else {
                this.doFail(new Exception("received invalid message [contained message is not a packet]"));
            }
        }
    }

    public static interface StoreCommitEntryHandler {
        public void onEntry(StoreCommitEntry var1);
    }

    private final class UnackedEvents {
        private MessageEvent[] array;
        private int size;

        private UnackedEvents() {
        }

        final void append(MessageEvent event) {
            if (this.array == null) {
                this.array = new MessageEvent[256];
            }
            if (this.size == this.array.length) {
                this.array = Arrays.copyOf(this.array, this.array.length * 2);
            }
            event.setAutoAck(false);
            this.array[this.size++] = (MessageEvent)event.acquire();
        }

        final MessageEvent[] array() {
            return this.array;
        }

        final int count() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void ack() {
            for (int i = 0; i < this.size && StoreReceiver.this.state == StoreSenderReceiver.State.Open; ++i) {
                MessageEvent eventToAck = this.array[i];
                try {
                    eventToAck.getAcknowledger().ack();
                    continue;
                }
                catch (Throwable e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Error during acknowledging processing of an ICR message [" + e.toString() + "].\n");
                    sb.append("Message:\n");
                    sb.append(eventToAck.getMessageView().getMessage().toString()).append("\n");
                    sb.append("Stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    StoreReceiver.this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    continue;
                }
                finally {
                    eventToAck.dispose();
                }
            }
            this.clear();
        }

        final void clear() {
            this.size = 0;
        }
    }
}

