/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.eaio.uuid.UUID;
import com.google.common.base.Strings;
import com.neeve.config.Config;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreBindingFailedEvent;
import com.neeve.ods.IStoreBindingStats;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.IStoreCommitCompletionEvent;
import com.neeve.ods.IStoreEvent;
import com.neeve.ods.IStoreEventHandler;
import com.neeve.ods.IStoreField;
import com.neeve.ods.IStoreIndex;
import com.neeve.ods.IStoreMember;
import com.neeve.ods.IStoreMemberControlEvent;
import com.neeve.ods.IStoreNonUniqueIndex;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.IStoreQueryEngine;
import com.neeve.ods.IStoreQueryRepository;
import com.neeve.ods.IStoreReader;
import com.neeve.ods.IStoreReplicatorNotificationHandler;
import com.neeve.ods.IStoreSender;
import com.neeve.ods.IStoreTransactionLog;
import com.neeve.ods.IStoreUniqueIndex;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsExpectationNotMetException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.OdsPartialInitException;
import com.neeve.ods.OdsReferentialIntegrityException;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreInterClusterReplicatorDescriptor;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StorePersisterFactory;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.ods.impl.StoreBindingFailedEvent;
import com.neeve.ods.impl.StoreBindingRoleChangedEvent;
import com.neeve.ods.impl.StoreBindingStats;
import com.neeve.ods.impl.StoreCommitCompletionEvent;
import com.neeve.ods.impl.StoreCommitCompletionStatus;
import com.neeve.ods.impl.StoreEvent;
import com.neeve.ods.impl.StoreIndexBase;
import com.neeve.ods.impl.StoreLifecycleEvent;
import com.neeve.ods.impl.StoreMemberConnectReplyEvent;
import com.neeve.ods.impl.StoreMemberConnectRequestEvent;
import com.neeve.ods.impl.StoreMemberDownEvent;
import com.neeve.ods.impl.StoreMemberFoundEvent;
import com.neeve.ods.impl.StoreMemberHandshakeBackupHelloEvent;
import com.neeve.ods.impl.StoreMemberHandshakePrimaryHelloEvent;
import com.neeve.ods.impl.StoreMemberHandshakeStartReadyEvent;
import com.neeve.ods.impl.StoreMemberInitCompleteEvent;
import com.neeve.ods.impl.StoreMemberInitReadyEvent;
import com.neeve.ods.impl.StoreMemberLostEvent;
import com.neeve.ods.impl.StoreMemberReplicationStatus;
import com.neeve.ods.impl.StoreMemberTableOpenWaitCompletionEvent;
import com.neeve.ods.impl.StoreMemberUpEvent;
import com.neeve.ods.impl.StoreNonUniqueIndexImpl;
import com.neeve.ods.impl.StoreObjectAddedEvent;
import com.neeve.ods.impl.StoreObjectReceivedEvent;
import com.neeve.ods.impl.StoreObjectRemovedEvent;
import com.neeve.ods.impl.StoreObjectUpdatedEvent;
import com.neeve.ods.impl.StoreQueryEngineImpl;
import com.neeve.ods.impl.StoreQueryRepositoryImpl;
import com.neeve.ods.impl.StoreReceiver;
import com.neeve.ods.impl.StoreReplicator;
import com.neeve.ods.impl.StoreSender;
import com.neeve.ods.impl.StoreSenderReceiver;
import com.neeve.ods.impl.StoreTransactionLog;
import com.neeve.ods.impl.StoreTransactionLogRepairedEvent;
import com.neeve.ods.impl.StoreUniqueIndexImpl;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.query.IQueryAPICallerContext;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxNonUniqueIndex;
import com.neeve.query.index.IdxUniqueIndex;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlLinkedHashMap;
import com.neeve.util.UtlList;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import com.neeve.util.UtlUnit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class StoreBindingImpl
extends OdsObject
implements IStoreBinding {
    private final int serialNo;
    private final String memberName;
    private final StoreDescriptor descriptor;
    private final Map<UUID, IStoreObject> objects;
    private final StoreTransactionLog txnlog;
    private final StoreReplicator replicator;
    private final IStorePersister persister;
    private final MemberInitializer memberInitializer;
    private final Object openCompletionNotifier;
    private final boolean eventSourcing;
    private final StoreSender sender;
    private final StoreReceiver receiver;
    private final IStoreMember standaloneMember;
    private final IStoreQueryEngine queryEngine;
    private final StoreQueryRepositoryImpl queryRepository;
    private final IStoreCheckpointingController checkpointingController;
    private final StoreCommitEntry commitEntry;
    private final StoreCommitEntryProcessor commitEntryProcessor;
    private final StoreQueryAPIManager queryAPIManager;
    private final Tracer evTracer;
    private final boolean duplicateChecking;
    private final boolean disposeOnRemove;
    private IStoreEventHandler eventHandler;
    private IStoreBinding.Role startupRoleExpectation;
    private IStorePersister.LogEmptinessExpectation startupLogEmptinessExpectation;
    private InitializationState initializationState;
    private Exception openException;
    private Syncer syncer;
    private long lastPersisterSyncTime;
    private long lastSenderSyncTime;
    private int memberCount;
    private volatile IStoreBinding.State state;
    private boolean treatNonFatalInitRIErrorsAsFatal;
    private long checkpointVersion;
    private volatile IStoreBinding.Role role;
    private long lastCommittedTransactionId;
    private long lastDataSizeLimitWarning = 0L;
    final StoreBindingStats stats;
    final boolean recordLegLatencies;
    private static AtomicInteger serialNoGenerator = new AtomicInteger();

    private StoreBindingImpl(String memberName, StoreDescriptor descriptor, IStoreEventHandler eventHandler, IStoreReplicatorNotificationHandler replicatorNotificationHandler, int flags) throws OdsException {
        super(null);
        StorePersisterDescriptor persisterDescriptor;
        this.descriptor = descriptor;
        this.eventHandler = eventHandler;
        this.evTracer = Tracer.get((String)"nv.ods.event");
        this.recordLegLatencies = descriptor.getRecordLegLatencies();
        this.eventSourcing = (flags & 1) == 1;
        this.serialNo = serialNoGenerator.incrementAndGet();
        this.objects = new UtlLinkedHashMap();
        this.duplicateChecking = Config.getValue((String)"nv.ods.duplicate.checking", (boolean)true);
        this.disposeOnRemove = Config.getValue((String)"nv.ods.disposeonremove", (boolean)true);
        this.treatNonFatalInitRIErrorsAsFatal = Config.getValue((String)"nv.ods.init.treatnonfatalriasfatal", (boolean)true);
        this.replicator = descriptor.getReplicator() != null ? StoreReplicator.create(this, StoreReplicatorDescriptor.load(descriptor.getReplicator()), replicatorNotificationHandler) : null;
        this.memberName = String.format("%03d,%s", this.replicator != null ? this.replicator.getMemberElectionPriority() : (short)0, memberName);
        this.txnlog = new StoreTransactionLog(descriptor.getName() + "." + this.memberName + "." + this.serialNo);
        StorePersisterDescriptor storePersisterDescriptor = persisterDescriptor = descriptor.getPersister() != null ? StorePersisterDescriptor.load(descriptor.getPersister()) : null;
        if (descriptor.getInterClusterReplicator() != null) {
            StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.load(descriptor.getInterClusterReplicator());
            switch (icrDescriptor.getRole()) {
                case Sender: {
                    this.sender = StoreSender.create(this.getStoreName(), icrDescriptor);
                    this.sender.setErrorHandler(new SenderReceiverErrorHandler());
                    this.receiver = null;
                    this.standaloneMember = this.isStandalone() ? new StandaloneMember() : null;
                    break;
                }
                case StandaloneReceiver: {
                    if (!this.isStandalone()) {
                        throw new IllegalStateException("store cannot be configured both as clustered and a standalone ICR receiver");
                    }
                    if (persisterDescriptor != null) {
                        if (persisterDescriptor.getProperty("detachedPersist") != null && persisterDescriptor.getProperty("detachedPersist").equalsIgnoreCase("true") || persisterDescriptor.getProperty("detachedSend") != null && persisterDescriptor.getProperty("detachedSend").equalsIgnoreCase("true") || persisterDescriptor.getProperty("detachedWrite") != null && persisterDescriptor.getProperty("detachedWrite").equalsIgnoreCase("true")) {
                            this.tracer.log(this.getTracePrefix("B") + "*** DETACHED PERSIST IS NOT SUPPORTED FOR AN ICR STANDALONERECEIVER ... DISABLING DETACHED PERSISTENCE ***", Tracer.Level.WARNING);
                        }
                        if (persisterDescriptor.getProperty("flushOnCommit") == null || persisterDescriptor.getProperty("flushOnCommit").equalsIgnoreCase("false")) {
                            this.tracer.log(this.getTracePrefix("B") + "*** FLUSH ON COMMIT IS MANDATORY FOR AN ICR STANDALONERECEIVER ... ENALING FLUSH ON COMMIT ***.", Tracer.Level.WARNING);
                        }
                        persisterDescriptor.setProperty("detachedPersist", "false");
                        persisterDescriptor.setProperty("flushOnCommit", "true");
                        persisterDescriptor.save();
                    }
                    this.sender = null;
                    this.receiver = StoreReceiver.create(this.getStoreName(), icrDescriptor, new ReceiverCommitEntryHandler());
                    this.receiver.setErrorHandler(new SenderReceiverErrorHandler());
                    this.standaloneMember = new StandaloneMember();
                    break;
                }
                default: {
                    throw new OdsException("unknown ICR role '" + (Object)((Object)icrDescriptor.getRole()) + "'");
                }
            }
        } else {
            this.sender = null;
            this.receiver = null;
            IStoreMember iStoreMember = this.standaloneMember = this.isStandalone() ? new StandaloneMember() : null;
        }
        if (persisterDescriptor != null && persisterDescriptor.getProperty("recordLegLatencies") == null) {
            persisterDescriptor.setProperty("recordLegLatencies", this.descriptor.getRecordLegLatencies() ? "true" : "false");
        }
        IStorePersister iStorePersister = this.persister = persisterDescriptor != null ? StorePersisterFactory.getInstance().createPersister(persisterDescriptor) : null;
        if (this.persister != null) {
            this.persister.setErrorHandler(new PersisterErrorHandler());
            this.persister.setEventHandler(new PersisterEventHandler());
        }
        this.memberInitializer = new MemberInitializer();
        if (descriptor.getCheckpointingType() != null) {
            switch (descriptor.getCheckpointingType()) {
                case Default: {
                    this.checkpointingController = new StoreCheckpointControllerDefault(descriptor);
                    break;
                }
                case CDC: {
                    this.checkpointingController = new StoreCheckpointControllerCDC(descriptor);
                    break;
                }
                case Conflation: {
                    this.checkpointingController = new StoreCheckpointControllerConflation(descriptor);
                    break;
                }
                default: {
                    this.checkpointingController = null;
                }
            }
            if (this.checkpointingController != null) {
                this.tracer.log(this.getTracePrefix("B") + "Checkpointing enabled: " + this.checkpointingController.toString(), Tracer.Level.INFO);
            }
        } else {
            this.checkpointingController = null;
        }
        this.commitEntry = StoreCommitEntry.create();
        this.commitEntryProcessor = new StoreCommitEntryProcessor();
        this.queryAPIManager = new StoreQueryAPIManager();
        this.openCompletionNotifier = new Object();
        this.initializationState = InitializationState.NotStarted;
        this.stats = new StoreBindingStats(this, this.descriptor.getName(), "nv.ods.stats.interval");
        if (descriptor.isQueryable()) {
            this.queryEngine = new StoreQueryEngineImpl();
            this.queryRepository = new StoreQueryRepositoryImpl(this);
            this.queryEngine.addRepository(this.queryRepository, this.getStoreName());
        } else {
            this.queryEngine = null;
            this.queryRepository = null;
        }
    }

    public static final IStoreBinding create(String memberName, StoreDescriptor descriptor, IStoreEventHandler eventHandler, IStoreReplicatorNotificationHandler replicatorNotificationHandler, Integer flags) throws OdsException {
        return new StoreBindingImpl(memberName, descriptor, eventHandler, replicatorNotificationHandler, flags == null ? 0 : flags);
    }

    private final IllegalStateException prepareStateValidationErrorException() {
        if (this.state == null) {
            return new IllegalStateException("binding has not been opened");
        }
        switch (this.state) {
            case Opening: {
                return new IllegalStateException("binding is opening");
            }
            case Open: {
                return new IllegalStateException("binding is open");
            }
            case Failed: {
                return new IllegalStateException("binding has failed");
            }
            case Closed: {
                return new IllegalStateException("binding is closed");
            }
        }
        throw new InternalError("Unknown state!!");
    }

    private final String prepareCommitEntryDiagnosticString(UUID id, short ofid, short otype, long transactionId, long stableTransactionId, long checkpointVersion, IStoreObject.EncodingType contentEncodingType, PktPacket serializedObject, IOElasticBuffer serializedMetadata, int serializedMetadataOffset, boolean commitEnd) {
        StringBuilder sb = new StringBuilder();
        try {
            IStoreObjectFactory factory;
            sb.append("\n          id: ").append(id);
            sb.append("\n        ofid: ").append(ofid);
            sb.append("\n       otype: ").append(otype);
            sb.append("\n       txnid: ").append(transactionId);
            sb.append("\n    sbltxnid: ").append(stableTransactionId);
            sb.append("\n    chkpoint: ").append(checkpointVersion);
            sb.append("\n    encoding: ").append((Object)contentEncodingType);
            sb.append("\n   commitEnd: ").append(commitEnd);
            sb.append("\n     payload: ").append(serializedObject);
            if (serializedObject != null && serializedObject.getBody() != null) {
                sb.append("\n            : ").append(serializedObject.getBody().dump("body"));
            }
            sb.append("\n    metadata: ").append(serializedMetadata);
            if (serializedMetadata != null) {
                sb.append("\n              ").append(serializedMetadata.dump("bytes", serializedMetadataOffset, serializedMetadata.getLength()));
            }
            if ((factory = StoreObjectFactoryRegistry.getInstance().getObjectFactory(ofid)) != null) {
                try {
                    IStoreObject object = factory.create(otype, id, contentEncodingType, serializedObject);
                    object.deserializeMetadata(serializedMetadata, serializedMetadataOffset);
                    object.setCheckpointVersion(checkpointVersion);
                    object.setStableTransactionId(stableTransactionId);
                    object.setTransactionId(transactionId);
                    sb.append("\n      object: ").append(object);
                }
                catch (Exception e) {
                    sb.append("\n      object: ").append("Deserialization Error: '" + e.toString() + "'");
                }
            } else {
                sb.append("\n    object: ").append("Factory could not be found");
            }
        }
        catch (Throwable thrown) {
            sb.append("... error dumping entry [" + thrown.getMessage() + "]");
        }
        return sb.toString();
    }

    private final void setStartupExpectations(Map<IStoreBinding.StartupExpectation, Enum<?>> expectations) {
        if (expectations != null) {
            for (IStoreBinding.StartupExpectation expectation : expectations.keySet()) {
                Enum<?> value = expectations.get((Object)expectation);
                switch (expectation) {
                    case Role: {
                        if (value instanceof IStoreBinding.Role) {
                            this.startupRoleExpectation = (IStoreBinding.Role)value;
                            break;
                        }
                        throw new IllegalArgumentException("role expectation must of type IStoreBinding.Role");
                    }
                    case LogEmptiness: {
                        if (value instanceof IStorePersister.LogEmptinessExpectation) {
                            this.startupLogEmptinessExpectation = (IStorePersister.LogEmptinessExpectation)value;
                            break;
                        }
                        throw new IllegalArgumentException("checkpoint expectation must of type IStorePersister.LogEmptinessExpectation");
                    }
                }
            }
        }
    }

    private final void setPersisterExpectations() {
        this.persister.setStartupExpectation(IStorePersister.StartupExpectation.LogEmptiness, this.startupLogEmptinessExpectation);
    }

    private final boolean isStandaloneReceiver() {
        return this.receiver != null && this.receiver.getDescriptor().getRole() == IStoreBinding.InterClusterReplicationRole.StandaloneReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitForBindingToOpen() {
        if (this.state == IStoreBinding.State.Opening) {
            Object object = this.openCompletionNotifier;
            synchronized (object) {
                while (this.state == IStoreBinding.State.Opening) {
                    try {
                        this.openCompletionNotifier.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private final boolean isDuplicate(long transactionId) {
        boolean isDuplicate;
        boolean bl = isDuplicate = transactionId > 0L && transactionId <= this.lastCommittedTransactionId;
        if (isDuplicate && !this.duplicateChecking) {
            this.tracer.log(this.getTracePrefix("B") + "Detected duplicate transaction #" + transactionId + ". Ignoring since duplicate checking is disabled...", Tracer.Level.WARNING);
        }
        return isDuplicate && this.duplicateChecking;
    }

    private final void checkAndUpdateCheckpointVersion(long val) {
        if (this.checkpointingController != null && this.checkpointVersion < val) {
            this.checkpointVersion = val;
            if (this.checkpointingController != null) {
                this.checkpointingController.onVersionChange();
            }
            if ((this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) && this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "Updated to checkpoint #" + this.checkpointVersion + " at commit of transaction #" + this.lastCommittedTransactionId, Tracer.Level.DEBUG);
            }
        }
    }

    private final void incrementCheckpointVersion() {
        this.checkAndUpdateCheckpointVersion(this.checkpointVersion + 1L);
    }

    private final IStoreObject onObjectPut(UUID id, short ofid, short otype, long transactionId, long stableTransactionId, long checkpointVersion, IStoreObject.EncodingType contentEncodingType, PktPacket serializedObject, IOElasticBuffer serializedMetadata, int serializedMetadataOffset, boolean commitEnd) {
        try {
            IStoreObjectFactory factory;
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "...entry is a PUT. Adding new object to store (ofid=" + ofid + ", otype=" + otype + ", id=" + id + ")...", Tracer.Level.DEBUG);
            }
            if ((factory = StoreObjectFactoryRegistry.getInstance().getObjectFactory(ofid)) != null) {
                serializedObject.acquire();
                IStoreObject object = factory.create(otype, id, contentEncodingType, serializedObject);
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "......object is '" + object.getClass().getSimpleName() + "'.", Tracer.Level.DEBUG);
                }
                if (this.isDuplicate(transactionId)) {
                    this.tracer.log(this.getTracePrefix("B") + "Duplicate object PUT (object=" + object.getClass().getSimpleName() + ", transactionId=" + transactionId + ", lastCommittedTransactionId=" + this.lastCommittedTransactionId + "). Discarding...", this.isStandaloneReceiver() ? Tracer.Level.VERBOSE : Tracer.Level.WARNING);
                    object.dispose();
                    return null;
                }
                object.deserializeMetadata(serializedMetadata, serializedMetadataOffset);
                object.setCheckpointVersion(checkpointVersion);
                object.setStableTransactionId(stableTransactionId);
                object.setTransactionId(transactionId);
                object.setBinding(this);
                object.acquire();
                this.objects.put(object.getOid(), object);
                if (this.checkpointingController != null) {
                    this.checkpointingController.onPut();
                }
                if (this.queryRepository != null) {
                    this.queryRepository.onPut(object);
                }
                int dataSize = serializedObject.getBody().getSerializedLength();
                object.getStoreMetadata().setCommittedDataSize(dataSize);
                this.stats.storeDataSize += (long)dataSize;
                if (commitEnd) {
                    this.checkAndUpdateCheckpointVersion(checkpointVersion);
                    this.lastCommittedTransactionId = transactionId;
                }
                return object;
            }
            String diagnosticStr = this.prepareCommitEntryDiagnosticString(id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, contentEncodingType, serializedObject, serializedMetadata, serializedMetadataOffset, commitEnd);
            this.tracer.log(this.getTracePrefix("B") + "Unable to add replicated/materialized object to store [Cannot find object factory (id=" + ofid + ")]" + diagnosticStr, Tracer.Level.SEVERE);
            throw new RuntimeException("cannot find object factory to deserialize put object (id=" + ofid + ")");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private final IStoreObject onObjectUpdate(UUID id, short ofid, short otype, long transactionId, long stableTransactionId, long checkpointVersion, IStoreObject.EncodingType contentEncodingType, PktPacket serializedObject, IOElasticBuffer serializedMetadata, int serializedMetadataOffset, boolean commitEnd) {
        try {
            IStoreObject object;
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "...entry is an UPDATE. Updating existing object in store (id=" + id + ")...", Tracer.Level.DEBUG);
            }
            if ((object = this.objects.get(id)) != null) {
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "......object is '" + object.getClass().getSimpleName() + "'.", Tracer.Level.DEBUG);
                }
                if (this.isDuplicate(transactionId)) {
                    this.tracer.log(this.getTracePrefix("B") + "Duplicate object UPDATE (object=" + object.getClass().getSimpleName() + ", transactionId=" + transactionId + ", lastCommittedTransactionId=" + this.lastCommittedTransactionId + "). Discarding...", this.isStandaloneReceiver() ? Tracer.Level.VERBOSE : Tracer.Level.WARNING);
                    return null;
                }
                if (this.queryRepository != null) {
                    this.queryRepository.onRemove(object);
                }
                object.deserializeMetadata(serializedMetadata, serializedMetadataOffset);
                object.setCheckpointVersion(checkpointVersion);
                object.setStableTransactionId(stableTransactionId);
                object.setTransactionId(transactionId);
                serializedObject.acquire();
                object.deserialize(serializedObject);
                object.acquire();
                if (this.queryRepository != null) {
                    this.queryRepository.onPut(object);
                }
                if (this.checkpointingController != null) {
                    this.checkpointingController.onUpdate();
                }
                int previousDataSize = object.getStoreMetadata().getCommittedDataSize();
                int dataSize = serializedObject.getBody().getSerializedLength();
                object.getStoreMetadata().setCommittedDataSize(dataSize);
                this.stats.storeDataSize += (long)(dataSize - previousDataSize);
                if (commitEnd) {
                    this.checkAndUpdateCheckpointVersion(checkpointVersion);
                    this.lastCommittedTransactionId = transactionId;
                }
                return object;
            }
            String diagnosticStr = this.prepareCommitEntryDiagnosticString(id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, contentEncodingType, serializedObject, serializedMetadata, serializedMetadataOffset, commitEnd);
            this.tracer.log(this.getTracePrefix("B") + "Unable to apply replicated/materialized update to object [Cannot find object (id=" + id + ")]" + diagnosticStr, Tracer.Level.SEVERE);
            throw new OdsReferentialIntegrityException("cannot find object to update (id=" + id + ")", true);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private final IStoreObject onObjectReceive(UUID id, short ofid, short otype, long transactionId, long stableTransactionId, long checkpointVersion, IStoreObject.EncodingType contentEncodingType, PktPacket serializedObject, IOElasticBuffer serializedMetadata, int serializedMetadataOffset, boolean commitEnd) {
        try {
            IStoreObjectFactory factory;
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "...entry is a SEND. Processing (ofid=" + ofid + ", otype=" + otype + ", id=" + id + ")...", Tracer.Level.DEBUG);
            }
            if ((factory = StoreObjectFactoryRegistry.getInstance().getObjectFactory(ofid)) != null) {
                serializedObject.acquire();
                IStoreObject object = factory.create(otype, id, contentEncodingType, serializedObject);
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "......object is '" + object.getClass().getSimpleName() + "'.", Tracer.Level.DEBUG);
                }
                if (this.isDuplicate(transactionId)) {
                    this.tracer.log(this.getTracePrefix("B") + "Duplicate object RECEIVE (object=" + object.getClass().getSimpleName() + ", transactionId=" + transactionId + ", lastCommittedTransactionId=" + this.lastCommittedTransactionId + "). Discarding...", this.isStandaloneReceiver() ? Tracer.Level.VERBOSE : Tracer.Level.WARNING);
                    object.dispose();
                    return null;
                }
                object.deserializeMetadata(serializedMetadata, serializedMetadataOffset);
                object.setCheckpointVersion(checkpointVersion);
                object.setStableTransactionId(stableTransactionId);
                object.setTransactionId(transactionId);
                if (this.checkpointingController != null) {
                    this.checkpointingController.onSend();
                }
                if (commitEnd) {
                    this.checkAndUpdateCheckpointVersion(checkpointVersion);
                    this.lastCommittedTransactionId = transactionId;
                }
                return object;
            }
            String diagnosticStr = this.prepareCommitEntryDiagnosticString(id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, contentEncodingType, serializedObject, serializedMetadata, serializedMetadataOffset, commitEnd);
            this.tracer.log(this.getTracePrefix("B") + "Unable to instantiate message object [Cannot find object factory (id=" + ofid + ")]" + diagnosticStr, Tracer.Level.SEVERE);
            throw new RuntimeException("cannot find object factory for deserializing received object (id=" + ofid + ")");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private final IStoreObject onObjectRemove(UUID id, short ofid, short otype, long transactionId, long stableTransactionId, long checkpointVersion, IStoreObject.EncodingType contentEncodingType, PktPacket serializedObject, IOElasticBuffer serializedMetadata, int serializedMetadataOffset, boolean commitEnd) {
        try {
            IStoreObject object;
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "...entry is a REMOVE. Removing object from store (id=" + id + ")...", Tracer.Level.DEBUG);
            }
            if ((object = this.objects.get(id)) != null) {
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "......object is '" + object.getClass().getSimpleName() + "'.", Tracer.Level.DEBUG);
                }
                if (this.isDuplicate(transactionId)) {
                    this.tracer.log(this.getTracePrefix("B") + "Duplicate object REMOVE (object=" + object.getClass().getSimpleName() + ", transactionId=" + transactionId + ", lastCommittedTransactionId=" + this.lastCommittedTransactionId + "). Discarding...", this.isStandaloneReceiver() ? Tracer.Level.VERBOSE : Tracer.Level.WARNING);
                    return null;
                }
                if (this.queryRepository != null) {
                    this.queryRepository.onRemove(object);
                }
                object.deserializeMetadata(serializedMetadata, serializedMetadataOffset);
                object.setCheckpointVersion(checkpointVersion);
                object.setStableTransactionId(stableTransactionId);
                object.setTransactionId(transactionId);
                object.setBinding(null);
                this.objects.remove(object.getOid());
                int previousDataSize = object.getStoreMetadata().getCommittedDataSize();
                object.getStoreMetadata().setCommittedDataSize(0);
                this.stats.storeDataSize -= (long)previousDataSize;
                if (this.checkpointingController != null) {
                    this.checkpointingController.onRemove();
                }
                if (commitEnd) {
                    this.checkAndUpdateCheckpointVersion(checkpointVersion);
                    this.lastCommittedTransactionId = transactionId;
                }
                return object;
            }
            String diagnosticStr = this.prepareCommitEntryDiagnosticString(id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, contentEncodingType, serializedObject, serializedMetadata, serializedMetadataOffset, commitEnd);
            this.tracer.log(this.getTracePrefix("B") + "Unable to remove replicated/materialized object from store [Cannot find object (id=" + id + ")]\n" + diagnosticStr, Tracer.Level.SEVERE);
            throw new OdsReferentialIntegrityException("cannot find object to remove (id=" + id + ")", false);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private final IStoreObject onInitCommitOrRead(StoreCommitEntry commitEntry) {
        IStoreObject object;
        switch (commitEntry.operation) {
            case Put: {
                object = this.onObjectPut(commitEntry.oid, commitEntry.ofid, commitEntry.otype, commitEntry.transactionId, commitEntry.stableTransactionId, commitEntry.checkpointVersion, commitEntry.contentEncodingType, commitEntry.serializedObject, commitEntry.serializedMetadata, commitEntry.serializedMetadataOffset, commitEntry.commitEnd);
                if (object == null) break;
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "...dispatching PUT event to application...", Tracer.Level.DEBUG);
                }
                this.onEvent(StoreObjectAddedEvent.create(this, object, commitEntry.transactionId, commitEntry.stableTransactionId, commitEntry.commitEnd));
                break;
            }
            case Update: {
                object = this.onObjectUpdate(commitEntry.oid, commitEntry.ofid, commitEntry.otype, commitEntry.transactionId, commitEntry.stableTransactionId, commitEntry.checkpointVersion, commitEntry.contentEncodingType, commitEntry.serializedObject, commitEntry.serializedMetadata, commitEntry.serializedMetadataOffset, commitEntry.commitEnd);
                if (object == null) break;
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "...dispatching UPDATE event to application...", Tracer.Level.DEBUG);
                }
                this.onEvent(StoreObjectUpdatedEvent.create(this, object, commitEntry.transactionId, commitEntry.stableTransactionId, commitEntry.commitEnd));
                break;
            }
            case Send: {
                object = this.onObjectReceive(commitEntry.oid, commitEntry.ofid, commitEntry.otype, commitEntry.transactionId, commitEntry.stableTransactionId, commitEntry.checkpointVersion, commitEntry.contentEncodingType, commitEntry.serializedObject, commitEntry.serializedMetadata, commitEntry.serializedMetadataOffset, commitEntry.commitEnd);
                if (object == null) break;
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "...dispatching RECEIVE event to application...", Tracer.Level.DEBUG);
                }
                this.onEvent(StoreObjectReceivedEvent.create(this, object, commitEntry.transactionId, commitEntry.stableTransactionId, commitEntry.commitEnd));
                break;
            }
            case Remove: {
                object = this.onObjectRemove(commitEntry.oid, commitEntry.ofid, commitEntry.otype, commitEntry.transactionId, commitEntry.stableTransactionId, commitEntry.checkpointVersion, commitEntry.contentEncodingType, commitEntry.serializedObject, commitEntry.serializedMetadata, commitEntry.serializedMetadataOffset, commitEntry.commitEnd);
                if (object == null) break;
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "...dispatching REMOVE event to application...", Tracer.Level.DEBUG);
                }
                this.onEvent(StoreObjectRemovedEvent.create(this, object, commitEntry.transactionId, commitEntry.stableTransactionId, commitEntry.commitEnd));
                break;
            }
            default: {
                throw new RuntimeException("unknown store operation [" + (Object)((Object)commitEntry.operation) + "]");
            }
        }
        return object;
    }

    private final IStoreObject onInitOrCommit(StoreCommitEntry commitEntry, long preDispatchTs) {
        IStoreObject object = this.onInitCommitOrRead(commitEntry);
        if (object != null) {
            long postDispatchTs;
            long l = postDispatchTs = this.recordLegLatencies ? UtlTime.now() : 0L;
            if (this.recordLegLatencies) {
                this.stats.d.add((double)(postDispatchTs - preDispatchTs));
            }
            this.writeCommitEntry(commitEntry, postDispatchTs);
        }
        return object;
    }

    private final void onCommitComplete(StoreCommitCompletionStatus completionStatus, long ackPostWireTs, long ackWireTime, long meanCommitEntryWireTime, boolean sync, boolean dispatch) {
        try {
            long preDispatchTs = this.recordLegLatencies ? UtlTime.now() : 0L;
            StoreCommitCompletionEvent completionEvent = (StoreCommitCompletionEvent)completionStatus.getCompletionEvent();
            boolean successfulCompletion = completionStatus.getFailedCount() == 0;
            long startTs = completionEvent.getStartTs();
            completionEvent.complete(sync);
            if (dispatch && this.state != IStoreBinding.State.Failed && completionEvent.getDispatch()) {
                this.onEvent(completionEvent, ExceptionHandlingPolicy.TrapAndDiscard);
            }
            ++this.stats.numCommitCompletionsReceived;
            if (successfulCompletion && this.recordLegLatencies) {
                long postDispatchTs = UtlTime.now();
                if (ackPostWireTs > 0L) {
                    this.stats.w.add((double)(meanCommitEntryWireTime + ackWireTime));
                }
                if (ackPostWireTs > 0L && preDispatchTs > 0L) {
                    this.stats.w2d.add((double)(preDispatchTs - ackPostWireTs));
                }
                if (preDispatchTs > 0L && postDispatchTs > 0L) {
                    this.stats.d.add((double)(postDispatchTs - preDispatchTs));
                }
                if (postDispatchTs > 0L && startTs > 0L) {
                    this.stats.c.add((double)(postDispatchTs - startTs));
                }
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    private final void syncPersister(boolean checkOpen) {
        if (this.persister != null) {
            if (checkOpen) {
                try {
                    if (!this.persister.isOpen()) {
                        return;
                    }
                }
                catch (Exception e) {
                    this.tracer.log(this.getTracePrefix("B") + "Error checking if persister is open: " + e.getMessage(), Tracer.Level.WARNING);
                }
            }
            this.persister.flush(true);
            this.lastPersisterSyncTime = System.currentTimeMillis();
        }
    }

    private final void syncSender(boolean checkOpen) {
        if (this.sender != null) {
            if (checkOpen) {
                try {
                    if (!this.sender.isOpen()) {
                        return;
                    }
                }
                catch (Exception e) {
                    this.tracer.log(this.getTracePrefix("B") + "Error checking if sender is open: " + e.getMessage(), Tracer.Level.WARNING);
                }
            }
            this.sender.flush(true);
            this.lastSenderSyncTime = System.currentTimeMillis();
        }
    }

    private final void writeCommitEntry(StoreCommitEntry commitEntry, long prePersistTs) {
        long postIdxTs;
        long postSendTs;
        long postPersistTs;
        boolean commitEnd = commitEntry.commitEnd;
        if (this.persister != null) {
            boolean sync = this.state != IStoreBinding.State.Opening && commitEnd && this.memberCount < this.descriptor.getPersistenceQuorum();
            this.persister.writeCommitEntry(commitEntry.serializedObject, sync);
            if (sync) {
                this.lastPersisterSyncTime = System.currentTimeMillis();
            }
        }
        long l = postPersistTs = this.recordLegLatencies && this.persister != null ? UtlTime.now() : prePersistTs;
        if (this.recordLegLatencies && this.persister != null) {
            this.stats.per.add((double)(postPersistTs - prePersistTs));
        }
        if (this.sender != null) {
            boolean sync = this.state != IStoreBinding.State.Opening && commitEnd && this.memberCount < this.descriptor.getInterClusterReplicationQuorum();
            this.sender.writeCommitEntry(commitEntry.serializedObject, sync);
            if (sync) {
                this.lastSenderSyncTime = System.currentTimeMillis();
            }
        }
        long l2 = postSendTs = this.recordLegLatencies && this.sender != null ? UtlTime.now() : postPersistTs;
        if (this.recordLegLatencies && this.sender != null) {
            this.stats.icr.add((double)(postSendTs - postPersistTs));
        }
        if (commitEnd && this.queryRepository != null) {
            this.queryRepository.commit();
        }
        long l3 = postIdxTs = this.recordLegLatencies && commitEnd && this.queryRepository != null ? UtlTime.now() : postSendTs;
        if (this.recordLegLatencies && commitEnd && this.queryRepository != null) {
            this.stats.idx.add((double)(postIdxTs - postSendTs));
        }
    }

    private final void handleExceptionByPolicy(Throwable e, ExceptionHandlingPolicy policy, StringBuilder sb) {
        switch (policy) {
            case PassThrough: {
                if (sb != null) {
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e)).append("");
                    sb.append("Rethrowing...");
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw (RuntimeException)e;
            }
            case TrapAndDiscard: {
                if (sb == null) break;
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e)).append("");
                sb.append("Ignoring...");
                break;
            }
            case TrapAndFail: {
                if (sb != null) {
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e)).append("");
                    sb.append("Failing...");
                }
                this.fail(e instanceof Error ? new OdsException(e) : (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleReferentialIntegrityError(OdsReferentialIntegrityException e, String str) {
        StringBuilder sb = new StringBuilder();
        sb.append(str + ":\n");
        boolean isFatal = this.treatNonFatalInitRIErrorsAsFatal || e.isFatal();
        try {
            if (isFatal) {
                throw e;
            }
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndDiscard, sb);
            this.tracer.log(this.getTracePrefix("B") + sb.toString(), isFatal ? Tracer.Level.SEVERE : Tracer.Level.WARNING);
        }
        catch (Throwable throwable) {
            this.tracer.log(this.getTracePrefix("B") + sb.toString(), isFatal ? Tracer.Level.SEVERE : Tracer.Level.WARNING);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onEvent(IStoreEvent event, ExceptionHandlingPolicy policy) {
        if ((this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open || this.state == IStoreBinding.State.Failed && event instanceof IStoreBindingFailedEvent) && this.eventHandler != null) {
            try {
                if (this.evTracer.debug) {
                    this.evTracer.log(this.getTracePrefix("B") + "<D> [" + event.getClass().getSimpleName() + "<" + event.getType() + ">]", Tracer.Level.DEBUG);
                }
                this.eventHandler.onEvent(event);
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("ODS store binding event handler [" + this.eventHandler + "] faulted with error [" + e.toString() + "] on event {" + event + "} with the following stack trace:\n");
                try {
                    this.handleExceptionByPolicy(e, policy, sb);
                }
                finally {
                    this.tracer.log(this.getTracePrefix("B") + sb.toString(), Tracer.Level.SEVERE);
                }
            }
            finally {
                event.dispose();
            }
        }
    }

    private final void onEvent(StoreEvent event) {
        this.onEvent(event, ExceptionHandlingPolicy.PassThrough);
    }

    final boolean isStandalone() {
        return this.replicator == null;
    }

    final StoreReplicator getReplicator() {
        return this.replicator;
    }

    final Iterator<IStoreObject> entries() {
        return this.objects.values().iterator();
    }

    final long getLastCommittedTransactionId() {
        return this.lastCommittedTransactionId;
    }

    final String getTracePrefix(String prefix) {
        return "[" + prefix + "->" + this.getStoreName() + "-" + this.getMemberName() + "] ";
    }

    final String getStoreName() {
        return this.isStandalone() ? this.descriptor.getName() : this.replicator.getStoreName();
    }

    final String getMemberName() {
        return this.memberName;
    }

    final void onMemberFound(IDiscoveryEntity member) {
        try {
            if (this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) {
                this.onEvent(StoreMemberFoundEvent.create(this, member));
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onMemberConnectRequest(IStoreMember member, String memberName, IStoreBinding.Role memberRole) {
        try {
            if (this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) {
                this.onEvent(StoreMemberConnectRequestEvent.create(this, member, memberName, memberRole));
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onMemberConnectReply(IStoreMember member, IStoreBinding.Role memberRole) {
        try {
            if (this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) {
                this.onEvent(StoreMemberConnectReplyEvent.create(this, member, memberRole));
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onMemberUp(IStoreMember member) {
        try {
            if (this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) {
                ++this.memberCount;
                this.onEvent(StoreMemberUpEvent.create(this, member), ExceptionHandlingPolicy.TrapAndDiscard);
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onMemberHandshakeStartReady(IStoreMember member) {
        try {
            if (this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) {
                this.onEvent(StoreMemberHandshakeStartReadyEvent.create(this, member));
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onMemberHandshakePrimaryHello(IStoreMember member, long lastCommittedTransactionId) {
        try {
            if (this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) {
                this.onEvent(StoreMemberHandshakePrimaryHelloEvent.create(this, member, lastCommittedTransactionId));
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onMemberHandshakeBackupHello(IStoreMember member, long lastCommittedTransactionId) {
        try {
            if (this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) {
                this.onEvent(StoreMemberHandshakeBackupHelloEvent.create(this, member, lastCommittedTransactionId));
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onMemberInitReady(IStoreMember member) {
        this.waitForBindingToOpen();
        try {
            if (this.state == IStoreBinding.State.Open) {
                this.onEvent(StoreMemberInitReadyEvent.create(this, member), ExceptionHandlingPolicy.PassThrough);
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    final void onRoleChange(IStoreBinding.Role role) {
        try {
            if (this.role == null && this.startupRoleExpectation != null && role != this.startupRoleExpectation) {
                throw new OdsExpectationNotMetException(IStoreBinding.StartupExpectation.Role, this.startupRoleExpectation, null, "mismatch startup role expectation (expected=" + (Object)this.startupRoleExpectation + ", actual=" + (Object)role + ")");
            }
            this.role = role;
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "Role changed to '" + (Object)role + "'....", Tracer.Level.DEBUG);
            }
            if (this.state == IStoreBinding.State.Opening && role == IStoreBinding.Role.Primary && this.initializationState == InitializationState.InProgress) {
                throw new OdsPartialInitException();
            }
            if (this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) {
                if (this.persister != null) {
                    if (role == IStoreBinding.Role.Primary) {
                        this.incrementCheckpointVersion();
                    }
                    this.persister.onRoleChange(role);
                    if (this.isStandalone() || role == IStoreBinding.Role.Primary && !this.persister.isOpen()) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.getTracePrefix("B") + "Opening persister....", Tracer.Level.DEBUG);
                        }
                        try {
                            this.setPersisterExpectations();
                            this.persister.open(this.descriptor.isDetachedMemberInitialization());
                            this.syncPersister(false);
                            if (!this.persister.wasRepaired()) ** GOTO lbl41
                            this.onEvent(StoreTransactionLogRepairedEvent.create(this), ExceptionHandlingPolicy.TrapAndDiscard);
                        }
                        catch (OdsExpectationNotMetException e) {
                            if (e.getUnmetExpectationType() == IStorePersister.StartupExpectation.LogEmptiness) {
                                oe = new OdsExpectationNotMetException(IStoreBinding.StartupExpectation.LogEmptiness, e.getUnmetExpectationValue(), e.getUnmetExpectationData(), e.getMessage());
                                oe.initCause(e);
                                throw oe;
                            }
                            throw e;
                        }
                    } else if (role == IStoreBinding.Role.Backup) {
                        if (this.persister.isShared()) {
                            if (this.tracer.debug) {
                                this.tracer.log(this.getTracePrefix("B") + "Not opening persister [member is backup and persister is shared]....", Tracer.Level.DEBUG);
                            }
                        } else if (this.tracer.debug) {
                            this.tracer.log(this.getTracePrefix("B") + "Not opening persister [member is backup and persister will be opened on receipt of init start]....", Tracer.Level.DEBUG);
                        }
                    } else if (this.tracer.debug) {
                        this.tracer.log(this.getTracePrefix("B") + "Not opening persister [member is primary but persister is already open (failover)]....", Tracer.Level.DEBUG);
                    }
                }
lbl41:
                // 9 sources

                if (this.queryRepository != null) {
                    this.queryRepository.open();
                }
                if (this.sender != null) {
                    this.sender.onRoleChange(role);
                    if (this.sender.isShared() && role == IStoreBinding.Role.Primary || !this.sender.isShared() && !this.sender.isOpen()) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.getTracePrefix("B") + "Opening ICR sender....", Tracer.Level.DEBUG);
                        }
                        this.sender.open();
                        this.syncSender(false);
                    } else if (this.sender.isShared()) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.getTracePrefix("B") + "Not opening ICR sender [sender is shared and member is backup]....", Tracer.Level.DEBUG);
                        }
                    } else if (this.tracer.debug) {
                        this.tracer.log(this.getTracePrefix("B") + "Not opening ICR sender [sender is dedicated but already open]....", Tracer.Level.DEBUG);
                    }
                }
                if (this.receiver != null) {
                    this.receiver.onRoleChange(role);
                    if (role == IStoreBinding.Role.Primary || this.isStandaloneReceiver()) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.getTracePrefix("B") + "Opening ICR receiver....", Tracer.Level.DEBUG);
                        }
                        this.receiver.open();
                    } else if (this.tracer.debug) {
                        this.tracer.log(this.getTracePrefix("B") + "Not opening ICR receiver [receiver is not standalone and member is backup]....", Tracer.Level.DEBUG);
                    }
                }
                if (this.state == IStoreBinding.State.Open) {
                    this.onEvent(StoreBindingRoleChangedEvent.create(this, role), ExceptionHandlingPolicy.TrapAndDiscard);
                }
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onInitStart(IStoreMember source, IOElasticBuffer persisterMetadata, int persisterMetadataOffset) {
        try {
            if (this.role == IStoreBinding.Role.Primary) {
                throw new InternalError("init handler invoked on a primary store binding!");
            }
            this.initializationState = InitializationState.InProgress;
            if (this.state == IStoreBinding.State.Opening) {
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "Received init start.", Tracer.Level.DEBUG);
                }
                if (this.persister != null && !this.persister.isShared()) {
                    if (this.tracer.debug) {
                        this.tracer.log(this.getTracePrefix("B") + "Opening persister....", Tracer.Level.DEBUG);
                    }
                    this.persister.open(persisterMetadata, persisterMetadataOffset, true, this.descriptor.isDetachedMemberInitialization());
                }
            } else if (this.state == IStoreBinding.State.Open || this.state == IStoreBinding.State.Closed) {
                throw new InternalError("Received an init start in the '" + (Object)((Object)this.state) + " state!");
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void onInitEntry(StoreCommitEntry commitEntry) {
        try {
            if (this.role == IStoreBinding.Role.Primary) {
                throw new InternalError("init handler invoked on a primary store binding!");
            }
            if (this.state == IStoreBinding.State.Opening) {
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "Received init entry for local application....", Tracer.Level.DEBUG);
                }
                if (this.initializationState != InitializationState.InProgress) throw new InternalError("Received an init entry in the '" + (Object)((Object)this.initializationState) + " initialization state!");
                this.commitEntryProcessor.process(StoreCommitEntrySource.Initializer, commitEntry, false, 0L);
                return;
            } else {
                if (this.state != IStoreBinding.State.Open && this.state != IStoreBinding.State.Closed) return;
                throw new InternalError("Received an init entry in the '" + (Object)((Object)this.state) + " state!");
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onInitComplete(IStoreMember source, long transactionId) {
        try {
            if (this.role == IStoreBinding.Role.Primary) {
                throw new InternalError("init handler invoked on a primary store binding!");
            }
            this.initializationState = InitializationState.Complete;
            if (this.state == IStoreBinding.State.Opening) {
                int incompleteCommitCount = this.commitEntryProcessor.clear();
                if (incompleteCommitCount > 0) {
                    this.tracer.log(this.getTracePrefix("B") + "Incomplete transaction commit at end of initialization of backup from primary  (count=" + incompleteCommitCount + "). Ignored incomplete transaction.", Tracer.Level.WARNING);
                }
                if (this.persister != null) {
                    this.persister.flush(false);
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "Received init completion (transactionId=" + transactionId + ").", Tracer.Level.DEBUG);
                }
                this.lastCommittedTransactionId = transactionId;
                this.onEvent(StoreMemberInitCompleteEvent.create(this, this.getMember(), this.lastCommittedTransactionId), ExceptionHandlingPolicy.TrapAndDiscard);
            } else if (this.state == IStoreBinding.State.Open || this.state == IStoreBinding.State.Closed) {
                throw new InternalError("Received an init complete in the '" + (Object)((Object)this.state) + " state!");
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onMemberTableOpenWaitCompletion() {
        try {
            if (this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) {
                this.onEvent(StoreMemberTableOpenWaitCompletionEvent.create(this));
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final long onCommitEntry(StoreCommitEntrySource commitEntrySource, StoreCommitEntry commitEntry, boolean ackedOnReturn, long postWireTs) {
        try {
            if (this.role == IStoreBinding.Role.Primary) {
                throw new InternalError("commit request handler invoked on a primary store binding!");
            }
            this.waitForBindingToOpen();
            if (this.state == IStoreBinding.State.Open) {
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "Received commit entry for local application....", Tracer.Level.DEBUG);
                }
                return this.commitEntryProcessor.process(commitEntrySource, commitEntry, ackedOnReturn, postWireTs);
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
        return 0L;
    }

    final void onCommitComplete(StoreCommitCompletionStatus completionStatus, long ackPostWireTs, long ackWireTime, long meanCommitEntryWireTime) {
        this.onCommitComplete(completionStatus, ackPostWireTs, ackWireTime, meanCommitEntryWireTime, false, true);
    }

    final void onCommitComplete(StoreCommitCompletionStatus completionStatus) {
        this.onCommitComplete(completionStatus, 0L, 0L, 0L, false, true);
    }

    final void onMemberLost(IDiscoveryEntity member) {
        try {
            if (this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) {
                this.onEvent(StoreMemberLostEvent.create(this, member));
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onMemberDown(IStoreMember member) {
        try {
            if (this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open) {
                --this.memberCount;
                this.syncPersister(this.state == IStoreBinding.State.Opening);
                this.syncSender(this.state == IStoreBinding.State.Opening);
                this.onEvent(StoreMemberDownEvent.create(this, member), ExceptionHandlingPolicy.TrapAndDiscard);
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    final void onFail(Exception e) {
        this.state = IStoreBinding.State.Failed;
        this.onEvent(StoreBindingFailedEvent.create(this, e), ExceptionHandlingPolicy.TrapAndDiscard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void open(Map<IStoreBinding.StartupExpectation, Enum<?>> expectations) throws OdsException {
        if (this.state == null) {
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "Opening store...", Tracer.Level.DEBUG);
            }
            Object object = this.openCompletionNotifier;
            synchronized (object) {
                try {
                    this.state = IStoreBinding.State.Opening;
                    this.setStartupExpectations(expectations);
                    this.memberInitializer.open();
                    if (!this.isStandalone()) {
                        this.replicator.open();
                    } else {
                        if (this.isStandaloneReceiver()) {
                            if (this.tracer.debug) {
                                this.tracer.log(this.getTracePrefix("B") + "I am a standalone ICR receiver. Not joining cluster....", Tracer.Level.DEBUG);
                            }
                            this.onRoleChange(IStoreBinding.Role.Backup);
                        } else {
                            if (this.tracer.debug) {
                                this.tracer.log(this.getTracePrefix("B") + "I am a standalone member. Not joining cluster....", Tracer.Level.DEBUG);
                            }
                            this.onRoleChange(IStoreBinding.Role.Primary);
                        }
                        this.initializationState = InitializationState.Complete;
                    }
                    if (this.state == IStoreBinding.State.Opening) {
                        if (this.role == IStoreBinding.Role.Primary || this.isStandalone()) {
                            if (this.tracer.debug) {
                                this.tracer.log(this.getTracePrefix("B") + "I am " + (this.isStandaloneReceiver() ? "standalone receiver" : "primary") + ". Reading from persister....", Tracer.Level.DEBUG);
                            }
                            if (this.persister != null) {
                                try {
                                    this.persister.read(new PersisterReadCallbackHandler());
                                    if (this.tracer.debug) {
                                        this.tracer.log(this.getTracePrefix("B") + "Persister read complete.", Tracer.Level.DEBUG);
                                    }
                                }
                                catch (Exception e) {
                                    this.fail(e);
                                }
                            } else if (this.tracer.debug) {
                                this.tracer.log(this.getTracePrefix("B") + "...No persister attached", Tracer.Level.DEBUG);
                            }
                            if (this.state != IStoreBinding.State.Failed) {
                                this.onEvent(StoreMemberInitCompleteEvent.create(this, this.getMember(), this.lastCommittedTransactionId), ExceptionHandlingPolicy.TrapAndDiscard);
                            }
                        } else if (this.tracer.debug) {
                            this.tracer.log(this.getTracePrefix("B") + "I am backup (role=" + (Object)((Object)this.role) + "). Not reading from persister.", Tracer.Level.DEBUG);
                        }
                    } else if (this.state != IStoreBinding.State.Failed) {
                        throw new InternalError("state change to invalid state '" + (Object)((Object)this.state) + "' during replicator open!");
                    }
                    if (this.state == IStoreBinding.State.Failed) {
                        if (this.openException == null) {
                            throw new InternalError("state changed to Failed during replicator open but openException was not set!");
                        }
                        try {
                            this.close(1);
                        }
                        catch (Exception e1) {
                            this.tracer.log(this.getTracePrefix("B") + "Failed to close the store after an open failure [" + e1.toString() + "].", Tracer.Level.WARNING);
                        }
                        if (this.openException instanceof OdsException) {
                            throw (OdsException)this.openException;
                        }
                        throw new OdsException(this.openException);
                    }
                    if (this.state == IStoreBinding.State.Opening) {
                        this.state = IStoreBinding.State.Open;
                    }
                }
                finally {
                    this.openCompletionNotifier.notifyAll();
                }
            }
            ++this.memberCount;
            if (!(this.descriptor.getMaxPersistSyncBacklog() <= 0 && this.descriptor.getMaxInterClusterReplicationSyncBacklog() <= 0 || Config.tuneForLatency())) {
                this.syncer = new Syncer();
                this.syncer.start();
            }
        } else {
            throw new IllegalStateException("store already opened");
        }
    }

    @Override
    public final void open() throws OdsException {
        this.open(null);
    }

    public final String getName() {
        return this.getMember().getName();
    }

    @Override
    public final IStoreMember getMember() {
        return this.isStandalone() ? this.standaloneMember : this.replicator.getMember();
    }

    @Override
    public final StoreDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final IStoreEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public final IStoreBinding.State getState() {
        return this.state;
    }

    @Override
    public final IStoreBindingStats getStats() {
        return this.stats;
    }

    @Override
    public final IStoreBinding.Role getRole() {
        if (this.state == null || this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open || this.state == IStoreBinding.State.Failed) {
            return this.role;
        }
        throw this.prepareStateValidationErrorException();
    }

    @Override
    public final IStoreBinding.InterClusterReplicationRole getInterClusterReplicationRole() {
        if (this.sender != null) {
            return IStoreBinding.InterClusterReplicationRole.Sender;
        }
        if (this.receiver != null) {
            return this.receiver.getDescriptor().getRole();
        }
        return null;
    }

    @Override
    public final int getMemberCount() {
        if (this.state == null || this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open || this.state == IStoreBinding.State.Failed) {
            return this.memberCount;
        }
        throw this.prepareStateValidationErrorException();
    }

    @Override
    public final boolean isPersistenceQuorumMet() {
        if (this.state == null || this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open || this.state == IStoreBinding.State.Failed) {
            return this.memberCount >= this.descriptor.getPersistenceQuorum();
        }
        throw this.prepareStateValidationErrorException();
    }

    @Override
    public final IStorePersister getPersister() {
        if (this.state == null || this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open || this.state == IStoreBinding.State.Failed) {
            return this.persister;
        }
        throw this.prepareStateValidationErrorException();
    }

    @Override
    public final IStoreSender getICRSender() {
        if (this.state == null || this.state == IStoreBinding.State.Opening || this.state == IStoreBinding.State.Open || this.state == IStoreBinding.State.Failed) {
            return this.sender;
        }
        throw this.prepareStateValidationErrorException();
    }

    @Override
    public final IStoreTransactionLog getTransactionLog() {
        if (this.state == IStoreBinding.State.Open || this.state == IStoreBinding.State.Failed) {
            return this.txnlog;
        }
        throw this.prepareStateValidationErrorException();
    }

    @Override
    public final IStoreQueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    @Override
    public final IStoreQueryRepository asQueryRepository() {
        return this.queryRepository;
    }

    @Override
    public final IStoreCommitCompletionEvent createCommitCompletionEvent() {
        return StoreCommitCompletionEvent.create(this);
    }

    @Override
    public final int sizeUnprotected() {
        return this.objects.size();
    }

    @Override
    public final int size() {
        return this.objects.size();
    }

    @Override
    public final void processMemberControlEvent(IStoreMemberControlEvent event) {
        if (this.state == IStoreBinding.State.Failed) {
            return;
        }
        if (this.state != IStoreBinding.State.Open && this.state != IStoreBinding.State.Opening) {
            throw this.prepareStateValidationErrorException();
        }
        if (this.evTracer.debug) {
            this.evTracer.log(this.getTracePrefix("B") + "<A> [" + event.getClass().getSimpleName() + "<" + event.getType() + ">]", Tracer.Level.DEBUG);
        }
        try {
            switch (event.getType()) {
                case 312: {
                    this.replicator.processMemberFound(((StoreMemberFoundEvent)event).getMember());
                    break;
                }
                case 315: {
                    this.replicator.processMemberConnectRequest(((StoreMemberConnectRequestEvent)event).getMember(), ((StoreMemberConnectRequestEvent)event).getMemberName(), ((StoreMemberConnectRequestEvent)event).getMemberRole());
                    break;
                }
                case 318: {
                    this.replicator.processMemberConnectReply(((StoreMemberConnectReplyEvent)event).getMember(), ((StoreMemberConnectReplyEvent)event).getMemberRole());
                    break;
                }
                case 316: {
                    this.replicator.startMemberHandshake(((StoreMemberHandshakeStartReadyEvent)event).getMember());
                    break;
                }
                case 320: {
                    this.replicator.processMemberHandshakePrimaryHello(((StoreMemberHandshakePrimaryHelloEvent)event).getMember(), ((StoreMemberHandshakePrimaryHelloEvent)event).getLastCommittedTransactionId());
                    break;
                }
                case 317: {
                    this.replicator.processMemberHandshakeBackupHello(((StoreMemberHandshakeBackupHelloEvent)event).getMember(), ((StoreMemberHandshakeBackupHelloEvent)event).getLastCommittedTransactionId());
                    break;
                }
                case 314: {
                    this.memberInitializer.scheduleOrExecuteMemberInit(((StoreMemberInitReadyEvent)event).getMember());
                    break;
                }
                case 319: {
                    this.replicator.processMemberTableOpenWaitCompletion();
                    break;
                }
                case 313: {
                    this.memberInitializer.unscheduleMemberInit(((StoreMemberLostEvent)event).getMember());
                    this.replicator.processMemberLost(((StoreMemberLostEvent)event).getMember());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal event ('" + event.getClass().getName() + "') passed in for processing");
                }
            }
        }
        catch (Throwable e) {
            this.handleExceptionByPolicy(e, ExceptionHandlingPolicy.TrapAndFail, null);
        }
    }

    @Override
    public final <T> void recordFieldUpdate(IStoreObject object, IStoreField<T> field, T oldValue, T newValue) {
        if (this.evTracer.debug) {
            this.evTracer.log(this.getTracePrefix("B") + "<A> [FieldUpdate<" + object.getClass().getSimpleName() + ", " + field.getFid() + ">]", Tracer.Level.DEBUG);
        }
        this.getTransactionLog().recordFieldUpdate(object, field.getFid(), field, oldValue);
        if (this.queryRepository != null) {
            this.queryRepository.onFieldUpdated(object, field, oldValue, newValue);
        }
    }

    @Override
    public final IStoreBinding put(IStoreObject object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (this.state == IStoreBinding.State.Failed) {
            return this;
        }
        if (this.state != IStoreBinding.State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        if (this.role != IStoreBinding.Role.Primary) {
            throw new IllegalStateException("this operation can only be performed on primary stores");
        }
        if (object.getBinding() != null) {
            throw new IllegalArgumentException("object already in a store");
        }
        if (this.checked && this.objects.get(object.getOid()) != null) {
            throw new InternalError("store object's binding is not set but object is in store");
        }
        if (object.getOid() == null) {
            object.ensureOId();
        }
        if (this.evTracer.debug) {
            this.evTracer.log(this.getTracePrefix("B") + "<A> [Put<" + object.getOid() + ", " + object.getClass().getSimpleName() + ">]", Tracer.Level.DEBUG);
        }
        this.txnlog.recordObjectPut(object);
        object.setBinding(this);
        this.objects.put(object.getOid(), object);
        if (this.queryEngine != null) {
            this.queryRepository.onPut(object);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.getTracePrefix("B") + "Put object '" + object.getOid() + "' (" + object.getClass().getSimpleName() + ") into store...", Tracer.Level.DEBUG);
        }
        return this;
    }

    @Override
    public final IStoreBinding send(IStoreObject object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (this.state == IStoreBinding.State.Failed) {
            return this;
        }
        if (this.state != IStoreBinding.State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        if (this.role != IStoreBinding.Role.Primary) {
            throw new IllegalStateException("this operation can only be performed on primary stores");
        }
        if (object.getBinding() != null) {
            throw new IllegalArgumentException("object (message) already in a store");
        }
        if (object.getOid() == null) {
            object.ensureOId();
        }
        if (this.evTracer.debug) {
            this.evTracer.log(this.getTracePrefix("B") + "<A> [Send<" + object.getOid() + ", " + object.getClass().getSimpleName() + ">]", Tracer.Level.DEBUG);
        }
        this.txnlog.recordObjectSend(object);
        object.setBinding(this);
        if (this.tracer.debug) {
            this.tracer.log(this.getTracePrefix("B") + "Send object '" + object.getOid() + "' (" + object.getClass().getSimpleName() + ") to store...", Tracer.Level.DEBUG);
        }
        return this;
    }

    @Override
    public final IStoreObject get(UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (this.state != IStoreBinding.State.Opening && this.state != IStoreBinding.State.Open && this.state != IStoreBinding.State.Failed) {
            throw this.prepareStateValidationErrorException();
        }
        if (this.evTracer.debug) {
            this.evTracer.log(this.getTracePrefix("B") + "<A> [Get<" + id + ">]", Tracer.Level.DEBUG);
        }
        return this.objects.get(id);
    }

    @Override
    public final IStoreBinding remove(IStoreObject object) {
        IStoreObject objectInStore;
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (this.state == IStoreBinding.State.Failed) {
            return this;
        }
        if (this.state != IStoreBinding.State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        if (this.role != IStoreBinding.Role.Primary) {
            throw new IllegalStateException("this operation can only be performed on primary stores");
        }
        if (this.evTracer.debug) {
            this.evTracer.log(this.getTracePrefix("B") + "<A> [Remove<" + object.getOid() + ", " + object.getClass().getSimpleName() + ">]", Tracer.Level.DEBUG);
        }
        if ((objectInStore = this.objects.get(object.getOid())) == object) {
            if (this.checked) {
                if (object.getBinding() == null) {
                    throw new InternalError("object is in store but object's binding is null");
                }
                if (object.getBinding() != this) {
                    throw new InternalError("object's binding is incorrect!");
                }
            }
            this.txnlog.recordObjectRemove(object);
            object.setBinding(null);
            this.objects.remove(object.getOid());
            if (this.queryRepository != null) {
                this.queryRepository.onRemove(object);
            }
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "Removed object '" + object.getOid() + "' (" + object.getClass().getSimpleName() + ") from store...", Tracer.Level.DEBUG);
            }
        } else {
            throw new IllegalArgumentException("object not in store");
        }
        return this;
    }

    private final boolean shouldPrepareCommitEntryForLogEntry(StoreTransactionLog.Entry.Type firstLogEntryType, StoreTransactionLog.Entry.Type lastLogEntryType) {
        if (firstLogEntryType == StoreTransactionLog.Entry.Type.Send) {
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "......send - log starts with send.", Tracer.Level.DEBUG);
            }
            return true;
        }
        if (firstLogEntryType == StoreTransactionLog.Entry.Type.Put) {
            if (lastLogEntryType == StoreTransactionLog.Entry.Type.Remove) {
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "......noop - log starts with put and ends with remove.", Tracer.Level.DEBUG);
                }
            } else {
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "......put - log starts with put but does not end with remove (last=" + (Object)((Object)lastLogEntryType) + ").", Tracer.Level.DEBUG);
                }
                if (!this.eventSourcing) {
                    return true;
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + ".........put - ignoring since operating in event sourcing mode.", Tracer.Level.DEBUG);
                }
            }
        } else if (lastLogEntryType == StoreTransactionLog.Entry.Type.Remove) {
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "......remove - log does not start with put but ends with remove.", Tracer.Level.DEBUG);
            }
            if (!this.eventSourcing) {
                return true;
            }
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + ".........remove - ignoring since operating in event sourcing mode.", Tracer.Level.DEBUG);
            }
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "......update - log does not start with put and does not end with remove.", Tracer.Level.DEBUG);
            }
            if (!this.eventSourcing) {
                return true;
            }
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + ".........update - ignoring since operating in event sourcing mode.", Tracer.Level.DEBUG);
            }
        }
        return false;
    }

    private final void prepareCommitEntry(IStoreBinding.Operation operation, long transactionId, long stableTransactionId, long checkpointVersion, boolean commitStart, boolean commitEnd, IStoreObject object) {
        object.setTransactionId(transactionId).setStableTransactionId(stableTransactionId);
        if (this.checkpointingController != null) {
            object.setCheckpointVersion(checkpointVersion);
            switch (operation) {
                case Send: {
                    this.checkpointingController.onSend();
                    break;
                }
                case Put: {
                    this.checkpointingController.onPut();
                    break;
                }
                case Remove: {
                    this.checkpointingController.onRemove();
                    break;
                }
                case Update: {
                    this.checkpointingController.onUpdate();
                    break;
                }
                default: {
                    throw new InternalError("unknown store operation '" + (Object)((Object)operation) + "'");
                }
            }
        }
        this.commitEntry.init(operation, object.getOid(), object.getOfid(), object.getObjectType(), transactionId, stableTransactionId, checkpointVersion, object, object.getContentEncodingType(), commitStart, commitEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean replicateAndWriteCommitEntry(StoreCommitCompletionStatus completionStatus, long preSerializeTs) {
        try {
            long prePersistTs;
            boolean complete;
            long postSerializeTs;
            boolean commitEnd = this.commitEntry.commitEnd;
            long l = postSerializeTs = this.recordLegLatencies ? UtlTime.now() : 0L;
            if (this.recordLegLatencies) {
                this.stats.s.add((double)(postSerializeTs - preSerializeTs));
            }
            boolean bl = this.isStandalone() || this.replicator.sendCommitEntry(this.commitEntry, commitEnd ? completionStatus : null, postSerializeTs) ? true : (complete = false);
            if (commitEnd) {
                ++this.stats.numCommitsSent;
            }
            ++this.stats.numCommitEntriesSent;
            long l2 = prePersistTs = this.recordLegLatencies ? UtlTime.now() : 0L;
            if (this.recordLegLatencies) {
                this.stats.s2p.add((double)(prePersistTs - postSerializeTs));
            }
            this.writeCommitEntry(this.commitEntry, prePersistTs);
            if (this.commitEntry.operation == IStoreBinding.Operation.Remove && this.disposeOnRemove) {
                this.commitEntry.object.dispose();
            } else if (Config.conserveMemory()) {
                this.commitEntry.object.saveMemory();
            }
            boolean bl2 = complete;
            return bl2;
        }
        finally {
            this.commitEntry.serializedPersisterMetadata.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IStoreCommitCompletionEvent commit(long transactionId, long stableTransactionId, IStoreObject[] messages, int messageCount, IStoreCommitCompletionEvent completionEvent, int flags) throws OdsException {
        long startTs;
        if (this.state == IStoreBinding.State.Failed) {
            return completionEvent;
        }
        if (this.state != IStoreBinding.State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        if (this.role != IStoreBinding.Role.Primary) {
            throw new IllegalStateException("this operation can only be performed on primary bindings");
        }
        if (this.checked && completionEvent != null && this != completionEvent.getSource()) {
            throw new IllegalStateException("completion event is associated with a different binding");
        }
        if (this.checked && completionEvent != null && !(completionEvent instanceof StoreCommitCompletionEvent)) {
            throw new IllegalArgumentException("completion event was not created by this binding");
        }
        if (this.evTracer.debug) {
            this.evTracer.log(this.getTracePrefix("B") + "<A> [Commit<" + transactionId + ", " + stableTransactionId + ">]", Tracer.Level.DEBUG);
        }
        long l = startTs = this.recordLegLatencies ? UtlTime.now() : 0L;
        if (completionEvent != null) {
            completionEvent.setTransactionId(transactionId);
            completionEvent.setStableTransactionId(stableTransactionId);
            if (this.recordLegLatencies) {
                completionEvent.setStartTs(startTs);
            }
        }
        long preSerializeTs = startTs;
        this.memberInitializer.onCommitStart();
        try {
            StoreCommitCompletionStatus completionStatus;
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "Starting commit...", Tracer.Level.DEBUG);
            }
            StoreCommitCompletionStatus storeCommitCompletionStatus = completionStatus = completionEvent != null ? ((StoreCommitCompletionEvent)completionEvent).getHiddenCompletionStatus() : null;
            if (this.persister != null) {
                this.persister.readMetadata(this.commitEntry.serializedPersisterMetadata);
            }
            boolean complete = true;
            boolean firstCommitEntry = true;
            boolean commitEntryPrepared = false;
            int commitEntriesReplicated = 0;
            if (this.txnlog.hasUncommitted()) {
                UtlLinkedHashMap.FastIterator iterator = this.txnlog.getLog().fastIterator().toFirst();
                while (iterator.hasNext()) {
                    IStoreObject object;
                    boolean prepareCommitEntry;
                    StoreTransactionLog.Entry.Type lastLogEntryType;
                    StoreTransactionLog.Entry.Type firstLogEntryType;
                    StoreTransactionLog.Entry lastLogEntry;
                    StoreTransactionLog.Entry firstLogEntry;
                    Map.Entry entry = (Map.Entry)iterator.next();
                    UUID id = (UUID)entry.getKey();
                    StoreTransactionLog.ObjectEntriesList list = (StoreTransactionLog.ObjectEntriesList)((Object)entry.getValue());
                    if (this.tracer.debug) {
                        this.tracer.log(this.getTracePrefix("B") + "...processing log for '" + id + "' (#entries=" + list.count() + ")...", Tracer.Level.DEBUG);
                    }
                    if (list != null && list.count() > 0) {
                        firstLogEntry = (StoreTransactionLog.Entry)list.first();
                        lastLogEntry = (StoreTransactionLog.Entry)list.last();
                        firstLogEntryType = firstLogEntry.type;
                        lastLogEntryType = lastLogEntry.type;
                        prepareCommitEntry = this.shouldPrepareCommitEntryForLogEntry(firstLogEntryType, lastLogEntryType);
                    } else {
                        firstLogEntry = null;
                        lastLogEntry = null;
                        firstLogEntryType = null;
                        lastLogEntryType = null;
                        prepareCommitEntry = false;
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.getTracePrefix("B") + "......prepare commit entry=" + prepareCommitEntry, Tracer.Level.DEBUG);
                    }
                    if (commitEntryPrepared && prepareCommitEntry) {
                        this.replicateAndWriteCommitEntry(completionStatus, preSerializeTs);
                        if (this.recordLegLatencies) {
                            ++commitEntriesReplicated;
                        }
                        preSerializeTs = this.recordLegLatencies ? UtlTime.now() : 0L;
                        commitEntryPrepared = false;
                    }
                    if (prepareCommitEntry) {
                        if (firstLogEntryType == StoreTransactionLog.Entry.Type.Send) {
                            object = ((StoreTransactionLog.SendEntry)firstLogEntry).object;
                            if (this.evTracer.debug) {
                                this.evTracer.log(this.getTracePrefix("B") + "<A> [C(Send)<" + object.getOid() + ", " + object.getClass().getSimpleName() + ">]", Tracer.Level.DEBUG);
                            }
                            this.prepareCommitEntry(IStoreBinding.Operation.Send, transactionId, stableTransactionId, this.checkpointVersion, firstCommitEntry, false, object);
                            object.setBinding(null);
                        } else if (firstLogEntryType == StoreTransactionLog.Entry.Type.Put) {
                            object = this.objects.get(id);
                            if (this.evTracer.debug) {
                                this.evTracer.log(this.getTracePrefix("B") + "<A> [C(Put)<" + object.getOid() + ", " + object.getClass().getSimpleName() + ">]", Tracer.Level.DEBUG);
                            }
                            this.prepareCommitEntry(IStoreBinding.Operation.Put, transactionId, stableTransactionId, this.checkpointVersion, firstCommitEntry, false, object);
                            int dataSize = this.commitEntry.serializedObject.getBody().getSerializedLength();
                            object.getStoreMetadata().setCommittedDataSize(dataSize);
                            this.stats.storeDataSize += (long)dataSize;
                        } else if (lastLogEntryType == StoreTransactionLog.Entry.Type.Remove) {
                            object = ((StoreTransactionLog.RemoveEntry)lastLogEntry).object;
                            if (this.evTracer.debug) {
                                this.evTracer.log(this.getTracePrefix("B") + "<A> [C(Remove)<" + object.getOid() + ", " + object.getClass().getSimpleName() + ">]", Tracer.Level.DEBUG);
                            }
                            this.prepareCommitEntry(IStoreBinding.Operation.Remove, transactionId, stableTransactionId, this.checkpointVersion, firstCommitEntry, false, object);
                            this.stats.storeDataSize -= (long)Math.max(0, object.getStoreMetadata().getCommittedDataSize());
                            object.setCommittedDataSize(0);
                        } else {
                            object = this.objects.get(id);
                            if (this.evTracer.debug) {
                                this.evTracer.log(this.getTracePrefix("B") + "<A> [C(Update)<" + object.getOid() + ", " + object.getClass().getSimpleName() + ">]", Tracer.Level.DEBUG);
                            }
                            this.prepareCommitEntry(IStoreBinding.Operation.Update, transactionId, stableTransactionId, this.checkpointVersion, firstCommitEntry, false, object);
                            int previousDataSize = object.getStoreMetadata().getCommittedDataSize();
                            int dataSize = this.commitEntry.serializedObject.getBody().getSerializedLength();
                            object.getStoreMetadata().setCommittedDataSize(dataSize);
                            this.stats.storeDataSize += (long)(dataSize - previousDataSize);
                        }
                        firstCommitEntry = false;
                        commitEntryPrepared = true;
                        continue;
                    }
                    if (this.evTracer.debug) {
                        this.evTracer.log(this.getTracePrefix("B") + "<A> [C(None)<" + id + ">]", Tracer.Level.DEBUG);
                    }
                    if (!Config.conserveMemory() || (object = this.objects.get(id)) == null) continue;
                    object.saveMemory();
                }
            }
            if (commitEntryPrepared) {
                if (messageCount == 0) {
                    this.commitEntry.commitEnd();
                }
                complete = this.replicateAndWriteCommitEntry(completionStatus, preSerializeTs);
                if (this.recordLegLatencies) {
                    ++commitEntriesReplicated;
                }
                preSerializeTs = this.recordLegLatencies ? UtlTime.now() : 0L;
            }
            for (int i = 0; i < messageCount; ++i) {
                if (messages[i] == null) continue;
                this.prepareCommitEntry(IStoreBinding.Operation.Send, transactionId, stableTransactionId, this.checkpointVersion, firstCommitEntry, i == messageCount - 1, messages[i]);
                firstCommitEntry = false;
                complete = this.replicateAndWriteCommitEntry(completionStatus, preSerializeTs);
                if (this.recordLegLatencies) {
                    ++commitEntriesReplicated;
                }
                preSerializeTs = this.recordLegLatencies ? UtlTime.now() : 0L;
            }
            if (this.recordLegLatencies) {
                this.stats.cqs.add((double)commitEntriesReplicated);
            }
            if (complete && completionStatus != null) {
                this.onCommitComplete(completionStatus, 0L, 0L, 0L, true, (flags & 8) == 0);
            }
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "Commit done.", Tracer.Level.DEBUG);
            }
            this.txnlog.clear();
            this.lastCommittedTransactionId = transactionId;
            if (this.checkpointingController != null && this.checkpointingController.onCommit()) {
                this.incrementCheckpointVersion();
            }
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Commit faulted with error [" + e.toString() + "] with the following stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            sb.append("Failing the store...").append("\n");
            this.tracer.log(this.getTracePrefix("B") + "" + sb.toString(), Tracer.Level.SEVERE);
            if (e instanceof Error) {
                this.fail(new RuntimeException(e));
            } else {
                this.fail((Exception)e);
            }
        }
        finally {
            this.memberInitializer.onCommitEnd();
            this.commitEntry.fin();
        }
        return completionEvent;
    }

    @Override
    public final IStoreCommitCompletionEvent commit(long transactionId, long stableTransactionId, IStoreCommitCompletionEvent completionEvent, int flags) throws OdsException {
        return this.commit(transactionId, stableTransactionId, null, 0, completionEvent, flags);
    }

    @Override
    public final IStoreCommitCompletionEvent commit(IStoreCommitCompletionEvent completionEvent) throws OdsException {
        return this.commit(0L, 0L, completionEvent, 0);
    }

    @Override
    public final int createSavepoint() {
        return this.txnlog.createSavepoint();
    }

    @Override
    public final int getLastSavepoint() {
        return this.txnlog.getCurrentSavepoint();
    }

    @Override
    public final IStoreBinding rollback() {
        return this.rollback(0);
    }

    @Override
    public final IStoreBinding rollback(int savepoint) {
        if (this.state == IStoreBinding.State.Failed) {
            return this;
        }
        if (this.state != IStoreBinding.State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        if (this.role != IStoreBinding.Role.Primary) {
            throw new IllegalStateException("this operation can only be performed on primary stores");
        }
        if (savepoint < 0 || savepoint > this.txnlog.getCurrentSavepoint()) {
            throw new IllegalArgumentException("Invalid rollback savepoint '" + savepoint + "' (current savepoint is '" + this.txnlog.getCurrentSavepoint() + "')");
        }
        if (this.evTracer.debug) {
            this.evTracer.log(this.getTracePrefix("B") + "<A> [Rollback to savepoint " + savepoint + " (current savepoint = " + this.txnlog.getCurrentSavepoint() + ")]", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.getTracePrefix("B") + "Starting rollback...", Tracer.Level.DEBUG);
        }
        try {
            UtlList olog = this.txnlog.getOrderedLog();
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix("B") + "...Processing log for (#entries=" + olog.count() + ") ...", Tracer.Level.DEBUG);
            }
            if (olog.count() > 0) {
                StoreTransactionLog.OrderedEntry ologEntry = (StoreTransactionLog.OrderedEntry)olog.last();
                while (ologEntry != null && ologEntry.savepoint >= savepoint) {
                    StoreTransactionLog.ObjectEntriesList list;
                    StoreTransactionLog.Entry<?> logEntry = ologEntry.entry;
                    UUID id = ((StoreTransactionLog.ObjectEntriesList)logEntry.head).oid;
                    if (this.tracer.debug) {
                        this.tracer.log(this.getTracePrefix("B") + "......entry is for object with id=" + id + ".", Tracer.Level.DEBUG);
                    }
                    switch (logEntry.type) {
                        case Put: {
                            if (this.tracer.debug) {
                                this.tracer.log(this.getTracePrefix("B") + ".........put - removing object from table.", Tracer.Level.DEBUG);
                            }
                            IStoreObject object = this.objects.get(id).setBinding(null);
                            this.objects.remove(id);
                            if (this.queryRepository == null || savepoint <= 0) break;
                            this.queryRepository.onRemove(object);
                            break;
                        }
                        case Remove: {
                            if (this.tracer.debug) {
                                this.tracer.log(this.getTracePrefix("B") + ".........remove - restoring object in table.", Tracer.Level.DEBUG);
                            }
                            this.objects.put(id, ((StoreTransactionLog.RemoveEntry)logEntry).object.setBinding(this));
                            if (this.queryRepository == null || savepoint <= 0) break;
                            this.queryRepository.onPut(((StoreTransactionLog.RemoveEntry)logEntry).object);
                            break;
                        }
                        case FieldUpdate: {
                            IStoreField<?> field;
                            if (this.tracer.debug) {
                                this.tracer.log(this.getTracePrefix("B") + ".........field update - restoring field value in object.", Tracer.Level.DEBUG);
                            }
                            StoreTransactionLog.FieldUpdateEntry logFieldUpdateEntry = (StoreTransactionLog.FieldUpdateEntry)logEntry;
                            IStoreObject object = this.objects.get(id);
                            if (this.queryRepository != null && savepoint > 0 && (field = logFieldUpdateEntry.field) != null) {
                                Object currentValue = field.apply(object);
                                this.queryRepository.onFieldUpdated(object, field, currentValue, logFieldUpdateEntry.fieldVal);
                            }
                            object.setFieldValue(logFieldUpdateEntry.fieldId, logFieldUpdateEntry.fieldVal);
                            break;
                        }
                        case Send: {
                            if (this.tracer.debug) {
                                this.tracer.log(this.getTracePrefix("B") + ".........send - clearing object's binding.", Tracer.Level.DEBUG);
                            }
                            ((StoreTransactionLog.SendEntry)logEntry).object.setBinding(null);
                        }
                    }
                    logEntry.unlink();
                    ologEntry.unlink();
                    ologEntry.dispose();
                    ologEntry = (StoreTransactionLog.OrderedEntry)olog.last();
                    if (savepoint <= 0 || (list = (StoreTransactionLog.ObjectEntriesList)((Object)this.txnlog.getLog().get((Object)id))).count() != 0) continue;
                    this.txnlog.getLog().remove((Object)id);
                }
            }
            if (savepoint == 0) {
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "Rollback done.", Tracer.Level.DEBUG);
                }
                this.txnlog.clear();
                if (this.queryRepository != null) {
                    this.queryRepository.rollback();
                }
            } else {
                this.txnlog.resetSavepoint(savepoint);
            }
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Rollback faulted with error [" + e.toString() + "] with the following stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            sb.append("Failing the store...").append("\n");
            this.tracer.log(this.getTracePrefix("B") + "" + sb.toString(), Tracer.Level.SEVERE);
            if (e instanceof Error) {
                this.fail(new RuntimeException(e));
            }
            this.fail((Exception)e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fail(Exception e) {
        if (this.evTracer.debug) {
            this.evTracer.log(this.getTracePrefix("B") + "<A> [Fail<" + (e != null ? e.toString() : "null") + ">]", Tracer.Level.DEBUG);
        }
        if (this.state == IStoreBinding.State.Opening) {
            this.state = IStoreBinding.State.Failed;
            this.openException = e;
            if (this.replicator != null && this.replicator.getState() == StoreReplicator.State.INIT) {
                this.replicator.fail(e);
            }
            if (e != null && e instanceof OdsExpectationNotMetException) {
                this.tracer.log(this.getTracePrefix("B") + "Failure occurred while opening store: " + e.getMessage(), Tracer.Level.SEVERE);
            } else {
                this.tracer.log(this.getTracePrefix("B") + "Failure occurred while opening store: " + e == null ? "null" : UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
            }
        } else {
            IStoreBinding.State state = this.state;
            synchronized (state) {
                if (this.state == IStoreBinding.State.Failed) {
                    return;
                }
                if (this.state != IStoreBinding.State.Open) {
                    throw this.prepareStateValidationErrorException();
                }
                this.state = IStoreBinding.State.Failed;
            }
            this.memberInitializer.close(false);
            if (this.replicator != null) {
                this.replicator.fail(e);
            } else {
                this.onFail(e);
            }
        }
    }

    @Override
    public final void close(int flags) {
        if (this.evTracer.debug) {
            this.evTracer.log(this.getTracePrefix("B") + "<A> [Close]", Tracer.Level.DEBUG);
        }
        if (this.state != IStoreBinding.State.Closed) {
            try {
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix("B") + "Closing store...", Tracer.Level.DEBUG);
                }
                this.stats.close();
                this.memberInitializer.close(true);
                if (this.syncer != null) {
                    this.syncer.shutdown();
                    this.syncer = null;
                }
                if (this.receiver != null) {
                    this.receiver.close((flags & 2) > 0);
                }
                if (!this.isStandalone()) {
                    this.replicator.close(flags);
                }
                if (this.persister != null) {
                    this.persister.close();
                }
                if (this.sender != null) {
                    this.sender.close((flags & 2) > 0);
                }
                if (this.queryEngine != null) {
                    try {
                        this.queryRepository.close();
                    }
                    catch (Exception e) {
                        this.tracer.log(this.getTracePrefix("B") + "Error closing query repository", Tracer.Level.WARNING);
                    }
                    try {
                        this.queryEngine.close();
                    }
                    catch (Exception e) {
                        this.tracer.log(this.getTracePrefix("B") + "Error closing query engine", Tracer.Level.WARNING);
                    }
                }
                this.txnlog.close();
            }
            finally {
                this.state = IStoreBinding.State.Closed;
            }
        }
    }

    protected final void finalize() {
        this.close(1);
    }

    @Override
    public void setQueryAPICallerContext(IQueryAPICallerContext queryAPICallerContext) {
        this.queryAPIManager.setCallerContext(queryAPICallerContext);
    }

    @Override
    public <K, T extends IStoreObject> IStoreUniqueIndex<K, T> createUniqueIndex(String fieldPath, String name) {
        if (!this.getDescriptor().isQueryable()) {
            throw new IllegalStateException("This store is not queryable.");
        }
        return this.queryAPIManager.createUniqueIndex(fieldPath, name);
    }

    @Override
    public <K, T extends IStoreObject> IStoreNonUniqueIndex<K, T> createNonUniqueIndex(String fieldPath, String name) {
        if (!this.getDescriptor().isQueryable()) {
            throw new IllegalStateException("This store is not queryable.");
        }
        return this.queryAPIManager.createNonUniqueIndex(fieldPath, name);
    }

    @Override
    public boolean dropIndexByName(String name) {
        if (!this.getDescriptor().isQueryable()) {
            throw new IllegalStateException("This store is not queryable.");
        }
        return this.queryAPIManager.dropIndexByName(name);
    }

    @Override
    public boolean dropIndex(String fieldPath) {
        if (!this.getDescriptor().isQueryable()) {
            throw new IllegalStateException("This store is not queryable.");
        }
        return this.queryAPIManager.dropIndex(fieldPath);
    }

    @Override
    public boolean dropIndex(IStoreIndex<?, ?> index) {
        if (!this.getDescriptor().isQueryable()) {
            throw new IllegalStateException("This store is not queryable.");
        }
        return this.queryAPIManager.dropIndex(index);
    }

    @Override
    public <K, T extends IStoreObject> IStoreUniqueIndex<K, T> getUniqueIndex(String fieldPath) {
        if (!this.getDescriptor().isQueryable()) {
            throw new IllegalStateException("This store is not queryable.");
        }
        return this.queryAPIManager.getUniqueIndex(fieldPath);
    }

    @Override
    public <K, T extends IStoreObject> IStoreNonUniqueIndex<K, T> getNonUniqueIndex(String fieldPath) {
        if (!this.getDescriptor().isQueryable()) {
            throw new IllegalStateException("This store is not queryable.");
        }
        return this.queryAPIManager.getNonUniqueIndex(fieldPath);
    }

    static enum StoreCommitEntrySource {
        Persister,
        Initializer,
        Replicator,
        ICRSender;

    }

    private static enum ExceptionHandlingPolicy {
        TrapAndDiscard,
        TrapAndFail,
        PassThrough;

    }

    private static enum InitializationState {
        NotStarted,
        InProgress,
        Complete;

    }

    private final class StoreQueryAPIManager {
        private final Map<String, StoreIndexBase<?, ?>> indexesByFieldPath = new HashMap();
        private final Map<String, StoreIndexBase<?, ?>> indexesByName = new HashMap();
        private IQueryAPICallerContext callerContext;

        StoreQueryAPIManager() {
        }

        private void setCallerContext(IQueryAPICallerContext callerContext) {
            this.callerContext = callerContext;
        }

        private <K, T extends IStoreObject> IStoreUniqueIndex<K, T> createUniqueIndex(String fieldPath, String name) {
            if (Strings.isNullOrEmpty((String)fieldPath)) {
                throw new IllegalArgumentException("'fieldPath' cannot be null or empty string.");
            }
            if (Strings.isNullOrEmpty((String)name)) {
                throw new IllegalArgumentException("'name' cannot be null or empty string.");
            }
            IdxField fieldDef = StoreBindingImpl.this.getQueryEngine().getField(fieldPath);
            boolean result = StoreBindingImpl.this.getQueryEngine().createIndex(fieldDef, true, name);
            if (result) {
                IdxUniqueIndex idxView = StoreBindingImpl.this.getQueryEngine().getUniqueIndex(fieldDef);
                StoreUniqueIndexImpl view = new StoreUniqueIndexImpl(idxView, this.callerContext, (IStoreBinding)StoreBindingImpl.this);
                this.indexesByFieldPath.put(fieldDef.getCanonicalName(), view);
                this.indexesByName.put(name, view);
                StoreBindingImpl.this.tracer.log("Created unique store index on field " + fieldDef.getCanonicalName(), Tracer.Level.INFO);
                return view;
            }
            throw new RuntimeException("Index '" + name + "' wasn't created.");
        }

        private <K, T extends IStoreObject> IStoreNonUniqueIndex<K, T> createNonUniqueIndex(String fieldPath, String name) {
            if (Strings.isNullOrEmpty((String)fieldPath)) {
                throw new IllegalArgumentException("'fieldPath' cannot be null or empty string.");
            }
            if (Strings.isNullOrEmpty((String)name)) {
                throw new IllegalArgumentException("'name' cannot be null or empty string.");
            }
            IdxField fieldDef = StoreBindingImpl.this.getQueryEngine().getField(fieldPath);
            boolean result = StoreBindingImpl.this.getQueryEngine().createIndex(fieldDef, false, name);
            if (result) {
                IdxNonUniqueIndex idxView = StoreBindingImpl.this.getQueryEngine().getNonUniqueIndex(fieldDef);
                StoreNonUniqueIndexImpl view = new StoreNonUniqueIndexImpl(idxView, this.callerContext, (IStoreBinding)StoreBindingImpl.this);
                this.indexesByFieldPath.put(fieldDef.getCanonicalName(), view);
                this.indexesByName.put(name, view);
                StoreBindingImpl.this.tracer.log("Created non-unique store index on field " + fieldDef.getCanonicalName(), Tracer.Level.INFO);
                return view;
            }
            throw new RuntimeException("Index '" + name + "' wasn't created.");
        }

        private <K, T extends IStoreObject> IStoreUniqueIndex<K, T> getUniqueIndex(String fieldPath) {
            if (fieldPath == null || fieldPath.isEmpty()) {
                throw new IllegalArgumentException("'fieldPath' cannot be null or empty string.");
            }
            IdxField fieldDefinition = StoreBindingImpl.this.getQueryEngine().getField(fieldPath);
            if (fieldDefinition == null) {
                return null;
            }
            StoreIndexBase<?, ?> view = this.indexesByFieldPath.get(fieldDefinition.getCanonicalName());
            if (view != null) {
                if (view.isUnique()) {
                    view.checkInstanceValid();
                    return (IStoreUniqueIndex)((Object)view);
                }
                throw new IllegalArgumentException("The requested index must be Unique Index.");
            }
            return null;
        }

        private <K, T extends IStoreObject> IStoreNonUniqueIndex<K, T> getNonUniqueIndex(String fieldPath) {
            if (fieldPath == null || fieldPath.isEmpty()) {
                throw new IllegalArgumentException("'fieldPath' cannot be null or empty string.");
            }
            IdxField fieldDefinition = StoreBindingImpl.this.getQueryEngine().getField(fieldPath);
            if (fieldDefinition == null) {
                return null;
            }
            StoreIndexBase<?, ?> index = this.indexesByFieldPath.get(fieldDefinition.getCanonicalName());
            if (index != null) {
                if (!index.isUnique()) {
                    index.checkInstanceValid();
                    return (IStoreNonUniqueIndex)((Object)index);
                }
                throw new IllegalArgumentException("The requested index must be Unique Index");
            }
            return null;
        }

        private boolean dropIndex(String fieldPath) {
            if (fieldPath == null || fieldPath.isEmpty()) {
                throw new IllegalArgumentException("'fieldPath' cannot be null or empty string.");
            }
            IdxField fieldDef = StoreBindingImpl.this.getQueryEngine().getField(fieldPath);
            if (fieldDef == null) {
                return false;
            }
            StoreIndexBase<?, ?> index = this.indexesByFieldPath.get(fieldDef.getCanonicalName());
            if (index != null && StoreBindingImpl.this.getQueryEngine().dropIndex(StoreBindingImpl.this.getQueryEngine().getField(fieldPath))) {
                index.invalidate();
                this.indexesByFieldPath.remove(fieldPath);
                this.indexesByName.remove(index.getName());
                StoreBindingImpl.this.tracer.log("Dropped store index on field " + fieldDef.getCanonicalName(), Tracer.Level.INFO);
                return true;
            }
            return false;
        }

        private boolean dropIndex(IStoreIndex<?, ? extends IStoreObject> index) {
            if (index == null) {
                throw new IllegalArgumentException("'index' cannot be null.");
            }
            boolean retVal = false;
            retVal = this.dropIndexByName(index.getName());
            return retVal;
        }

        private boolean dropIndexByName(String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                throw new IllegalArgumentException("'name' cannot be null or empty string.");
            }
            StoreIndexBase<?, ?> index = this.indexesByName.get(name);
            if (index != null && StoreBindingImpl.this.getQueryEngine().dropIndex(name)) {
                index.invalidate();
                return true;
            }
            return false;
        }
    }

    private final class StoreCommitEntryProcessor {
        private Entry[] entries = new Entry[1024];
        private int entryCount;
        private int commitQueueSize;
        private long currentTransactionId;

        StoreCommitEntryProcessor() {
            this.createEntries(this.entries, 0);
            this.currentTransactionId = -1L;
        }

        private final void createEntries(Entry[] entries, int from) {
            for (int i = from; i < entries.length; ++i) {
                entries[i] = new Entry();
            }
        }

        final int clear() {
            int ret = this.entryCount;
            if (this.entryCount > 0) {
                for (int i = 0; i < this.entryCount; ++i) {
                    this.entries[i].commitEntry.serializedObject.dispose();
                    this.entries[i].fin();
                }
                this.entryCount = 0;
            }
            return ret;
        }

        final void add(StoreCommitEntrySource commitEntrySource, StoreCommitEntry commitEntry, boolean ackedOnReturn, long postWireTs) {
            if (this.entryCount == this.entries.length) {
                Entry[] newEntries = new Entry[this.entries.length * 2];
                for (int i = 0; i < this.entries.length; ++i) {
                    newEntries[i] = this.entries[i];
                }
                this.createEntries(newEntries, this.entries.length);
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Increased max store transaction commit length from " + this.entries.length + " to " + newEntries.length + ".", Tracer.Level.INFO);
                this.entries = newEntries;
            }
            this.entries[this.entryCount++].init(commitEntrySource, commitEntry, ackedOnReturn, postWireTs);
            if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "...enqueued commit entry.", Tracer.Level.DEBUG);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final long dispatchOne(StoreCommitEntrySource commitEntrySource, StoreCommitEntry commitEntry, boolean ackedOnReturn, long postWireTs) {
            long preDispatchTs;
            long l = preDispatchTs = StoreBindingImpl.this.recordLegLatencies ? UtlTime.now() : 0L;
            if (StoreBindingImpl.this.recordLegLatencies && postWireTs > 0L) {
                StoreBindingImpl.this.stats.w2d.add((double)(preDispatchTs - postWireTs));
            }
            ++StoreBindingImpl.this.stats.numCommitEntriesReceived;
            if (commitEntry.commitEnd) {
                ++StoreBindingImpl.this.stats.numCommitsReceived;
            }
            if (ackedOnReturn) {
                ++StoreBindingImpl.this.stats.numCommitCompletionsSent;
            }
            IStoreObject object = null;
            try {
                if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                    StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "...dispatching commit entry for local application.", Tracer.Level.DEBUG);
                }
                switch (commitEntrySource) {
                    case Persister: {
                        try {
                            object = StoreBindingImpl.this.onInitCommitOrRead(commitEntry);
                        }
                        catch (OdsReferentialIntegrityException e) {
                            StoreBindingImpl.this.handleReferentialIntegrityError(e, "Processing of entry (id=" + commitEntry.oid + ", type=" + (Object)((Object)commitEntry.operation) + ") during initialization from transaction log encountered a referential integrity error (fatal=" + e.isFatal() + ")");
                        }
                        break;
                    }
                    case Initializer: {
                        try {
                            object = StoreBindingImpl.this.onInitOrCommit(commitEntry, preDispatchTs);
                        }
                        catch (OdsReferentialIntegrityException e) {
                            StoreBindingImpl.this.handleReferentialIntegrityError(e, "Processing of entry (id=" + commitEntry.oid + ", type=" + (Object)((Object)commitEntry.operation) + ") during initialization from primary encountered a referential integrity error (fatal=" + e.isFatal() + ")");
                        }
                        break;
                    }
                    case Replicator: 
                    case ICRSender: {
                        object = StoreBindingImpl.this.onInitOrCommit(commitEntry, preDispatchTs);
                        break;
                    }
                    default: {
                        throw new InternalError("unknown commit entry source '" + (Object)((Object)commitEntrySource) + "'");
                    }
                }
                long l2 = StoreBindingImpl.this.recordLegLatencies ? UtlTime.now() : 0L;
                return l2;
            }
            finally {
                if ((commitEntry.operation == IStoreBinding.Operation.Put || commitEntry.operation == IStoreBinding.Operation.Update) && object != null && Config.conserveMemory()) {
                    if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "...compacted committed object's memory.", Tracer.Level.DEBUG);
                    }
                    object.saveMemory();
                }
                commitEntry.fin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final long dispatchAll() {
            try {
                long lastPostProcTs = 0L;
                for (int i = 0; i < this.entryCount; ++i) {
                    Entry entry = this.entries[i];
                    lastPostProcTs = this.dispatchOne(entry.commitEntrySource, entry.commitEntry, entry.ackedOnReturn, entry.postWireTs);
                }
                long l = lastPostProcTs;
                return l;
            }
            finally {
                this.entryCount = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final long process(StoreCommitEntrySource commitEntrySource, StoreCommitEntry commitEntry, boolean ackedOnReturn, long postWireTs) {
            boolean transactionCompletenessAlreadyVerified;
            boolean commitStart = commitEntry.commitStart || this.currentTransactionId != commitEntry.transactionId;
            boolean commitEnd = commitEntry.commitEnd;
            boolean bl = transactionCompletenessAlreadyVerified = commitEntrySource == StoreCommitEntrySource.Persister || commitEntrySource == StoreCommitEntrySource.Initializer;
            if (commitStart) {
                if (transactionCompletenessAlreadyVerified) {
                    if (this.commitQueueSize > 0) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Received successive commit starts from a source that has verified transaction completeness (source=" + (Object)((Object)commitEntrySource) + ", currentTransactionId=" + this.currentTransactionId + ", entryTransactionId=" + commitEntry.transactionId + ", count=" + this.commitQueueSize + ").", Tracer.Level.WARNING);
                        this.commitQueueSize = 0;
                    }
                } else {
                    int incompleteCommitCount = this.clear();
                    if (incompleteCommitCount > 0) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Incomplete transaction commit (source=" + (Object)((Object)commitEntrySource) + ", currentTransactionId=" + this.currentTransactionId + ", entryTransactionId=" + commitEntry.transactionId + ", count=" + incompleteCommitCount + "). Ignored incomplete transaction.", Tracer.Level.WARNING);
                    }
                }
            }
            this.currentTransactionId = commitEntry.transactionId;
            boolean singleEntryTransaction = commitStart && commitEnd;
            try {
                if (transactionCompletenessAlreadyVerified || singleEntryTransaction) {
                    if (singleEntryTransaction) {
                        if (StoreBindingImpl.this.recordLegLatencies) {
                            StoreBindingImpl.this.stats.cqs.add(1.0);
                        }
                        if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                            StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Single entry commit. Dispatching...", Tracer.Level.DEBUG);
                        }
                    } else {
                        ++this.commitQueueSize;
                        if (commitEnd) {
                            if (StoreBindingImpl.this.recordLegLatencies) {
                                StoreBindingImpl.this.stats.cqs.add((double)this.commitQueueSize);
                            }
                            this.commitQueueSize = 0;
                        }
                        if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                            StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Multi-entry commit but commit completeness already verified. Dispatching...", Tracer.Level.DEBUG);
                        }
                    }
                    long l = this.dispatchOne(commitEntrySource, commitEntry, ackedOnReturn, postWireTs);
                    return l;
                }
                if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                    StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Multi-entry entry commit. Enqueuing...", Tracer.Level.DEBUG);
                }
                this.add(commitEntrySource, commitEntry, ackedOnReturn, postWireTs);
                if (commitEnd) {
                    if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Commit complete (count=" + this.entryCount + "). Dispatching...", Tracer.Level.DEBUG);
                    }
                    if (StoreBindingImpl.this.recordLegLatencies) {
                        StoreBindingImpl.this.stats.cqs.add((double)this.entryCount);
                    }
                    long l = this.dispatchAll();
                    return l;
                }
                long l = 0L;
                return l;
            }
            finally {
                if (commitEnd) {
                    this.currentTransactionId = -1L;
                }
            }
        }

        private final class Entry {
            StoreCommitEntrySource commitEntrySource;
            final StoreCommitEntry commitEntry = StoreCommitEntry.create();
            boolean ackedOnReturn;
            long postWireTs;

            private Entry() {
            }

            final void init(StoreCommitEntrySource commitEntrySource, StoreCommitEntry commitEntry, boolean ackedOnReturn, long postWireTs) {
                this.commitEntrySource = commitEntrySource;
                this.commitEntry.init(commitEntry);
                this.ackedOnReturn = ackedOnReturn;
                this.postWireTs = postWireTs;
            }

            final void fin() {
                this.commitEntry.fin();
            }
        }
    }

    private final class StoreCheckpointControllerConflation
    extends StoreCheckpointControllerBase {
        public StoreCheckpointControllerConflation(StoreDescriptor descriptor) {
            super(descriptor);
        }

        @Override
        public boolean onPut() {
            return false;
        }
    }

    private final class StoreCheckpointControllerCDC
    extends StoreCheckpointControllerBase {
        public StoreCheckpointControllerCDC(StoreDescriptor descriptor) {
            super(descriptor);
        }

        @Override
        public boolean onSend() {
            return false;
        }
    }

    private final class StoreCheckpointControllerDefault
    extends StoreCheckpointControllerBase {
        public StoreCheckpointControllerDefault(StoreDescriptor descriptor) {
            super(descriptor);
        }
    }

    private class StoreCheckpointControllerBase
    implements IStoreCheckpointingController {
        private final IStoreCheckpointingController.Type type;
        private final int checkpointThreshold;
        private int checkpointCountdown;
        private long checkpointMaxInterval = -1L;
        private long lastCheckpointTs;

        public StoreCheckpointControllerBase(StoreDescriptor descriptor) {
            this.checkpointCountdown = this.checkpointThreshold = descriptor.getCheckpointThreshold();
            this.checkpointMaxInterval = descriptor.getCheckpointMaxInterval();
            this.type = descriptor.getCheckpointingType();
        }

        protected boolean countdown() {
            --this.checkpointCountdown;
            return true;
        }

        @Override
        public boolean onPut() {
            return this.countdown();
        }

        @Override
        public boolean onRemove() {
            return this.countdown();
        }

        @Override
        public boolean onUpdate() {
            return this.countdown();
        }

        @Override
        public boolean onSend() {
            return this.countdown();
        }

        @Override
        public boolean onCommit() {
            long currentTs = System.currentTimeMillis();
            if (this.lastCheckpointTs == 0L) {
                this.lastCheckpointTs = currentTs;
            }
            return this.checkpointThreshold > 0 && this.checkpointCountdown <= 0 || this.checkpointMaxInterval > 0L && currentTs - this.lastCheckpointTs >= this.checkpointMaxInterval && this.checkpointCountdown < this.checkpointThreshold;
        }

        @Override
        public void onVersionChange() {
            this.checkpointCountdown = this.checkpointThreshold;
            this.lastCheckpointTs = System.currentTimeMillis();
        }

        public String toString() {
            return "[Type=" + (Object)((Object)this.type) + ", threshold=" + this.checkpointThreshold + ", interval=" + this.checkpointMaxInterval + "]";
        }
    }

    private final class PersisterEventHandler
    implements IEventHandler {
        private PersisterEventHandler() {
        }

        public final void onEvent(Event event) {
            if (event instanceof IStoreEvent) {
                if (event instanceof StoreLifecycleEvent) {
                    ((StoreLifecycleEvent)event).setStore(StoreBindingImpl.this);
                }
                StoreBindingImpl.this.onEvent((IStoreEvent)event, ExceptionHandlingPolicy.PassThrough);
            } else {
                StoreBindingImpl.this.tracer.log("Dropping non-store event from persister: " + event, Tracer.Level.WARNING);
                event.dispose();
            }
        }
    }

    private final class Syncer
    extends Thread {
        private volatile boolean done;

        Syncer() {
            this.setDaemon(true);
        }

        final void shutdown() {
            this.done = true;
            this.interrupt();
            while (true) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        @Override
        public final void run() {
            while (!this.done) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (StoreBindingImpl.this.descriptor.getMaxPersistSyncBacklog() > 0 && System.currentTimeMillis() - StoreBindingImpl.this.lastPersisterSyncTime > (long)(StoreBindingImpl.this.descriptor.getMaxPersistSyncBacklog() * 1000)) {
                    try {
                        StoreBindingImpl.this.syncPersister(false);
                    }
                    catch (Throwable e) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Failed to sync store persister [" + e.toString() + "].", Tracer.Level.SEVERE);
                        e.printStackTrace();
                    }
                }
                if (StoreBindingImpl.this.descriptor.getMaxInterClusterReplicationSyncBacklog() <= 0 || System.currentTimeMillis() - StoreBindingImpl.this.lastSenderSyncTime <= (long)(StoreBindingImpl.this.descriptor.getMaxInterClusterReplicationSyncBacklog() * 1000)) continue;
                try {
                    StoreBindingImpl.this.syncSender(false);
                }
                catch (Throwable e) {
                    StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Failed to sync store sender [" + e.toString() + "].", Tracer.Level.SEVERE);
                    e.printStackTrace();
                }
            }
        }
    }

    private final class MemberInitializer
    extends Thread {
        private final XLinkedHashMap<String, IStoreMember> memberQueue;
        private final ReentrantLock initializationSynchronizer;
        private volatile IStoreMember runningMember;
        private volatile boolean closed;

        MemberInitializer() {
            this.setDaemon(true);
            this.memberQueue = new XLinkedHashMap();
            this.initializationSynchronizer = new ReentrantLock(true);
        }

        private final boolean detachedMemberInitializationEnabled() {
            return StoreBindingImpl.this.descriptor.isDetachedMemberInitialization() && StoreBindingImpl.this.replicator != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void initializeMember(IStoreMember member) {
            block17: {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Initializing member '" + member.getName() + "'...", Tracer.Level.INFO);
                try {
                    if (StoreBindingImpl.this.persister != null) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "... disabling packet body desync for transaction log reader...", Tracer.Level.VERBOSE);
                        try (IStoreReader.IterativeReader reader = StoreBindingImpl.this.persister.iterativeReader(0);){
                            StoreCommitEntry commitEntry;
                            if (!this.closed) {
                                StoreBindingImpl.this.replicator.startMemberInit(member, reader.metadata());
                            }
                            long ts = System.currentTimeMillis();
                            PktRecoveryLog.FilePosition lastEntryFilePosition = null;
                            while (!this.closed && (commitEntry = reader.next()) != null) {
                                lastEntryFilePosition = (PktRecoveryLog.FilePosition)commitEntry.serializedObject.getTag(4);
                                StoreBindingImpl.this.replicator.sendMemberInitEntry(member, commitEntry);
                            }
                            long leg1ReadTime = System.currentTimeMillis() - ts;
                            reader.stats().recordReadLegTime(leg1ReadTime);
                            this.initializationSynchronizer.lock();
                            try {
                                StoreBindingImpl.this.persister.flush(true);
                                Thread.sleep(100L);
                                ts = System.currentTimeMillis();
                                int leg2Entries = 0;
                                if (!this.closed) {
                                    reader.seek(lastEntryFilePosition != null ? lastEntryFilePosition.getPosition() + (long)lastEntryFilePosition.getSize() : 0L);
                                }
                                while (!this.closed && (commitEntry = reader.next()) != null) {
                                    ++leg2Entries;
                                    StoreBindingImpl.this.replicator.sendMemberInitEntry(member, commitEntry);
                                }
                                long leg2ReadTime = System.currentTimeMillis() - ts;
                                reader.stats().recordReadLegTime(leg2ReadTime);
                                if (!this.closed) {
                                    StoreBindingImpl.this.replicator.completeMemberInit(member, StoreBindingImpl.this.lastCommittedTransactionId);
                                    StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Member '" + member.getName() + "' initialization complete (entries=" + reader.stats().numEntriesRead() + " (leg2=" + leg2Entries + "), transactions=" + reader.stats().numTransactionsRead() + ", elapsedTime=" + UtlUnit.formatDuration((double)reader.stats().elapsedTime(), (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + ", readTime=" + UtlUnit.formatDuration((double)reader.stats().readTime(), (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + " (leg2=" + leg2ReadTime + "), lastCommittedTransactionId=" + StoreBindingImpl.this.lastCommittedTransactionId + ")...", Tracer.Level.INFO);
                                    StoreBindingImpl.this.onEvent(StoreMemberInitCompleteEvent.create(StoreBindingImpl.this, member, StoreBindingImpl.this.lastCommittedTransactionId), ExceptionHandlingPolicy.TrapAndDiscard);
                                }
                                break block17;
                            }
                            finally {
                                this.initializationSynchronizer.unlock();
                            }
                        }
                    }
                    if (!this.closed) {
                        StoreBindingImpl.this.replicator.startMemberInit(member, null);
                        StoreBindingImpl.this.replicator.completeMemberInit(member, StoreBindingImpl.this.lastCommittedTransactionId);
                        StoreBindingImpl.this.onEvent(StoreMemberInitCompleteEvent.create(StoreBindingImpl.this, member, StoreBindingImpl.this.lastCommittedTransactionId), ExceptionHandlingPolicy.TrapAndDiscard);
                    }
                }
                catch (Throwable e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(StoreBindingImpl.this.getTracePrefix("B") + "Failed to initialize member '" + member.getName() + "' [" + e.toString() + "]").append("\n");
                    sb.append("Stack Trace:").append("\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + sb.toString(), Tracer.Level.SEVERE);
                    try {
                        member.fail(e);
                    }
                    catch (Throwable e1) {
                        sb.setLength(0);
                        sb.append(StoreBindingImpl.this.getTracePrefix("B") + "Failed to fail member '" + member.getName() + "' after failure to initialize member [" + e1.toString() + "]").append("\n");
                        sb.append("Stack Trace:").append("\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e1));
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + sb.toString(), Tracer.Level.WARNING);
                    }
                }
            }
        }

        final void open() {
            if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Opening store member initializer...", Tracer.Level.DEBUG);
            }
            if (this.detachedMemberInitializationEnabled()) {
                if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                    StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Detached member initialization is enabled. Starting detached thread...", Tracer.Level.DEBUG);
                }
                this.setName("X-ODS-MemberInitializer-" + StoreBindingImpl.this.replicator.getStoreName() + "-" + StoreBindingImpl.this.replicator.getMemberName());
                this.start();
            } else if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Detached member initialization is not enabled. Not starting detached thread.", Tracer.Level.DEBUG);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void scheduleOrExecuteMemberInit(IStoreMember member) {
            if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Scheduling member '" + member.getName() + "' for initialization...", Tracer.Level.DEBUG);
            }
            if (!this.closed) {
                if (this.detachedMemberInitializationEnabled()) {
                    if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Detached initialization enabled. Enqueing member for initialization with detached thread..", Tracer.Level.DEBUG);
                    }
                    XLinkedHashMap<String, IStoreMember> xLinkedHashMap = this.memberQueue;
                    synchronized (xLinkedHashMap) {
                        this.memberQueue.put((Object)member.getName(), (Object)member);
                        if (this.runningMember == null) {
                            this.memberQueue.notifyAll();
                        }
                    }
                } else {
                    if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Detached initialization not enabled. Initializing using this thread...", Tracer.Level.DEBUG);
                    }
                    this.initializeMember(member);
                }
            } else if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Ignoring...member initializer has been closed", Tracer.Level.DEBUG);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void unscheduleMemberInit(IDiscoveryEntity entity) {
            String memberName = StoreBindingImpl.this.replicator.entityNameToMemberName(entity.getName());
            if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Unscheduling member '" + memberName + "' initialization...", Tracer.Level.DEBUG);
            }
            if (!this.closed) {
                if (this.detachedMemberInitializationEnabled()) {
                    if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Detached initialization enabled. Removing member from queue...", Tracer.Level.DEBUG);
                    }
                    XLinkedHashMap<String, IStoreMember> xLinkedHashMap = this.memberQueue;
                    synchronized (xLinkedHashMap) {
                        if (this.memberQueue.remove((Object)memberName) == null) {
                            if (this.runningMember != null && memberName.equals(this.runningMember.getName())) {
                                if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                                    StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Member initialization currently in progress.", Tracer.Level.DEBUG);
                                }
                                while (this.runningMember != null && memberName.equals(this.runningMember.getName())) {
                                    try {
                                        if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                                            StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Waiting for member initialization to terminate.", Tracer.Level.DEBUG);
                                        }
                                        this.memberQueue.wait(100L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                                    StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Member initialization done.", Tracer.Level.DEBUG);
                                }
                            } else if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Member not previously enqueued for initialization.", Tracer.Level.DEBUG);
                            }
                        }
                    }
                }
            } else if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Ignoring...member initializer has been closed", Tracer.Level.DEBUG);
            }
        }

        final void onCommitStart() {
            if (this.closed) {
                throw new IllegalStateException("reeived commit start notification after member initializer was closed");
            }
            if (this.detachedMemberInitializationEnabled()) {
                this.initializationSynchronizer.lock();
            }
        }

        final void onCommitEnd() {
            if (this.closed) {
                throw new IllegalStateException("reeived commit start notification after member initializer was closed");
            }
            if (this.detachedMemberInitializationEnabled()) {
                this.initializationSynchronizer.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void close(boolean waitForDetachedThreadToExit) {
            if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Closing store member initializer...", Tracer.Level.DEBUG);
            }
            if (!this.closed) {
                this.closed = true;
                if (this.detachedMemberInitializationEnabled()) {
                    if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Detached initialization enabled. Shutting down detached initializer thread...", Tracer.Level.DEBUG);
                    }
                    XLinkedHashMap<String, IStoreMember> xLinkedHashMap = this.memberQueue;
                    synchronized (xLinkedHashMap) {
                        this.memberQueue.clear();
                        this.memberQueue.notifyAll();
                    }
                } else if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                    StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Detached initialization not enabled. Close done", Tracer.Level.DEBUG);
                }
            } else if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Member initializer already closed.", Tracer.Level.DEBUG);
            }
            if (this.detachedMemberInitializationEnabled()) {
                if (waitForDetachedThreadToExit) {
                    if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Waiting for initializer thread to shut down...", Tracer.Level.DEBUG);
                    }
                    while (true) {
                        try {
                            this.join();
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                    if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                        StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Detached initializer thread has shut down.", Tracer.Level.DEBUG);
                    }
                } else if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                    StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Requested to not wait for initializer thread to shut down.", Tracer.Level.DEBUG);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Detached member initialization thread started.", Tracer.Level.DEBUG);
            }
            UtlThread.setCPUAffinityMask((String)StoreBindingImpl.this.descriptor.getDetachedMemberInitializerCpuAffinityMask());
            while (!this.closed) {
                XLinkedHashMap<String, IStoreMember> xLinkedHashMap = this.memberQueue;
                synchronized (xLinkedHashMap) {
                    this.runningMember = null;
                    while (this.memberQueue.size() == 0 && !this.closed) {
                        try {
                            if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Waiting for member to be queued for initializaton.", Tracer.Level.DEBUG);
                            }
                            this.memberQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.closed) {
                        this.runningMember = (IStoreMember)this.memberQueue.reuseableValueIterator().next();
                        this.memberQueue.remove((Object)this.runningMember.getName());
                        if (((StoreBindingImpl)StoreBindingImpl.this).tracer.debug) {
                            StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Member " + this.runningMember.getName() + " picked up for initialization.", Tracer.Level.DEBUG);
                        }
                    }
                }
                if (this.runningMember == null) continue;
                this.initializeMember(this.runningMember);
            }
        }
    }

    private final class PersisterReadCallbackHandler
    implements IStoreReader.ReadCallback {
        @Override
        public final void metadata(IOElasticBuffer buffer) {
        }

        @Override
        public final boolean entry(StoreCommitEntry commitEntry) {
            StoreBindingImpl.this.commitEntryProcessor.process(StoreCommitEntrySource.Persister, commitEntry, false, 0L);
            return true;
        }

        @Override
        public final void done(long lastTransactionId) {
            int incompleteCommitCount;
            if (lastTransactionId >= 0L) {
                StoreBindingImpl.this.lastCommittedTransactionId = lastTransactionId;
            }
            if ((incompleteCommitCount = StoreBindingImpl.this.commitEntryProcessor.clear()) > 0) {
                StoreBindingImpl.this.tracer.log(StoreBindingImpl.this.getTracePrefix("B") + "Incomplete transaction commit at end of store initialization from log (count=" + incompleteCommitCount + "). Ignored incomplete transaction.", Tracer.Level.WARNING);
            }
        }
    }

    private final class ReceiverCommitEntryHandler
    implements StoreReceiver.StoreCommitEntryHandler {
        private ReceiverCommitEntryHandler() {
        }

        @Override
        public final void onEntry(StoreCommitEntry commitEntry) {
            StoreBindingImpl.this.onCommitEntry(StoreCommitEntrySource.ICRSender, commitEntry, false, 0L);
        }
    }

    private final class SenderReceiverErrorHandler
    implements StoreSenderReceiver.ErrorHandler {
        private SenderReceiverErrorHandler() {
        }

        @Override
        public final void onError(Exception cause) {
            StoreBindingImpl.this.fail(cause);
        }
    }

    private final class PersisterErrorHandler
    implements IStorePersister.ErrorHandler {
        private PersisterErrorHandler() {
        }

        @Override
        public final void onError(Exception cause) {
            StoreBindingImpl.this.fail(cause);
        }
    }

    private final class StandaloneMember
    implements IStoreMember {
        private StandaloneMember() {
        }

        @Override
        public final String getName() {
            return StoreBindingImpl.this.memberName;
        }

        @Override
        public final IStoreBinding.Role getRole() {
            return null;
        }

        @Override
        public final StoreMemberReplicationStatus createReplicationStatus() {
            return new StoreMemberReplicationStatus(this);
        }

        @Override
        public final void fail(Throwable cause) {
        }
    }
}

