/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import com.neeve.config.Config;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public final class StoreObjectFactoryDescriptor
extends OdsObject {
    private final String name;
    private final short id;
    private final String className;

    private StoreObjectFactoryDescriptor(String name, short id, String className) {
        super(null);
        this.name = name;
        this.id = id;
        this.className = className;
    }

    public final String getName() {
        return this.name;
    }

    public final short getId() {
        return this.id;
    }

    public final String getClassName() {
        return this.className;
    }

    public final void save(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/ods/objectfactories");
            if (container == null) {
                container = repo.createSimpleEntityContainer("/ods/objectfactories");
            }
            if ((entity = (IConfigSimpleEntity)container.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)container.createEntity(this.name);
            }
            entity.setProperties(null);
            entity.setProperty("Id", String.valueOf(this.getId()));
            entity.setProperty("Name", this.getName());
            entity.setProperty("Class", this.getClassName());
        }
        catch (EConfigException e) {
            throw new OdsException(e);
        }
    }

    public final void save() throws OdsException {
        this.save(Config.getRepository());
    }

    public final void delete(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/ods/objectfactories");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final String toString() {
        return "(" + this.name + ", " + this.id + ", '" + this.className + ")";
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("object factory name cannot be null");
        }
        return repo.getSimpleEntity("/ods/objectfactories/" + name) != null;
    }

    public static boolean exists(String name) {
        return StoreObjectFactoryDescriptor.exists(Config.getRepository(), name);
    }

    public static StoreObjectFactoryDescriptor create(String name, short id, String className) {
        if (name == null) {
            throw new IllegalArgumentException("factory name cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("factory class name cannot be null");
        }
        return new StoreObjectFactoryDescriptor(name, id, className);
    }

    public static StoreObjectFactoryDescriptor load(IConfigRepository repo, String name) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("factory name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/ods/objectfactories/" + name);
        if (entity != null) {
            short id = (short)UtlProps.getValue((Properties)entity.getProperties(), (String)"Id", (int)0);
            if (id == 0) {
                throw new OdsException("Invalid object factory configuration [Missing or invalid value for 'Id']");
            }
            String className = entity.getProperty("Class", null);
            if (className == null) {
                throw new OdsException("Invalid object factory configuration [Missing 'Class' property]");
            }
            return StoreObjectFactoryDescriptor.create(name, id, className);
        }
        throw new OdsException("Object factory '" + name + "' not found in repository");
    }

    public static StoreObjectFactoryDescriptor load(String name) throws OdsException {
        return StoreObjectFactoryDescriptor.load(Config.getRepository(), name);
    }

    public static Map<Short, StoreObjectFactoryDescriptor> loadAll(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashMap<Short, StoreObjectFactoryDescriptor> factories = new LinkedHashMap<Short, StoreObjectFactoryDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/ods/objectfactories");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    StoreObjectFactoryDescriptor descriptor = StoreObjectFactoryDescriptor.load(repo, entity.getName());
                    StoreObjectFactoryDescriptor existingDescriptor = factories.put(descriptor.getId(), descriptor);
                    if (existingDescriptor == null) continue;
                    descriptor.getTracer().log("ODS object factory '" + descriptor.getName() + "' uses the same id as object factory '" + existingDescriptor.getName() + "' [id=" + descriptor.getId() + "]. Using object factory '" + descriptor.getName() + "'...", Tracer.Level.WARNING);
                }
                catch (OdsException e) {
                    throw new OdsException("Failure in loading descriptor for object factory '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return factories;
    }

    public static Map<Short, StoreObjectFactoryDescriptor> loadAll() throws OdsException {
        return StoreObjectFactoryDescriptor.loadAll(Config.getRepository());
    }
}

