/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl.loopback;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageChannelBase;
import com.neeve.sma.impl.loopback.LoopbackMessageBusBinding;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlTime;

public final class LoopbackMessageChannel
extends MessageChannelBase {
    private final LoopbackMessageBusBinding binding;
    private final XString sendTopicBuilder = XString.create();
    private String[] filters;

    LoopbackMessageChannel(MessageChannelDescriptor descriptor, LoopbackMessageBusBinding binding) throws SmaException {
        super(null, descriptor, binding);
        this.binding = binding;
    }

    private final void subscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        String topic;
        String string = filter == null ? this.getName() : (topic = topicStartsWithChannel ? this.getName() + "/" + filter : filter);
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Subscribing to '" + topic + "'...", Tracer.Level.DEBUG);
        }
        this.binding.subscribe(topic);
    }

    private final void unsubscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        String topic;
        String string = filter == null ? this.getName() : (topic = topicStartsWithChannel ? this.getName() + "/" + filter : filter);
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Unsubscribing from '" + topic + "'...", Tracer.Level.DEBUG);
        }
        this.binding.unsubscribe(topic);
    }

    final void onMessage(long sno, Object message, MessageMetadata metadata, boolean ackRequired, XString topic, long sendTs, long preWireTs, long postWireTs) {
        Object smaMessage;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received message (sno=" + sno + ") is " + message + ". Metadata is " + (Object)((Object)metadata), Tracer.Level.DEBUG);
        }
        long preDeserializeTs = MessageLatencyManager.recordMsgLegWaypoints ? UtlTime.now() : 0L;
        MessageWaypointListenerRegistry.dispatch(MessageWaypointListener.Waypoint.d1, MessageWaypointListener.MessagingDirection.Inbound, message);
        switch (metadata.getMessageEncodingType()) {
            case 1: {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is CUSTOM. Dispatching as is...", Tracer.Level.DEBUG);
                }
                smaMessage = message != null ? ((IOBuffer)message).getBufferUnsafe() : null;
                break;
            }
            case 6: {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is QUARK. Dispatching as is...", Tracer.Level.DEBUG);
                }
                smaMessage = message != null ? ((IOBuffer)message).getBufferUnsafe() : null;
                break;
            }
            case 3: {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is XBUF. Dispatching as is...", Tracer.Level.DEBUG);
                }
                smaMessage = message != null ? ((IOBuffer)message).getBufferUnsafe() : null;
                break;
            }
            case 7: {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is XBUF2. Dispatching as is...", Tracer.Level.DEBUG);
                }
                smaMessage = message != null ? ((IOBuffer)message).getBufferUnsafe() : null;
                break;
            }
            case 4: {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is PROTOBUF. Dispatching as is...", Tracer.Level.DEBUG);
                }
                smaMessage = message != null ? ((IOBuffer)message).getBufferUnsafe() : null;
                break;
            }
            case 5: {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Encoding type is JSON. Dispatching as is...", Tracer.Level.DEBUG);
                }
                smaMessage = message;
                if (!(message instanceof String) || !this.tracer.debug) break;
                this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + (String)message, Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                break;
            }
            default: {
                throw new RuntimeException("unknown encoding type: " + metadata.getMessageEncodingType());
            }
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Dispatching...", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... Timestamps {", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... ...preDeserialize=" + preDeserializeTs, Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... }", Tracer.Level.DEBUG);
        }
        this.onMessage(smaMessage, null, metadata.getMessageViewFactory(), metadata.getMessageViewType(), metadata.getMessageEncodingType(), metadata.getMessageSender(), metadata.getMessageFlow(), metadata.getMessageSno(), metadata.getRequestId(), metadata.getRequestorIdAsRaw(), topic, ackRequired ? this.binding.createAcknowledger(sno) : null, sendTs, preWireTs, postWireTs, preDeserializeTs);
        metadata.dispose();
        if (message instanceof IOBuffer) {
            ((IOBuffer)message).dispose();
        }
    }

    final void onPublishComplete(MessageView view, MessageMetadata metadata, Exception status) {
        if (this.tracer.debug) {
            if (status == null) {
                this.tracer.log(this.tracePrefix + "Publish for sno=" + metadata.getMessageSno() + " positively acknowledged", Tracer.Level.DEBUG);
            } else {
                this.tracer.log(this.tracePrefix + "Publish for sno=" + metadata.getMessageSno() + " negatively acknowledged (status=" + status + ").", Tracer.Level.DEBUG);
            }
        }
        metadata.dispose();
        this.onMessageStability(view, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean doSend(MessageView view, int flags) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received request to send message...", Tracer.Level.DEBUG);
        }
        if (this.binding.rawMode()) {
            throw new UnsupportedOperationException("the loopback bus does not support raw mode operation");
        }
        MessageWaypointListenerRegistry.dispatch(MessageWaypointListener.Waypoint.s1, MessageWaypointListener.MessagingDirection.Outbound, view);
        if (MessageLatencyManager.recordMsgLegWaypoints) {
            view.setPreSerializeTs(UtlTime.now());
        }
        IOBuffer serializedMessage = null;
        MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
        try {
            Object messageToSend;
            switch (this.binding.getMetadataVersion()) {
                case 2: {
                    metadata.serializeV2((byte)view.getMessageEncodingType(), view.getVfid(), view.getMessageType(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw());
                    break;
                }
                case 3: {
                    metadata.serializeV3((byte)view.getMessageEncodingType(), view.getVfid(), view.getMessageType(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw(), view.getRequestId(), view.getRequestorIdAsRaw());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported metadata version [" + this.binding.getMetadataVersion() + "]");
                }
            }
            switch (view.getMessageEncodingType()) {
                case 1: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is CUSTOM.", Tracer.Level.DEBUG);
                    }
                    if (this.binding.serializeMessages()) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "...serializing...", Tracer.Level.DEBUG);
                        }
                        serializedMessage = view.serializeToIOBuffer(true);
                        messageToSend = serializedMessage;
                        break;
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...not serializing...", Tracer.Level.DEBUG);
                    }
                    messageToSend = view.getMessage();
                    break;
                }
                case 6: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is QUARK.", Tracer.Level.DEBUG);
                    }
                    if (this.binding.serializeMessages()) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "...serializing...", Tracer.Level.DEBUG);
                        }
                        serializedMessage = view.serializeToIOBuffer(true);
                        messageToSend = serializedMessage;
                        break;
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...not serializing...", Tracer.Level.DEBUG);
                    }
                    messageToSend = view.getMessage();
                    break;
                }
                case 3: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is XBUF.", Tracer.Level.DEBUG);
                    }
                    if (this.binding.serializeMessages()) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "...serializing...", Tracer.Level.DEBUG);
                        }
                        serializedMessage = view.serializeToIOBuffer(true);
                        messageToSend = serializedMessage;
                        break;
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...not serializing...", Tracer.Level.DEBUG);
                    }
                    messageToSend = view.getMessage();
                    break;
                }
                case 7: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is XBUF2.", Tracer.Level.DEBUG);
                    }
                    if (this.binding.serializeMessages()) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "...serializing...", Tracer.Level.DEBUG);
                        }
                        serializedMessage = view.serializeToIOBuffer(true);
                        messageToSend = serializedMessage;
                        break;
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...not serializing...", Tracer.Level.DEBUG);
                    }
                    messageToSend = view.getMessage();
                    break;
                }
                case 4: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is PROTOBUF.", Tracer.Level.DEBUG);
                    }
                    if (this.binding.serializeMessages()) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "...serializing...", Tracer.Level.DEBUG);
                        }
                        serializedMessage = view.serializeToIOBuffer(true);
                        messageToSend = serializedMessage;
                        break;
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...not serializing...", Tracer.Level.DEBUG);
                    }
                    messageToSend = view.getMessage();
                    break;
                }
                case 5: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is JSON.", Tracer.Level.DEBUG);
                    }
                    messageToSend = view.getMessage();
                    break;
                }
                default: {
                    throw new SmaException("unsupported encoding type '" + view.getMessageEncodingType() + "'");
                }
            }
            XString key = view.getMessageKeyAsRaw();
            boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
            if (key == null && !topicStartsWithChannel) {
                throw new SmaException("send performed with null key but binding configured to not prepend topic with channel");
            }
            XString topic = this.resolveSendTopic(key, topicStartsWithChannel);
            if (MessageLatencyManager.recordMsgLegWaypoints) {
                view.setPostSerializeTs(UtlTime.now());
            }
            MessageWaypointListenerRegistry.dispatch(MessageWaypointListener.Waypoint.s2, MessageWaypointListener.MessagingDirection.Outbound, view);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Publishing message. Message is " + messageToSend + ", metadata is " + (Object)((Object)metadata) + ", topic is '" + topic + "'", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... Timestamps {", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... ...preSerialize=" + view.getPreSerializeTs(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... ...postSerialize=" + view.getPostSerializeTs(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... }", Tracer.Level.DEBUG);
                if (messageToSend instanceof IOBuffer) {
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + ((IOBuffer)messageToSend).toString(), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                } else {
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + messageToSend, Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                }
            }
            this.binding.publish(this, topic, view, messageToSend, metadata);
        }
        finally {
            if (serializedMessage != null) {
                serializedMessage.dispose();
            }
            metadata.dispose();
        }
        return true;
    }

    private final XString resolveSendTopic(XString keyOrFilter, boolean topicStartsWithChannel) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Constructing topic using [keyOrFilter=" + keyOrFilter + ", topicStartsWithChannel=" + topicStartsWithChannel + "]...", Tracer.Level.DEBUG);
        }
        if (keyOrFilter == null || keyOrFilter.length() == 0) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...keyOrFilter is null. using static topic", Tracer.Level.DEBUG);
            }
            return this.getNameAsRaw();
        }
        if (topicStartsWithChannel) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...keyOrFilter is not null and topic starts with channel. preparing topic...", Tracer.Level.DEBUG);
            }
            this.sendTopicBuilder.clear(false);
            this.sendTopicBuilder.append((CharSequence)this.descriptor.getName()).append((CharSequence)"/").append(keyOrFilter);
            return this.sendTopicBuilder;
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...keyOrFilter is not null and topic does not starts with channel. using keyOrFilter as topic...", Tracer.Level.DEBUG);
        }
        return keyOrFilter;
    }

    @Override
    protected final void doJoin(String[] filters, int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(filters != null && filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("join performed with null filter but binding configured to not prepend subscription with channel");
        }
        if (filters == null || filters.length == 0) {
            this.subscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : filters) {
                this.subscribe(filter, topicStartsWithChannel);
            }
        }
        this.filters = filters;
    }

    @Override
    protected final void doLeave(int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(this.filters != null && this.filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("leave performed with null filter but binding configured to not prepend subscription with channel");
        }
        if (this.filters == null || this.filters.length == 0) {
            this.unsubscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : this.filters) {
                this.unsubscribe(filter, topicStartsWithChannel);
            }
        }
    }

    @Override
    protected final void doClose() throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Closing channel...", Tracer.Level.DEBUG);
        }
    }

    @Override
    public final String getType() {
        return "Loopback";
    }
}

