/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl;

import com.neeve.event.IEventHandler;
import com.neeve.root.RootConfig;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessagingProvider;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.sma.impl.MessageChannelKeyNormalizer;
import com.neeve.trace.Tracer;
import java.util.Properties;

public abstract class MessagingProviderBase
extends SmaObject
implements MessagingProvider {
    protected final String name;
    protected final Properties props;

    protected MessagingProviderBase(RootConfig.ObjectConfig config, String name, Properties props) {
        super(config);
        this.name = name;
        this.props = props;
    }

    public abstract MessageBusBinding doCreateBinding(String var1, MessageBusDescriptor var2, IEventHandler var3) throws SmaException;

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final MessageBusBinding createMessageBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        if (userName == null) {
            throw new IllegalArgumentException("user name cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        if (eventHandler == null) {
            this.tracer.log("[MsgProvider," + this.name + "]  No event handler supplied for binding to bus '" + descriptor.getName() + "'.", Tracer.Level.WARNING);
        }
        return this.doCreateBinding(userName, descriptor, eventHandler);
    }

    public MessageChannelKeyNormalizer createMessageChannelKeyNormalizer(MessageChannelDescriptor channelDescriptor) {
        return null;
    }
}

