/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.config.Config;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigComplexEntity;
import com.neeve.config.IConfigComplexEntityContainer;
import com.neeve.config.IConfigRepository;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.sma.SmaPermanentException;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public final class MessageBusDescriptor
extends SmaObject {
    private final String name;
    private final LinkedHashMap<String, MessageChannelDescriptor> channels;
    private volatile Properties providerConfig;
    public static final String PROPNAME_PROVIDER_NAME = "Provider";
    public static final String PROPNAME_ADDRESS = "Address";
    public static final String PROPNAME_METADATA_VERSION = "sma_metadata_version";
    public static final int PROPNAME_METADATA_VERSION_DEFAULT = 2;
    public static final String PROPNAME_SET_FLOW_ON_RECEIPT = "set_flow_on_receipt";
    public static final boolean PROPNAME_SET_FLOW_ON_RECEIPT_DEFAULT = false;
    public static final String PROPNAME_SET_SNO_ON_RECEIPT = "set_sno_on_receipt";
    public static final boolean PROPNAME_SET_SNO_ON_RECEIPT_DEFAULT = true;
    public static final String PROPNAME_SET_BUS_AND_CHANNEL_ON_RECEIPT = "set_bus_and_channel_on_receipt";
    public static final boolean PROPNAME_SET_BUS_AND_CHANNEL_ON_RECEIPT_DEFAULT = false;
    public static final String PROPNAME_SET_KEY_ON_RECEIPT = "set_key_on_receipt";
    public static final boolean PROPNAME_SET_KEY_ON_RECEIPT_DEFAULT = false;
    public static final String PROPNAME_ENABLE_INBOUND_TRANSPORT_HEADERS = "enable_inbound_transport_headers";
    public static final boolean PROPNAME_ENABLE_INBOUND_TRANSPORT_HEADERS_DEFAULT = false;
    public static final String PROPNAME_ENABLE_CONCURRENT_SENDS = "enable_concurrent_sends";
    public static final boolean PROPNAME_ENABLE_CONCURRENT_SENDS_DEFAULT = false;
    public static final String PROPNAME_TOPIC_STARTS_WITH_CHANNEL = "topic_starts_with_channel";
    public static final boolean PROPNAME_TOPIC_STARTS_WITH_CHANNEL_DEFAULT = true;
    public static final String PROPNAME_AUTO_ADD_CATCHALL_CHANNEL = "auto_add_catchall_channel";
    public static final boolean PROPNAME_AUTO_ADD_CATCHALL_CHANNEL_DEFAULT = false;
    public static final String PROPNAME_RAW_MODE = "raw_mode";
    public static final boolean PROPNAME_RAW_MODE_DEFAULT = false;
    public static final String PROPNAME_ADDITIONAL_PROPERTIES_FILE = "additional_properties_file";
    public static final String CATCH_ALL_CHANNEL_NAME = "_CATCHALL_";
    public static final short CATCH_ALL_CHANNEL_ID = Short.MAX_VALUE;

    private MessageBusDescriptor(String name) {
        super(null);
        this.name = name;
        this.channels = new LinkedHashMap();
        this.providerConfig = new Properties();
    }

    public final String getName() {
        return this.name;
    }

    public final MessageBusDescriptor setProviderConfig(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("property set cannot be null");
        }
        this.providerConfig.clear();
        this.providerConfig.putAll((Map<?, ?>)props);
        return this;
    }

    public final MessageBusDescriptor setProviderConfigProperty(String propName, String propVal) throws SmaException {
        this.getProviderConfig().setProperty(propName, propVal);
        return this;
    }

    public final MessageBusDescriptor setProviderConfig(String descriptorStr) throws SmaException {
        try {
            UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse((String)descriptorStr, null);
            this.providerConfig.setProperty(PROPNAME_PROVIDER_NAME, descriptor.type);
            this.providerConfig.setProperty(PROPNAME_ADDRESS, descriptor.address);
            this.providerConfig.putAll((Map<?, ?>)descriptor.props);
        }
        catch (Exception e) {
            throw new SmaException(e);
        }
        return this;
    }

    public final UtlAddressDescriptor getProviderConfigAsAddressDescriptor() throws SmaException {
        HashMap<String, String> props = new HashMap<String, String>();
        for (String name : this.providerConfig.stringPropertyNames()) {
            String value = this.providerConfig.getProperty(name);
            props.put(name, value);
        }
        String provider = (String)props.get(PROPNAME_PROVIDER_NAME);
        if (provider != null) {
            String address = (String)props.get(PROPNAME_ADDRESS);
            if (address != null) {
                props.remove(PROPNAME_PROVIDER_NAME);
                props.remove(PROPNAME_ADDRESS);
                return UtlAddressDescriptor.parse((String)(provider + "://" + address), props);
            }
            throw new SmaException("Invalid provider configuration [missing 'Address' property]");
        }
        throw new SmaException("Invalid provider configuration [missing 'Provider' property]");
    }

    public final Properties getProviderConfig() {
        return this.providerConfig;
    }

    public final Properties loadAdditionalPropertiesFile() throws SmaException {
        Properties retVal = new Properties();
        String additionalPropsPath = UtlProps.getValue((Properties)this.getProviderConfig(), (String)PROPNAME_ADDITIONAL_PROPERTIES_FILE);
        if (additionalPropsPath != null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(additionalPropsPath);
                retVal.load(is);
                this.getProviderConfig().putAll((Map<?, ?>)retVal);
            }
            catch (FileNotFoundException e) {
                throw new SmaPermanentException("'additional_properties_file' file was not found [" + additionalPropsPath + "]", e);
            }
            catch (IOException e) {
                throw new SmaException("'additional_properties_file' file could not be loaded [" + additionalPropsPath + "']", e);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        throw new SmaException("Unable to close additional Properties file '[" + additionalPropsPath + "']", e);
                    }
                }
            }
        }
        return retVal;
    }

    public final boolean configuredToAutoAddCatchallChannel() {
        return UtlProps.getValue((Properties)this.getProviderConfig(), (String)PROPNAME_AUTO_ADD_CATCHALL_CHANNEL, (boolean)false) || UtlProps.getValue((Properties)this.getProviderConfig(), (String)PROPNAME_RAW_MODE, (boolean)false);
    }

    public final void createAutoCreatedChannels() {
        if (this.configuredToAutoAddCatchallChannel()) {
            boolean catchallChannelExists = false;
            for (MessageChannelDescriptor channelDescriptor : this.getChannels()) {
                if (channelDescriptor.getChannelId() != Short.MAX_VALUE) continue;
                catchallChannelExists = true;
                break;
            }
            if (!catchallChannelExists) {
                MessageChannelDescriptor catchallChannelDescriptor = MessageChannelDescriptor.create(CATCH_ALL_CHANNEL_NAME, this);
                catchallChannelDescriptor.setChannelId((short)Short.MAX_VALUE);
                this.addChannel(catchallChannelDescriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageBusDescriptor addChannel(MessageChannelDescriptor channelDescriptor) {
        if (channelDescriptor.getParent() != this) {
            throw new IllegalArgumentException("cannot add channel [channel belong to a different bus '" + channelDescriptor.getParent().getName() + "']");
        }
        LinkedHashMap<String, MessageChannelDescriptor> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            this.channels.put(channelDescriptor.getName(), channelDescriptor);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageChannelDescriptor getChannel(String channelName) {
        LinkedHashMap<String, MessageChannelDescriptor> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            return this.channels.get(MessageChannelDescriptor.normalizeChannelName(channelName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<MessageChannelDescriptor> getChannels() {
        LinkedHashMap<String, MessageChannelDescriptor> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            Iterator<MessageChannelDescriptor> iterator = this.channels.values().iterator();
            LinkedHashSet<MessageChannelDescriptor> retval = new LinkedHashSet<MessageChannelDescriptor>();
            while (iterator.hasNext()) {
                retval.add(iterator.next());
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getChannelCount() {
        LinkedHashMap<String, MessageChannelDescriptor> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            return this.channels.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChannel(String channelName) {
        LinkedHashMap<String, MessageChannelDescriptor> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            this.channels.remove(MessageChannelDescriptor.normalizeChannelName(channelName));
        }
    }

    public final Properties save(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("props cannot be null");
        }
        Iterator<MessageChannelDescriptor> iterator = this.getChannels().iterator();
        String s = "";
        while (iterator.hasNext()) {
            s = s + iterator.next().getName();
            if (!iterator.hasNext()) continue;
            s = s + ",";
        }
        props.setProperty("Channels", s);
        return props;
    }

    public final void save(IConfigRepository repo, String userName) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigComplexEntity entity;
            String busContainerAddr = "/sma/buses";
            IConfigComplexEntityContainer busContainer = repo.getComplexEntityContainer("/sma/buses");
            if (busContainer == null) {
                busContainer = repo.createComplexEntityContainer("/sma/buses");
            }
            if ((entity = (IConfigComplexEntity)busContainer.getEntity(this.name)) == null) {
                entity = (IConfigComplexEntity)busContainer.createEntity(this.name);
            }
            entity.setProperties("bus.properties", null).setProperties("bus.properties", this.save(new Properties()));
            entity.setProperties("provider.config", null).setProperties("provider.config", this.getProviderConfig());
            String channelContainerAddr = "/sma/buses/" + this.name + "/channels";
            IConfigComplexEntityContainer channelContainer = repo.getComplexEntityContainer(channelContainerAddr);
            if (channelContainer == null) {
                channelContainer = repo.createComplexEntityContainer(channelContainerAddr);
            }
            Iterator<MessageChannelDescriptor> iterator = this.getChannels().iterator();
            while (iterator.hasNext()) {
                iterator.next().save(repo, userName);
            }
        }
        catch (EConfigException e) {
            throw new SmaException(e);
        }
    }

    public final void save(String userName) throws SmaException {
        this.save(Config.getRepository(), userName);
    }

    public final void save() throws SmaException {
        this.save((String)null);
    }

    public final void delete(IConfigRepository repo) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        Iterator<MessageChannelDescriptor> iterator = MessageChannelDescriptor.loadAll(repo, this, null).iterator();
        while (iterator.hasNext()) {
            iterator.next().delete(repo);
        }
        repo.removeComplexEntityContainer("/sma/buses/" + this.name + "/channels");
        IConfigComplexEntityContainer busContainer = repo.getComplexEntityContainer("/sma/buses");
        if (busContainer != null) {
            busContainer.removeEntity(this.name);
        }
    }

    public final void delete() throws SmaException {
        this.delete(Config.getRepository());
    }

    public final String toString() {
        try {
            return "(name=" + this.name + ", channelcount=" + this.getChannelCount() + ", providerconfig=" + this.getProviderConfigAsAddressDescriptor().toPasswordSanitizedFullString() + ")";
        }
        catch (SmaException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean exists(IConfigRepository repo, String busName) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        return repo.getComplexEntity("/sma/buses/" + busName) != null;
    }

    public static boolean exists(String busName) {
        return MessageBusDescriptor.exists(Config.getRepository(), busName);
    }

    public static MessageBusDescriptor create(String name) {
        if (name == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        if (name.contains("\\")) {
            throw new IllegalArgumentException("bus name cannot contain '\\'");
        }
        if (name.contains("/")) {
            throw new IllegalArgumentException("bus name cannot contain '/'");
        }
        return new MessageBusDescriptor(name);
    }

    public static MessageBusDescriptor load(IConfigRepository repo, String name, String userName) throws SmaException {
        IConfigComplexEntity entity;
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        MessageBusDescriptor busDescriptor = MessageBusDescriptor.create(name);
        Tracer tracer = busDescriptor.getTracer();
        if (tracer.debug) {
            tracer.log("[BusDescriptor," + name + "] Loading bus descriptor for bus '" + name + "' from repository...", Tracer.Level.DEBUG);
        }
        if ((entity = repo.getComplexEntity("/sma/buses/" + name)) != null) {
            Properties providerConfigProps;
            Properties busProps = entity.getProperties("bus.properties");
            if (busProps == null) {
                busProps = new Properties();
            }
            if (tracer.debug) {
                tracer.log("[BusDescriptor," + name + "] Bus properties=" + busProps.toString(), Tracer.Level.DEBUG);
            }
            if ((providerConfigProps = entity.getProperties("provider.config")) == null) {
                providerConfigProps = new Properties();
            }
            if (tracer.debug) {
                tracer.log("[BusDescriptor," + name + "] Provider config=" + providerConfigProps.toString(), Tracer.Level.DEBUG);
            }
            busDescriptor.setProviderConfig((Properties)providerConfigProps.clone());
            String channelList = busProps.getProperty("Channels", "");
            StringTokenizer tokenizer = new StringTokenizer(channelList, ",");
            if (tokenizer.hasMoreTokens()) {
                if (tracer.debug) {
                    tracer.log("[BusDescriptor," + name + "] Channel list={" + channelList + "}", Tracer.Level.DEBUG);
                }
                while (tokenizer.hasMoreTokens()) {
                    String channelName = tokenizer.nextToken().trim();
                    busDescriptor.addChannel(MessageChannelDescriptor.load(repo, busDescriptor, channelName, userName));
                }
            } else if (tracer.debug) {
                tracer.log("[BusDescriptor," + name + "] No channels configured", Tracer.Level.DEBUG);
            }
        } else {
            throw new SmaException("Message bus '" + name + "' not found in repository");
        }
        return busDescriptor;
    }

    public static MessageBusDescriptor load(String name, String userName) throws SmaException {
        return MessageBusDescriptor.load(Config.getRepository(), name, userName);
    }

    public static MessageBusDescriptor load(String name) throws SmaException {
        return MessageBusDescriptor.load(name, null);
    }

    public static Set<MessageBusDescriptor> loadAll(IConfigRepository repo, String userName) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<MessageBusDescriptor> buses = new LinkedHashSet<MessageBusDescriptor>();
        IConfigComplexEntityContainer container = repo.getComplexEntityContainer("/sma/buses");
        if (container != null) {
            for (IConfigComplexEntity entity : container) {
                try {
                    buses.add(MessageBusDescriptor.load(repo, entity.getName(), userName));
                }
                catch (SmaException e) {
                    throw new SmaException("Failure in loading descriptor for bus '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return buses;
    }

    public static Set<MessageBusDescriptor> loadAll(String userName) throws SmaException {
        return MessageBusDescriptor.loadAll(Config.getRepository(), userName);
    }

    public static Set<MessageBusDescriptor> loadAll() throws SmaException {
        return MessageBusDescriptor.loadAll(null);
    }
}

