/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ddl;

import com.neeve.config.Config;
import com.neeve.ddl.DdlConfigNode;
import com.neeve.util.UtlTailoring;
import com.neeve.util.UtlTailoringCore;
import java.util.Map;
import java.util.TreeMap;

public class DdlConfigTree
extends DdlConfigNode {
    private Map<String, DdlConfigNode> values = new TreeMap<String, DdlConfigNode>();
    private final UtlTailoring.PropertySource overrides;
    final String xConfigRoot = Config.getValue((String)"nv.ddl.prefix", (String)"x");
    private final UtlTailoring.PropertySource substitutionValues = new UtlTailoring.PropertySource(){

        public String getValue(String key, String defaultValue) {
            String value;
            String string = value = DdlConfigTree.this.overrides != null ? DdlConfigTree.this.overrides.getValue(key, null) : null;
            if (value == null) {
                DdlConfigNode node = (DdlConfigNode)DdlConfigTree.this.values.get(key);
                if (node == null) {
                    value = defaultValue;
                } else {
                    value = node.getUnsubstitutedValue();
                    if (value == null) {
                        value = defaultValue;
                    }
                }
            }
            return value;
        }
    };

    public DdlConfigTree(UtlTailoring.PropertySource overrides) {
        super(null, null, null, null);
        this.overrides = overrides;
    }

    @Override
    public DdlConfigNode get(String key) {
        return this.values.get(key);
    }

    String overrideProperty(String name, String value) {
        String string = value = this.overrides != null && name != null ? this.overrides.getValue(name, value) : value;
        if (value != null) {
            try {
                String[] nameParts;
                if (name.endsWith(".key") && "buses".equals((nameParts = DdlConfigTree.toPath(name))[1]) && "channels".equals(nameParts[3])) {
                    return value;
                }
                value = UtlTailoring.springScanAndReplace((String)value, (UtlTailoring.PropertySource)this.substitutionValues);
            }
            catch (UtlTailoringCore.TailoringException e) {
                throw new RuntimeException("Error substituting ddl property '" + name + "' from unsubsituted value of '" + value + ": " + e.getMessage(), e);
            }
        }
        return value;
    }

    public void onNodeAdded(DdlConfigNode node) {
        this.values.put(node.getFullName(), node);
    }

    public void onNodeRemoved(DdlConfigNode node) {
        this.values.remove(node.getFullName());
    }
}

