/*
 * Decompiled with CFR 0.152.
 */
package vanilla.java.affinity;

import vanilla.java.affinity.AffinityLock;
import vanilla.java.affinity.AffinityStrategy;
import vanilla.java.affinity.CpuLayout;

public enum AffinityStrategies implements AffinityStrategy
{
    ANY{

        @Override
        public boolean matches(int cpuId, int cpuId2) {
            return true;
        }
    }
    ,
    SAME_CORE{

        @Override
        public boolean matches(int cpuId, int cpuId2) {
            CpuLayout cpuLayout = AffinityLock.cpuLayout();
            return cpuLayout.socketId(cpuId) == cpuLayout.socketId(cpuId2) && cpuLayout.coreId(cpuId) == cpuLayout.coreId(cpuId2);
        }
    }
    ,
    SAME_SOCKET{

        @Override
        public boolean matches(int cpuId, int cpuId2) {
            CpuLayout cpuLayout = AffinityLock.cpuLayout();
            return cpuLayout.socketId(cpuId) == cpuLayout.socketId(cpuId2) && cpuLayout.coreId(cpuId) != cpuLayout.coreId(cpuId2);
        }
    }
    ,
    DIFFERENT_CORE{

        @Override
        public boolean matches(int cpuId, int cpuId2) {
            CpuLayout cpuLayout = AffinityLock.cpuLayout();
            return cpuLayout.socketId(cpuId) != cpuLayout.socketId(cpuId2) || cpuLayout.coreId(cpuId) != cpuLayout.coreId(cpuId2);
        }
    }
    ,
    DIFFERENT_SOCKET{

        @Override
        public boolean matches(int cpuId, int cpuId2) {
            CpuLayout cpuLayout = AffinityLock.cpuLayout();
            return cpuLayout.socketId(cpuId) != cpuLayout.socketId(cpuId2);
        }
    };

}

