/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.link;

import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkBlockingReader;
import com.neeve.emx.EmxNwLnkConnector;
import com.neeve.emx.EmxNwLnkReader;
import com.neeve.io.IOBuffer;
import com.neeve.perf.common.SystemProperties;
import com.neeve.stats.StatsLatencyWriter;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlGovernor;
import com.neeve.util.UtlThread;
import java.text.DecimalFormat;

@AnnotatedCommand.Command(keywords={"NonBlockingPingPongSender"}, description="A non blocking (streaming) sender to test ping pong performance using EMX links")
public class NonBlockingPingPongSender
extends AnnotatedCommand {
    @AnnotatedCommand.Option(shortForm=100, longForm="descriptor", required=true, description="The connection descriptor to use e.g. tcp://192.168.1.7:12000&localifaddr=192.168.1.8&localport=12000&tcpnodelay=true")
    private String _descriptor;
    @AnnotatedCommand.Option(shortForm=109, longForm="messageSize", defaultValue="256", required=true, description="The size of the message to ping pong")
    private int _messageSize;
    @AnnotatedCommand.Option(shortForm=99, longForm="testCount", defaultValue="10000000", description="The number of messages to send")
    private int _testCount;
    @AnnotatedCommand.Option(shortForm=114, longForm="testRate", defaultValue="1000", description="The rate at which to send messages")
    private int _testRate;
    @AnnotatedCommand.Option(shortForm=119, longForm="warmupTime", defaultValue="2", description="The warm up time, in seconds")
    private int _warmupTime;
    @AnnotatedCommand.Option(shortForm=97, longForm="writerCpuAffinityMask", description="which CPU(s) to affinitize the writer thread to")
    private String _writerCpuAffinityMask;
    @AnnotatedCommand.Option(shortForm=98, longForm="readerCpuAffinityMask", description="which CPU(s) to affinitize the reader thread to")
    private String _readerCpuAffinityMask;
    @AnnotatedCommand.Option(shortForm=115, longForm="stats", defaultValue="false", description="Whether to output incremental throughput stats")
    private boolean _stats;
    @AnnotatedCommand.Option(shortForm=111, longForm="oneWayLatency", description="whether to calculate one-way latency values")
    private boolean _oneWay;
    @AnnotatedCommand.Option(shortForm=105, longForm="printIntervalStats", description="whether to output stats at periodic intervals instead of only at the end")
    private boolean _printIntervalStats;
    @AnnotatedCommand.Option(shortForm=102, longForm="dontWriteLatenciesToFile", description="whether to suppress writing latency values to a file")
    private boolean _dontWriteLatenciesToFile;
    private EmxNwLnkBlockingReader reader;

    private void stats(int numSent, int deltaNumSent, int numReceived, int deltaNumReceived, long now, long start, long deltaStart) {
        long deltaSendRate = deltaStart > 0L ? (long)deltaNumSent * 1000L / (now - deltaStart) : 0L;
        long overallSendRate = (long)numSent * 1000L / (now - start);
        long deltaReceiveRate = deltaStart > 0L ? (long)deltaNumReceived * 1000L / (now - deltaStart) : 0L;
        long overallReceiveRate = (long)numReceived * 1000L / (now - start);
        int pending = numSent - numReceived;
        System.out.println("[NonBlockingPingPongSender] SEND [" + numSent + "," + deltaSendRate + "," + overallSendRate + "] RECV [" + numReceived + "," + deltaReceiveRate + "," + overallReceiveRate + "] PENDING [" + pending + "]");
    }

    private void waitForRoundTripsToComplete(int numSent, ReadCallback cb) {
        while (numSent > cb.numReceived) {
            System.out.println("[NonBlockingPingPongSender] Waiting for round trips to complete (sent=" + numSent + ", numRcvd=" + cb.numReceived + ")...");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void execute() throws Exception {
        long start;
        if (this._writerCpuAffinityMask != null) {
            System.out.println("[NonBlockingPingPongSender] Affinitizing writer thread to CPU " + this._writerCpuAffinityMask);
            UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)this._writerCpuAffinityMask));
        }
        SystemProperties.dump();
        DecimalFormat dfmt = new DecimalFormat("#,###");
        System.out.println("[NonBlockingPingPongSender] Descriptor:" + this._descriptor);
        System.out.println("[NonBlockingPingPongSender] Message size:" + this._messageSize);
        System.out.println("[NonBlockingPingPongSender] Test count:" + dfmt.format(this._testCount));
        System.out.println("[NonBlockingPingPongSender] Warmup time:" + this._warmupTime + "s");
        System.out.println("[NonBlockingPingPongSender] Test rate:" + dfmt.format(this._testRate));
        System.out.println("[NonBlockingPingPongSender] Writer CPU affinity mask:" + this._writerCpuAffinityMask);
        System.out.println("[NonBlockingPingPongSender] Reader CPU affinity mask:" + this._readerCpuAffinityMask);
        System.out.println("[NonBlockingPingPongSender] One Way Latency:" + this._oneWay);
        System.out.println("[NonBlockingPingPongSender] Print interval stats:" + this._printIntervalStats);
        System.out.println("[NonBlockingPingPongSender] Write latencies to file:" + !this._dontWriteLatenciesToFile);
        System.out.println("[NonBlockingPingPongSender] Establishing link...");
        EmxNwLnkConnector connector = EmxNwLnkConnector.create((String)this._descriptor);
        EmxNwLnk link = connector.connect();
        System.out.println("[NonBlockingPingPongSender] Configuring link (message size=" + this._messageSize + ")...");
        link.configureBlockingWrite(true);
        System.out.println("[NonBlockingPingPongSender] Starting the concurrent reader...");
        ReadCallback cb = new ReadCallback();
        this.reader = EmxNwLnkBlockingReader.create((EmxNwLnk)link, (EmxNwLnkReader.Callback)cb);
        new ReaderThread().start();
        IOBuffer message = IOBuffer.create((int)this._messageSize);
        StatsLatencyWriter lw = new StatsLatencyWriter("nw-lat", this._dontWriteLatenciesToFile ? null : "latencies.send.bin", this._printIntervalStats);
        System.out.println("[NonBlockingPingPongSender] Warming up (" + this._warmupTime + " seconds)...");
        UtlGovernor governor = new UtlGovernor(this._testRate);
        long warmupStart = System.currentTimeMillis();
        int numSent = 0;
        while (System.currentTimeMillis() - warmupStart < (long)this._warmupTime * 1000L) {
            message.putLong(0, System.nanoTime());
            link.write(message, 0, this._messageSize);
            ++numSent;
            governor.blockToNext();
        }
        this.waitForRoundTripsToComplete(numSent, cb);
        System.out.println("[NonBlockingPingPongSender] Running test (rate=" + dfmt.format(this._testRate) + ", count=" + dfmt.format(this._testCount) + ")...");
        numSent = 0;
        cb.reset().setLatencyWriter(lw);
        governor = new UtlGovernor(this._testRate);
        int deltaNumSent = 0;
        long deltaStart = start = System.currentTimeMillis();
        lw.start(this._testRate, this._testCount);
        for (int i = 0; i < this._testCount; ++i) {
            message.putLong(0, System.nanoTime());
            link.write(message, 0, this._messageSize);
            ++numSent;
            if (this._stats) {
                ++deltaNumSent;
                long now = System.currentTimeMillis();
                if (now - deltaStart >= 1000L) {
                    this.stats(numSent, deltaNumSent, cb.numReceived, cb.deltaNumReceived, now, start, deltaStart);
                    deltaStart = now;
                    deltaNumSent = 0;
                    cb.deltaNumReceived = 0;
                }
            }
            governor.blockToNext();
        }
        long stop = System.currentTimeMillis();
        this.waitForRoundTripsToComplete(numSent, cb);
        lw.close();
        System.out.println("[NonBlockingPingPongSender] Test complete.");
        if (this._stats) {
            this.stats(numSent, deltaNumSent, cb.numReceived, cb.deltaNumReceived, stop, start, 0L);
        }
        this.reader.stop();
        link.close();
        if (!this._dontWriteLatenciesToFile) {
            System.out.println("[NonBlockingPingPongSender] Test complete (run rumi-reporter on latencies.send.bin to calculate latency stats).");
        } else {
            System.out.println("[NonBlockingPingPongSender] Test complete.");
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("nv.tuning.cpu.enableaffinitymasks", "true");
        new NonBlockingPingPongSender().run(args);
    }

    private final class ReaderThread
    extends Thread {
        ReaderThread() throws Exception {
            super((Runnable)NonBlockingPingPongSender.this.reader);
        }

        @Override
        public final void run() {
            if (NonBlockingPingPongSender.this._readerCpuAffinityMask != null) {
                System.out.println("[NonBlockingPingPongSender] Affinitizing reader thread to CPU " + NonBlockingPingPongSender.this._readerCpuAffinityMask);
                UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)NonBlockingPingPongSender.this._readerCpuAffinityMask));
            }
            super.run();
        }
    }

    private final class ReadCallback
    implements EmxNwLnkReader.Callback {
        private StatsLatencyWriter lw;
        int numReceived;
        int deltaNumReceived;

        ReadCallback() {
        }

        final ReadCallback reset() {
            this.deltaNumReceived = 0;
            this.numReceived = 0;
            return this;
        }

        final void setLatencyWriter(StatsLatencyWriter lw) {
            this.lw = lw;
        }

        public final int handleReadData(EmxNwLnk link, IOBuffer iobuf, int length) {
            long ts = System.nanoTime();
            int count = length / NonBlockingPingPongSender.this._messageSize;
            try {
                if (count > 0) {
                    int messageBoundary = 0;
                    for (int i = 0; i < count; ++i) {
                        if (this.lw != null) {
                            this.lw.write((int)((ts - iobuf.getLong(messageBoundary)) / (long)(NonBlockingPingPongSender.this._oneWay ? 2 : 1)));
                        }
                        messageBoundary += NonBlockingPingPongSender.this._messageSize;
                    }
                }
                this.numReceived += count;
                this.deltaNumReceived += count;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return NonBlockingPingPongSender.this._messageSize * count;
        }

        public final void handleLinkClosure(EmxNwLnk lnk) {
            System.out.println("Link closed by peer");
        }

        public final void handleLinkFailure(EmxNwLnk lnk, Throwable cause) {
            cause.printStackTrace();
        }
    }
}

