/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import cern.colt.function.IntObjectProcedure;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.root.RootConfig;
import com.neeve.sto.EStoException;
import com.neeve.sto.StoConfig;
import com.neeve.sto.StoObject;
import com.neeve.sto.StoTypeFactory;
import com.neeve.sto.StoTypeFactoryDescriptor;
import com.neeve.trace.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class StoTypeFactoryRegistry
extends StoObject {
    private static final StoTypeFactoryRegistry instance;
    private static final OpenIntObjectHashMap typeFactories;

    private static StoTypeFactory loadTypeFactory(String className) throws Exception {
        if (className != null) {
            Class<?> factoryClass = null;
            try {
                factoryClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Type factory class [" + className + "] could not be found");
            }
            catch (UnsupportedClassVersionError e) {
                throw new Exception("Type factory class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
            }
            Method factoryCreateMethod = null;
            try {
                Class[] parameterTypes = new Class[]{Class.forName("java.util.Properties")};
                factoryCreateMethod = factoryClass.getMethod("create", parameterTypes);
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("Failed to load java.util.Properties during instantiation of STO type factory class [" + className + "]");
            }
            catch (SecurityException e) {
                throw new Exception("Access to instantiation method in type factory class [" + className + "] is denied");
            }
            catch (NoSuchMethodException e) {
                throw new Exception("Instantiation method in type factory class [" + className + "] could not be found");
            }
            StoTypeFactory factory = null;
            try {
                try {
                    Object[] parameters = new Object[]{new Properties()};
                    factory = (StoTypeFactory)factoryCreateMethod.invoke(null, parameters);
                    if (factory == null) {
                        throw new Exception("Instantiation method in type factory class [" + className + "] returned a null object");
                    }
                }
                catch (ClassCastException e) {
                    throw new Exception("Instantiation method in type factory class [" + className + "] returned object of incorrect type");
                }
            }
            catch (IllegalAccessException e) {
                throw new Exception("Access to instantiation method in type factory class [" + className + "] is denied");
            }
            catch (InvocationTargetException e) {
                throw new Exception(e.getCause());
            }
            return factory;
        }
        return null;
    }

    private StoTypeFactoryRegistry() {
    }

    public static final StoTypeFactoryRegistry getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerTypeFactory(StoTypeFactory factory) {
        OpenIntObjectHashMap openIntObjectHashMap = typeFactories;
        synchronized (openIntObjectHashMap) {
            this.tracer.log("Registering STO type factory (id=" + factory.getTfid() + ")...", Tracer.Level.VERBOSE);
            typeFactories.put((int)factory.getTfid(), (Object)factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StoTypeFactory getTypeFactory(short id) {
        OpenIntObjectHashMap openIntObjectHashMap = typeFactories;
        synchronized (openIntObjectHashMap) {
            return (StoTypeFactory)typeFactories.get((int)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> getTypeFactoryNames(final Set<String> factories) {
        if (factories == null) {
            throw new IllegalArgumentException("factories cannot be null");
        }
        OpenIntObjectHashMap openIntObjectHashMap = typeFactories;
        synchronized (openIntObjectHashMap) {
            typeFactories.forEachPair(new IntObjectProcedure(){

                public final boolean apply(int first, Object second) {
                    factories.add(((StoTypeFactory)second).getClass().getName());
                    return true;
                }
            });
        }
        return factories;
    }

    static {
        block6: {
            instance = new StoTypeFactoryRegistry();
            Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)StoConfig.getConfig());
            tracer.log("Loading STO type factories...", Tracer.Level.VERBOSE);
            typeFactories = new OpenIntObjectHashMap();
            try {
                Map<Short, StoTypeFactoryDescriptor> typeFactoryDescriptors = StoTypeFactoryDescriptor.loadAll();
                if (typeFactoryDescriptors.size() > 0) {
                    Set<Map.Entry<Short, StoTypeFactoryDescriptor>> typeFactoryEntries = typeFactoryDescriptors.entrySet();
                    for (Map.Entry<Short, StoTypeFactoryDescriptor> entry : typeFactoryEntries) {
                        StoTypeFactoryDescriptor descriptor = entry.getValue();
                        String s = "..." + descriptor.getName();
                        try {
                            typeFactories.put((int)descriptor.getId(), (Object)StoTypeFactoryRegistry.loadTypeFactory(descriptor.getClassName()));
                            s = s + " - success";
                        }
                        catch (Exception e) {
                            s = s + " - failed [" + e.toString() + "]";
                        }
                        tracer.log(s, Tracer.Level.VERBOSE);
                    }
                    break block6;
                }
                tracer.log("...<No configured STO type factories>", Tracer.Level.VERBOSE);
            }
            catch (EStoException e) {
                tracer.log("Failure encountered while loading STO type factories [" + e.toString() + "]", Tracer.Level.SEVERE);
            }
        }
    }
}

