/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.log;

import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.EPktException;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktObject;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheader;
import com.neeve.pkt.PktUtils;
import com.neeve.pkt.log.EPktLogCorruptException;
import com.neeve.pkt.log.EPktLogExpectationNotMetException;
import com.neeve.pkt.log.EPktLogInvalidException;
import com.neeve.pkt.log.EPktLogInvalidPositionException;
import com.neeve.pkt.log.EPktLogNotFoundException;
import com.neeve.pkt.types.PktBodyRecoveryLogCheckpointState;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

public final class PktRecoveryLog
extends PktObject {
    public static final int PREAMBLE_LENGTH = 9;
    public static final int FLG_SYNC = 1;
    public static final int FLG_AUTOREPAIR = 2;
    public static final int FLG_EXPECT_LOGEMPTY = 4;
    public static final int FLG_EXPECT_LOGPRESENT = 8;
    public static final int FLG_EXPECT_LOGABSENT = 16;
    public static final int FLG_EXPECT_LOGNOTEMPTY = 32;
    public static final int FLG_SUPPORT_TAILING = 128;
    public static final int FLG_SKIP_INTEGRITY_CHECK = 256;
    @Deprecated
    public static final int FLG_SKIP_WRITE_SEEK = 256;
    public static final String BACKUP_DIRECTORY = "$archive$";
    private static final byte V1 = 1;
    private static final byte VERSION = 1;
    private static final int MAX_BUFFER_COUNT_PER_FLUSH = 10;
    private final String dirname;
    private final String filenameOnly;
    private final String filename;
    private FileOpenMode openMode;
    private long initialLength;
    private boolean zeroOutInitial;
    private int pageSize;
    private int readBufferSize;
    private boolean readBufferSizeExplictlySet;
    private int writeBufferSize;
    private boolean writeBufferSizeExplictlySet;
    private boolean flushUsingMappedMemory;
    private boolean flushUsingNative;
    private boolean flushDirectFromPacket;
    private PktPacket checkpointState;
    private IOBuffer eof;
    private int eofLength;
    private RandomAccessFile file;
    private FileChannel fileChannel;
    private long nfile;
    private MappedByteBuffer mappedFileBuffer;
    private long mappedFilePointer;
    private IOElasticBuffer writeBuffer;
    private ByteBuffer[] flushBuffers;
    private long[] nativeFlushBuffers;
    private int[] nativeFlushBufferLengths;
    private PktSubheader[] subheaders;
    private Preamble preamble;
    private long logSize;
    private boolean supportTailing;
    private boolean wasRepaired;
    private RandomAccessFile fileForStats;
    private static final boolean nativeFileIOEnabled = UtlFile.isNativeFileIOEnabled();
    private static final boolean enableWriteChecks = Config.getValue((String)"nv.packet.log.enablewritechecks", (boolean)true);
    private static final boolean enableSerializationChecks = Config.getValue((String)"nv.packet.log.enableserializationchecks", (boolean)false);

    private PktRecoveryLog(String dirname, String filename) {
        super(null);
        this.dirname = dirname;
        this.filenameOnly = filename;
        this.filename = PktRecoveryLog.filename(dirname, filename);
        this.openMode = FileOpenMode.rw;
        this.initialLength = 0L;
        this.zeroOutInitial = false;
        this.flushUsingMappedMemory = false;
        this.pageSize = 4096;
        this.readBufferSize = this.writeBufferSize = 4096 * 2;
    }

    private static final String filename(String dirname, String filename) {
        if (dirname == null) {
            throw new IllegalArgumentException("log directory cannot be null");
        }
        return dirname + File.separator + (filename == null ? "packet.log" : filename);
    }

    private static final void scavenge(String dirname, int retentionCount) {
        File[] files = new File(dirname).listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public final int compare(File f1, File f2) {
                if (f1.lastModified() == f2.lastModified()) {
                    return 0;
                }
                return f1.lastModified() < f2.lastModified() ? -1 : 1;
            }
        });
        for (int i = retentionCount; i < files.length; ++i) {
            files[i].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String backup(String dirname, String filename, boolean deleteOriginal, boolean shrinkToSize, boolean repair, int retentionCount) throws IOException {
        if (dirname == null) {
            throw new IllegalArgumentException("directory name cannot be null");
        }
        File logFile = new File(PktRecoveryLog.filename(dirname, filename));
        if (logFile.exists()) {
            String backupDirname = dirname + File.separator + BACKUP_DIRECTORY;
            new File(backupDirname).mkdirs();
            File backupFile = new File(PktRecoveryLog.filename(backupDirname, filename) + "." + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()));
            if (deleteOriginal) {
                if (shrinkToSize) {
                    PktRecoveryLog log = PktRecoveryLog.create(dirname, filename).setOpenMode(FileOpenMode.rw);
                    log.open(repair ? 2 : 0, -1L);
                    try {
                        log.file.setLength(log.getSize());
                    }
                    finally {
                        try {
                            log.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                logFile.renameTo(backupFile);
            } else {
                UtlFile.copyFile((File)logFile, (File)backupFile);
            }
            PktRecoveryLog.scavenge(backupDirname, retentionCount);
            return backupFile.getAbsolutePath();
        }
        return null;
    }

    public static final String backup(String dirname, String filename, boolean deleteOriginal, boolean shrinkToSize, boolean repair) throws IOException {
        return PktRecoveryLog.backup(dirname, filename, deleteOriginal, shrinkToSize, repair, 1);
    }

    public static final PktRecoveryLog create(String dirname, String filename) {
        return new PktRecoveryLog(dirname, filename);
    }

    private final void adjustInitialLengthToAlignOnPageSizeBoundary() {
        this.initialLength = this.initialLength % (long)this.pageSize == 0L ? this.initialLength : (this.initialLength / (long)this.pageSize + 1L) * (long)this.pageSize;
    }

    private final void prepareEOFMarker() throws EPktException {
        try {
            PktPacket eofPacket = PktFactory.getInstance().createPacket(262);
            this.eofLength = eofPacket.getSerializedLength();
            this.eof = IOBuffer.create((int)this.eofLength);
            eofPacket.serialize(this.eof, 0);
        }
        catch (Exception e) {
            throw new EPktException("Failed to create EOF marker packet for log [" + e.toString() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeEof() throws IOException {
        long nextWritePos = this.file.getFilePointer();
        if (this.tracer.debug) {
            this.tracer.log("Writing EOF.. (pos=" + nextWritePos + ")", Tracer.Level.DEBUG);
        }
        ByteBuffer eofBuffer = this.eof.takeBuffer();
        try {
            this.fileChannel.write(eofBuffer);
            this.file.seek(nextWritePos);
        }
        finally {
            this.eof.releaseBuffer();
        }
    }

    private final void checkLogPresenceExpectations(int openFlags, boolean logfileExists) {
        if ((openFlags & 8) == 8 && !logfileExists) {
            throw new EPktLogExpectationNotMetException(8, null, "log presence expectation mismatch (log is absent when expected to be present)");
        }
        if ((openFlags & 0x10) == 16 && logfileExists) {
            throw new EPktLogExpectationNotMetException(16, null, "log presence expectation mismatch (log is present when expected to be absent)");
        }
    }

    private final void checkLogEmptinessExpectations(int openFlags, boolean hasEntries) {
        if ((openFlags & 4) == 4 && hasEntries) {
            throw new EPktLogExpectationNotMetException(4, hasEntries, "log emptiness expectation not met (entries in the log)");
        }
        if ((openFlags & 0x20) == 32 && !hasEntries) {
            throw new EPktLogExpectationNotMetException(32, hasEntries, "log not empty expectation not met (no entries in the log)");
        }
    }

    private final void completeOpen(long eofPointer, boolean writeEof) throws IOException {
        this.file.seek(eofPointer);
        if (writeEof) {
            this.writeEof();
        }
        this.logSize = this.file.getFilePointer() - (long)this.preamble.getSerializedLength();
    }

    private final MappedByteBuffer mapFileAt(long position, int bytesNeeded) throws EPktException {
        long ts = System.nanoTime();
        FileChannel.MapMode mode = null;
        long bytesRemaining = -1L;
        int bytesToMap = -1;
        try {
            mode = this.openMode == FileOpenMode.r ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            bytesRemaining = this.file.length() - position;
            bytesToMap = Math.max(Math.max((int)Math.min(Integer.MAX_VALUE, bytesRemaining), bytesNeeded), (int)Math.min(Integer.MAX_VALUE, this.initialLength));
            if ((long)bytesToMap > bytesRemaining) {
                long ts1 = System.nanoTime();
                this.file.setLength(this.file.length() + ((long)bytesToMap - bytesRemaining));
                if (this.tracer.debug) {
                    this.tracer.log("Extended log length by " + ((long)bytesToMap - bytesRemaining) + " bytes (" + (System.nanoTime() - ts1) / 1000L + " us).", Tracer.Level.DEBUG);
                }
            }
            MappedByteBuffer ret = this.fileChannel.map(mode, position, bytesToMap);
            if (this.tracer.debug) {
                this.tracer.log("Mapped " + bytesToMap + " bytes of log at pos=" + position + " to memory (" + (System.nanoTime() - ts) / 1000L + " us (includes file length increase time))", Tracer.Level.DEBUG);
            }
            return ret;
        }
        catch (IOException e) {
            throw new EPktException("I/O error while memory mapping the log [" + e.toString() + " (" + mode + "," + position + "," + bytesRemaining + ")]", e);
        }
    }

    private final void prepareMappedFileBufferForFlush(int bytesToFlush) {
        if (bytesToFlush > this.mappedFileBuffer.remaining()) {
            this.mappedFileBuffer = this.mapFileAt(this.mappedFilePointer, bytesToFlush + this.eofLength);
            if (bytesToFlush > this.mappedFileBuffer.remaining()) {
                throw new EPktException("no more space in file");
            }
        }
    }

    private final EPktException prepareFlushException(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append("FATAL ERROR: Log write/sync faulted with error [" + e.toString() + "].\n");
        sb.append("Stack trace:\n");
        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
        if (e instanceof IOException) {
            sb.append("**** LOG CORRUPTION MAY HAVE OCCURRED ****\n");
        }
        this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        return e instanceof EPktException ? (EPktException)((Object)e) : new EPktException(e);
    }

    private final int serializePacketToBuffer(PktPacket packet, IOElasticBuffer buffer) {
        int bufferLengthAfter;
        int bufferLengthBefore = enableSerializationChecks ? buffer.getLength() : 0;
        int serializedLength = packet.getTo(buffer, buffer.getLength(), !this.supportTailing || buffer.getLength() > 0);
        int n = bufferLengthAfter = enableSerializationChecks ? buffer.getLength() : 0;
        if (this.tracer.debug) {
            this.tracer.log("Serialize complete [numSerializedBytes=" + serializedLength + ", numDirtyBytes=" + buffer.getLength() + "]", Tracer.Level.DEBUG);
        }
        if (enableSerializationChecks && bufferLengthAfter - bufferLengthBefore != serializedLength) {
            StringBuilder sb = new StringBuilder();
            sb.append("Bytes serialized for packet(" + (bufferLengthAfter - bufferLengthBefore) + ") does not match serialized packet length (" + serializedLength + ")!\n");
            sb.append("  Packet:").append((Object)packet).append("\n");
            throw new EPktException(sb.toString());
        }
        return serializedLength;
    }

    private final void validateFlushUsingGatheringIOWentAsExpected(long fpBefore, long totalToWrite, long totalWritten) throws IOException {
        if (totalWritten != totalToWrite) {
            StringBuilder sb = new StringBuilder();
            sb.append("failed to persist full data block (expected=" + totalToWrite + " bytes, actual=" + totalWritten + " bytes) (out of disk space?)\n");
            throw new IOException(sb.toString());
        }
        long fpAfter = this.file.getFilePointer();
        if (fpAfter - fpBefore != totalWritten) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unexpected file pointer (" + this.file.getFilePointer() + ") after native flush of " + totalWritten + " bytes. Expected " + (fpBefore + totalWritten) + " but is " + this.file.getFilePointer() + " (off by " + (fpAfter - fpBefore + totalWritten) + ")!\n");
            throw new IOException(sb.toString());
        }
    }

    private final int flushPacketUsingMemoryMappedIO(PktPacket packet) {
        if (this.tracer.debug) {
            this.tracer.log("Writing using memory mapped IO.", Tracer.Level.DEBUG);
        }
        int serializedLength = packet.getSerializedLength();
        this.prepareMappedFileBufferForFlush(serializedLength + this.eofLength);
        packet.getTo((ByteBuffer)this.mappedFileBuffer, !this.supportTailing);
        this.mappedFileBuffer.position(this.mappedFileBuffer.position() + serializedLength);
        this.mappedFilePointer += (long)serializedLength;
        if (this.tracer.debug) {
            this.tracer.log("Write complete [numSerializedBytes=" + serializedLength + ", numDirtyBytes=" + this.writeBuffer.getLength() + "]", Tracer.Level.DEBUG);
        }
        this.eof.getTo(0, (ByteBuffer)this.mappedFileBuffer, this.eofLength);
        if (this.supportTailing) {
            PktHeader.restoreClearedMagic(this.mappedFileBuffer, this.mappedFileBuffer.position() - serializedLength);
        }
        return serializedLength;
    }

    private final int flushPacketUsingNativeGatheringIO(PktPacket packet) throws Exception {
        if (this.tracer.debug) {
            this.tracer.log("Writing using native gathering IO.", Tracer.Level.DEBUG);
        }
        int serializedLength = 0;
        int numFlushBuffers = 0;
        PktHeader header = packet.getHeader();
        int bufferSerializedLength = header.getStaticSerializedLength();
        this.nativeFlushBuffers[numFlushBuffers] = header.getBuffer().getBackingBufferUnsafe().getNativeAddress();
        if (this.supportTailing) {
            PktHeader.clearMagic(this.nativeFlushBuffers[numFlushBuffers], 0);
        }
        this.nativeFlushBufferLengths[numFlushBuffers] = bufferSerializedLength;
        serializedLength += bufferSerializedLength;
        ++numFlushBuffers;
        int numSubheaders = header.getNumSubheaders();
        int numProcessed = 0;
        int j = 0;
        for (int i = 1; i <= 7 && numProcessed < numSubheaders; ++i) {
            PktSubheader subheader = header.getSubheader(i, false);
            if (subheader == null) continue;
            bufferSerializedLength = subheader.getSerializedLength();
            int n = j++;
            PktSubheader pktSubheader = subheader;
            this.subheaders[n] = pktSubheader;
            this.nativeFlushBuffers[numFlushBuffers] = pktSubheader.getBuffer().getBackingBufferUnsafe().getNativeAddress();
            this.nativeFlushBufferLengths[numFlushBuffers] = bufferSerializedLength;
            serializedLength += bufferSerializedLength;
            ++numFlushBuffers;
            ++numProcessed;
        }
        PktBody body = packet.getBody();
        bufferSerializedLength = body.getSerializedLength();
        this.nativeFlushBuffers[numFlushBuffers] = body.getBuffer().getBackingBufferUnsafe().getNativeAddress();
        this.nativeFlushBufferLengths[numFlushBuffers] = bufferSerializedLength;
        header.setLength(serializedLength += bufferSerializedLength);
        this.flushBuffersUsingNativeGatheringIO(++numFlushBuffers, serializedLength);
        return serializedLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int flushPacketUsingGatheringIO(PktPacket packet) throws Exception {
        if (this.tracer.debug) {
            this.tracer.log("Writing using gathering IO.", Tracer.Level.DEBUG);
        }
        PktHeader header = packet.getHeader();
        PktBody body = packet.getBody();
        int serializedLength = 0;
        int numFlushBuffers = 0;
        int bufferSerializedLength = header.getStaticSerializedLength();
        if (this.supportTailing) {
            PktHeader.clearMagic(header.getBuffer(), 0);
        }
        int n = numFlushBuffers++;
        ByteBuffer byteBuffer = header.getBuffer().getBackingBufferUnsafe().takeBuffer();
        this.flushBuffers[n] = byteBuffer;
        byteBuffer.limit(bufferSerializedLength);
        serializedLength += bufferSerializedLength;
        try {
            int i;
            int numSubheaders = header.getNumSubheaders();
            int numProcessed = 0;
            int j = 0;
            for (i = 1; i <= 7 && numProcessed < numSubheaders; ++i) {
                PktSubheader subheader = header.getSubheader(i, false);
                if (subheader == null) continue;
                bufferSerializedLength = subheader.getSerializedLength();
                int n2 = numFlushBuffers++;
                int n3 = j++;
                PktSubheader pktSubheader = subheader;
                this.subheaders[n3] = pktSubheader;
                ByteBuffer byteBuffer2 = pktSubheader.getBuffer().getBackingBufferUnsafe().takeBuffer();
                this.flushBuffers[n2] = byteBuffer2;
                byteBuffer2.limit(bufferSerializedLength);
                serializedLength += bufferSerializedLength;
                ++numProcessed;
            }
            try {
                bufferSerializedLength = body.getSerializedLength();
                int n4 = numFlushBuffers++;
                ByteBuffer byteBuffer3 = body.getBuffer().getBackingBufferUnsafe().takeBuffer();
                this.flushBuffers[n4] = byteBuffer3;
                byteBuffer3.limit(bufferSerializedLength);
                serializedLength += bufferSerializedLength;
                try {
                    header.setLength(serializedLength);
                    this.flushBuffersUsingGatheringIO(numFlushBuffers, serializedLength);
                }
                catch (Throwable throwable) {
                    body.getBuffer().getBackingBufferUnsafe().releaseBuffer();
                    throw throwable;
                }
                body.getBuffer().getBackingBufferUnsafe().releaseBuffer();
            }
            finally {
                for (i = 0; i < j; ++i) {
                    this.subheaders[i].getBuffer().getBackingBufferUnsafe().releaseBuffer();
                }
            }
        }
        finally {
            header.getBuffer().getBackingBufferUnsafe().releaseBuffer();
        }
        return serializedLength;
    }

    private final void flushBufferUsingMemoryMappedIO(IOElasticBuffer buffer, int numBytes) {
        this.prepareMappedFileBufferForFlush(numBytes + this.eofLength);
        buffer.getTo(0, (ByteBuffer)this.mappedFileBuffer, numBytes);
        this.mappedFileBuffer.position(this.mappedFileBuffer.position() + numBytes);
        this.mappedFilePointer += (long)numBytes;
        if (this.tracer.debug) {
            this.tracer.log(numBytes + " bytes flushed.", Tracer.Level.DEBUG);
        }
        this.eof.getTo(0, (ByteBuffer)this.mappedFileBuffer, this.eofLength);
        if (this.supportTailing) {
            if (this.tracer.debug) {
                this.tracer.log("Restoring magic at pos=" + (this.mappedFileBuffer.position() - numBytes) + "...", Tracer.Level.DEBUG);
            }
            PktHeader.restoreClearedMagic(this.mappedFileBuffer, this.mappedFileBuffer.position() - numBytes);
        }
        if (this.tracer.debug) {
            this.tracer.log("Flush complete [filePos=" + this.mappedFilePointer + ", bufferPos=" + this.mappedFileBuffer.position() + "]...", Tracer.Level.DEBUG);
        }
    }

    private final void flushBuffersUsingNativeGatheringIO(int numDataFlushBuffers, int dataLength) throws Exception {
        this.nativeFlushBuffers[numDataFlushBuffers] = this.eof.getNativeAddress();
        this.nativeFlushBufferLengths[numDataFlushBuffers] = this.eofLength;
        int numFlushBuffers = numDataFlushBuffers + 1;
        long fpBefore = this.file.getFilePointer();
        int totalToWrite = dataLength + this.eofLength;
        if (this.tracer.debug) {
            this.tracer.log("Flushing " + numFlushBuffers + " buffers to file at pos=" + this.file.getFilePointer() + "...", Tracer.Level.DEBUG);
        }
        long totalWritten = UtlFile.nativeWrite((long)this.nfile, (long[])this.nativeFlushBuffers, (int[])this.nativeFlushBufferLengths, (int)numFlushBuffers);
        if (this.tracer.debug) {
            this.tracer.log(totalWritten + " bytes flushed.", Tracer.Level.DEBUG);
        }
        this.validateFlushUsingGatheringIOWentAsExpected(fpBefore, totalToWrite, totalWritten);
        long justBeforeEofFp = this.file.getFilePointer() - (long)this.eofLength;
        if (this.supportTailing) {
            this.file.seek(this.file.getFilePointer() - totalWritten);
            if (this.tracer.debug) {
                this.tracer.log("Restoring magic at pos=" + this.file.getFilePointer() + "...", Tracer.Level.DEBUG);
            }
            this.nativeFlushBufferLengths[0] = 3;
            PktHeader.restoreClearedMagic(this.nativeFlushBuffers[0], 0);
            long totalMagicWritten = UtlFile.nativeWrite((long)this.nfile, (long[])this.nativeFlushBuffers, (int[])this.nativeFlushBufferLengths, (int)1);
            if (totalMagicWritten != 3L) {
                throw new IOException("failed to persist full data block (expected=3 bytes, actual=" + totalMagicWritten + " bytes) (out of disk space?)");
            }
            if (this.tracer.debug) {
                this.tracer.log(totalMagicWritten + " magic bytes flushed.", Tracer.Level.DEBUG);
            }
        }
        this.file.seek(justBeforeEofFp);
        if (this.tracer.debug) {
            this.tracer.log("Flush complete [pos=" + this.file.getFilePointer() + "]...", Tracer.Level.DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushBuffersUsingGatheringIO(int numDataFlushBuffers, int dataLength) throws Exception {
        ByteBuffer eofBuffer = this.eof.takeBuffer();
        try {
            this.flushBuffers[numDataFlushBuffers] = eofBuffer;
            int numFlushBuffers = numDataFlushBuffers + 1;
            long fpBefore = this.file.getFilePointer();
            int totalToWrite = dataLength + this.eofLength;
            if (this.tracer.debug) {
                this.tracer.log("Flushing " + numFlushBuffers + " buffers to file at pos=" + this.file.getFilePointer() + "...", Tracer.Level.DEBUG);
            }
            long totalWritten = this.fileChannel.write(this.flushBuffers, 0, numFlushBuffers);
            if (this.tracer.debug) {
                this.tracer.log(totalWritten + " bytes flushed.", Tracer.Level.DEBUG);
            }
            this.validateFlushUsingGatheringIOWentAsExpected(fpBefore, totalToWrite, totalWritten);
            long justBeforeEofFp = this.file.getFilePointer() - (long)this.eofLength;
            if (this.supportTailing) {
                this.file.seek(this.file.getFilePointer() - totalWritten);
                if (this.tracer.debug) {
                    this.tracer.log("Restoring magic at pos=" + this.file.getFilePointer() + "...", Tracer.Level.DEBUG);
                }
                this.flushBuffers[0].position(0);
                this.flushBuffers[0].limit(3);
                PktHeader.restoreClearedMagic(this.flushBuffers[0], 0);
                long totalMagicWritten = this.fileChannel.write(this.flushBuffers, 0, 1);
                if (totalMagicWritten != 3L) {
                    throw new IOException("failed to persist full data block (expected=3 bytes, actual=" + totalMagicWritten + " bytes) (out of disk space?)");
                }
                if (this.tracer.debug) {
                    this.tracer.log(totalMagicWritten + " magic bytes flushed.", Tracer.Level.DEBUG);
                }
            }
            this.file.seek(justBeforeEofFp);
            if (this.tracer.debug) {
                this.tracer.log("Flush complete [pos=" + this.file.getFilePointer() + "]...", Tracer.Level.DEBUG);
            }
        }
        finally {
            this.eof.releaseBuffer();
        }
    }

    public final String getDirname() {
        return this.dirname;
    }

    public final String getFilename() {
        return this.filenameOnly;
    }

    public final PktRecoveryLog setOpenMode(FileOpenMode val) {
        if (this.isOpen()) {
            throw new IllegalStateException("this configuration parameter cannot be set after the log has been opened");
        }
        this.openMode = val;
        return this;
    }

    public final PktRecoveryLog setInitialLength(long val) {
        if (this.isOpen()) {
            throw new IllegalStateException("this configuration parameter cannot be set after the log has been opened");
        }
        if (val < 0L) {
            throw new IllegalArgumentException("initial log length must be >= 0");
        }
        this.initialLength = val;
        this.adjustInitialLengthToAlignOnPageSizeBoundary();
        return this;
    }

    public final long getInitialLength() {
        return this.initialLength;
    }

    public final PktRecoveryLog setZeroOutInitial(boolean val) {
        if (this.isOpen()) {
            throw new IllegalStateException("this configuration parameter cannot be set after the log has been opened");
        }
        this.zeroOutInitial = val;
        return this;
    }

    public final boolean isZeroOutInitial() {
        return this.zeroOutInitial;
    }

    public final FileOpenMode getOpenMode() {
        return this.openMode;
    }

    public final PktRecoveryLog setPageSize(int val) {
        if (this.isOpen()) {
            throw new IllegalStateException("this configuration parameter cannot be set after the log has been opened");
        }
        if (val <= 0) {
            throw new IllegalArgumentException("page size must be > 0");
        }
        this.pageSize = IOBuffer.slabSize((int)val);
        if (!this.readBufferSizeExplictlySet) {
            this.readBufferSize = this.pageSize * 2;
        }
        if (!this.writeBufferSizeExplictlySet) {
            this.writeBufferSize = this.pageSize * 2;
        }
        this.adjustInitialLengthToAlignOnPageSizeBoundary();
        return this;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final PktRecoveryLog setReadBufferSize(int val) {
        if (this.isOpen()) {
            throw new IllegalStateException("this configuration parameter cannot be set after the log has been opened");
        }
        if (val <= 0) {
            throw new IllegalArgumentException("read buffer size must be > 0");
        }
        this.readBufferSize = IOBuffer.slabSize((int)val);
        this.readBufferSizeExplictlySet = true;
        return this;
    }

    public final int getReadBufferSize() {
        return this.readBufferSize;
    }

    public final PktRecoveryLog setWriteBufferSize(int val) {
        if (this.isOpen()) {
            throw new IllegalStateException("this configuration parameter cannot be set after the log has been opened");
        }
        if (val > 0 && this.isFlushDirectFromPacket()) {
            throw new IllegalStateException("write buffer size cannot be set on log configured for direct flush from packet");
        }
        this.writeBufferSize = val <= 0 ? val : IOBuffer.slabSize((int)val);
        this.writeBufferSizeExplictlySet = true;
        return this;
    }

    public final int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public final PktRecoveryLog setFlushUsingMappedMemory(boolean val) {
        if (this.isOpen()) {
            throw new IllegalStateException("this configuration parameter cannot be set after the log has been opened");
        }
        this.flushUsingMappedMemory = val;
        return this;
    }

    public final boolean isFlushUsingMappedMemory() {
        return this.flushUsingMappedMemory;
    }

    public final PktRecoveryLog setFlushDirectFromPacket(boolean val) {
        if (this.isOpen()) {
            throw new IllegalStateException("this configuration parameter cannot be set after the log has been opened");
        }
        this.flushDirectFromPacket = val;
        if (this.flushDirectFromPacket) {
            this.setWriteBufferSize(0);
        }
        return this;
    }

    public final boolean isFlushDirectFromPacket() {
        return this.flushDirectFromPacket;
    }

    public final void shrinkToSize() throws IOException {
        if (this.eof != null) {
            if (this.tracer.debug) {
                this.tracer.log("Shrinking log '" + this.filename + "' to size.", Tracer.Level.DEBUG);
            }
        } else {
            throw new IllegalStateException("Can't shrink a closed log");
        }
        this.file.setLength(this.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void open(int flags, long startingPos, ILogIntegrityChecker logIntegrityChecker) throws EPktException {
        try {
            this.checkpointState = PktFactory.getInstance().createPacket(261);
            ((PktBodyRecoveryLogCheckpointState)this.checkpointState.getBody()).setState(CheckpointState.DONE.toString());
        }
        catch (Exception e) {
            throw new EPktException("Failed to create checkpoint state packet for log [" + e.toString() + "]");
        }
        this.supportTailing = (flags & 128) == 128;
        skipIntegrityCheck = this.openMode == FileOpenMode.r && (flags & 256) == 256;
        autoRepair = (flags & 2) == 2;
        this.prepareEOFMarker();
        try {
            logfileExists = new File(this.filename).exists();
            this.checkLogPresenceExpectations(flags, logfileExists);
            dir = new File(this.dirname);
            if (!dir.exists()) {
                if (this.tracer.debug) {
                    this.tracer.log("Creating log directory '" + this.dirname + "'", Tracer.Level.DEBUG);
                }
                if (!dir.mkdirs()) {
                    throw new EPktException("Failed to create log directory '" + this.dirname + "'");
                }
            } else if (this.tracer.debug) {
                this.tracer.log("Directory already exists.", Tracer.Level.DEBUG);
            }
            switch (2.$SwitchMap$com$neeve$pkt$log$PktRecoveryLog$FileOpenMode[this.openMode.ordinal()]) {
                case 1: {
                    mode = "r";
                    break;
                }
                case 2: {
                    mode = "rw";
                    break;
                }
                case 3: {
                    mode = "rws";
                    break;
                }
                case 4: {
                    mode = "rwd";
                    break;
                }
                default: {
                    throw new EPktException("Unsupported file open mode '" + (Object)this.openMode + "'");
                }
            }
            if (this.tracer.debug) {
                this.tracer.log("Opening log '" + this.filename + "' using open mode='" + mode + "' (supportTailing = " + this.supportTailing + ")", Tracer.Level.DEBUG);
                if ((flags & 32) == 32) {
                    this.tracer.log("...emptiness expectation is 'Not Empty'", Tracer.Level.DEBUG);
                } else if ((flags & 4) == 4) {
                    this.tracer.log("...emptiness expectation is 'Empty'", Tracer.Level.DEBUG);
                } else {
                    this.tracer.log("...emptiness expectation is 'No Expectation'", Tracer.Level.DEBUG);
                }
            }
            this.file = new RandomAccessFile(this.filename, mode);
            this.fileChannel = this.file.getChannel();
            this.flushUsingNative = false;
            if (PktRecoveryLog.nativeFileIOEnabled) {
                if (!this.flushUsingMappedMemory) {
                    try {
                        fileDescriptor = this.file.getFD();
                        field = fileDescriptor.getClass().getDeclaredField("fd");
                        if (field != null) {
                            field.setAccessible(true);
                            fd = (Integer)field.get(fileDescriptor);
                            if (fd != null) {
                                this.nfile = UtlFile.nativeWrap((int)fd);
                                this.flushUsingNative = true;
                                if (!this.tracer.debug) ** GOTO lbl81
                                this.tracer.log("...successfully configured to use native file IO (fd = " + fd + ")", Tracer.Level.DEBUG);
                            }
                            this.nfile = -1L;
                            if (!this.tracer.debug) ** GOTO lbl81
                            this.tracer.log("...native file IO enabled but could not obtain value for 'fd' field", Tracer.Level.DEBUG);
                        }
                        this.nfile = -1L;
                        if (!this.tracer.debug) ** GOTO lbl81
                        this.tracer.log("...native file IO enabled but could not find field named 'fd' in file descriptor class", Tracer.Level.DEBUG);
                    }
                    catch (Exception e) {
                        throw new EPktException(e);
                    }
                } else {
                    this.nfile = -1L;
                    if (this.tracer.debug) {
                        this.tracer.log("...not using native file IO [flush using mapped memory enabled]", Tracer.Level.DEBUG);
                    }
                }
            } else {
                this.nfile = -1L;
                if (this.tracer.debug) {
                    this.tracer.log("...cannot use native file IO [native file IO not enabled]", Tracer.Level.DEBUG);
                }
            }
lbl81:
            // 10 sources

            sb = new StringBuilder();
            sb.append("Packet log '").append(this.filename).append("' configuration {\n");
            sb.append("...openMode=").append((Object)this.openMode).append("\n");
            sb.append("...initialLength=").append(this.initialLength).append("\n");
            sb.append("...zeroOutInitial=").append(this.zeroOutInitial).append("\n");
            sb.append("...pageSize=").append(this.pageSize).append("\n");
            sb.append("...readBufferSize=").append(this.readBufferSize).append("\n");
            sb.append("...writeBufferSize=").append(this.writeBufferSize).append("\n");
            sb.append("...flushUsingMappedMemory=").append(this.flushUsingMappedMemory).append("\n");
            sb.append("...flushDirectFromPacket=").append(this.flushDirectFromPacket).append("\n");
            sb.append("...flushUsingNativeIO=").append(this.flushUsingNative).append("\n");
            sb.append("...supportTailing=").append(this.supportTailing).append("\n");
            sb.append("...skipIntegrityCheckOnOpen=").append(skipIntegrityCheck).append("\n");
            sb.append("...autoRepair=").append(autoRepair).append("\n");
            sb.append("}");
            this.tracer.log(sb.toString(), Tracer.Level.CONFIG);
            if (!logfileExists) {
                if (this.openMode == FileOpenMode.r) {
                    throw new EPktLogInvalidException("no file to read");
                }
                this.checkLogEmptinessExpectations(flags, false);
                if (this.tracer.debug) {
                    this.tracer.log("Creating new log...", Tracer.Level.DEBUG);
                }
                try {
                    ts = System.currentTimeMillis();
                    if (this.zeroOutInitial) {
                        data = new byte[this.pageSize];
                        numBlocks = this.initialLength / (long)this.pageSize;
                        if (this.tracer.debug) {
                            this.tracer.log("Preallocating log by zeroing out (" + numBlocks + " blocks, " + data.length + " bytes each)...", Tracer.Level.DEBUG);
                        }
                        i = 0;
                        while ((long)i < numBlocks) {
                            this.file.write(data, 0, data.length);
                            ++i;
                        }
                        this.file.getFD().sync();
                    } else {
                        if (this.tracer.debug) {
                            this.tracer.log("Preallocating log by setting length to " + this.initialLength + ".", Tracer.Level.DEBUG);
                        }
                        this.file.setLength(this.initialLength);
                    }
                    this.tracer.log("Log creation (length=" + this.initialLength + ", mode=" + (this.zeroOutInitial != false ? "zeroOut" : "setLength") + ") took " + (System.currentTimeMillis() - ts) + " milliseconds.", Tracer.Level.INFO);
                    this.file.seek(0L);
                    this.preamble = new Preamble(1);
                    this.preamble.write(this.file);
                    this.writeEof();
                }
                catch (IOException e) {
                    throw new EPktException("Log '" + this.filename + "' init failure [" + e.toString() + "]");
                }
                if (this.tracer.debug) {
                    this.tracer.log("Log created <initialLength=" + this.initialLength + " preamble=" + this.preamble + ">", Tracer.Level.DEBUG);
                }
            } else {
                ts = System.currentTimeMillis();
                formatVersion = this.file.readByte();
                if (formatVersion == 1) {
                    this.preamble = new Preamble(formatVersion);
                    this.preamble.read(this.file);
                    if (!skipIntegrityCheck) {
                        block66: {
                            packetHandler = new IntegrityCheckPacketHandler(logIntegrityChecker);
                            reader = new MemoryMappedReader(this.filename, packetHandler, null, this.supportTailing != false ? 50 : 0, this.tracer);
                            skippedValidatedEntries = false;
                            try {
                                if (this.file.length() == (long)this.preamble.getSerializedLength()) {
                                    throw new EPktLogCorruptException("EOF but no EOF marker");
                                }
                                if (startingPos >= 0L && !autoRepair) {
                                    if (!reader.isValidAt(startingPos)) {
                                        reader.reset();
                                        this.tracer.log("Unable to open log from specified starting position: " + startingPos + ", attempt to start from begining instead", Tracer.Level.WARNING);
                                    } else {
                                        v0 = skippedValidatedEntries = startingPos > (long)this.preamble.getSerializedLength();
                                    }
                                }
                                if ((readCompletionReason = reader.read()) != MemoryMappedReader.ReadCompletionReason.EndOfFile) {
                                    throw new InternalError("read completed with an unexpected completion code '" + (Object)readCompletionReason + "'");
                                }
                                packetHandler.done();
                                this.completeOpen(reader.filePointer(), false);
                                numValidEntries = packetHandler.numValidEntries();
                                this.checkLogEmptinessExpectations(flags, numValidEntries > 0 || skippedValidatedEntries != false);
                                this.tracer.log("Log open (size=" + this.logSize + ", entries=" + (skippedValidatedEntries != false ? ">" : "") + numValidEntries + ") took " + (System.currentTimeMillis() - ts) + " milliseconds.", Tracer.Level.INFO);
                            }
                            catch (EPktLogCorruptException e) {
                                numValidEntries = packetHandler.numValidEntries();
                                recoverableFileLength = packetHandler.validatedFileLength();
                                this.tracer.log("***** Log '" + this.filename + "' is corrupt [" + e.toString() + "].", Tracer.Level.WARNING);
                                this.tracer.log("***** ...[preamble=" + this.preamble + ", recoverableEntries=" + (skippedValidatedEntries != false ? ">" : "") + numValidEntries + ", recoverableLength=" + recoverableFileLength + "]", Tracer.Level.WARNING);
                                if (autoRepair) {
                                    this.tracer.log("***** ...auto-repairing and continuing...", Tracer.Level.WARNING);
                                    backedUpFilename = PktRecoveryLog.backup(this.dirname, this.filenameOnly, false, false, false);
                                    this.tracer.log("***** ...corrupt file backed up to '" + backedUpFilename + "'...", Tracer.Level.WARNING);
                                    this.completeOpen(recoverableFileLength, true);
                                    this.tracer.log("***** ...recovered " + numValidEntries + " entries.", Tracer.Level.WARNING);
                                    this.wasRepaired = true;
                                    this.checkLogEmptinessExpectations(flags, numValidEntries > 0);
                                    break block66;
                                }
                                throw e;
                            }
                            finally {
                                reader.close();
                            }
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("Loaded log from disk <preamble=" + this.preamble + ", numEntries=" + (skippedValidatedEntries != false ? ">" : "") + numValidEntries + ", fp=" + this.file.getFilePointer() + ">", Tracer.Level.DEBUG);
                        }
                    } else {
                        this.logSize = -1L;
                        if (this.tracer.fine) {
                            this.tracer.log("Log '" + this.filename + "' open with integrity checks bypassed.", Tracer.Level.FINE);
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("Opened log for pure read (EOF not validated)", Tracer.Level.DEBUG);
                        }
                    }
                } else {
                    throw new EPktLogInvalidException("unsupported version [exp=1 actual=" + formatVersion + "]");
                }
            }
            if (this.openMode != FileOpenMode.r) {
                if (this.flushUsingMappedMemory) {
                    this.mappedFilePointer = this.file.getFilePointer();
                    v1 = this.mapFileAt(this.mappedFilePointer, 0);
                } else {
                    v1 = null;
                }
                this.mappedFileBuffer = v1;
                this.writeBuffer = IOElasticBuffer.create((int)Math.max(this.writeBufferSize, 8192));
                this.writeBuffer.setLength(0);
                this.flushBuffers = new ByteBuffer[10];
                this.nativeFlushBuffers = new long[10];
                this.nativeFlushBufferLengths = new int[10];
                this.subheaders = new PktSubheader[7];
            }
        }
        catch (FileNotFoundException e) {
            throw new EPktLogNotFoundException(this.filename);
        }
        catch (IOException e) {
            throw new EPktException("I/O error during log open [" + e.toString() + "]");
        }
        try {
            this.fileForStats = new RandomAccessFile(this.filename, "r");
        }
        catch (Throwable thrown) {
            this.tracer.log("Unable to open file '" + this.filename + "' for stats [" + thrown.getMessage() + "]", Tracer.Level.WARNING);
        }
    }

    public final void open(int flags, long startingPos) throws EPktException {
        this.open(flags, startingPos, null);
    }

    public final void open() throws EPktException {
        this.open(0, -1L);
    }

    public final void open(int flags) throws EPktException {
        this.open(flags, -1L);
    }

    public final boolean isOpen() {
        return this.file != null;
    }

    public final Reader createReader() throws IOException {
        if (this.tracer.debug) {
            this.tracer.log("Opening private reader for '" + this.filename + "' (supportTailing=" + this.supportTailing + ")", Tracer.Level.DEBUG);
        }
        return new Reader(this.filename, this.supportTailing ? 50 : 0, this.readBufferSize, this.tracer);
    }

    public final MemoryMappedReader createMemoryMappedReader(IPacketBufferReceiver receiver) throws IOException {
        if (this.tracer.debug) {
            this.tracer.log("Opening private memory mapped reader for '" + this.filename + "' (supportTailing=" + this.supportTailing + ")", Tracer.Level.DEBUG);
        }
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be null");
        }
        return new MemoryMappedReader(this.filename, receiver, this.supportTailing ? 50 : 0, this.tracer);
    }

    public final MemoryMappedReader createMemoryMappedReader(IPacketReceiver receiver) throws IOException {
        if (this.tracer.debug) {
            this.tracer.log("Opening private memory mapped reader for '" + this.filename + "' (supportTailing=" + this.supportTailing + ")", Tracer.Level.DEBUG);
        }
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be null");
        }
        return new MemoryMappedReader(this.filename, receiver, this.supportTailing ? 50 : 0, this.tracer);
    }

    public final boolean wasRepaired() {
        if (this.file == null) {
            throw new IllegalStateException("log not opened");
        }
        return this.wasRepaired;
    }

    public final boolean supportsTailing() {
        return this.supportTailing;
    }

    public final long getCheckpointCount() {
        return this.preamble.checkpointCount;
    }

    public final long getSize() {
        return this.logSize + (long)this.preamble.getSerializedLength() + (long)this.eofLength;
    }

    public final long getAllocatedSize() {
        RandomAccessFile currentFile = this.fileForStats;
        if (currentFile == null || !currentFile.getChannel().isOpen()) {
            return 0L;
        }
        try {
            return currentFile.length();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public final long getNextWritePointer() {
        return this.logSize + (long)this.preamble.getSerializedLength();
    }

    public final void write(PktPacket packet, int flags) throws EPktException {
        int serializedLength;
        FilePosition position;
        if (this.tracer.debug) {
            this.tracer.log("Writing " + (Object)((Object)packet.getHeader()) + " to log...", Tracer.Level.DEBUG);
        }
        if ((position = (FilePosition)packet.getTag(4)) == null) {
            position = new FilePosition();
            packet.setTag(4, position);
        }
        position.setPosition(this.logSize + (long)this.preamble.getSerializedLength());
        if (this.tracer.debug) {
            this.tracer.log("Packet position in log is " + position.getPosition() + ".", Tracer.Level.DEBUG);
        }
        boolean flush = false;
        if (this.flushDirectFromPacket) {
            if (this.tracer.debug) {
                this.tracer.log("Writing directly from packet to file.", Tracer.Level.DEBUG);
            }
            try {
                serializedLength = this.flushUsingMappedMemory ? this.flushPacketUsingMemoryMappedIO(packet) : (this.flushUsingNative ? this.flushPacketUsingNativeGatheringIO(packet) : this.flushPacketUsingGatheringIO(packet));
            }
            catch (Throwable e) {
                throw this.prepareFlushException(e);
            }
        } else {
            serializedLength = this.serializePacketToBuffer(packet, this.writeBuffer);
            flush = this.writeBuffer.getLength() >= this.writeBufferSize;
        }
        position.setSize(serializedLength);
        this.logSize += (long)serializedLength;
        if (flush) {
            if (this.tracer.debug) {
                this.tracer.log("Write buffer size (" + this.writeBufferSize + ") exceeded. Flushing...", Tracer.Level.DEBUG);
            }
            this.flush(flags);
            if (enableWriteChecks && !this.flushUsingMappedMemory) {
                try {
                    if (this.file.getFilePointer() != position.getPosition() + (long)serializedLength) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Unexpected file pointer after flush: " + this.file.getFilePointer() + " but expected " + (position.getPosition() + (long)serializedLength) + "!\n");
                        sb.append("POSSIBLE LOG CORRUPTION\n");
                        sb.append("  Packet:").append((Object)packet).append("\n");
                        throw new EPktException(sb.toString());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public final void setCheckpointState(CheckpointState state) throws EPktException {
        if (state == CheckpointState.DONE) {
            if (this.tracer.debug) {
                this.tracer.log("Truncating log...", Tracer.Level.DEBUG);
            }
            try {
                ++this.preamble.checkpointCount;
                this.file.seek(0L);
                this.preamble.write(this.file);
                this.writeEof();
            }
            catch (IOException e) {
                throw new EPktException("Log truncate failure [" + e.toString() + "]");
            }
            this.writeBuffer.setLength(0);
            this.logSize = 0L;
            if (this.tracer.debug) {
                this.tracer.log("  Done <preamble=" + this.preamble + ">.", Tracer.Level.DEBUG);
            }
        } else {
            ((PktBodyRecoveryLogCheckpointState)this.checkpointState.getBody()).setState(state.toString());
            this.write(this.checkpointState, 1);
            this.flush(1);
        }
    }

    public final CheckpointState getCheckpointState() {
        return CheckpointState.valueOf(((PktBodyRecoveryLogCheckpointState)this.checkpointState.getBody()).getState());
    }

    public final boolean hasBufferedDataToFlush() {
        return this.writeBuffer != null && this.writeBuffer.getLength() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush(int flags) throws EPktException {
        if (this.tracer.debug) {
            this.tracer.log("Flushing log to disk...", Tracer.Level.DEBUG);
        }
        try {
            int numDirtyBytes;
            int n = numDirtyBytes = this.writeBuffer != null ? this.writeBuffer.getLength() : 0;
            if (numDirtyBytes > 0) {
                try {
                    if (this.flushUsingMappedMemory) {
                        this.flushBufferUsingMemoryMappedIO(this.writeBuffer, numDirtyBytes);
                    }
                    if (this.flushUsingNative) {
                        this.nativeFlushBuffers[0] = this.writeBuffer.getBackingBufferUnsafe().getNativeAddress();
                        this.nativeFlushBufferLengths[0] = numDirtyBytes;
                        this.flushBuffersUsingNativeGatheringIO(1, numDirtyBytes);
                    }
                    ByteBuffer flushBuffer = this.writeBuffer.getBackingBufferUnsafe().takeBuffer();
                    try {
                        this.flushBuffers[0] = flushBuffer;
                        this.flushBuffers[0].limit(numDirtyBytes);
                        this.flushBuffersUsingGatheringIO(1, numDirtyBytes);
                    }
                    finally {
                        this.writeBuffer.getBackingBufferUnsafe().releaseBuffer();
                    }
                }
                finally {
                    this.writeBuffer.setLength(0);
                }
            } else if (this.tracer.debug) {
                this.tracer.log("Nothing to flush.", Tracer.Level.DEBUG);
            }
            if ((flags & 1) == 1) {
                if (this.tracer.debug) {
                    this.tracer.log("Force sync to file...", Tracer.Level.DEBUG);
                }
                if (this.flushUsingMappedMemory) {
                    if (this.mappedFileBuffer != null) {
                        this.mappedFileBuffer.force();
                    }
                } else {
                    this.file.getFD().sync();
                }
            } else if (this.tracer.debug) {
                this.tracer.log("Not force sync to file...", Tracer.Level.DEBUG);
            }
        }
        catch (Throwable e) {
            throw this.prepareFlushException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void close(boolean sync) throws EPktException {
        if (this.file != null) {
            try {
                this.flush(sync ? 1 : 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.file != null) {
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Closing log file...", Tracer.Level.DEBUG);
                }
                this.file.close();
                this.file = null;
            }
            catch (IOException e) {
                throw new EPktException("Log file close failure [" + e.toString() + "]");
            }
            finally {
                if (this.nfile >= 0L) {
                    UtlFile.nativeDestroy((long)this.nfile);
                }
                if (this.fileForStats != null) {
                    try {
                        this.fileForStats.close();
                    }
                    catch (IOException e) {
                        this.tracer.log("Log stats file instance close failure [" + e.toString() + "]", Tracer.Level.WARNING);
                    }
                    finally {
                        this.fileForStats = null;
                    }
                }
            }
        }
        if (this.mappedFileBuffer == null) return;
        try {
            UtlBuffer.releaseBuffer((ByteBuffer)this.mappedFileBuffer);
            return;
        }
        catch (RuntimeException re) {
            throw new EPktException("Log file unmap failure [" + re.toString() + "]", re);
        }
    }

    public final void close() throws EPktException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(Appendable w) throws IOException {
        try (Reader reader = this.createReader();){
            PktPacket packet = reader.next();
            long nextReadPos = -1L;
            boolean eof = false;
            try {
                while (packet != null) {
                    FilePosition fp = (FilePosition)packet.getTag(4);
                    if (fp != null) {
                        w.append("[fp:").append(String.valueOf(fp.getPosition())).append(", size:").append(String.valueOf(fp.getSize())).append("]");
                    }
                    PktFactory.PktType type = null;
                    try {
                        type = PktFactory.getInstance().getPacketType(packet.getBody().getType());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    w.append("[").append(String.valueOf(type)).append("]").append(packet.toString()).append("\n");
                    nextReadPos = fp.position + (long)fp.size;
                    packet = reader.readAt(nextReadPos);
                    if (packet != null) continue;
                    w.append("[EOF]\n");
                    eof = true;
                    packet = reader.readAt(nextReadPos + (long)this.eofLength);
                    eof = false;
                }
            }
            catch (EPktLogInvalidPositionException e) {
                if (eof) {
                    w.append("EOF reached ... no additional packets immediately after it.\n");
                } else {
                    w.append("Corrupted Packet detected: ").append(UtlThrowable.prepareStackTrace((Throwable)((Object)e))).append("\n");
                }
            }
            catch (EPktLogCorruptException e) {
                if (eof) {
                    w.append("EOF reached ... no additional packets immediately after it.\n");
                }
                w.append("Corrupted Packet detected: ").append(UtlThrowable.prepareStackTrace((Throwable)((Object)e))).append("\n");
            }
            w.append("Read ").append(String.valueOf(nextReadPos)).append("/").append(String.valueOf(reader.file.length())).append(" bytes worth of packets from log.\n");
            if (nextReadPos < reader.file.length()) {
                ByteBuffer buffer = ByteBuffer.allocate(1024);
                int read = reader.file.getChannel().read(buffer, nextReadPos);
                buffer.flip();
                w.append("First ").append(String.valueOf(read)).append(" bytes after last packet:").append(UtlBuffer.dump((String)"", (ByteBuffer)buffer, (int)0, (int)read)).append("\n");
            }
        }
    }

    public static interface ILogIntegrityChecker {
        public void init(long var1);

        public void onPacket(IOBuffer var1, int var2, int var3, long var4);

        public void done();

        public boolean corruptionDetected();

        public int numValidEntries();

        public long validatedFileLength();
    }

    public static interface IPacketReceiver {
        public void onPacket(PktPacket var1);
    }

    public static interface IPacketBufferReceiver {
        public void onPacket(IOBuffer var1, int var2, int var3, long var4);

        public void onBufferChange(IOBuffer var1, IOBuffer var2);
    }

    public static final class Reader {
        private final Tracer tracer;
        private final String filename;
        private final int readBufferSize;
        private final int maxReadFailsForCorruption;
        private final RandomAccessFile file;
        private final FileChannel fileChannel;
        private final Marker marker;
        private final ReadContext readContext;
        private ReadContext readOneContext;

        Reader(String filename, int maxReadFailsForCorruption, int readBufferSize, Tracer tracer) throws IOException {
            this.filename = filename;
            this.tracer = tracer;
            this.readBufferSize = readBufferSize;
            this.maxReadFailsForCorruption = maxReadFailsForCorruption;
            this.file = new RandomAccessFile(filename, "r");
            this.fileChannel = this.file.getChannel();
            this.marker = new Marker();
            this.readContext = new ReadContext(readBufferSize);
            this.reset();
        }

        private final void waitForMoreDataToBeWritten() {
            if (this.tracer.debug) {
                this.tracer.log("  ...assuming log data is partial. Waiting for more data to arrive in log...", Tracer.Level.DEBUG);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log("  ...done waiting.", Tracer.Level.DEBUG);
                }
            }
        }

        private final void onReadFail(int numReadFails, Throwable e, String reason) {
            if (numReadFails > this.maxReadFailsForCorruption) {
                if (this.tracer.debug) {
                    if (this.maxReadFailsForCorruption > 0) {
                        this.tracer.log("  ...timed out waiting for partial data issue to resolve.", Tracer.Level.DEBUG);
                    } else {
                        this.tracer.log("  ...log is corrupt.", Tracer.Level.DEBUG);
                    }
                }
                if (e != null) {
                    throw new EPktLogCorruptException(e);
                }
                throw new EPktLogCorruptException(reason);
            }
            this.waitForMoreDataToBeWritten();
        }

        private final void tagPacketWithFilePositionAndSize(PktPacket packet, long packetFilePointer, int packetSize) {
            FilePosition position = (FilePosition)packet.getTag(4);
            if (position == null) {
                position = new FilePosition();
                packet.setTag(4, position);
            }
            position.setPosition(packetFilePointer);
            position.setSize(packetSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final Reader read(int maxToRead) throws IOException {
            numReadFails = 0;
            eofReached = false;
            this.readContext.init(this.file.getFilePointer());
            if (this.tracer.debug) {
                this.tracer.log("Reading from log...", Tracer.Level.DEBUG);
            }
            try {
                block9: while (!eofReached && ReadContext.access$400(this.readContext).count() == 0) {
                    block28: {
                        buffer = ReadContext.access$800(this.readContext);
                        if (this.tracer.debug) {
                            this.tracer.log("  Reading " + this.readContext + "...", Tracer.Level.DEBUG);
                        }
                        if ((bytesRead = this.fileChannel.read(buffer)) <= 0) break block28;
                        if (this.tracer.debug) {
                            this.tracer.log("  Read " + bytesRead + " bytes " + this.readContext + ".", Tracer.Level.DEBUG);
                        }
                        buffer.flip();
                        ** GOTO lbl29
                    }
                    if (bytesRead == 0) {
                        throw new InternalError("Zero bytes read [buffer=" + buffer + "]!");
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("  Hit EOF with no EOF marker", Tracer.Level.DEBUG);
                    }
                    try {
                        this.onReadFail(++numReadFails, null, "EOF but no EOF marker");
                    }
                    catch (EPktLogCorruptException e) {
                        if (ReadContext.access$400(this.readContext).count() <= 0) {
                            throw e;
                        }
                        break;
lbl29:
                        // 1 sources

                        do {
                            block27: {
                                if (this.tracer.debug) {
                                    this.tracer.log("  Deserializing " + this.readContext + "...", Tracer.Level.DEBUG);
                                }
                                packet = null;
                                try {
                                    packetSize = PktHeader.getSerializedPacketLength(buffer, buffer.position(), buffer.remaining());
                                    if (packetSize <= 0 || packetSize > buffer.remaining()) break block27;
                                    packet = PktFactory.getInstance().createPacket(PktHeader.getBodyType(buffer, buffer.position()));
                                    if (packetSize != packet.deserialize(buffer, buffer.position())) {
                                        throw new InternalError("serialized packet length in header is different from actual serialized packet length");
                                    }
                                    buffer.position(buffer.position() + packetSize);
                                }
                                catch (Throwable e) {
                                    packetBufferPos = buffer.position();
                                    packetBufferLimit = buffer.limit();
                                    try {
                                        if (this.tracer.debug) {
                                            this.tracer.log("  LOG READ ERROR [Deserialization failed]", Tracer.Level.DEBUG);
                                        }
                                        this.readContext.rollback();
                                        this.onReadFail(++numReadFails, e, null);
                                        if (!this.tracer.debug) continue block9;
                                        this.tracer.log("  ...buffer prepared for next read " + this.readContext + ".", Tracer.Level.DEBUG);
                                        continue block9;
                                    }
                                    catch (EPktLogCorruptException e1) {
                                        if (ReadContext.access$400(this.readContext).count() <= 0) {
                                            PktUtils.dumpCorruptedSerializedPacket("Corrupted packet in file '" + this.filename + "' at offset " + ReadContext.access$900(this.readContext), buffer, packetBufferPos, packetBufferLimit, e, this.tracer);
                                            throw e1;
                                        }
                                        if (!this.tracer.debug) continue block9;
                                        this.tracer.log("  ..." + ReadContext.access$400(this.readContext).count() + " packets have been succesfully read before the error. dispatching those...", Tracer.Level.DEBUG);
                                        continue block9;
                                    }
                                }
                            }
                            if (packet != null) {
                                if (this.tracer.debug) {
                                    this.tracer.log("  Deserialized full packet of size = " + packetSize + " bytes (type=" + packet.getBody().getType() + ")" + this.readContext + ".", Tracer.Level.DEBUG);
                                }
                                if (eofReached = packet.getBody().getType() == 262) {
                                    this.readContext.rollback();
                                    if (!this.tracer.debug) continue;
                                    this.tracer.log("  EOF reached " + this.readContext + ".", Tracer.Level.DEBUG);
                                    continue;
                                }
                                this.tagPacketWithFilePositionAndSize(packet, ReadContext.access$900(this.readContext), packetSize);
                                this.readContext.commit(packet, packetSize);
                                if (!this.tracer.debug) continue;
                                this.tracer.log("  EOF not reached " + this.readContext + ".", Tracer.Level.DEBUG);
                                continue;
                            }
                            numCurrentPacketBytesInBuffer = buffer.remaining();
                            if (this.tracer.debug) {
                                this.tracer.log("  Deserialized partial packet (addtnl=" + (packetSize - numCurrentPacketBytesInBuffer) + ") " + this.readContext + ".", Tracer.Level.DEBUG);
                            }
                            this.readContext.compact(packetSize);
                            continue block9;
                        } while (!eofReached && ReadContext.access$400(this.readContext).count() < maxToRead);
                    }
                }
            }
            finally {
                this.readContext.rollback();
            }
            if (this.tracer.debug) {
                this.tracer.log("Done " + this.readContext + ".", Tracer.Level.DEBUG);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final PktPacket readOne(long filePointer) throws IOException {
            block29: {
                block28: {
                    packet = null;
                    numReadFails = 0;
                    eofReached = false;
                    if (this.readOneContext == null) {
                        this.readOneContext = new ReadContext(this.readBufferSize);
                    }
                    currentFilePointer = this.file.getFilePointer();
                    this.readOneContext.init(filePointer);
                    if (this.tracer.debug) {
                        this.tracer.log("Reading from log...", Tracer.Level.DEBUG);
                    }
                    this.file.seek(filePointer);
                    while (true) {
                        if (eofReached || ReadContext.access$400(this.readOneContext).count() != 0) break block28;
                        buffer = ReadContext.access$800(this.readOneContext);
                        if (this.tracer.debug) {
                            this.tracer.log("  Reading " + this.readOneContext + "...", Tracer.Level.DEBUG);
                        }
                        if ((bytesRead = this.fileChannel.read(buffer)) > 0) {
                            if (this.tracer.debug) {
                                this.tracer.log("  Read " + bytesRead + " bytes " + this.readOneContext + ".", Tracer.Level.DEBUG);
                            }
                            buffer.flip();
                            if (this.tracer.debug) {
                                this.tracer.log("  Prepared buffer for deserialize " + this.readOneContext + ".", Tracer.Level.DEBUG);
                            }
                            break block29;
                        }
                        if (bytesRead == 0) {
                            throw new InternalError("Zero bytes read [buffer=" + buffer + "]!");
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("  Hit EOF with no EOF marker", Tracer.Level.DEBUG);
                        }
                        this.onReadFail(++numReadFails, null, "EOF but no EOF marker");
                        continue;
                        break;
                    }
                    finally {
                        this.file.seek(currentFilePointer);
                    }
                }
                if (this.tracer.debug) {
                    this.tracer.log("Done " + this.readOneContext + ".", Tracer.Level.DEBUG);
                }
                if (ReadContext.access$400((ReadContext)this.readOneContext).count == 0) {
                    return null;
                }
                packet = (PktPacket)ReadContext.access$400(this.readOneContext).first();
                if (packet != null) {
                    packet.unlink();
                }
                return packet;
            }
            do {
                if (this.tracer.debug) {
                    this.tracer.log("  Deserializing...", Tracer.Level.DEBUG);
                }
                packet = null;
                try {
                    packetSize = PktHeader.getSerializedPacketLength(buffer, buffer.position(), buffer.remaining());
                    if (packetSize > 0 && packetSize <= buffer.remaining()) {
                        packet = PktFactory.getInstance().createPacket(PktHeader.getBodyType(buffer, buffer.position()));
                        if (packetSize != packet.deserialize(buffer, buffer.position())) {
                            throw new InternalError("serialized packet length in header is different from actual serialized packet length");
                        }
                        buffer.position(buffer.position() + packetSize);
                    }
                }
                catch (Throwable e) {
                    packetBufferPos = buffer.position();
                    packetBufferLimit = buffer.limit();
                    try {
                        if (this.tracer.debug) {
                            this.tracer.log("  LOG READ ERROR [Deserialization failed]", Tracer.Level.DEBUG);
                        }
                        this.readOneContext.rollback();
                        this.onReadFail(++numReadFails, e, null);
                        if (!this.tracer.debug) ** GOTO lbl-1000
                        this.tracer.log("  ...buffer prepared for next read " + this.readOneContext + ".", Tracer.Level.DEBUG);
                        ** GOTO lbl-1000
                    }
                    catch (EPktLogCorruptException e1) {
                        PktUtils.dumpCorruptedSerializedPacket("Corrupted packet in file '" + this.filename + "' at offset " + ReadContext.access$900(this.readOneContext), buffer, packetBufferPos, packetBufferLimit, e, this.tracer);
                        throw e1;
                    }
                }
                if (packet != null) {
                    if (this.tracer.debug) {
                        this.tracer.log("  Deserialized full packet of size = " + packetSize + " bytes (type=" + packet.getBody().getType() + ")" + this.readOneContext + ".", Tracer.Level.DEBUG);
                    }
                    if (eofReached = packet.getBody().getType() == 262) {
                        this.readOneContext.rollback();
                        if (!this.tracer.debug) continue;
                        this.tracer.log("  EOF reached " + this.readOneContext + ".", Tracer.Level.DEBUG);
                        continue;
                    }
                    this.tagPacketWithFilePositionAndSize(packet, ReadContext.access$900(this.readOneContext), packetSize);
                    this.readOneContext.commit(packet, packetSize);
                    if (!this.tracer.debug) continue;
                    this.tracer.log("  EOF not reached " + this.readOneContext + ".", Tracer.Level.DEBUG);
                    continue;
                }
                numCurrentPacketBytesInBuffer = buffer.remaining();
                if (this.tracer.debug) {
                    this.tracer.log("  Deserialized partial packet (addtnl=" + (packetSize - numCurrentPacketBytesInBuffer) + ") " + this.readOneContext + ".", Tracer.Level.DEBUG);
                }
                this.readOneContext.compact(packetSize);
                ** GOTO lbl-1000
            } while (!eofReached && ReadContext.access$400(this.readOneContext).count() == 0);
            ** continue;
        }

        private final Reader read() throws IOException {
            return this.read(Integer.MAX_VALUE);
        }

        public final PktPacket readAt(long position) throws IOException {
            if (position >= this.file.length()) {
                throw new EPktLogInvalidPositionException("Invalid position [position " + position + " is greater than the file length]");
            }
            if (position < 0L) {
                throw new EPktLogInvalidPositionException("Invalid position [position " + position + " must be greater than 0]");
            }
            try {
                return this.readOne(position);
            }
            catch (EPktLogCorruptException e) {
                throw new EPktLogInvalidPositionException((Throwable)((Object)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final File dumpAt(FilePosition filePosition) throws IOException {
            File dumpFile = File.createTempFile("PktRecoveryLog", ".dump");
            try (PrintStream out = new PrintStream(new FileOutputStream(dumpFile));){
                out.println("Log dump for " + this.filename + " starting at position '" + filePosition.getPosition() + "' of size " + filePosition.getSize() + " bytes");
                this.marker.mark();
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(filePosition.getSize());
                    this.file.seek(filePosition.getPosition());
                    int bytesRead = this.fileChannel.read(buffer);
                    buffer.flip();
                    out.println(UtlBuffer.dump((String)("Log contents (read size= " + bytesRead + ")"), (ByteBuffer)buffer, (int)0, (int)bytesRead));
                }
                finally {
                    this.marker.restore();
                }
                out.flush();
                File file = dumpFile;
                return file;
            }
        }

        private final PktPacket unlink() {
            PktPacket packet = (PktPacket)this.readContext.validPackets.first();
            if (packet != null) {
                packet.unlink();
            }
            return packet;
        }

        public final PktPacket first() throws IOException {
            return this.reset().read().unlink();
        }

        public final PktPacket next() throws IOException {
            if (this.readContext.validPackets.count() == 0) {
                this.read();
            }
            return this.unlink();
        }

        public final void seek(long pos) throws IOException {
            this.marker.mark();
            try {
                this.file.seek(pos);
                this.read(1);
                this.marker.clear();
            }
            catch (IOException thrown) {
                this.marker.restore();
                throw thrown;
            }
        }

        public final Reader reset() throws IOException {
            PktPacket packet;
            while ((packet = this.unlink()) != null) {
                packet.dispose();
            }
            this.file.seek(9L);
            return this;
        }

        public final long filePointer() throws IOException {
            return this.file.getFilePointer();
        }

        @Deprecated
        public final long lastValidFilePointer() throws IOException {
            return this.filePointer();
        }

        public final void close() throws IOException {
            if (this.tracer.debug) {
                this.tracer.log("Closing reader for '" + this.filename + "'", Tracer.Level.DEBUG);
            }
            this.file.close();
        }

        private final class ReadContext {
            private IOBuffer iobuffer;
            private ByteBuffer buffer;
            private long lastValidFilePointer;
            private final UtlList validPackets;

            ReadContext(int readBufferSize) {
                this.iobuffer = IOBuffer.create((int)readBufferSize);
                this.buffer = this.iobuffer.getBufferUnsafe();
                this.validPackets = UtlList.create();
            }

            final void init(long filePointer) {
                this.buffer.clear();
                this.lastValidFilePointer = filePointer;
            }

            final void commit(PktPacket packet, int packetSize) {
                this.validPackets.append((UtlListElement)packet);
                this.lastValidFilePointer += (long)packetSize;
            }

            final void rollback() throws IOException {
                Reader.this.file.seek(this.lastValidFilePointer);
                this.buffer.clear();
            }

            final void compact(int minBytesNeeded) {
                if (minBytesNeeded > this.buffer.capacity()) {
                    int newSize = ((this.buffer.remaining() + minBytesNeeded) / Reader.this.readBufferSize + 1) * Reader.this.readBufferSize;
                    IOBuffer iobuffer = IOBuffer.create((int)newSize);
                    iobuffer.getBufferUnsafe().put(this.buffer);
                    this.iobuffer.dispose();
                    this.iobuffer = iobuffer;
                    this.buffer = iobuffer.getBufferUnsafe();
                    if (((Reader)Reader.this).tracer.debug) {
                        Reader.this.tracer.log("  Allocated a new buffer (buffer=" + this.buffer + ")", Tracer.Level.DEBUG);
                    }
                } else {
                    this.buffer.compact();
                }
            }

            public final String toString() {
                try {
                    return "[buf=" + this.buffer + ", fp=" + Reader.this.file.getFilePointer() + ", lvfp=" + this.lastValidFilePointer + "]";
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            static /* synthetic */ ByteBuffer access$800(ReadContext x0) {
                return x0.buffer;
            }

            static /* synthetic */ long access$900(ReadContext x0) {
                return x0.lastValidFilePointer;
            }
        }

        private final class Marker {
            private final UtlList currentValidPackets = UtlList.create();
            private long currentFilePointer;

            private Marker() {
            }

            final void mark() throws IOException {
                PktPacket packet;
                this.currentFilePointer = Reader.this.file.getFilePointer();
                while ((packet = Reader.this.unlink()) != null) {
                    this.currentValidPackets.append((UtlListElement)packet);
                }
            }

            final void restore() throws IOException {
                PktPacket packet;
                Reader.this.reset();
                while ((packet = (PktPacket)this.currentValidPackets.first()) != null) {
                    packet.unlink();
                    Reader.this.readContext.validPackets.append((UtlListElement)packet);
                }
                Reader.this.file.seek(this.currentFilePointer);
            }

            final void clear() {
                PktPacket packet;
                this.currentFilePointer = 0L;
                while ((packet = (PktPacket)this.currentValidPackets.first()) != null) {
                    packet.unlink();
                    packet.dispose();
                }
            }
        }
    }

    public static final class MemoryMappedReader {
        private final Tracer tracer;
        private final String filename;
        private final int maxReadFailsForCorruption;
        private final IPacketBufferReceiver packetBufferReceiver;
        private final IPacketReceiver packetReceiver;
        private final RandomAccessFile raf;
        private final FileChannel fileChannel;
        private long filePointer;
        private IOBuffer buffer;
        private long bufferFilePointer;
        private int bufferLength;
        private int bufferPos;
        private volatile boolean running;
        private volatile boolean stopped;
        private volatile boolean closed;

        private MemoryMappedReader(String filename, IPacketBufferReceiver packetBufferReceiver, IPacketReceiver packetReceiver, int maxReadFailsForCorruption, Tracer tracer) {
            this.filename = filename;
            this.tracer = tracer;
            this.maxReadFailsForCorruption = maxReadFailsForCorruption;
            this.packetBufferReceiver = packetBufferReceiver;
            this.packetReceiver = packetReceiver;
            try {
                this.raf = new RandomAccessFile(filename, "r");
                this.fileChannel = this.raf.getChannel();
            }
            catch (FileNotFoundException e) {
                throw new InternalError("file '" + filename + "' reported not found");
            }
            this.filePointer = 9L;
        }

        MemoryMappedReader(String filename, IPacketBufferReceiver receiver, int maxReadFailsForCorruption, Tracer tracer) {
            this(filename, receiver, null, maxReadFailsForCorruption, tracer);
        }

        MemoryMappedReader(String filename, IPacketReceiver receiver, int maxReadFailsForCorruption, Tracer tracer) {
            this(filename, null, receiver, maxReadFailsForCorruption, tracer);
        }

        private final void map(long position, long maxFilePointer, boolean forceRemap) throws IOException {
            long logSize = this.raf.length();
            if (this.tracer.debug) {
                this.tracer.log("Checking to map file at position=" + position + " [forceRemap=" + forceRemap + ", maxFilePointer=" + maxFilePointer + ", logSize=" + logSize + ", bufferFilePointer=" + this.bufferFilePointer + ", bufferLength=" + this.bufferLength + "]", Tracer.Level.DEBUG);
            }
            if (forceRemap || this.buffer == null || position < this.bufferFilePointer || position >= this.bufferFilePointer + (long)this.bufferLength) {
                int bytesToMap = (int)Math.min(Math.min(logSize, maxFilePointer) - position, Integer.MAX_VALUE);
                this.bufferFilePointer = position;
                this.bufferLength = bytesToMap;
                MappedByteBuffer mapBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, this.bufferFilePointer, this.bufferLength);
                IOBuffer oldBuffer = this.buffer;
                this.buffer = IOBuffer.wrap((ByteBuffer)mapBuffer);
                this.bufferPos = 0;
                if (this.packetBufferReceiver != null) {
                    this.packetBufferReceiver.onBufferChange(oldBuffer, this.buffer);
                }
                if (oldBuffer != null) {
                    oldBuffer.dispose();
                }
                if (forceRemap) {
                    if (this.tracer.debug) {
                        this.tracer.log("Requested to forcibly remap to requested position. Created new mapped buffer [bufferFilePointer=" + this.bufferFilePointer + ", bufferLength=" + this.bufferLength + ", bufferPos=" + this.bufferPos + ", logSize=" + logSize + "]", Tracer.Level.DEBUG);
                    }
                } else if (this.tracer.debug) {
                    this.tracer.log("Requested position not in currently mapped section. Created new mapped buffer [bufferFilePointer=" + this.bufferFilePointer + ", bufferLength=" + this.bufferLength + ", bufferPos=" + this.bufferPos + ", logSize=" + logSize + "]", Tracer.Level.DEBUG);
                }
            } else {
                this.bufferPos = (int)(position - this.bufferFilePointer);
                if (this.tracer.debug) {
                    this.tracer.log("Requested buffer position is in currently mapped section. Adjusted buffer position [bufferFilePointer=" + this.bufferFilePointer + ", bufferLength=" + this.bufferLength + ", bufferPos=" + this.bufferPos + ", logSize=" + logSize + "]", Tracer.Level.DEBUG);
                }
            }
        }

        private final void waitForMoreDataToBeWritten() {
            if (this.tracer.debug) {
                this.tracer.log("Assuming log data is partial. Waiting for more data to arrive in log...", Tracer.Level.DEBUG);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log("Done waiting.", Tracer.Level.DEBUG);
                }
            }
        }

        private final void onReadOneError(int errorCode, int numFails) {
            if (this.tracer.debug) {
                this.tracer.log("Read error (" + errorCode + ") (numFails=" + numFails + ")", Tracer.Level.DEBUG);
            }
            if (numFails > this.maxReadFailsForCorruption) {
                throw new EPktLogCorruptException(PktHeader.convertGetSerializedPacketLengthErrorCodeToException(this.buffer.getBufferUnsafe(), this.bufferPos, errorCode).getMessage());
            }
            this.waitForMoreDataToBeWritten();
        }

        private final ReadCompletionReason readOneCore(long maxFilePointer) throws IOException {
            if (this.tracer.debug) {
                this.tracer.log("Reading one packet (fp=" + this.filePointer + ", mfp=" + maxFilePointer + ")...", Tracer.Level.DEBUG);
            }
            if (this.filePointer < maxFilePointer) {
                int numFails = 0;
                while (!this.stopped && !this.closed) {
                    int packetLength;
                    int remaining = this.buffer.getLength() - this.bufferPos;
                    if (this.tracer.debug) {
                        this.tracer.log(remaining + " bytes remaining in buffer.", Tracer.Level.DEBUG);
                    }
                    if ((packetLength = PktHeader.getSerializedPacketLengthNoException(this.buffer, this.bufferPos, remaining)) < 0) {
                        this.onReadOneError(packetLength, ++numFails);
                        continue;
                    }
                    if (packetLength == 0 || packetLength > remaining) {
                        if (this.tracer.debug) {
                            this.tracer.log("End of buffer (packetLength=" + packetLength + ", remaining=" + remaining + "). Mapping new buffer.", Tracer.Level.DEBUG);
                        }
                        this.map(this.filePointer, maxFilePointer, true);
                        remaining = this.buffer.getLength() - this.bufferPos;
                        if (this.tracer.debug) {
                            this.tracer.log("Buffer remapped (packetLength=" + packetLength + ", remaining=" + remaining + ").", Tracer.Level.DEBUG);
                        }
                        if (remaining > 0) {
                            packetLength = PktHeader.getSerializedPacketLengthNoException(this.buffer, this.bufferPos, remaining);
                            if (packetLength < 0) {
                                this.onReadOneError(packetLength, ++numFails);
                                continue;
                            }
                            if (packetLength == 0 || packetLength > remaining) {
                                throw new EPktLogCorruptException("incomplete packet at end of file");
                            }
                        } else {
                            throw new EPktLogCorruptException("EOF but no EOF marker");
                        }
                    }
                    if (PktHeader.getBodyType(this.buffer, this.bufferPos) == 262) {
                        if (this.tracer.debug) {
                            this.tracer.log("End of file.", Tracer.Level.DEBUG);
                        }
                        return ReadCompletionReason.EndOfFile;
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("Dispatching packet (length=" + packetLength + ")", Tracer.Level.DEBUG);
                    }
                    if (this.packetBufferReceiver != null) {
                        this.packetBufferReceiver.onPacket(this.buffer, this.bufferPos, packetLength, this.filePointer);
                    }
                    if (this.packetReceiver != null) {
                        PktPacket packet = PktFactory.getInstance().createPacket(PktHeader.getBodyType(this.buffer, this.bufferPos));
                        packet.deserialize(this.buffer, this.bufferPos, false);
                        this.packetReceiver.onPacket(packet);
                    }
                    this.bufferPos += packetLength;
                    this.filePointer += (long)packetLength;
                    return null;
                }
                return this.closed ? ReadCompletionReason.Closed : ReadCompletionReason.Stopped;
            }
            return ReadCompletionReason.MaxFilePointerReached;
        }

        private final void closeCore() {
            if (this.buffer != null) {
                this.buffer.dispose();
                this.buffer = null;
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                this.tracer.log("Failed to close file underlying memory mapped reader [" + e + "]", Tracer.Level.WARNING);
            }
        }

        public final void seek(long pos) throws IOException {
            if (pos < 9L) {
                throw new IllegalArgumentException("cannot seek to before beginning of file");
            }
            if (pos >= this.raf.length()) {
                throw new IllegalArgumentException("cannot seek to beyond end of file");
            }
            if (this.running) {
                throw new IllegalStateException("cannot seek while running the reader");
            }
            if (this.closed) {
                throw new IllegalStateException("reader is closed");
            }
            this.map(pos, Long.MAX_VALUE, false);
            this.filePointer = pos;
        }

        public final long filePointer() {
            return this.filePointer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final ReadCompletionReason readOne(long maxFilePointer) {
            try {
                Object object = this;
                synchronized (object) {
                    if (this.closed) {
                        throw new IllegalStateException("reader is closed");
                    }
                    if (this.running) {
                        throw new IllegalStateException("already running");
                    }
                    this.stopped = false;
                    this.running = true;
                }
                if (this.tracer.debug) {
                    this.tracer.log("Reading one packet [maxFilePointer=" + maxFilePointer + "]", Tracer.Level.DEBUG);
                }
                this.map(this.filePointer, maxFilePointer, false);
                object = this.readOneCore(maxFilePointer);
                return object;
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log("Exiting read...", Tracer.Level.DEBUG);
                }
                if (this.closed) {
                    this.closeCore();
                }
                this.running = false;
            }
        }

        public final ReadCompletionReason readOne() {
            return this.readOne(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final ReadCompletionReason read(long maxFilePointer) {
            try {
                ReadCompletionReason completionReason;
                MemoryMappedReader memoryMappedReader = this;
                synchronized (memoryMappedReader) {
                    if (this.closed) {
                        throw new IllegalStateException("reader is closed");
                    }
                    if (this.running) {
                        throw new IllegalStateException("already running");
                    }
                    this.stopped = false;
                    this.running = true;
                }
                if (this.tracer.debug) {
                    this.tracer.log("Started read [maxFilePointer=" + maxFilePointer + "]", Tracer.Level.DEBUG);
                }
                this.map(this.filePointer, maxFilePointer, false);
                while (!this.stopped && !this.closed) {
                    completionReason = this.readOneCore(maxFilePointer);
                    if (completionReason == null) continue;
                    ReadCompletionReason readCompletionReason = completionReason;
                    return readCompletionReason;
                }
                completionReason = this.stopped ? ReadCompletionReason.Stopped : ReadCompletionReason.Closed;
                return completionReason;
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log("Exiting read...", Tracer.Level.DEBUG);
                }
                if (this.closed) {
                    this.closeCore();
                }
                this.running = false;
            }
        }

        public final ReadCompletionReason read() {
            return this.read(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final ReadCompletionReason readAt(long position) throws IOException {
            ReadCompletionReason readCompletionReason;
            if (this.tracer.debug) {
                this.tracer.log("Reading at position '" + position + "'...", Tracer.Level.DEBUG);
            }
            long currentPosition = this.filePointer();
            try {
                this.seek(position);
                readCompletionReason = this.readOne(Long.MAX_VALUE);
            }
            catch (Throwable throwable) {
                try {
                    this.seek(currentPosition);
                    throw throwable;
                }
                catch (EPktLogCorruptException e) {
                    throw new EPktLogInvalidPositionException((Throwable)((Object)e));
                }
            }
            this.seek(currentPosition);
            return readCompletionReason;
        }

        public final boolean isValidAt(long position) throws IOException {
            if (this.tracer.debug) {
                this.tracer.log("Checking if position '" + position + "' contains a valid packet...", Tracer.Level.DEBUG);
            }
            long fileLength = this.raf.length();
            if (position >= 9L && position < fileLength) {
                this.seek(position);
                int remaining = (int)Math.min(Integer.MAX_VALUE, fileLength - position);
                int packetLength = PktHeader.getSerializedPacketLengthNoException(this.buffer, this.bufferPos, remaining);
                return packetLength > 0 && packetLength <= remaining;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stop() {
            MemoryMappedReader memoryMappedReader = this;
            synchronized (memoryMappedReader) {
                if (!this.running) {
                    throw new IllegalStateException("not running");
                }
                this.stopped = true;
            }
        }

        public final MemoryMappedReader reset() throws IOException {
            this.seek(9L);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() {
            MemoryMappedReader memoryMappedReader = this;
            synchronized (memoryMappedReader) {
                this.closed = true;
                if (!this.running) {
                    this.closeCore();
                }
            }
        }

        public static enum ReadCompletionReason {
            EndOfFile,
            MaxFilePointerReached,
            Stopped,
            Closed;

        }
    }

    public static final class FilePosition {
        long position;
        int size;

        public final void setPosition(long position) {
            this.position = position;
        }

        public final long getPosition() {
            return this.position;
        }

        public final void setSize(int size) {
            this.size = size;
        }

        public final int getSize() {
            return this.size;
        }

        public final String toString() {
            return "[pos=" + this.getPosition() + ", size=" + this.getSize() + "]";
        }
    }

    private final class Preamble {
        final byte formatVersion;
        long checkpointCount;

        Preamble(byte formatVersion) {
            this.formatVersion = formatVersion;
        }

        final void write(RandomAccessFile file) throws IOException {
            file.seek(0L);
            file.writeByte(this.formatVersion);
            file.writeLong(this.checkpointCount);
        }

        final void read(RandomAccessFile file) throws IOException {
            if (file.length() < (long)this.getSerializedLength()) {
                throw new EPktLogCorruptException("missing or partial preamble");
            }
            file.seek(1L);
            this.checkpointCount = file.readLong();
        }

        final int getSerializedLength() {
            return 9;
        }

        public final String toString() {
            return "[ver=" + this.formatVersion + " checkpoints=" + this.checkpointCount + "]";
        }
    }

    public static enum CheckpointState {
        DONE,
        SAVING_IMAGE,
        TRUNCATING_LOG;

    }

    public static enum FileOpenMode {
        r,
        rw,
        rws,
        rwd;

    }

    private final class IntegrityCheckPacketHandler
    implements IPacketBufferReceiver {
        private final ILogIntegrityChecker logIntegrityChecker;
        int numValidEntries;
        long validatedFileLength;

        IntegrityCheckPacketHandler(ILogIntegrityChecker logIntegrityChecker) {
            this.validatedFileLength = PktRecoveryLog.this.preamble.getSerializedLength();
            this.logIntegrityChecker = logIntegrityChecker;
            if (this.logIntegrityChecker != null) {
                this.logIntegrityChecker.init(PktRecoveryLog.this.preamble.getSerializedLength());
            }
        }

        final void done() {
            if (this.logIntegrityChecker != null) {
                this.logIntegrityChecker.done();
            }
        }

        final int numValidEntries() {
            return this.logIntegrityChecker != null && this.logIntegrityChecker.corruptionDetected() ? this.logIntegrityChecker.numValidEntries() : this.numValidEntries;
        }

        final long validatedFileLength() {
            return this.logIntegrityChecker != null && this.logIntegrityChecker.corruptionDetected() ? this.logIntegrityChecker.validatedFileLength() : this.validatedFileLength;
        }

        @Override
        public final void onPacket(IOBuffer buffer, int bufferPosition, int packetLength, long filePosition) {
            ++this.numValidEntries;
            this.validatedFileLength = filePosition + (long)packetLength;
            if (this.logIntegrityChecker != null) {
                this.logIntegrityChecker.onPacket(buffer, bufferPosition, packetLength, filePosition);
            }
        }

        @Override
        public final void onBufferChange(IOBuffer from, IOBuffer to) {
        }
    }
}

