/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.neeve.io.IOBuffer;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktSubheaderVariable;
import java.nio.ByteBuffer;
import java.util.Properties;

public final class PktSubheaderFMC
extends PktSubheaderVariable {
    private static final byte V1 = 1;
    private static final byte VERSION = 1;
    private static int VERSION_POS = 1;
    private static int TOPICLEN_POS = VERSION_POS + 1;
    private static int TOPIC_POS = TOPICLEN_POS + 2;
    private short topicLen;
    private byte[] topic;

    private PktSubheaderFMC(Properties props) {
        super(2);
    }

    public static PktBody create(Properties props) {
        return new PktSubheaderFMC(props);
    }

    public static PktBody create() {
        return PktSubheaderFMC.create(null);
    }

    private final void updateFieldOffsets() {
    }

    private final void initTopicFromBuffer(boolean onlyOffset) {
        if (this.topic == null) {
            this.topicLen = this.buffer.getShort(TOPICLEN_POS);
            if (!onlyOffset) {
                if (this.topicLen == 0) {
                    this.topic = null;
                }
                this.topic = new byte[this.topicLen];
                this.buffer.getTo(TOPIC_POS, this.topic, 0, (int)this.topicLen);
            }
        }
    }

    public static final int calcSerializedLength(ByteBuffer buffer, int offset) {
        return 2 + (2 + buffer.getShort(offset + TOPICLEN_POS));
    }

    public static final int calcSerializedLength(IOBuffer buffer, int offset) {
        return 2 + (2 + buffer.getShort(offset + TOPICLEN_POS));
    }

    public static final int calcSerializedLength(long addr, int offset) {
        return 2 + (2 + IOBuffer.getShort((long)addr, (int)(offset + TOPICLEN_POS)));
    }

    @Override
    public final void initialize() {
        this.updateFieldOffsets();
    }

    @Override
    public final int doGetSerializedLength() {
        return 2 + (2 + this.topicLen);
    }

    @Override
    public final int getSerializedLength(ByteBuffer buffer, int offset) {
        return PktSubheaderFMC.calcSerializedLength(buffer, offset);
    }

    @Override
    public final int getSerializedLength(IOBuffer buffer, int offset) {
        return PktSubheaderFMC.calcSerializedLength(buffer, offset);
    }

    @Override
    public final int getSerializedLength(long addr, int offset) {
        return PktSubheaderFMC.calcSerializedLength(addr, offset);
    }

    @Override
    public final void doDesync(int len) {
        this.initTopicFromBuffer(true);
    }

    @Override
    protected final boolean isResettable() {
        return true;
    }

    @Override
    protected final void doReset() {
        this.topicLen = 0;
        this.topic = null;
    }

    public static final short getLatestSubheaderVersion() {
        return 1;
    }

    private final void setSubheaderVersion(short version) {
        this.buffer.put(VERSION_POS, (byte)version);
    }

    public final short getSubheaderVersion() {
        return (short)(0xFF & this.buffer.get(VERSION_POS));
    }

    public final void setTopic(String topic) {
        if (topic == null) {
            this.topic = null;
            this.topicLen = 0;
        } else {
            try {
                this.topic = topic.getBytes("UTF-8");
                this.topicLen = (short)this.topic.length;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.updateFieldOffsets();
        this.buffer.putShort(TOPICLEN_POS, this.topicLen);
        if (this.topic != null) {
            this.buffer.putFrom(TOPIC_POS, this.topic, 0, (int)this.topicLen);
        }
    }

    public final String getTopic() {
        if (this.topic == null) {
            this.initTopicFromBuffer(false);
        }
        if (this.topic == null) {
            return null;
        }
        try {
            return new String(this.topic, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void initializeBuffer() {
        if (!this.inDeserialize) {
            this.setSubheaderVersion((short)1);
        }
    }

    public final String toString() {
        return "FMC{" + this.getSubheaderVersion() + " " + this.getTopic() + "}";
    }

    public final boolean equals(Object obj) {
        PktSubheaderFMC fmc = (PktSubheaderFMC)((Object)obj);
        if (fmc == null || fmc.getTopic() == null && this.getTopic() != null || fmc.getTopic() == null && this.getTopic() == null) {
            return false;
        }
        if (fmc.getTopic() == null && this.getTopic() == null) {
            return true;
        }
        return this.getTopic().compareTo(fmc.getTopic()) == 0;
    }

    public final int hashCode() {
        return this.getTopic().hashCode();
    }
}

