/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import cern.colt.bitvector.QuickBitVector;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.EPktCorruptException;
import com.neeve.pkt.EPktDeserializeException;
import com.neeve.pkt.EPktException;
import com.neeve.pkt.EPktVersionInvalidException;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktSubheader;
import com.neeve.pkt.PktSubheaderFMC;
import com.neeve.pkt.PktSubheaderFUC;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.PktSubheaderRR;
import com.neeve.pkt.PktSubheaderSMA;
import com.neeve.util.UtlFabricAddress;
import com.neeve.util.UtlListElement;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Properties;

public final class PktHeader
extends UtlListElement
implements IOElasticBuffer.Initializer {
    private static final int MAGIC_POS = 0;
    private static final int VERSION_POS = 3;
    private static final int LEN_POS = 4;
    private static final int SRC_POS = 8;
    private static final int DEST_POS = 12;
    private static final int SPORT_POS = 16;
    private static final int DPORT_POS = 18;
    private static final int FLOW_POS = 20;
    private static final int FLAGS_POS = 24;
    private static final int HTL_POS = 27;
    private static final int CLAZZ_POS = 28;
    private static final int NUM_SH_POS = 29;
    private static final int BODY_TYPE_POS = 30;
    private static final int FLAG_NO_BUFFERING = 256;
    private static final int FLAG_REPLY_EXPECTED = 512;
    private static final byte V1 = 1;
    private static final byte VERSION = 1;
    private static final int STATIC_HEADER_LENGTH_V1 = 34;
    public static final int STATIC_HEADER_LENGTH = 34;
    private static final int SUBHDR_ARRAY_LENGTH = 8;
    private static final ByteOrder bufferByteOrder = IOBuffer.getByteOrder();
    private final IOElasticBuffer buffer = IOElasticBuffer.create((int)34);
    private final PktSubheader[] subheaders;
    private final PktBody body;
    private final long[] activeSubheaders;
    private boolean inDeserialize;
    public static final int MAGIC_SIZE = 3;
    public static final int MAGIC_LE = 11394234;
    public static final int MAGIC_BE = -1159942912;
    public static final int MAGIC;
    public static final short MAX_HTL = 255;

    private PktHeader(PktBody body, Properties props) {
        this.buffer.setInitializer((IOElasticBuffer.Initializer)this);
        this.subheaders = new PktSubheader[8];
        this.activeSubheaders = new long[1];
        this.body = body;
    }

    public static PktHeader create(PktBody body, Properties props) {
        return new PktHeader(body, props);
    }

    private static final int getMagic(ByteBuffer buffer, int offset) {
        if (bufferByteOrder == ByteOrder.LITTLE_ENDIAN) {
            return buffer.getInt(offset + 0) & 0xFFFFFF;
        }
        if (bufferByteOrder == ByteOrder.BIG_ENDIAN) {
            return buffer.getInt(offset + 0) & 0xFFFFFF00;
        }
        throw new IllegalArgumentException("unknown byte order [" + bufferByteOrder + "]");
    }

    private static final int getMagic(IOBuffer buffer, int offset) {
        if (bufferByteOrder == ByteOrder.LITTLE_ENDIAN) {
            return buffer.getInt(offset + 0) & 0xFFFFFF;
        }
        if (bufferByteOrder == ByteOrder.BIG_ENDIAN) {
            return buffer.getInt(offset + 0) & 0xFFFFFF00;
        }
        throw new IllegalArgumentException("unknown byte order [" + bufferByteOrder + "]");
    }

    private static final int getMagic(long addr, int offset) {
        if (bufferByteOrder == ByteOrder.LITTLE_ENDIAN) {
            return IOBuffer.getInt((long)addr, (int)(offset + 0)) & 0xFFFFFF;
        }
        if (bufferByteOrder == ByteOrder.BIG_ENDIAN) {
            return IOBuffer.getInt((long)addr, (int)(offset + 0)) & 0xFFFFFF00;
        }
        throw new IllegalArgumentException("unknown byte order [" + bufferByteOrder + "]");
    }

    private static final short getVersion(ByteBuffer buffer, int offset) {
        return (short)(0xFF & buffer.get(offset + 3));
    }

    private static final short getVersion(IOBuffer buffer, int offset) {
        return (short)(0xFF & buffer.getByte(offset + 3));
    }

    private static final short getVersion(long addr, int offset) {
        return (short)(0xFF & IOBuffer.getByte((long)addr, (int)(offset + 3)));
    }

    private static final int getLength(ByteBuffer buffer, int offset) {
        return buffer.getInt(offset + 4);
    }

    private static final int getLength(IOBuffer buffer, int offset) {
        return buffer.getInt(offset + 4);
    }

    private static final int getLength(long addr, int offset) {
        return IOBuffer.getInt((long)addr, (int)(offset + 4));
    }

    public static final EPktException convertGetSerializedPacketLengthErrorCodeToException(ByteBuffer buf, int bufOffset, int code) {
        switch (code) {
            case -1: {
                return new EPktCorruptException("invalid header magic number: " + PktHeader.getMagic(buf, bufOffset));
            }
            case -2: {
                return new EPktCorruptException("Invalid header version [" + PktHeader.getVersion(buf, bufOffset) + "]");
            }
            case -3: {
                return new EPktVersionInvalidException("Invalid header version [max supported=1 received=" + PktHeader.getVersion(buf, bufOffset));
            }
        }
        throw new IllegalArgumentException(code + " does not represent a valid error returned by getSerializedPacketLengthNoException");
    }

    public static final int getSerializedPacketLength(ByteBuffer buf, int bufOffset, int length) {
        if (length < 8) {
            return 0;
        }
        int magic = PktHeader.getMagic(buf, bufOffset);
        if (magic != MAGIC) {
            throw new EPktCorruptException("invalid header magic number: " + magic);
        }
        short version = PktHeader.getVersion(buf, bufOffset);
        if (version <= 0) {
            throw new EPktCorruptException("Invalid header version [" + version + "]");
        }
        if (version > 1) {
            throw new EPktVersionInvalidException("Invalid header version [max supported=1 received=" + version);
        }
        return PktHeader.getLength(buf, bufOffset);
    }

    public static final int getSerializedPacketLengthNoException(ByteBuffer buf, int bufOffset, int length) {
        if (length < 8) {
            return 0;
        }
        int magic = PktHeader.getMagic(buf, bufOffset);
        if (magic != MAGIC) {
            return -1;
        }
        short version = PktHeader.getVersion(buf, bufOffset);
        if (version <= 0) {
            return -2;
        }
        if (version > 1) {
            return -3;
        }
        return PktHeader.getLength(buf, bufOffset);
    }

    public static final EPktException convertGetSerializedPacketLengthErrorCodeToException(IOBuffer iobuf, int iobufOffset, int code) {
        switch (code) {
            case -1: {
                return new EPktCorruptException("invalid header magic number: " + PktHeader.getMagic(iobuf, iobufOffset));
            }
            case -2: {
                return new EPktCorruptException("Invalid header version [" + PktHeader.getVersion(iobuf, iobufOffset) + "]");
            }
            case -3: {
                return new EPktVersionInvalidException("Invalid header version [max supported=1 received=" + PktHeader.getVersion(iobuf, iobufOffset));
            }
        }
        throw new IllegalArgumentException(code + " does not represent a valid error returned by getSerializedPacketLengthNoException");
    }

    public static final int getSerializedPacketLength(IOBuffer iobuf, int iobufOffset, int length) {
        if (length < 8) {
            return 0;
        }
        int magic = PktHeader.getMagic(iobuf, iobufOffset);
        if (magic != MAGIC) {
            throw new EPktCorruptException("invalid header magic number: " + magic);
        }
        short version = PktHeader.getVersion(iobuf, iobufOffset);
        if (version <= 0) {
            throw new EPktCorruptException("Invalid header version [" + version + "]");
        }
        if (version > 1) {
            throw new EPktVersionInvalidException("Invalid header version [max supported=1 received=" + version);
        }
        return PktHeader.getLength(iobuf, iobufOffset);
    }

    public static final int getSerializedPacketLengthNoException(IOBuffer iobuf, int iobufOffset, int length) {
        if (length < 8) {
            return 0;
        }
        int magic = PktHeader.getMagic(iobuf, iobufOffset);
        if (magic != MAGIC) {
            return -1;
        }
        short version = PktHeader.getVersion(iobuf, iobufOffset);
        if (version <= 0) {
            return -2;
        }
        if (version > 1) {
            return -3;
        }
        return PktHeader.getLength(iobuf, iobufOffset);
    }

    public static final EPktException convertGetSerializedPacketLengthErrorCodeToException(long addr, int offset, int code) {
        switch (code) {
            case -1: {
                return new EPktCorruptException("invalid header magic number: " + PktHeader.getMagic(addr, offset));
            }
            case -2: {
                return new EPktCorruptException("Invalid header version [" + PktHeader.getVersion(addr, offset) + "]");
            }
            case -3: {
                return new EPktVersionInvalidException("Invalid header version [max supported=1 received=" + PktHeader.getVersion(addr, offset));
            }
        }
        throw new IllegalArgumentException(code + " does not represent a valid error returned by getSerializedPacketLengthNoException");
    }

    public static final int getSerializedPacketLength(long addr, int offset, int length) {
        if (length < 8) {
            return 0;
        }
        int magic = PktHeader.getMagic(addr, offset);
        if (magic != MAGIC) {
            throw new EPktCorruptException("invalid header magic number: " + magic);
        }
        short version = PktHeader.getVersion(addr, offset);
        if (version <= 0) {
            throw new EPktCorruptException("Invalid header version [" + version + "]");
        }
        if (version > 1) {
            throw new EPktVersionInvalidException("Invalid header version [max supported=1 received=" + version);
        }
        return PktHeader.getLength(addr, offset);
    }

    public static final int getSerializedPacketLengthNoException(long addr, int offset, int length) {
        if (length < 8) {
            return 0;
        }
        int magic = PktHeader.getMagic(addr, offset);
        if (magic != MAGIC) {
            return -1;
        }
        short version = PktHeader.getVersion(addr, offset);
        if (version <= 0) {
            return -2;
        }
        if (version > 1) {
            return -3;
        }
        return PktHeader.getLength(addr, offset);
    }

    public static final void clearMagic(ByteBuffer buffer, int offset) {
        buffer.put(offset + 0, (byte)0);
    }

    public static final void clearMagic(IOBuffer buffer, int offset) {
        buffer.putByte(offset + 0, (byte)0);
    }

    public static final void clearMagic(IOElasticBuffer buffer, int offset) {
        buffer.put(offset + 0, (byte)0);
    }

    public static final void clearMagic(long addr, int offset) {
        IOBuffer.putByte((long)addr, (int)(offset + 0), (byte)0);
    }

    public static final void restoreClearedMagic(ByteBuffer buffer, int offset) {
        if (bufferByteOrder == ByteOrder.LITTLE_ENDIAN) {
            buffer.put(offset + 0, (byte)-70);
        } else if (bufferByteOrder == ByteOrder.BIG_ENDIAN) {
            buffer.put(offset + 0, (byte)-70);
        } else {
            throw new IllegalArgumentException("unknown byte order [" + bufferByteOrder + "]");
        }
    }

    public static final void restoreClearedMagic(IOBuffer buffer, int offset) {
        if (bufferByteOrder == ByteOrder.LITTLE_ENDIAN) {
            buffer.putByte(offset + 0, (byte)-70);
        } else if (bufferByteOrder == ByteOrder.BIG_ENDIAN) {
            buffer.putByte(offset + 0, (byte)-70);
        } else {
            throw new IllegalArgumentException("unknown byte order [" + bufferByteOrder + "]");
        }
    }

    public static final void restoreClearedMagic(IOElasticBuffer buffer, int offset) {
        if (bufferByteOrder == ByteOrder.LITTLE_ENDIAN) {
            buffer.putByte(offset + 0, (byte)-70);
        } else if (bufferByteOrder == ByteOrder.BIG_ENDIAN) {
            buffer.putByte(offset + 0, (byte)-70);
        } else {
            throw new IllegalArgumentException("unknown byte order [" + bufferByteOrder + "]");
        }
    }

    public static final void restoreClearedMagic(long addr, int offset) {
        if (bufferByteOrder == ByteOrder.LITTLE_ENDIAN) {
            IOBuffer.putByte((long)addr, (int)(offset + 0), (byte)-70);
        } else if (bufferByteOrder == ByteOrder.BIG_ENDIAN) {
            IOBuffer.putByte((long)addr, (int)(offset + 0), (byte)-70);
        } else {
            throw new IllegalArgumentException("unknown byte order [" + bufferByteOrder + "]");
        }
    }

    public static final boolean hasMagic(ByteBuffer buffer, int offset) {
        return buffer.remaining() >= 4 && PktHeader.getMagic(buffer, offset) == MAGIC;
    }

    public static final short getLatestVersion() {
        return 1;
    }

    private final void setNumSubheaders(short num) {
        this.buffer.put(29, (byte)num);
    }

    private final PktSubheader activateSubheader(int type, boolean reset) {
        if (!QuickBitVector.get((long[])this.activeSubheaders, (int)type)) {
            QuickBitVector.set((long[])this.activeSubheaders, (int)type);
            this.initializeSubheader(type);
            if (reset) {
                this.subheaders[type].reset(false);
            }
            this.setNumSubheaders((short)(this.getNumSubheaders() + 1));
        }
        return this.subheaders[type];
    }

    private final void initializeSubheader(int type) {
        if (this.subheaders[type] == null && PktFactory.getInstance().getPacketType(type) != null) {
            this.subheaders[type] = (PktSubheader)PktFactory.getInstance().createPacketBody(type);
        }
    }

    private final void deactivateSubheader(int type) {
        if (QuickBitVector.get((long[])this.activeSubheaders, (int)type)) {
            QuickBitVector.clear((long[])this.activeSubheaders, (int)type);
            this.setNumSubheaders((short)(this.getNumSubheaders() - 1));
        }
    }

    private static final int getStaticSerializedLength(short version) {
        switch (version) {
            case 1: {
                return 34;
            }
        }
        return 0;
    }

    final boolean isSubheaderActive(int type) {
        return QuickBitVector.get((long[])this.activeSubheaders, (int)type);
    }

    final void cloneActiveSubheaderMask(PktHeader header) {
        header.activeSubheaders[0] = this.activeSubheaders[0];
        if (this.activeSubheaders.length > 1) {
            throw new InternalError("active subheader mask clone needs to be updated!");
        }
    }

    public final short getVersion() {
        return (short)(0xFF & this.buffer.get(3));
    }

    public final int getLength() {
        return this.buffer.getInt(4);
    }

    public final void setSrc(int addr) {
        this.buffer.putInt(8, addr);
    }

    public final int getSrc() {
        return this.buffer.getInt(8);
    }

    public final void setDest(int addr) {
        this.buffer.putInt(12, addr);
    }

    public final int getDest() {
        return this.buffer.getInt(12);
    }

    public static final void setPreWireTs(ByteBuffer buffer, int pos, long ts) {
        buffer.putInt(pos + 8, (int)(ts >> 32 & 0xFFFFFFFFL));
        buffer.putInt(pos + 12, (int)(ts & 0xFFFFFFFFL));
    }

    public static final void setPreWireTs(IOBuffer buffer, int pos, long ts) {
        buffer.putInt(pos + 8, (int)(ts >> 32 & 0xFFFFFFFFL));
        buffer.putInt(pos + 12, (int)(ts & 0xFFFFFFFFL));
    }

    public static final void setPreWireTs(IOElasticBuffer buffer, int pos, long ts) {
        buffer.putInt(pos + 8, (int)(ts >> 32 & 0xFFFFFFFFL));
        buffer.putInt(pos + 12, (int)(ts & 0xFFFFFFFFL));
    }

    public final void setPreWireTs(long ts) {
        PktHeader.setPreWireTs(this.buffer, 0, ts);
    }

    public final long getPreWireTs() {
        return (long)this.buffer.getInt(12) & 0xFFFFFFFFL | ((long)this.buffer.getInt(8) & 0xFFFFFFFFL) << 32;
    }

    public final void setSrcPort(short port) {
        this.buffer.putShort(16, port);
    }

    public final short getSrcPort() {
        return this.buffer.getShort(16);
    }

    public final void setDestPort(short port) {
        this.buffer.putShort(18, port);
    }

    public final short getDestPort() {
        return this.buffer.getShort(18);
    }

    public final void setFlow(int flow) {
        this.buffer.putInt(20, flow);
    }

    public final int getFlow() {
        return this.buffer.getInt(20);
    }

    public final void setNoBuffering(boolean val) {
        int flags = this.buffer.getInt(24);
        flags = val ? (flags |= 0x100) : (flags &= 0xFFFFFEFF);
        this.buffer.putInt(24, flags);
    }

    public final boolean getNoBuffering() {
        return (this.buffer.getInt(24) & 0x100) == 256;
    }

    public final void setReplyExpected(boolean val) {
        int flags = this.buffer.getInt(24);
        flags = val ? (flags |= 0x200) : (flags &= 0xFFFFFDFF);
        this.buffer.putInt(24, flags);
    }

    public final boolean getReplyExpected() {
        return (this.buffer.getInt(24) & 0x200) == 512;
    }

    public final void setHtl(short htl) {
        this.buffer.put(27, (byte)htl);
    }

    public final short getHtl() {
        return (short)(0xFF & this.buffer.get(27));
    }

    public final void setClazz(short clazz) {
        this.buffer.put(28, (byte)clazz);
    }

    public final short getClazz() {
        return (short)(0xFF & this.buffer.get(28));
    }

    public final int getBodyType() {
        return this.buffer.getInt(30);
    }

    public static final int getBodyType(ByteBuffer buffer, int offset) {
        return buffer.getInt(offset + 30);
    }

    public static final int getBodyType(IOBuffer buffer, int offset) {
        return buffer.getInt(offset + 30);
    }

    public static final int getBodyType(IOElasticBuffer buffer, int offset) {
        return buffer.getInt(offset + 30);
    }

    public static final int getBodyType(long addr, int offset) {
        return IOBuffer.getInt((long)addr, (int)(offset + 30));
    }

    public static final short getNumSubheaders(long addr, int offset) {
        return (short)(0xFF & IOBuffer.getByte((long)addr, (int)(offset + 29)));
    }

    public final short getNumSubheaders() {
        return this.buffer.hasBackingBuffer() ? (short)(0xFF & this.buffer.get(29)) : (short)0;
    }

    public final IOElasticBuffer getBuffer() {
        return this.buffer;
    }

    public final PktSubheaderRR activateRRSubheader(boolean reset) {
        return (PktSubheaderRR)this.activateSubheader(1, reset);
    }

    public final void deactivateRRSubheader() {
        this.deactivateSubheader(1);
    }

    public final PktSubheader getSubheader(int type, boolean ignoreInactive) {
        if (ignoreInactive || QuickBitVector.get((long[])this.activeSubheaders, (int)type)) {
            this.initializeSubheader(type);
            return this.subheaders[type];
        }
        return null;
    }

    public final PktSubheaderRR getRRSubheader() {
        return (PktSubheaderRR)this.getSubheader(1, false);
    }

    public final PktSubheaderFMC activateFMCSubheader(boolean reset) {
        return (PktSubheaderFMC)this.activateSubheader(2, reset);
    }

    public final void deactivateFMCSubheader() {
        this.deactivateSubheader(2);
    }

    public final PktSubheaderFMC getFMCSubheader() {
        return (PktSubheaderFMC)this.getSubheader(2, false);
    }

    public final PktSubheaderFUC activateFUCSubheader(boolean reset) {
        return (PktSubheaderFUC)this.activateSubheader(3, reset);
    }

    public final void deactivateFUCSubheader() {
        this.deactivateSubheader(3);
    }

    public final PktSubheaderFUC getFUCSubheader() {
        return (PktSubheaderFUC)this.getSubheader(3, false);
    }

    public final PktSubheaderSMA activateSMASubheader(boolean reset) {
        return (PktSubheaderSMA)this.activateSubheader(5, reset);
    }

    public final void deactivateSMASubheader() {
        this.deactivateSubheader(5);
    }

    public final PktSubheaderSMA getSMASubheader() {
        return (PktSubheaderSMA)this.getSubheader(5, false);
    }

    public static final int getSubheaderOffset(long addr, int offset, int subheaderType) {
        int headerStaticSerializedLength = PktHeader.getStaticSerializedLength(PktHeader.getVersion(addr, offset));
        int numSubheaders = PktHeader.getNumSubheaders(addr, offset);
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < numSubheaders; ++i) {
            int subheaderSerializedLength;
            int pktTypeId = PktSubheader.getType(addr, offset + headerSerializedLength);
            if (pktTypeId == subheaderType) {
                return offset + headerSerializedLength;
            }
            switch (pktTypeId) {
                case 1: {
                    subheaderSerializedLength = PktSubheaderRR.calcSerializedLength(addr, offset + headerSerializedLength);
                    break;
                }
                case 2: {
                    subheaderSerializedLength = PktSubheaderFMC.calcSerializedLength(addr, offset + headerSerializedLength);
                    break;
                }
                case 3: {
                    subheaderSerializedLength = PktSubheaderFUC.calcSerializedLength(addr, offset + headerSerializedLength);
                    break;
                }
                case 5: {
                    subheaderSerializedLength = PktSubheaderSMA.calcSerializedLength(addr, offset + headerSerializedLength);
                    break;
                }
                case 7: {
                    subheaderSerializedLength = PktSubheaderODS.calcSerializedLength(addr, offset + headerSerializedLength);
                    break;
                }
                default: {
                    throw new EPktCorruptException("invalid header type '" + pktTypeId + "' in serialized header");
                }
            }
            headerSerializedLength += subheaderSerializedLength;
        }
        return -1;
    }

    public final PktSubheaderODS activateODSSubheader(boolean reset) {
        return (PktSubheaderODS)this.activateSubheader(7, reset);
    }

    public final void deactivateODSSubheader() {
        this.deactivateSubheader(7);
    }

    public final PktSubheaderODS getODSSubheader() {
        return (PktSubheaderODS)this.getSubheader(7, false);
    }

    public final PktBody getBody() {
        return this.body;
    }

    public final void reset(boolean initBackingBuffer) {
        this.getNumSubheaders();
        if (this.buffer.isWrapped()) {
            this.buffer.reset();
        } else if (initBackingBuffer) {
            this.buffer.wipe(0, 34);
            this.initializeBuffer();
        } else {
            this.buffer.setLength(0);
        }
        for (int i = 1; i < this.subheaders.length; ++i) {
            if (this.subheaders[i] != null) {
                this.subheaders[i].reset(initBackingBuffer);
            }
            QuickBitVector.clear((long[])this.activeSubheaders, (int)i);
        }
    }

    public final void reset() {
        this.reset(true);
    }

    public final void setLength(int length) {
        this.buffer.putInt(4, length);
    }

    public final int getStaticSerializedLength() {
        return PktHeader.getStaticSerializedLength(this.getVersion());
    }

    public static final int getSerializedLength(long addr, int offset) {
        int headerStaticSerializedLength = PktHeader.getStaticSerializedLength(PktHeader.getVersion(addr, offset));
        int numSubheaders = PktHeader.getNumSubheaders(addr, offset);
        int headerSerializedLength = headerStaticSerializedLength;
        block7: for (int i = 0; i < numSubheaders; ++i) {
            int pktTypeId = PktSubheader.getType(addr, offset + headerSerializedLength);
            switch (pktTypeId) {
                case 1: {
                    headerSerializedLength += PktSubheaderRR.calcSerializedLength(addr, offset + headerSerializedLength);
                    continue block7;
                }
                case 2: {
                    headerSerializedLength += PktSubheaderFMC.calcSerializedLength(addr, offset + headerSerializedLength);
                    continue block7;
                }
                case 3: {
                    headerSerializedLength += PktSubheaderFUC.calcSerializedLength(addr, offset + headerSerializedLength);
                    continue block7;
                }
                case 5: {
                    headerSerializedLength += PktSubheaderSMA.calcSerializedLength(addr, offset + headerSerializedLength);
                    continue block7;
                }
                case 7: {
                    headerSerializedLength += PktSubheaderODS.calcSerializedLength(addr, offset + headerSerializedLength);
                    continue block7;
                }
                default: {
                    throw new EPktCorruptException("invalid header type '" + pktTypeId + "' in serialized header");
                }
            }
        }
        return headerSerializedLength;
    }

    public final int getSerializedLength() {
        int size = this.getStaticSerializedLength();
        int numSubheaders = this.getNumSubheaders();
        int numProcessed = 0;
        for (int i = 0; i < this.subheaders.length && numProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            size += subheader.getSerializedLength();
            ++numProcessed;
        }
        return size;
    }

    public final int sync() {
        int headerSerializedLength = this.getStaticSerializedLength();
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            headerSerializedLength += subheader.sync();
            ++numSubheadersProcessed;
        }
        int bodySerializedLength = this.body != null ? this.body.getBuffer().getLength() : 0;
        int packetSerializedLength = headerSerializedLength + bodySerializedLength;
        if (this.getLength() != packetSerializedLength) {
            this.setLength(packetSerializedLength);
        }
        return headerSerializedLength;
    }

    public final PktHeader syncf() {
        this.sync();
        return this;
    }

    public final void desync() {
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            subheader.desync();
            ++numSubheadersProcessed;
        }
    }

    public final int getTo(ByteBuffer buf, int bufOffset, boolean withMagic) {
        int headerStaticSerializedLength = this.getStaticSerializedLength();
        if (withMagic) {
            this.buffer.getTo(0, buf, bufOffset, headerStaticSerializedLength);
        } else {
            buf.put(bufOffset, (byte)0);
            this.buffer.getTo(1, buf, bufOffset + 1, headerStaticSerializedLength - 1);
        }
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            headerSerializedLength += subheader.getTo(buf, bufOffset + headerSerializedLength);
            ++numSubheadersProcessed;
        }
        return headerSerializedLength;
    }

    public final int getTo(ByteBuffer buf, int bufOffset) {
        return this.getTo(buf, bufOffset, true);
    }

    public final int getTo(ByteBuffer buf, boolean withMagic) {
        return this.getTo(buf, buf.position(), withMagic);
    }

    public final int getTo(ByteBuffer buf) {
        return this.getTo(buf, true);
    }

    public final int getTo(byte[] array, int arrayOffset, boolean withMagic) {
        int headerStaticSerializedLength = this.getStaticSerializedLength();
        if (withMagic) {
            this.buffer.getTo(0, array, arrayOffset, headerStaticSerializedLength);
        } else {
            array[arrayOffset] = 0;
            this.buffer.getTo(1, array, arrayOffset + 1, headerStaticSerializedLength - 1);
        }
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            headerSerializedLength += subheader.getTo(array, arrayOffset + headerSerializedLength);
            ++numSubheadersProcessed;
        }
        return headerSerializedLength;
    }

    public final int getTo(byte[] array, int arrayOffset) {
        return this.getTo(array, arrayOffset, true);
    }

    public final int getTo(byte[] array) {
        return this.getTo(array, 0);
    }

    public final int getTo(IOBuffer iobuf, int iobufOffset, boolean withMagic) {
        int headerStaticSerializedLength = this.getStaticSerializedLength();
        if (withMagic) {
            this.buffer.getTo(0, iobuf, iobufOffset, headerStaticSerializedLength);
        } else {
            iobuf.putByte(iobufOffset, (byte)0);
            this.buffer.getTo(1, iobuf, iobufOffset + 1, headerStaticSerializedLength - 1);
        }
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            headerSerializedLength += subheader.getTo(iobuf, iobufOffset + headerSerializedLength);
            ++numSubheadersProcessed;
        }
        return headerSerializedLength;
    }

    public final int getTo(IOBuffer iobuf, int iobufOffset) {
        return this.getTo(iobuf, iobufOffset, true);
    }

    public final int getTo(IOElasticBuffer iobuf, int iobufOffset, boolean withMagic) {
        int headerStaticSerializedLength = this.getStaticSerializedLength();
        if (withMagic) {
            iobuf.putFrom(iobufOffset, this.buffer, 0, headerStaticSerializedLength);
        } else {
            iobuf.putByte(iobufOffset, (byte)0);
            iobuf.putFrom(iobufOffset + 1, this.buffer, 1, headerStaticSerializedLength - 1);
        }
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            headerSerializedLength += subheader.getTo(iobuf, iobufOffset + headerSerializedLength);
            ++numSubheadersProcessed;
        }
        return headerSerializedLength;
    }

    public final int getTo(IOElasticBuffer iobuf, int iobufOffset) {
        return this.getTo(iobuf, iobufOffset, true);
    }

    public final int getTo(long addr, int addrOffset, boolean withMagic) {
        int headerStaticSerializedLength = this.getStaticSerializedLength();
        if (withMagic) {
            this.buffer.getToNative(0, addr, addrOffset, headerStaticSerializedLength);
        } else {
            IOBuffer.putByte((long)addr, (int)addrOffset, (byte)0);
            this.buffer.getToNative(1, addr, addrOffset + 1, headerStaticSerializedLength - 1);
        }
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            headerSerializedLength += subheader.getTo(addr, addrOffset + headerSerializedLength);
            ++numSubheadersProcessed;
        }
        return headerSerializedLength;
    }

    public final int getTo(long addr, int addrOffset) {
        return this.getTo(addr, addrOffset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int putFrom(ByteBuffer buf, int bufOffset) {
        this.inDeserialize = true;
        try {
            int headerStaticSerializedLength = PktHeader.getStaticSerializedLength(PktHeader.getVersion(buf, bufOffset));
            this.buffer.putFrom(0, buf, bufOffset, headerStaticSerializedLength);
            int numSubheaders = this.getNumSubheaders();
            this.setNumSubheaders((short)0);
            int headerSerializedLength = headerStaticSerializedLength;
            for (int i = 0; i < numSubheaders; ++i) {
                int pktTypeId = PktSubheader.getType(buf, bufOffset + headerSerializedLength);
                if (QuickBitVector.get((long[])this.activeSubheaders, (int)pktTypeId)) {
                    throw new InternalError("Subheader (type=" + pktTypeId + ") is marked as active during deserialize!");
                }
                this.initializeSubheader(pktTypeId);
                PktSubheader subheader = this.subheaders[pktTypeId];
                int subheaderSerializedLength = subheader.getSerializedLength(buf, bufOffset + headerSerializedLength);
                subheader.putFrom(buf, bufOffset + headerSerializedLength, subheaderSerializedLength);
                headerSerializedLength += subheaderSerializedLength;
                this.activateSubheader(pktTypeId, false);
            }
            int n = headerSerializedLength;
            return n;
        }
        finally {
            this.inDeserialize = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int putFrom(IOBuffer iobuf, int iobufOffset, boolean wrap) {
        this.inDeserialize = true;
        try {
            ByteBuffer bytebuf = iobuf.getBufferUnsafe();
            int headerStaticSerializedLength = PktHeader.getStaticSerializedLength(PktHeader.getVersion(bytebuf, iobufOffset));
            if (wrap) {
                this.buffer.wrapBackingBuffer(iobuf, iobufOffset, headerStaticSerializedLength);
            } else {
                this.buffer.putFrom(0, iobuf, iobufOffset, headerStaticSerializedLength);
            }
            int numSubheaders = this.getNumSubheaders();
            if (!wrap) {
                this.setNumSubheaders((short)0);
            }
            for (int i = 1; i < this.subheaders.length; ++i) {
                QuickBitVector.clear((long[])this.activeSubheaders, (int)i);
            }
            int headerSerializedLength = headerStaticSerializedLength;
            for (int i = 0; i < numSubheaders; ++i) {
                int pktTypeId = PktSubheader.getType(bytebuf, iobufOffset + headerSerializedLength);
                if (QuickBitVector.get((long[])this.activeSubheaders, (int)pktTypeId)) {
                    throw new InternalError("Subheader (type=" + pktTypeId + ") is marked as active during deserialize!");
                }
                this.initializeSubheader(pktTypeId);
                PktSubheader subheader = this.subheaders[pktTypeId];
                int subheaderSerializedLength = subheader.getSerializedLength(bytebuf, iobufOffset + headerSerializedLength);
                subheader.putFrom(iobuf, iobufOffset + headerSerializedLength, subheaderSerializedLength, wrap);
                headerSerializedLength += subheaderSerializedLength;
                if (wrap) {
                    QuickBitVector.set((long[])this.activeSubheaders, (int)pktTypeId);
                    continue;
                }
                this.activateSubheader(pktTypeId, false);
            }
            int n = headerSerializedLength;
            return n;
        }
        finally {
            this.inDeserialize = false;
        }
    }

    public final int putFrom(IOBuffer iobuf, int iobufOffset) throws EPktDeserializeException {
        return this.putFrom(iobuf, iobufOffset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int putFrom(long addr, int addrOffset) {
        this.inDeserialize = true;
        try {
            int headerStaticSerializedLength = PktHeader.getStaticSerializedLength(PktHeader.getVersion(addr, addrOffset));
            this.buffer.putFrom(0, addr, addrOffset, headerStaticSerializedLength);
            int numSubheaders = this.getNumSubheaders();
            this.setNumSubheaders((short)0);
            int headerSerializedLength = headerStaticSerializedLength;
            for (int i = 0; i < numSubheaders; ++i) {
                int pktTypeId = PktSubheader.getType(addr, addrOffset + headerSerializedLength);
                if (QuickBitVector.get((long[])this.activeSubheaders, (int)pktTypeId)) {
                    throw new InternalError("Subheader (type=" + pktTypeId + ") is marked as active during deserialize!");
                }
                this.initializeSubheader(pktTypeId);
                PktSubheader subheader = this.subheaders[pktTypeId];
                int subheaderSerializedLength = subheader.getSerializedLength(addr, addrOffset + headerSerializedLength);
                subheader.putFrom(addr, addrOffset + headerSerializedLength, subheaderSerializedLength);
                headerSerializedLength += subheaderSerializedLength;
                this.activateSubheader(pktTypeId, false);
            }
            int n = headerSerializedLength;
            return n;
        }
        finally {
            this.inDeserialize = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int putFrom(PktHeader src) {
        this.inDeserialize = true;
        try {
            this.reset(false);
            int headerStaticSerializedLength = PktHeader.getStaticSerializedLength(src.getVersion());
            this.buffer.putFrom(0, src.buffer, 0, headerStaticSerializedLength);
            int headerSerializedLength = headerStaticSerializedLength;
            this.setNumSubheaders((short)0);
            int numSubheaders = src.getNumSubheaders();
            int numProcessed = 0;
            for (int i = 0; i < src.subheaders.length && numProcessed < numSubheaders; ++i) {
                PktSubheader subheader = src.getSubheader(i, false);
                if (subheader == null) continue;
                headerSerializedLength += this.activateSubheader(i, false).putFrom(subheader).getSerializedLength();
                ++numProcessed;
            }
            int n = headerSerializedLength;
            return n;
        }
        finally {
            this.inDeserialize = false;
        }
    }

    public final int serialize(ByteBuffer buf, int bufOffset, boolean withMagic) {
        return this.syncf().getTo(buf, bufOffset, withMagic);
    }

    public final int serialize(ByteBuffer buf, int bufOffset) {
        return this.serialize(buf, bufOffset, true);
    }

    public final int serialize(ByteBuffer buf, boolean withMagic) {
        return this.serialize(buf, buf.position(), withMagic);
    }

    public final int serialize(ByteBuffer buf) {
        return this.serialize(buf, true);
    }

    public final int serialize(byte[] array, int arrayOffset, boolean withMagic) {
        return this.syncf().getTo(array, arrayOffset, withMagic);
    }

    public final int serialize(byte[] array, int arrayOffset) {
        return this.serialize(array, arrayOffset, true);
    }

    public final int serialize(IOBuffer iobuf, int iobufOffset, boolean withMagic) {
        return this.syncf().getTo(iobuf, iobufOffset, withMagic);
    }

    public final int serialize(IOBuffer iobuf, int iobufOffset) {
        return this.serialize(iobuf, iobufOffset, true);
    }

    public final int serialize(IOElasticBuffer iobuf, int iobufOffset, boolean withMagic) {
        return this.syncf().getTo(iobuf, iobufOffset, withMagic);
    }

    public final int serialize(IOElasticBuffer iobuf, int iobufOffset) {
        return this.serialize(iobuf, iobufOffset, true);
    }

    public final int serialize(long address, int addressOffset, boolean withMagic) {
        return this.syncf().getTo(address, addressOffset, withMagic);
    }

    public final int serialize(long address, int addressOffset) {
        return this.serialize(address, addressOffset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int deserialize(ByteBuffer buf, int bufOffset) {
        try {
            int n = this.putFrom(buf, bufOffset);
            return n;
        }
        finally {
            this.desync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int deserialize(IOBuffer iobuf, int iobufOffset, boolean wrap) {
        try {
            int n = this.putFrom(iobuf, iobufOffset, wrap);
            return n;
        }
        finally {
            this.desync();
        }
    }

    public final void deserialize(IOBuffer iobuf, int iobufOffset) throws EPktDeserializeException {
        this.deserialize(iobuf, iobufOffset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int deserialize(long addr, int addrOffset) {
        try {
            int n = this.putFrom(addr, addrOffset);
            return n;
        }
        finally {
            this.desync();
        }
    }

    public final String dump(String prefix) {
        return this.buffer.dump(prefix, 0, this.getSerializedLength());
    }

    public final void initializeBuffer() {
        if (!this.inDeserialize) {
            this.buffer.putInt(0, MAGIC);
            this.buffer.put(3, (byte)1);
            this.buffer.put(27, (byte)-1);
            this.buffer.putInt(30, this.body != null ? this.body.getType() : 0);
        }
    }

    public final String toString() {
        String str = "";
        str = str + "[";
        str = str + this.getVersion() + "," + this.getLength() + ",<" + UtlFabricAddress.toString((int)this.getSrc()) + ":" + this.getSrcPort() + ">,<" + UtlFabricAddress.toString((int)this.getDest()) + ":" + this.getDestPort() + ">," + this.getFlow() + ",<nb=" + this.getNoBuffering() + " re=" + this.getReplyExpected() + ">," + this.getHtl() + "," + this.getClazz() + "," + this.getNumSubheaders() + "," + this.getBodyType();
        int numSubheaders = this.getNumSubheaders();
        int numProcessed = 0;
        for (int i = 0; i < this.subheaders.length && numProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            str = str + " " + (Object)((Object)subheader);
            ++numProcessed;
        }
        str = str + "]";
        return str;
    }

    static {
        if (bufferByteOrder == ByteOrder.LITTLE_ENDIAN) {
            MAGIC = 11394234;
        } else if (bufferByteOrder == ByteOrder.BIG_ENDIAN) {
            MAGIC = -1159942912;
        } else {
            throw new IllegalArgumentException("unsupported byte order [" + bufferByteOrder + "]");
        }
    }
}

