/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.jcsmp.protocol.smf.AbstractHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;

public class PubSubCtrlHeaderBean
extends AbstractHeaderBean {
    private int pubCtrlVersion = 2;
    private int msgLenWords = 0;

    @Override
    public void reset() {
        super.reset();
        this.pubCtrlVersion = 2;
        this.msgLenWords = 0;
    }

    public int getMsgLenWords() {
        return this.msgLenWords;
    }

    public SmfTLVParameter[] getParams() {
        SmfTLVParameter[] theArray = new SmfTLVParameter[this.paramList.size()];
        return this.paramList.toArray(theArray);
    }

    public PubSubCtrlHeaderBean setMsgLenWords(int msgLenWords) {
        this.msgLenWords = msgLenWords;
        return this;
    }

    public int getProtocolVersion() {
        return this.pubCtrlVersion;
    }

    public PubSubCtrlHeaderBean setProtocolVersion(int pubCtrlVersion) {
        this.pubCtrlVersion = pubCtrlVersion;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("version=" + this.pubCtrlVersion + ";" + "msgLenWords=" + this.msgLenWords + ";" + "params=" + this.paramList.size());
        if (this.paramList.size() > 0) {
            sb.append("\n");
            for (int i = 0; i < this.paramList.size(); ++i) {
                sb.append("  ");
                sb.append(((SmfTLVParameter)this.paramList.get(i)).toString()).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public int getSmfEncodedLength() {
        int totalLen = 3;
        for (int i = 0; i < this.paramList.size(); ++i) {
            totalLen += ((SmfTLVParameter)this.paramList.get(i)).getSmfEncodedLength();
        }
        while (totalLen % 4 != 0) {
            ++totalLen;
        }
        return totalLen;
    }
}

