/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.discovery.impl.mcast;

import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.impl.DiscoveryCacheBase;
import com.neeve.emx.EEmxNwLnkInetAddrFormatException;
import com.neeve.emx.EmxNwLnkInetAddr;
import com.neeve.io.IOBuffer;
import com.neeve.pkt.EPktException;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlNet;
import com.neeve.util.UtlThread;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;

final class McastDiscoveryCache
extends DiscoveryCacheBase {
    private InetAddress groupAddr;
    private int groupPort;
    private MulticastSocket socket;
    private Receiver receiver;
    private byte[] sendBuffer;
    private byte[] receiveBuffer;
    private ByteBuffer receiveByteBuffer;
    private static final int MAX_SERIALIZED_PACKET_LEN = 8192;

    McastDiscoveryCache(UtlAddressDescriptor descriptor, int flags) throws EDiscoveryException {
        super(descriptor, flags);
    }

    private final DatagramPacket serialize(PktPacket packet) throws EDiscoveryException {
        int serializeLen = packet.serialize(this.sendBuffer, 0);
        DatagramPacket datagram = new DatagramPacket(this.sendBuffer, 0, serializeLen, this.groupAddr, this.groupPort);
        if (this.tracer.debug) {
            this.tracer.log("[McastDiscoveryCache-" + this.getLocalMemberName() + "] Serialized packet len =" + datagram.getLength() + ".", Tracer.Level.DEBUG);
        }
        return datagram;
    }

    private final PktPacket deserialize(DatagramPacket datagram) throws EPktException {
        if (datagram.getData() != this.receiveBuffer) {
            throw new InternalError("Buffer in receipt datagram is different from receive buffer!");
        }
        if (datagram.getOffset() != 0) {
            throw new InternalError("Data offset in receipt datagram is != 0!");
        }
        return PktFactory.getInstance().createPacket(this.receiveByteBuffer, 0, datagram.getLength());
    }

    private final void onReceipt(DatagramPacket datagram) {
        try {
            PktPacket packet = this.deserialize(datagram);
            this.onPacket(packet);
            packet.dispose();
        }
        catch (Exception e) {
            this.tracer.log("[McastDiscoveryCache-" + this.getLocalMemberName() + "] Failed to deserialize a discovery datagram into a packet [" + e.toString() + "]", Tracer.Level.SEVERE);
            e.printStackTrace();
        }
    }

    private final NetworkInterface findSuitableNetworkInterface() throws EDiscoveryException {
        if (this.tracer.debug) {
            this.tracer.log("[McastDiscoveryCache-" + this.getLocalMemberName() + "] Finding a suitable network interface for use...", Tracer.Level.DEBUG);
        }
        try {
            return UtlNet.getFirstActiveNetworkInterface((UtlNet.DebugTracer)new UtlNet.DebugTracer(){

                public boolean isEnabled() {
                    return ((McastDiscoveryCache)McastDiscoveryCache.this).tracer.debug;
                }

                public void log(String message) {
                    McastDiscoveryCache.this.tracer.log("[McastDiscoveryCache-" + McastDiscoveryCache.this.getLocalMemberName() + "] " + message, Tracer.Level.DEBUG);
                }
            }, (boolean)true);
        }
        catch (Exception e) {
            throw new EDiscoveryException("Error encountered while finding a multicast enabled interface to use [" + e.toString() + "]");
        }
    }

    @Override
    protected final void doOpen() throws EDiscoveryException {
        EmxNwLnkInetAddr emxInetAddr;
        try {
            emxInetAddr = EmxNwLnkInetAddr.parse((String)this.descriptor.address);
        }
        catch (IllegalArgumentException e) {
            throw new EDiscoveryException((Throwable)new EEmxNwLnkInetAddrFormatException(this.descriptor.address));
        }
        NetworkInterface localIf = null;
        String localIfAddr = (String)this.descriptor.props.get("localIfAddr");
        if (localIfAddr != null) {
            try {
                localIf = NetworkInterface.getByInetAddress(InetAddress.getByName(localIfAddr));
            }
            catch (Exception e) {
                throw new EDiscoveryException("Failed to get network interface associated with specified local network address '" + localIfAddr + "' [" + e.toString() + "]");
            }
        }
        if (localIf == null) {
            localIf = this.findSuitableNetworkInterface();
        }
        if (localIf == null) {
            throw new EDiscoveryException("A multicast enabled network interface was not specified and could not be found");
        }
        try {
            this.groupAddr = InetAddress.getByName(emxInetAddr.host);
            this.groupPort = emxInetAddr.port;
        }
        catch (Exception e) {
            throw new EDiscoveryException("Failed to resolve address '" + emxInetAddr.host + "'");
        }
        if (!this.groupAddr.isMulticastAddress()) {
            throw new EDiscoveryException("'" + this.groupAddr + "(" + emxInetAddr.host + ")' is not a multicast address");
        }
        this.sendBuffer = new byte[8192];
        this.receiveByteBuffer = IOBuffer.allocateByteBuffer((int)8192, (boolean)false);
        this.receiveBuffer = this.receiveByteBuffer.array();
        if (this.tracer.debug) {
            this.tracer.log("[McastDiscoveryCache-" + this.getLocalMemberName() + "] Creating multicast socket (port=" + this.groupPort + ")...", Tracer.Level.DEBUG);
        }
        try {
            this.socket = new MulticastSocket(this.groupPort);
        }
        catch (Exception e) {
            throw new EDiscoveryException("Failed to create multicast socket (port=" + this.groupPort + ") [" + e.toString() + "]");
        }
        this.tracer.log("[McastDiscoveryCache-" + this.getLocalMemberName() + "@" + emxInetAddr.host + ":" + this.groupPort + "] Using network interface " + UtlNet.formatNetworkInterfaceDescriptor((NetworkInterface)localIf), Tracer.Level.INFO);
        try {
            this.socket.setNetworkInterface(localIf);
        }
        catch (Exception e) {
            throw new EDiscoveryException("Failed to set local network interface " + UtlNet.formatNetworkInterfaceDescriptor((NetworkInterface)localIf) + " [" + e.toString() + "]");
        }
        if (this.tracer.debug) {
            this.tracer.log("[McastDiscoveryCache-" + this.getLocalMemberName() + "] Joining multicast group '" + this.groupAddr + "'...", Tracer.Level.DEBUG);
        }
        try {
            this.socket.joinGroup(this.groupAddr);
        }
        catch (Exception e) {
            throw new EDiscoveryException("Failed to join multicast group '" + this.groupAddr + "' [" + e.toString() + "]");
        }
        this.receiver = new Receiver();
        this.receiver.start();
    }

    @Override
    protected final void doBroadcast(PktPacket packet) throws EDiscoveryException {
        try {
            this.socket.send(this.serialize(packet));
        }
        catch (Exception e) {
            if (e instanceof EDiscoveryException) {
                throw (EDiscoveryException)((Object)e);
            }
            throw new EDiscoveryException(e);
        }
    }

    @Override
    protected final void doClose() {
        this.receiver.shutdown();
        while (true) {
            try {
                this.receiver.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private final class Receiver
    extends Thread {
        private final DatagramPacket datagram;
        private boolean done = false;

        Receiver() {
            this.setName("X-EDP-McastReceiver");
            this.setDaemon(true);
            this.datagram = new DatagramPacket(McastDiscoveryCache.this.receiveBuffer, McastDiscoveryCache.this.receiveBuffer.length);
        }

        @Override
        public final void run() {
            UtlThread.setDefaultCPUAffinityMask();
            while (!this.done) {
                try {
                    McastDiscoveryCache.this.socket.receive(this.datagram);
                    if (((McastDiscoveryCache)McastDiscoveryCache.this).tracer.debug) {
                        McastDiscoveryCache.this.tracer.log("[McastDiscoveryCache-" + McastDiscoveryCache.this.getLocalMemberName() + "] Received a datagram [len=" + this.datagram.getLength() + "]...", Tracer.Level.DEBUG);
                    }
                    McastDiscoveryCache.this.onReceipt(this.datagram);
                }
                catch (Throwable e) {
                    if (this.done) continue;
                    McastDiscoveryCache.this.tracer.log("[McastDiscoveryCache-" + McastDiscoveryCache.this.getLocalMemberName() + "] Error encountered while receiving on socket [" + e.toString() + "] Shutting down...", Tracer.Level.SEVERE);
                    this.shutdown();
                }
            }
        }

        final void shutdown() {
            this.done = true;
            McastDiscoveryCache.this.socket.close();
        }
    }
}

