/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jni;

import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.solxf.ISolMessageProducer;
import com.neeve.solxf.ISolPublishEventHandler;
import com.neeve.solxf.impl.jni.SolJniListener;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;

public final class SolJniMessageProducer
extends SmaObject
implements ISolMessageProducer {
    private final boolean alwaysCopyTopic = Config.getValue((String)"nv.sma.soljniproducer.alwayscopytopic", (boolean)false);
    private final long _nsession;
    private final ISolPublishEventHandler _handler;
    private final boolean useNativePrewireTs;

    public SolJniMessageProducer(long nsession, ISolPublishEventHandler handler) {
        super(null);
        this._nsession = nsession;
        this._handler = handler;
        this.useNativePrewireTs = UtlTime.isNativeTimeEnabled();
        SolJniListener.registerPublishEventHandler(this._nsession, this._handler);
    }

    private static final native long nativeSend(long var0, long var2, int var4, int var5, long var6, int var8, int var9, long var10, int var12, int var13, long var14, int var16, int var17, long var18) throws SmaException;

    private static final native IOBuffer nativeRequest(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7, long var8) throws SmaException;

    @Override
    public final long send(IOBuffer serializedMessage, int serializedMessageOffset, int serializedMessageLength, IOBuffer serializedMetadata, int serializedMetadataOffset, int serializedMetadataLength, IOBuffer serializedUserdata, int serializedUserdataOffset, int serializedUserdataLength, XString topic, long originTs, long ackCorrelator) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log("[SolJniMessageProducer] Sending message...", Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessage=" + serializedMessage, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessageOffset=" + serializedMessageOffset, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessageLength=" + serializedMessageLength, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadata=" + serializedMetadata, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadataOffset=" + serializedMetadataOffset, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadataLength=" + serializedMetadataLength, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedUserdata=" + serializedUserdata, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedUserdataOffset=" + serializedUserdataOffset, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedUserdataLength=" + serializedUserdataLength, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...destination=" + topic, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...ackCorrelator=" + ackCorrelator, Tracer.Level.DEBUG);
        }
        int serializedTopicLength = topic.serializedLength();
        topic.ensureCapacity((short)(topic.serializedLength() + 1));
        IOBuffer.putByte((long)topic.nativeAddress(), (int)serializedTopicLength, (byte)0);
        try {
            long preSendTs = this.useNativePrewireTs ? 0L : UtlTime.now();
            long nativePrewireTs = SolJniMessageProducer.nativeSend(this._nsession, serializedMessage.getNativeAddress(), serializedMessageOffset, serializedMessageLength, serializedMetadata != null ? serializedMetadata.getNativeAddress() : 0L, serializedMetadataOffset, serializedMetadataLength, serializedUserdata != null ? serializedUserdata.getNativeAddress() : 0L, serializedUserdataOffset, serializedUserdataLength, topic.nativeAddress(), 0, serializedTopicLength, ackCorrelator);
            return this.useNativePrewireTs ? nativePrewireTs : preSendTs;
        }
        catch (SmaException smae) {
            this.tracer.log("[SolJniMessageProducer] Sending message failed [" + smae.getMessage() + "]...", Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessage=" + serializedMessage, Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessageOffset=" + serializedMessageOffset, Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessageLength=" + serializedMessageLength, Tracer.Level.SEVERE);
            try {
                this.tracer.log("[SolJniMessageProducer] ...serializedMessageBuffer=" + UtlBuffer.dump((ByteBuffer)serializedMessage.getBufferUnsafe()), Tracer.Level.SEVERE);
            }
            catch (Throwable thrown) {
                this.tracer.log("[SolJniMessageProducer] ...serializedMessageBuffer=[" + thrown.getMessage() + "]", Tracer.Level.SEVERE);
            }
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadata=" + serializedMetadata, Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadataOffset=" + serializedMetadataOffset, Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadataLength=" + serializedMetadataLength, Tracer.Level.SEVERE);
            try {
                this.tracer.log("[SolJniMessageProducer] ...serializedMetadataBuffer=" + (serializedMetadata != null ? UtlBuffer.dump((ByteBuffer)serializedMetadata.getBufferUnsafe()) : null), Tracer.Level.SEVERE);
            }
            catch (Throwable thrown) {
                this.tracer.log("[SolJniMessageProducer] ...serializedMetadataBuffer=[" + thrown.getMessage() + "]", Tracer.Level.SEVERE);
            }
            this.tracer.log("[SolJniMessageProducer] ...destination=" + topic, Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...topicString=" + topic.toDiagnosticString(), Tracer.Level.SEVERE);
            try {
                this.tracer.log("[SolJniMessageProducer] ...serializedTopicBuffer=" + IOBuffer.dump((long)topic.nativeAddress(), (int)0, (int)serializedTopicLength), Tracer.Level.SEVERE);
            }
            catch (Throwable thrown) {
                this.tracer.log("[SolJniMessageProducer] ...serializedTopicBuffer=[" + thrown.getMessage() + "]", Tracer.Level.SEVERE);
            }
            throw smae;
        }
    }

    @Override
    public final void close() {
        SolJniListener.deregisterPublishEventHandler(this._nsession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] request(XString topic, byte[] content, long timeoutMillis) throws SmaException {
        IOBuffer requestContentBuffer = null;
        IOBuffer replyContentBuffer = null;
        try {
            byte[] byArray;
            IOBuffer serializedTopic = IOBuffer.create((int)(topic.serializedLength() + 1));
            try {
                topic.getTo(serializedTopic, 0);
                serializedTopic.putByte(topic.serializedLength(), (byte)0);
                requestContentBuffer = IOBuffer.create((int)content.length);
                UtlBuffer.copy((byte[])content, (int)0, (ByteBuffer)requestContentBuffer.getBufferUnsafe(), (int)0, (int)content.length);
                replyContentBuffer = SolJniMessageProducer.nativeRequest(this._nsession, serializedTopic.getBufferUnsafe(), 0, topic.serializedLength(), requestContentBuffer.getBufferUnsafe(), 0, content.length, timeoutMillis);
                byte[] ret = new byte[replyContentBuffer.getLength()];
                UtlBuffer.copy((ByteBuffer)replyContentBuffer.getBufferUnsafe(), (int)0, (byte[])ret, (int)0, (int)replyContentBuffer.getLength());
                byArray = ret;
            }
            catch (Throwable throwable) {
                serializedTopic.dispose();
                throw throwable;
            }
            serializedTopic.dispose();
            return byArray;
        }
        finally {
            if (requestContentBuffer != null) {
                requestContentBuffer.dispose();
            }
        }
    }

    @Override
    public final boolean supportsRequests() {
        return true;
    }
}

