/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jni;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XLongLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.root.RootConfig;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.SmaConfig;
import com.neeve.solxf.ISolMessageListener;
import com.neeve.solxf.ISolPublishEventHandler;
import com.neeve.solxf.impl.jni.SolJniFactory;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;

public final class SolJniListener {
    private static final XLongLinkedHashMap<ISolMessageListener> _sessionListeners = new XLongLinkedHashMap();
    private static final XLongLinkedHashMap<XString> _sessionTopics = new XLongLinkedHashMap();
    private static final XLongLinkedHashMap<ISolMessageListener> _flowReceivers = new XLongLinkedHashMap();
    private static final XLongLinkedHashMap<XString> _flowTopics = new XLongLinkedHashMap();
    private static final XLongLinkedHashMap<ISolPublishEventHandler> _publishEventHandlers = new XLongLinkedHashMap().shared();
    private static final Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)SmaConfig.getConfig());
    private static final boolean useNativePostwireTs = UtlTime.isNativeTimeEnabled();
    private static final ThreadLocal<XString> xstr = new ThreadLocal<XString>(){

        @Override
        protected final XString initialValue() {
            return XString.create();
        }
    };
    private static final IOBuffer emptySerializedMessage = IOBuffer.create((int)0);

    private static final long resolvePostWireTs(long nativePostWireTs) {
        long resolvedPostWireTs = MessageLatencyManager.captureMsgLatencyStats ? (useNativePostwireTs ? nativePostWireTs : UtlTime.now()) : 0L;
        return resolvedPostWireTs;
    }

    static final void registerSessionListener(long nsession, ISolMessageListener listener) {
        _sessionListeners.put(nsession, (Object)listener);
        _sessionTopics.put(nsession, (Object)XString.create((short)256, (boolean)true));
    }

    static final void deregisterSessionListener(long nsession) {
        _sessionListeners.remove(nsession);
        _sessionTopics.remove(nsession);
    }

    static final void registerFlowReceiver(long nflow, ISolMessageListener listener) {
        _flowReceivers.put(nflow, (Object)listener);
        _flowTopics.put(nflow, (Object)XString.create((short)256, (boolean)true));
    }

    static final void deregisterFlowReceiver(long nflow) {
        _flowReceivers.remove(nflow);
        _flowTopics.remove(nflow);
    }

    static final void registerPublishEventHandler(long nsession, ISolPublishEventHandler handler) {
        _publishEventHandlers.put(nsession, (Object)handler);
    }

    static final void deregisterPublishEventHandler(long nsession) {
        _publishEventHandlers.remove(nsession);
    }

    public static final void onLog(int category, int level, long msg, int msglen) {
        XString str = xstr.get();
        str.setValueFromMemory(msg, msglen);
        SolJniFactory.ccsmpTracer().log("[CCSMP] [" + SolJniFactory.toCcsmpTraceCategoryStr(category) + ", " + SolJniFactory.toCcsmpTraceLevelStr(level) + "] " + str.toString(), SolJniFactory.ccsmpToXTraceLevel(level));
    }

    public static final void onMessage(long nsession, long serializedMessage, int serializedMessageLength, long serializedMetadata, int serializedMetadataLength, long serializedUserdata, int serializedUserdataLength, long ntopic, int ntopicLen, long postWireTs) {
        ISolMessageListener listener = (ISolMessageListener)_sessionListeners.get(nsession);
        if (listener != null) {
            XString topic;
            XString xString = topic = ntopic > 0L ? (XString)_sessionTopics.get(nsession) : null;
            if (topic != null) {
                topic.setValueFromMemory(ntopic, ntopicLen);
            }
            try {
                listener.onMessage(0L, serializedMessage == 0L ? emptySerializedMessage.getNativeAddress() : serializedMessage, serializedMessageLength, serializedMetadata, serializedMetadataLength, serializedUserdata, serializedUserdataLength, topic, false, SolJniListener.resolvePostWireTs(postWireTs));
            }
            catch (Throwable thrown) {
                tracer.log("[SolJniListener] Error in onMessage: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
            }
        } else {
            tracer.log("[SolJniListener] No listener found for received message on session " + nsession, Tracer.Level.WARNING);
        }
    }

    public static final void onFlowMessage(long nflow, long msgId, long serializedMessage, int serializedMessageLength, long serializedMetadata, int serializedMetadataLength, long serializedUserdata, int serializedUserdataLength, long ntopic, int ntopicLen, long postWireTs) {
        ISolMessageListener listener = (ISolMessageListener)_flowReceivers.get(nflow);
        if (listener != null) {
            XString topic;
            XString xString = topic = ntopic > 0L ? (XString)_flowTopics.get(nflow) : null;
            if (topic != null) {
                topic.setValueFromMemory(ntopic, ntopicLen);
            }
            try {
                listener.onMessage(msgId, serializedMessage == 0L ? emptySerializedMessage.getNativeAddress() : serializedMessage, serializedMessageLength, serializedMetadata, serializedMetadataLength, serializedUserdata, serializedUserdataLength, topic, true, SolJniListener.resolvePostWireTs(postWireTs));
            }
            catch (Throwable thrown) {
                tracer.log("[SolJniListener] Error in onFlowMessage: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
            }
        } else {
            tracer.log("[SolJniListener] No listener found for received message on flow " + nflow, Tracer.Level.WARNING);
        }
    }

    public static final void onAck(long nsession, long correlator) {
        ISolPublishEventHandler handler = (ISolPublishEventHandler)_publishEventHandlers.get(nsession);
        if (handler != null) {
            try {
                handler.onAck(correlator);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static final void onNack(long nsession, long correlator, Exception cause) {
        ISolPublishEventHandler handler = (ISolPublishEventHandler)_publishEventHandlers.get(nsession);
        if (handler != null) {
            try {
                handler.onNack(correlator, cause);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static final void onSessionReconnecting(long nsession) {
        ISolMessageListener listener = (ISolMessageListener)_sessionListeners.get(nsession);
        if (listener != null) {
            try {
                listener.onSessionReconnecting();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static final void onSessionReconnected(long nsession) {
        ISolMessageListener listener = (ISolMessageListener)_sessionListeners.get(nsession);
        if (listener != null) {
            try {
                listener.onSessionReconnected();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static final void onSessionFailed(long nsession, Exception cause) {
        ISolMessageListener listener = (ISolMessageListener)_sessionListeners.get(nsession);
        if (listener != null) {
            try {
                listener.onSessionFailed(cause);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

