/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jcsmp;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.solxf.ESolException;
import com.neeve.solxf.ISolMessageProducer;
import com.neeve.solxf.ISolPublishEventHandler;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlTime;
import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.JCSMPStreamingPublishCorrelatingEventHandler;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.Requestor;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.XMLMessageProducer;
import java.util.Properties;

public final class SolJcsmpMessageProducer
extends SmaObject
implements ISolMessageProducer,
JCSMPStreamingPublishCorrelatingEventHandler {
    private final XMLMessageProducer _producer;
    private final Requestor _requestor;
    private final ISolPublishEventHandler _handler;
    private final boolean _writePayloadInXmlContent;

    public SolJcsmpMessageProducer(JCSMPSession _session, ISolPublishEventHandler handler, Properties solxfProperties) throws SmaException {
        super(null);
        try {
            this._handler = handler;
            this._producer = _session.getMessageProducer((JCSMPStreamingPublishEventHandler)this);
            this._requestor = _session.createRequestor();
            this._writePayloadInXmlContent = UtlProps.getValue((Properties)solxfProperties, (String)"write_payload_in_xml_content", (boolean)false);
        }
        catch (JCSMPErrorResponseException ex) {
            throw new ESolException(ex.getSubcodeEx(), ex.getMessage());
        }
        catch (JCSMPException e) {
            throw new SmaException((Throwable)e);
        }
    }

    @Override
    public final byte[] request(XString requestTopic, byte[] requestContent, long timeoutMillis) throws SmaException {
        try {
            BytesXMLMessage requestMsg = this._producer.createBytesXMLMessage();
            requestMsg.writeAttachment(requestContent);
            BytesXMLMessage replyMsg = this._requestor.request((XMLMessage)requestMsg, timeoutMillis, (Destination)JCSMPFactory.onlyInstance().createTopic(requestTopic.getValue()));
            byte[] reply = new byte[replyMsg.getAttachmentContentLength()];
            replyMsg.readAttachmentBytes(reply);
            return reply;
        }
        catch (JCSMPException e) {
            throw new SmaException("Error sending Jcsmp request: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final long send(IOBuffer serializedMessage, int serializedMessageOffset, int serializedMessageLength, IOBuffer serializedMetadata, int serializedMetadataOffset, int serializedMetadataLength, IOBuffer serializedUserdata, int serializedUserdataOffset, int serializedUserdataLength, XString destination, long originTs, long ackCorrelator) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log("[SolJcsmpMessageProducer] Sending message...", Tracer.Level.DEBUG);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMessage=" + serializedMessage, Tracer.Level.DEBUG);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMessageOffset=" + serializedMessageOffset, Tracer.Level.DEBUG);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMessageLength=" + serializedMessageLength, Tracer.Level.DEBUG);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMetadata=" + serializedMetadata, Tracer.Level.DEBUG);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMetadataOffset=" + serializedMetadataOffset, Tracer.Level.DEBUG);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMetadataLength=" + serializedMetadataLength, Tracer.Level.DEBUG);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedUserdata=" + serializedUserdata, Tracer.Level.DEBUG);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedUserdataOffset=" + serializedUserdataOffset, Tracer.Level.DEBUG);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedUserdataLength=" + serializedUserdataLength, Tracer.Level.DEBUG);
            this.tracer.log("[SolJcsmpMessageProducer] ...destination=" + destination, Tracer.Level.DEBUG);
        }
        try {
            long preWireTs;
            DeliveryMode deliveryMode;
            BytesXMLMessage solaceMessage;
            byte[] serializedMessageBytes = new byte[serializedMessageLength];
            serializedMessage.getTo(serializedMessageOffset, serializedMessageBytes, 0, serializedMessageLength);
            if (!this._writePayloadInXmlContent) {
                if (this.tracer.debug) {
                    this.tracer.log("[SolJcsmpMessageProducer] ...writing " + serializedMessageLength + " bytes to solace bytes message...", Tracer.Level.DEBUG);
                }
                BytesMessage message = this._producer.createBytesMessage();
                message.setData(serializedMessageBytes);
                solaceMessage = message;
            } else {
                if (this.tracer.debug) {
                    this.tracer.log("[SolJcsmpMessageProducer] ...writing " + serializedMessageLength + " bytes to solace bytes xml message...", Tracer.Level.WARNING);
                }
                solaceMessage = this._producer.createBytesXMLMessage();
                solaceMessage.writeBytes(serializedMessageBytes);
            }
            if (serializedMetadata != null) {
                byte[] serializedMetadataBytes = new byte[serializedMetadataLength];
                serializedMetadata.getTo(serializedMetadataOffset, serializedMetadataBytes, 0, serializedMetadataLength);
                if (this.tracer.debug) {
                    this.tracer.log("[SolJcsmpMessageProducer] ...writing " + serializedMetadataLength + " bytes to solace property...", Tracer.Level.DEBUG);
                }
                SDTMap props = this._producer.createMap();
                props.putBytes("x-sma-metadata", serializedMetadataBytes, 0, serializedMetadataLength);
                solaceMessage.setProperties(props);
            }
            DeliveryMode deliveryMode2 = deliveryMode = ackCorrelator > 0L ? DeliveryMode.PERSISTENT : DeliveryMode.DIRECT;
            if (this.tracer.debug) {
                this.tracer.log("[SolJcsmpMessageProducer] ...qos=" + deliveryMode, Tracer.Level.DEBUG);
            }
            solaceMessage.setDeliveryMode(ackCorrelator > 0L ? DeliveryMode.PERSISTENT : DeliveryMode.DIRECT);
            if (ackCorrelator > 0L) {
                solaceMessage.setCorrelationKey((Object)ackCorrelator);
            }
            if (this.tracer.debug) {
                this.tracer.log("[SolJcsmpMessageProducer] ...sending...", Tracer.Level.DEBUG);
            }
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.w1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)serializedMessage);
            long l = preWireTs = MessageLatencyManager.captureMsgLatencyStats ? UtlTime.now() : 0L;
            if (serializedUserdata != null) {
                byte[] userdata = new byte[serializedUserdataLength];
                serializedUserdata.getTo(serializedUserdataOffset, userdata, 0, serializedUserdataLength);
                solaceMessage.setUserData(userdata);
            } else {
                byte[] timestamps = new byte[16];
                UtlBuffer.writeLong((long)originTs, (byte[])timestamps, (int)0, (boolean)true);
                UtlBuffer.writeLong((long)preWireTs, (byte[])timestamps, (int)8, (boolean)true);
                solaceMessage.setUserData(timestamps);
            }
            this._producer.send((XMLMessage)solaceMessage, (Destination)JCSMPFactory.onlyInstance().createTopic(destination.getValue()));
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.w2, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)serializedMessage);
            return preWireTs;
        }
        catch (JCSMPErrorResponseException ex) {
            this.tracer.log("[SolJcsmpMessageProducer] Sending message failed...", Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMessage=" + serializedMessage, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMessageOffset=" + serializedMessageOffset, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMessageLength=" + serializedMessageLength, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMetadata=" + serializedMetadata, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMetadataOffset=" + serializedMetadataOffset, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMetadataLength=" + serializedMetadataLength, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...destination=" + destination, Tracer.Level.SEVERE);
            throw new ESolException(ex.getSubcodeEx(), ex.getMessage());
        }
        catch (JCSMPException e) {
            this.tracer.log("[SolJcsmpMessageProducer] Sending message failed...", Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMessage=" + serializedMessage, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMessageOffset=" + serializedMessageOffset, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMessageLength=" + serializedMessageLength, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMetadata=" + serializedMetadata, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMetadataOffset=" + serializedMetadataOffset, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...serializedMetadataLength=" + serializedMetadataLength, Tracer.Level.SEVERE);
            this.tracer.log("[SolJcsmpMessageProducer] ...destination=" + destination, Tracer.Level.SEVERE);
            throw new SmaException((Throwable)e);
        }
    }

    @Override
    public final void close() {
        this._producer.close();
    }

    public final void responseReceived(String msgId) {
        this.tracer.log("[SolJcsmpMessageProducer,] Solace responseReceived() callback method called. Expected responseReceivedEx() to be called. Not processing.", Tracer.Level.WARNING);
    }

    public final void handleError(String msgId, JCSMPException cause, long timestamp) {
        this.tracer.log("[SolJcsmpMessageProducer,] Solace handleError() callback method called. Expected handleErrorEx() to be called. Not processing.", Tracer.Level.WARNING);
    }

    public final void responseReceivedEx(Object key) {
        this._handler.onAck((Long)key);
    }

    public final void handleErrorEx(Object key, JCSMPException cause, long timestamp) {
        Object ex = cause;
        if (cause instanceof JCSMPErrorResponseException) {
            JCSMPErrorResponseException jcsmpEx = (JCSMPErrorResponseException)((Object)cause);
            ex = new ESolException(jcsmpEx.getSubcodeEx(), jcsmpEx.getMessage());
        }
        this._handler.onNack(null != key ? (Long)key : 0L, (Exception)ex);
    }

    @Override
    public boolean supportsRequests() {
        return true;
    }
}

