/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jcsmp;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.solxf.ISolMessageListener;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPReconnectEventHandler;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.XMLMessageListener;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SolJcsmpMessageListener
extends SmaObject
implements XMLMessageListener,
JCSMPReconnectEventHandler {
    private final ISolMessageListener _listener;
    private final boolean _readPayloadFromXmlContent;
    private IOBuffer _serializedMessage;
    private IOBuffer _serializedMetadata;
    private IOBuffer _serializedUserdata;
    private static final ConcurrentHashMap<Long, BytesXMLMessage> _tempMessageStore = new ConcurrentHashMap();

    public SolJcsmpMessageListener(JCSMPSession session, ISolMessageListener listener, Properties solxfProperties) {
        super(null);
        this._listener = listener;
        this._readPayloadFromXmlContent = UtlProps.getValue((Properties)solxfProperties, (String)"read_payload_from_xml_content", (boolean)false);
    }

    private final int prepareSerializedMessage(BytesXMLMessage message) {
        byte[] serializedMessageBytes = ((BytesMessage)message).getData();
        if (serializedMessageBytes == null && this._readPayloadFromXmlContent) {
            if (this.tracer.debug) {
                this.tracer.log("[SolJcsmpMessageListener] Content not found in binary attachment ... checking in XML content...'", Tracer.Level.DEBUG);
            }
            if (message.getContentLength() > 0) {
                serializedMessageBytes = new byte[message.getContentLength()];
                int read = message.readContentBytes(serializedMessageBytes);
                if (read != serializedMessageBytes.length) {
                    serializedMessageBytes = null;
                    this.tracer.log("[SolJcsmpMessageListener] Unable to read all xml content bytes expected " + serializedMessageBytes + " but read" + read, Tracer.Level.SEVERE);
                }
            } else {
                this.tracer.log("[SolJcsmpMessageListener] XML content is 0 length'", Tracer.Level.WARNING);
            }
        }
        if (serializedMessageBytes != null) {
            this._serializedMessage = IOBuffer.ensureCapacity((IOBuffer)this._serializedMessage, (int)serializedMessageBytes.length, (boolean)false);
            this._serializedMessage.putFrom(0, serializedMessageBytes, 0, serializedMessageBytes.length);
            return serializedMessageBytes.length;
        }
        return 0;
    }

    private final int prepareSerializedMetadata(BytesXMLMessage message) throws JCSMPException {
        byte[] serializedMetadataBytes;
        SDTMap props = message.getProperties();
        if (props != null && (serializedMetadataBytes = props.getBytes("x-sma-metadata")) != null) {
            this._serializedMetadata = IOBuffer.ensureCapacity((IOBuffer)this._serializedMetadata, (int)serializedMetadataBytes.length, (boolean)false);
            this._serializedMetadata.putFrom(0, serializedMetadataBytes, 0, serializedMetadataBytes.length);
            return serializedMetadataBytes.length;
        }
        return 0;
    }

    private final int prepareSerializedUserdata(BytesXMLMessage message) throws JCSMPException {
        if (message.hasUserData()) {
            byte[] serializedUserdataBytes = message.getUserData();
            this._serializedUserdata = IOBuffer.ensureCapacity((IOBuffer)this._serializedUserdata, (int)serializedUserdataBytes.length, (boolean)false);
            this._serializedUserdata.putFrom(0, serializedUserdataBytes, 0, serializedUserdataBytes.length);
            return serializedUserdataBytes.length;
        }
        return 0;
    }

    public final void onException(JCSMPException e) {
        this._listener.onSessionFailed((Exception)new SmaException((Throwable)e));
    }

    public abstract void onReceive(BytesXMLMessage var1);

    protected final void onReceive(BytesXMLMessage message, boolean isGuaranteed) {
        long postWireTs = MessageLatencyManager.captureMsgLatencyStats ? UtlTime.now() : 0L;
        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.r, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Inbound, (Object)message);
        if (isGuaranteed) {
            _tempMessageStore.put(message.getMessageIdLong(), message);
        }
        if (message instanceof BytesMessage) {
            if (this.tracer.debug) {
                this.tracer.log("[SolJcsmpMessageListener] Received a message on topic '" + message.getDestination().getName() + "'", Tracer.Level.DEBUG);
            }
            XString topic = XString.create((String)message.getDestination().getName());
            int serializedMessageLength = 0;
            int serializedMetadataLength = 0;
            int serializedUserdataLength = 0;
            try {
                serializedMessageLength = this.prepareSerializedMessage(message);
                serializedMetadataLength = this.prepareSerializedMetadata(message);
                serializedUserdataLength = this.prepareSerializedUserdata(message);
                try {
                    this._listener.onMessage(message.getMessageIdLong(), serializedMessageLength > 0 ? this._serializedMessage.getNativeAddress() : 0L, serializedMessageLength, serializedMetadataLength > 0 ? this._serializedMetadata.getNativeAddress() : 0L, serializedMetadataLength, serializedUserdataLength > 0 ? this._serializedUserdata.getNativeAddress() : 0L, serializedUserdataLength, topic, isGuaranteed, postWireTs);
                }
                catch (Throwable thrown) {
                    this.tracer.log("[SolJcsmpMessageListener] Error in onMessage: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                }
            }
            catch (Throwable thrown) {
                String error = "[SolJcsmpMessageListener] Error unmarshalling inbound message: " + thrown.getMessage();
                try {
                    this._listener.onCorruptMessage(message.getMessageIdLong(), topic, serializedMessageLength > 0 ? this._serializedMessage.getNativeAddress() : 0L, serializedMessageLength, serializedMetadataLength > 0 ? this._serializedMetadata.getNativeAddress() : 0L, serializedMetadataLength, new RuntimeException(error, thrown));
                }
                catch (Throwable thrown2) {
                    this.tracer.log("[SolJcsmpMessageListener] Error in onCorruptMessage handler: " + UtlThrowable.prepareStackTrace((Throwable)thrown2), Tracer.Level.SEVERE);
                }
            }
        } else {
            XString topic = null;
            try {
                topic = XString.create((String)message.getDestination().getName());
            }
            catch (Throwable thrown) {
                this.tracer.log("[SolJcsmpMessageListener] Error getting topic from invalid message type: " + thrown.getMessage(), Tracer.Level.WARNING);
            }
            int serializedMetadataLength = 0;
            try {
                serializedMetadataLength = this.prepareSerializedMetadata(message);
            }
            catch (Throwable thrown) {
                this.tracer.log("[SolJcsmpMessageListener] Error getting serialized metadata from invalid message type: " + thrown.getMessage(), Tracer.Level.WARNING);
            }
            try {
                this._listener.onCorruptMessage(message.getMessageIdLong(), topic, 0L, 0, serializedMetadataLength > 0 ? this._serializedMetadata.getNativeAddress() : 0L, serializedMetadataLength, new RuntimeException("Message is not of type BytesMessage '" + message.getClass() + "' [unsupported message type]"));
            }
            catch (Throwable thrown2) {
                this.tracer.log("[SolJcsmpMessageListener] Error in onCorruptMessage handler: " + UtlThrowable.prepareStackTrace((Throwable)thrown2), Tracer.Level.SEVERE);
            }
        }
    }

    public final void ackMessage(long messageId) {
        BytesXMLMessage message = _tempMessageStore.get(messageId);
        if (null != message) {
            message.ackMessage();
            _tempMessageStore.remove(messageId);
        }
    }

    public final boolean preReconnect() {
        this._listener.onSessionReconnecting();
        return true;
    }

    public final void postReconnect() {
        this._listener.onSessionReconnected();
    }

    public final BytesXMLMessage getMessage(long messageId) {
        return _tempMessageStore.get(messageId);
    }
}

