/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsResponse;

public class CreateTopicsRequest
extends AbstractRequest {
    private final CreateTopicsRequestData data;
    public static final int NO_NUM_PARTITIONS = -1;
    public static final short NO_REPLICATION_FACTOR = -1;

    private CreateTopicsRequest(CreateTopicsRequestData data, short version) {
        super(ApiKeys.CREATE_TOPICS, version);
        this.data = data;
    }

    public CreateTopicsRequest(Struct struct, short version) {
        super(ApiKeys.CREATE_TOPICS, version);
        this.data = new CreateTopicsRequestData(struct, version);
    }

    public CreateTopicsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        CreateTopicsResponseData response = new CreateTopicsResponseData();
        if (this.version() >= 2) {
            response.setThrottleTimeMs(throttleTimeMs);
        }
        ApiError apiError = ApiError.fromThrowable(e);
        for (CreateTopicsRequestData.CreatableTopic topic : this.data.topics()) {
            response.topics().add(new CreateTopicsResponseData.CreatableTopicResult().setName(topic.name()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
        }
        return new CreateTopicsResponse(response);
    }

    public static CreateTopicsRequest parse(ByteBuffer buffer, short version) {
        return new CreateTopicsRequest(ApiKeys.CREATE_TOPICS.parseRequest(version, buffer), version);
    }

    @Override
    public Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateTopicsRequest> {
        private final CreateTopicsRequestData data;

        public Builder(CreateTopicsRequestData data) {
            super(ApiKeys.CREATE_TOPICS);
            this.data = data;
        }

        @Override
        public CreateTopicsRequest build(short version) {
            if (this.data.validateOnly() && version == 0) {
                throw new UnsupportedVersionException("validateOnly is not supported in version 0 of CreateTopicsRequest");
            }
            return new CreateTopicsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

