/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.event;

import com.neeve.config.Config;
import com.neeve.event.Event;
import com.neeve.event.EventFactory;
import com.neeve.event.IEventAcknowledger;
import com.neeve.event.alert.AlertEvent;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.SmaException;
import com.neeve.trace.Tracer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class UnhandledMessageEvent
extends AlertEvent {
    protected static final Tracer tracer = Tracer.get((String)"nv.sma");
    private static final String PROP_AUTOACK_DEPRECATED = "nv.sma.unhandledmessageevent.autoAck";
    public static final String PROP_AUTOACK = "nv.sma.unhandledmessageevent.autoack";
    public static final boolean PROP_AUTOACK_DEFAULT = false;
    static final boolean autoAckDefault = Config.getValue((String)"nv.sma.unhandledmessageevent.autoack", (boolean)Config.getValue((String)"nv.sma.unhandledmessageevent.autoAck", (boolean)false));
    private MessageMetadata messageMetadata;
    private String messageKey;
    private String messageSMATransportMessageId;
    private MessageBusBinding messageBus;
    private MessageChannel messageChannel;
    private Object unwrappedMessage;
    private Throwable reason;
    private byte[] serializedPayloadBlob;
    private byte[] serializedMetadataBlob;
    private boolean autoAck = this.autoAckDefault();
    private final AtomicBoolean acked = new AtomicBoolean(false);

    private UnhandledMessageEvent() {
        this(111);
    }

    protected UnhandledMessageEvent(short type) {
        super(type);
    }

    public static Event create(Properties props) {
        return new UnhandledMessageEvent();
    }

    public static UnhandledMessageEvent create(MessageBusBinding binding, MessageChannel channel, MessageMetadata messageMetadata, String messageKey, String smaTransportMessageId, Object unwrappedMessage, byte[] serializedMetadataBlob, byte[] serializedPayloadBlob, IEventAcknowledger acknowledger, Throwable reason) {
        return ((UnhandledMessageEvent)EventFactory.getInstance().createEvent((short)111)).init(binding, channel, messageMetadata, messageKey, smaTransportMessageId, unwrappedMessage, serializedMetadataBlob, serializedPayloadBlob, acknowledger, reason);
    }

    protected boolean autoAckDefault() {
        return autoAckDefault;
    }

    protected final UnhandledMessageEvent init(MessageBusBinding binding, MessageChannel channel, MessageMetadata messageMetadata, String messageKey, String smaTransportMessageId, Object unwrappedMessage, byte[] serializedMetadataBlob, byte[] serializedPayloadBlob, IEventAcknowledger acknowledger, Throwable reason) {
        super.init(binding);
        this.serializedPayloadBlob = serializedPayloadBlob;
        this.serializedMetadataBlob = serializedMetadataBlob;
        this.messageMetadata = messageMetadata;
        this.messageBus = binding;
        this.messageChannel = channel;
        this.messageKey = messageKey;
        this.messageSMATransportMessageId = smaTransportMessageId;
        this.unwrappedMessage = unwrappedMessage;
        this.reason = reason;
        this.autoAck = this.autoAckDefault();
        this.acked.set(false);
        super.setAcknowledger(acknowledger);
        return this;
    }

    @Override
    protected final void reset() {
        super.reset();
        if (this.serializedMetadataBlob != null) {
            this.serializedMetadataBlob = null;
        }
        if (this.serializedPayloadBlob != null) {
            this.serializedPayloadBlob = null;
        }
        this.autoAck = this.autoAckDefault();
        this.messageSMATransportMessageId = null;
        this.messageMetadata = null;
        this.messageKey = null;
        this.unwrappedMessage = null;
        this.messageBus = null;
        this.messageChannel = null;
        this.reason = null;
        this.acked.set(false);
    }

    protected final void preDispose() {
        if (this.getAutoAck()) {
            try {
                this.acknowledge();
            }
            catch (SmaException e) {
                tracer.log("auto ack failed for: " + this, Tracer.Level.WARNING);
            }
        }
    }

    protected final String toString(String eventType) {
        return "[event=" + eventType + ", " + super.toString() + ", metadata=" + (this.messageMetadata != null ? this.messageMetadata.toString() : "null") + ", key=" + this.messageKey + ", messageId='" + this.messageSMATransportMessageId + "', reason=" + this.reason + "]";
    }

    public final void acknowledge() throws SmaException {
        IEventAcknowledger acknowledger = this.getAcknowledger();
        if (acknowledger != null && this.acked.compareAndSet(false, true)) {
            this.setAutoAck(false);
            acknowledger.ack();
        }
    }

    public final void setAutoAck(boolean val) {
        this.autoAck = val;
    }

    public final boolean getAutoAck() {
        return this.autoAck;
    }

    public final MessageMetadata getMessageMetadata() {
        return this.messageMetadata;
    }

    public final String getMessageKey() {
        return this.messageKey;
    }

    public final String getMessageSMATransportMessageId() {
        return this.messageSMATransportMessageId;
    }

    public final byte[] getSerializedPayloadBlob() {
        return this.serializedPayloadBlob;
    }

    public final byte[] getSerializedMetadataBlob() {
        return this.serializedMetadataBlob;
    }

    public final Object getUnwrappedMessage() {
        return this.unwrappedMessage;
    }

    public final MessageBusBinding getMessageBusBinding() {
        return this.messageBus;
    }

    public final MessageChannel getMessageChannel() {
        return this.messageChannel;
    }

    public final Throwable getReason() {
        return this.reason;
    }

    @Override
    public String toString() {
        return this.toString("UNHANDLED_MESSAGE");
    }

    static {
        tracer.bind("nv.sma");
        tracer.log("SMA Unhandled message auto ack default is " + autoAckDefault, Tracer.Level.CONFIG);
    }
}

