/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import cern.colt.function.IntObjectProcedure;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.adm.runtime.AdmCompatibility;
import com.neeve.root.RootConfig;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryDescriptor;
import com.neeve.sma.SmaConfig;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaFactoryIdConflictException;
import com.neeve.sma.SmaObject;
import com.neeve.trace.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class MessageViewFactoryRegistry
extends SmaObject {
    public static final String ADM_COMPATIBILITY_LEVEL = "5.0.0";
    private static final MessageViewFactoryRegistry instance;
    private static final OpenIntObjectHashMap viewFactories;

    private MessageViewFactoryRegistry() {
        super(null);
    }

    public static final MessageViewFactoryRegistry getInstance() {
        return instance;
    }

    public static final MessageViewFactory loadViewFactory(String className) throws Exception {
        if (className != null) {
            Class<?> factoryClass = null;
            try {
                factoryClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new Exception("View factory class [" + className + "] could not be found");
            }
            catch (UnsupportedClassVersionError e) {
                throw new Exception("View factory class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
            }
            Method factoryCreateMethod = null;
            try {
                Class[] parameterTypes = new Class[]{Class.forName("java.util.Properties")};
                factoryCreateMethod = factoryClass.getMethod("create", parameterTypes);
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("Failed to load java.util.Properties during instantiation of SMA message view factory class [" + className + "]");
            }
            catch (SecurityException e) {
                throw new Exception("Access to instantiation method in view factory class [" + className + "] is denied");
            }
            catch (NoSuchMethodException e) {
                throw new Exception("Instantiation method in view factory class [" + className + "] could not be found");
            }
            MessageViewFactory factory = null;
            try {
                try {
                    Object[] parameters = new Object[]{new Properties()};
                    factory = (MessageViewFactory)factoryCreateMethod.invoke(null, parameters);
                    if (factory == null) {
                        throw new Exception("Instantiation method in view factory class [" + className + "] returned a null object");
                    }
                }
                catch (ClassCastException e) {
                    throw new Exception("Instantiation method in view factory class [" + className + "] returned object of incorrect type");
                }
            }
            catch (IllegalAccessException e) {
                throw new Exception("Access to instantiation method in view factory class [" + className + "] is denied");
            }
            catch (InvocationTargetException e) {
                throw new Exception(e.getCause());
            }
            return factory;
        }
        return null;
    }

    public final void registerMessageViewFactory(String factoryClassName) throws Exception {
        this.registerMessageViewFactory(MessageViewFactoryRegistry.loadViewFactory(factoryClassName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerMessageViewFactory(MessageViewFactory factory) {
        OpenIntObjectHashMap openIntObjectHashMap = viewFactories;
        synchronized (openIntObjectHashMap) {
            StringBuilder builder = new StringBuilder();
            AdmCompatibility.getAdmGenerationDetails(factory.getClass(), (StringBuilder)builder);
            this.tracer.log("Registering SMA message view factory (id=" + factory.getVfid() + ")..." + factory.getClass().getName() + " [" + builder.toString() + "]", Tracer.Level.VERBOSE);
            AdmCompatibility.assertRuntimeCompatibility((String)ADM_COMPATIBILITY_LEVEL, (Object)factory);
            viewFactories.put((int)factory.getVfid(), (Object)factory);
        }
    }

    public final boolean registerIfNoConflict(String factoryClassName) throws SmaFactoryIdConflictException, Exception {
        return this.registerIfNoConflict(MessageViewFactoryRegistry.loadViewFactory(factoryClassName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean registerIfNoConflict(MessageViewFactory factory) throws SmaFactoryIdConflictException {
        OpenIntObjectHashMap openIntObjectHashMap = viewFactories;
        synchronized (openIntObjectHashMap) {
            MessageViewFactory existing = (MessageViewFactory)viewFactories.get((int)factory.getVfid());
            if (existing != null) {
                if (existing.getClass() != factory.getClass()) {
                    throw new SmaFactoryIdConflictException("Factory conflicts with an already registered factory (" + existing.getClass().getName() + ").", existing, factory);
                }
                return false;
            }
            this.registerMessageViewFactory(factory);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageViewFactory getMessageViewFactory(short factoryId) {
        OpenIntObjectHashMap openIntObjectHashMap = viewFactories;
        synchronized (openIntObjectHashMap) {
            return (MessageViewFactory)viewFactories.get((int)factoryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> getMessageViewFactoryNames(final Set<String> factories) {
        if (factories == null) {
            throw new IllegalArgumentException("factories cannot be null");
        }
        OpenIntObjectHashMap openIntObjectHashMap = viewFactories;
        synchronized (openIntObjectHashMap) {
            viewFactories.forEachPair(new IntObjectProcedure(){

                public final boolean apply(int first, Object second) {
                    factories.add(((MessageViewFactory)second).getClass().getName());
                    return true;
                }
            });
        }
        return factories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dumpFactoryVersionInfo(final StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("appendable cannot be null");
        }
        OpenIntObjectHashMap openIntObjectHashMap = viewFactories;
        synchronized (openIntObjectHashMap) {
            viewFactories.forEachPair(new IntObjectProcedure(){

                public final boolean apply(int first, Object second) {
                    String className = second.getClass().getCanonicalName();
                    builder.append(className).append("(id=").append(((MessageViewFactory)second).getVfid()).append(")...");
                    AdmCompatibility.getAdmGenerationDetails(second.getClass(), (StringBuilder)builder);
                    builder.append("\n");
                    return true;
                }
            });
        }
    }

    static {
        block6: {
            instance = new MessageViewFactoryRegistry();
            Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)SmaConfig.getConfig());
            tracer.log("Loading SMA message view factories...", Tracer.Level.VERBOSE);
            viewFactories = new OpenIntObjectHashMap();
            try {
                Map<Short, MessageViewFactoryDescriptor> viewFactoryDescriptors = MessageViewFactoryDescriptor.loadAll();
                if (viewFactoryDescriptors.size() > 0) {
                    Set<Map.Entry<Short, MessageViewFactoryDescriptor>> viewFactoryEntries = viewFactoryDescriptors.entrySet();
                    for (Map.Entry<Short, MessageViewFactoryDescriptor> entry : viewFactoryEntries) {
                        MessageViewFactoryDescriptor descriptor = entry.getValue();
                        String s = "..." + descriptor.getName();
                        try {
                            instance.registerMessageViewFactory(MessageViewFactoryRegistry.loadViewFactory(descriptor.getClassName()));
                            s = s + " - success";
                        }
                        catch (Exception e) {
                            s = s + " - failed [" + e.toString() + "]";
                        }
                        tracer.log(s, Tracer.Level.VERBOSE);
                    }
                    break block6;
                }
                tracer.log("...<No configured message view factories>", Tracer.Level.VERBOSE);
            }
            catch (SmaException e) {
                tracer.log("Failure encountered while loading SMA message view factories [" + e.toString() + "]", Tracer.Level.SEVERE);
            }
        }
    }
}

