/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.eaio.uuid.UUID;
import com.neeve.util.UtlTime;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.WordUtils;

public class UtlTableFormatter {
    protected static final String newline = System.getProperty("line.separator");
    private final boolean isMultiLine;

    public UtlTableFormatter(boolean isMultiLine) {
        this.isMultiLine = isMultiLine;
    }

    public final Object formatColumn(String columnHeader, Class<?> columnType, Object result, Format format) {
        if (result == null) {
            return null;
        }
        Class<?> resultClass = result.getClass();
        if (resultClass.isArray()) {
            return this.formatColumn(columnHeader, String.class, resultClass.getComponentType().getSimpleName() + "[" + Array.getLength(result) + "]", format);
        }
        if (result instanceof Collection) {
            return this.formatColumn(columnHeader, String.class, resultClass.getSimpleName() + ((Collection)result).size(), format);
        }
        if (result instanceof Map) {
            return this.formatColumn(columnHeader, String.class, resultClass.getSimpleName() + ((Map)result).size(), format);
        }
        if (resultClass == Integer.TYPE || resultClass == Integer.class) {
            return result;
        }
        if (resultClass == Boolean.TYPE || resultClass == Boolean.class) {
            return result;
        }
        if (resultClass == Double.TYPE || resultClass == Double.class) {
            if (String.valueOf(result).length() > 20) {
                double value = (Double)result;
                return this.formatColumn(columnHeader, BigDecimal.class, BigDecimal.valueOf(value), format);
            }
            return result;
        }
        if (resultClass == Float.TYPE || resultClass == Float.class) {
            if (String.valueOf(result).length() > 20) {
                double value = ((Float)result).doubleValue();
                return this.formatColumn(columnHeader, BigDecimal.class, BigDecimal.valueOf(value), format);
            }
            return result;
        }
        if (resultClass == Long.TYPE || resultClass == Long.class) {
            if (this.isTimestampColumn(columnHeader, columnType)) {
                return this.formatColumn(columnHeader, columnType, new Date((Long)result), format);
            }
            return result;
        }
        if (resultClass == Byte.TYPE || resultClass == Byte.class) {
            return result;
        }
        if (resultClass == Short.TYPE || resultClass == Short.class) {
            return result;
        }
        if (resultClass == Currency.class) {
            return result;
        }
        if (resultClass == BigInteger.class) {
            return result;
        }
        if (resultClass == BigDecimal.class) {
            BigDecimal bigDec = (BigDecimal)result;
            if (bigDec.precision() > 12) {
                int digitsToRemove = bigDec.precision() - 12;
                bigDec = bigDec.setScale(bigDec.scale() - digitsToRemove, RoundingMode.HALF_UP);
            }
            return bigDec;
        }
        if (resultClass == Character.class || resultClass == Character.TYPE) {
            return result;
        }
        if (resultClass == Date.class) {
            Date date = (Date)result;
            if (date.getTime() == 0L || date.getTime() == -1L) {
                return "";
            }
            String dateString = UtlTime.format((Date)result);
            switch (format) {
                case CSV: {
                    return "\"" + dateString + "\"";
                }
                case HTML: {
                    return dateString;
                }
            }
            if (!this.isMultiLine) {
                return this.formatForSingleLineColumn(dateString, this.calculateFieldLength(columnHeader, columnType));
            }
            return dateString;
        }
        if (resultClass == UUID.class) {
            return result;
        }
        if (resultClass.isEnum()) {
            return result;
        }
        String str = result.toString();
        switch (format) {
            case CSV: {
                return "\"" + str + "\"";
            }
            case HTML: {
                return StringEscapeUtils.escapeHtml((String)str);
            }
        }
        if (!this.isMultiLine) {
            return this.formatForSingleLineColumn(str, this.calculateFieldLength(columnHeader, columnType));
        }
        return str;
    }

    public final Object formatColumn(String columnHeader, Class<?> columnType, Object result, int width, Format format) {
        if (result == null) {
            return null;
        }
        Class<?> resultClass = result.getClass();
        if (resultClass.isArray()) {
            return this.formatColumn(columnHeader, String.class, resultClass.getComponentType().getSimpleName() + "[" + Array.getLength(result) + "]", format);
        }
        if (result instanceof Collection) {
            return this.formatColumn(columnHeader, String.class, resultClass.getSimpleName() + ((Collection)result).size(), format);
        }
        if (result instanceof Map) {
            return this.formatColumn(columnHeader, String.class, resultClass.getSimpleName() + ((Map)result).size(), format);
        }
        if (resultClass == Integer.TYPE || resultClass == Integer.class) {
            return result;
        }
        if (resultClass == Boolean.TYPE || resultClass == Boolean.class) {
            return result;
        }
        if (resultClass == Double.TYPE || resultClass == Double.class) {
            if (String.valueOf(result).length() > width) {
                double value = (Double)result;
                return this.formatColumn(columnHeader, BigDecimal.class, BigDecimal.valueOf(value), format);
            }
            return result;
        }
        if (resultClass == Float.TYPE || resultClass == Float.class) {
            if (String.valueOf(result).length() > width) {
                double value = ((Float)result).doubleValue();
                return this.formatColumn(columnHeader, BigDecimal.class, BigDecimal.valueOf(value), format);
            }
            return result;
        }
        if (resultClass == Long.TYPE || resultClass == Long.class) {
            if (this.isTimestampColumn(columnHeader, columnType)) {
                return this.formatColumn(columnHeader, columnType, new Date((Long)result), format);
            }
            return result;
        }
        if (resultClass == Byte.TYPE || resultClass == Byte.class) {
            return result;
        }
        if (resultClass == Short.TYPE || resultClass == Short.class) {
            return result;
        }
        if (resultClass == Currency.class) {
            return result;
        }
        if (resultClass == BigInteger.class) {
            return result;
        }
        if (resultClass == BigDecimal.class) {
            BigDecimal bigDec = (BigDecimal)result;
            if (bigDec.precision() > 12) {
                int digitsToRemove = bigDec.precision() - 12;
                bigDec = bigDec.setScale(bigDec.scale() - digitsToRemove, RoundingMode.HALF_UP);
            }
            return bigDec;
        }
        if (resultClass == Character.class || resultClass == Character.TYPE) {
            return result;
        }
        if (resultClass == Date.class) {
            Date date = (Date)result;
            if (date.getTime() == 0L || date.getTime() == -1L) {
                return "";
            }
            String dateString = UtlTime.format((Date)result);
            switch (format) {
                case CSV: {
                    return "\"" + dateString + "\"";
                }
                case HTML: {
                    return dateString;
                }
            }
            if (!this.isMultiLine) {
                return this.formatForSingleLineColumn(dateString, width);
            }
            return dateString;
        }
        if (resultClass == UUID.class) {
            return result;
        }
        if (resultClass.isEnum()) {
            return result;
        }
        String str = result.toString();
        switch (format) {
            case CSV: {
                return "\"" + str + "\"";
            }
            case HTML: {
                return StringEscapeUtils.escapeHtml((String)str);
            }
        }
        if (!this.isMultiLine) {
            return this.formatForSingleLineColumn(str, width);
        }
        return str;
    }

    public final String getColumnFormat(String columnHeader, Class<?> columnType, int length) {
        if (columnType == Double.TYPE || columnType == Double.class) {
            return "%" + length + "s";
        }
        if (columnType == Float.TYPE || columnType == Float.class) {
            return "%" + length + "s";
        }
        if (columnType == Integer.TYPE || columnType == Integer.class) {
            return "%" + length + "d";
        }
        if (columnType == Long.TYPE || columnType == Long.class) {
            if (!this.isTimestampColumn(columnHeader, columnType)) {
                return "%" + length + "d";
            }
        } else {
            if (columnType == Byte.TYPE || columnType == Byte.class) {
                return "%" + length + "d";
            }
            if (columnType == Short.TYPE || columnType == Short.class) {
                return "%" + length + "d";
            }
            if (columnType == BigInteger.class) {
                return "%" + length + "d";
            }
            if (columnType == BigDecimal.class) {
                return "%" + length + "s";
            }
        }
        return "%-" + length + "s";
    }

    public int calculateFieldLength(String columnHeader, Class<?> columnType) {
        int typeLength = 20;
        if (columnType == String.class) {
            typeLength = 20;
        } else if (columnType == Integer.TYPE || columnType == Integer.class) {
            typeLength = 11;
        } else if (columnType == Boolean.TYPE || columnType == Boolean.class) {
            typeLength = 5;
        } else if (columnType == Double.TYPE || columnType == Double.class) {
            typeLength = 20;
        } else if (columnType == Float.TYPE || columnType == Float.class) {
            typeLength = 20;
        } else if (columnType == Long.TYPE || columnType == Long.class) {
            typeLength = this.isTimestampColumn(columnHeader, columnType) ? UtlTableFormatter.dateFormatLength() : 20;
        } else if (columnType == Byte.TYPE || columnType == Byte.class) {
            typeLength = 4;
        } else if (columnType == Short.TYPE || columnType == Short.class) {
            typeLength = 7;
        } else if (columnType == Currency.class) {
            typeLength = 3;
        } else if (columnType == BigInteger.class) {
            typeLength = 10;
        } else if (columnType == BigDecimal.class) {
            typeLength = 20;
        } else if (columnType == Character.class || columnType == Character.TYPE) {
            typeLength = 1;
        } else if (columnType == Date.class) {
            typeLength = UtlTableFormatter.dateFormatLength();
        } else if (columnType == UUID.class) {
            typeLength = 36;
        } else if (columnType.isEnum()) {
            try {
                Object[] values;
                for (Object value : values = (Object[])columnType.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                    typeLength = 0;
                    typeLength = Math.max(typeLength, value.toString().length());
                }
            }
            catch (Exception e) {
                typeLength = 10;
            }
        }
        return Math.max(typeLength, columnHeader.length());
    }

    public int calculateDesiredFieldLength(String columnHeader, Object value) {
        if (value == null) {
            return Math.max(4, columnHeader.length());
        }
        Class<?> columnType = value.getClass();
        int typeLength = 20;
        if (columnType == String.class) {
            return value.toString().length();
        }
        if (columnType == Integer.TYPE || columnType == Integer.class) {
            typeLength = 11;
        } else if (columnType == Boolean.TYPE || columnType == Boolean.class) {
            typeLength = 5;
        } else if (columnType == Double.TYPE || columnType == Double.class) {
            typeLength = 20;
        } else if (columnType == Float.TYPE || columnType == Float.class) {
            typeLength = 20;
        } else if (columnType == Long.TYPE || columnType == Long.class) {
            typeLength = this.isTimestampColumn(columnHeader, columnType) ? UtlTableFormatter.dateFormatLength() : 20;
        } else if (columnType == Byte.TYPE || columnType == Byte.class) {
            typeLength = 4;
        } else if (columnType == Short.TYPE || columnType == Short.class) {
            typeLength = 7;
        } else if (columnType == Currency.class) {
            typeLength = 3;
        } else if (columnType == BigInteger.class) {
            typeLength = 10;
        } else if (columnType == BigDecimal.class) {
            typeLength = 20;
        } else if (columnType == Character.class || columnType == Character.TYPE) {
            typeLength = 1;
        } else if (columnType == Date.class) {
            typeLength = UtlTableFormatter.dateFormatLength();
        } else if (columnType == UUID.class) {
            typeLength = 36;
        } else if (columnType.isEnum()) {
            try {
                Object[] values;
                for (Object enumValue : values = (Object[])columnType.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                    typeLength = 0;
                    typeLength = Math.max(typeLength, enumValue.toString().length());
                }
            }
            catch (Exception e) {
                typeLength = 10;
            }
        }
        return Math.max(typeLength, columnHeader.length());
    }

    public final boolean isTimestampColumn(String columnHeader, Class<?> columnType) {
        if (columnType == Date.class) {
            return true;
        }
        if (columnType == Long.class || columnType == Long.TYPE && columnHeader != null) {
            return columnHeader.endsWith("Ts") || columnHeader.endsWith("imestamp");
        }
        return false;
    }

    public final String formatForSingleLineColumn(String str, int columnWidth) {
        boolean newLinesHandled = false;
        if (str.length() <= columnWidth) {
            if ((str = str.replaceAll("(\\t|\\r?\\n)+", "\\\\n")).length() <= columnWidth) {
                return str;
            }
            newLinesHandled = true;
        }
        String h1 = null;
        String h2 = null;
        int h2Len = columnWidth / 2 - 3;
        int h1Len = columnWidth - h2Len - 3;
        h1 = str.substring(0, h1Len);
        h2 = str.substring(str.length() - h2Len);
        if (!newLinesHandled) {
            if ((h1 = h1.replaceAll("(\\t|\\r?\\n)+", "\\\\n")).length() > h1Len) {
                h1 = h1.substring(0, h1Len);
            }
            if ((h2 = h2.replaceAll("(\\t|\\r?\\n)+", "\\\\n")).length() > h2Len) {
                h2 = h2.substring(str.length() - h2Len);
            }
        }
        return h1.concat("...").concat(h2);
    }

    public static final Table createTable(String ... columnHeaders) {
        return new Table(columnHeaders);
    }

    private static int dateFormatLength() {
        return UtlTime.format(new Date()).length();
    }

    public static final class Table {
        final String[] columnHeaders;
        final Class<?>[] columnTypes;
        boolean autoSizeColumns = true;
        int[] columnWidths;
        static final UtlTableFormatter formatter = new UtlTableFormatter(true);
        LinkedList<Object[]> rows = new LinkedList();

        private Table(String ... columnHeaders) {
            this.columnHeaders = columnHeaders;
            this.columnTypes = new Class[columnHeaders.length];
            this.columnWidths = new int[columnHeaders.length];
        }

        public void setColumnWidths(int ... widths) {
            this.columnWidths = widths;
            this.autoSizeColumns = false;
        }

        public void addRow(Object ... values) {
            if (values == null || values.length > this.columnHeaders.length) {
                throw new IllegalArgumentException("Too many columns in row");
            }
            this.rows.add(values);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                if (this.columnTypes[i] == null) {
                    this.columnTypes[i] = values[i].getClass();
                    continue;
                }
                if (this.columnTypes[i] == values[i].getClass()) continue;
                this.columnTypes[i] = String.class;
            }
        }

        public void write(StringBuffer sb, Format format, boolean includeHeaders, int maxWidth) {
            if (this.autoSizeColumns && maxWidth > 0 && format == Format.TABULAR) {
                for (int i = 0; i < this.columnWidths.length; ++i) {
                    this.columnWidths[i] = !includeHeaders ? 0 : this.columnHeaders[i].length();
                }
                for (Object[] rowValues : this.rows) {
                    for (int i = 0; i < rowValues.length; ++i) {
                        this.columnWidths[i] = Math.max(this.columnWidths[i], formatter.calculateDesiredFieldLength(this.columnHeaders[i], rowValues[i]));
                    }
                }
                int uniformColumnSize = (maxWidth - (this.columnHeaders.length + 1)) / this.columnHeaders.length;
                int columnsUnderSize = 0;
                int columnsOver = 0;
                for (int columnWidth : this.columnWidths) {
                    if (columnWidth <= uniformColumnSize) {
                        columnsUnderSize += columnWidth + 1;
                        continue;
                    }
                    ++columnsOver;
                }
                if (columnsOver > 0) {
                    int spacePerColumnOver = (maxWidth - columnsUnderSize - columnsOver - 1) / columnsOver;
                    for (int i = 0; i < this.columnWidths.length; ++i) {
                        if (this.columnWidths[i] <= uniformColumnSize) continue;
                        this.columnWidths[i] = spacePerColumnOver;
                    }
                }
            }
            if (includeHeaders) {
                sb.append(this.getHeader(format));
            }
            String rowFormat = this.getRowFormatString(format);
            for (Object[] rowValues : this.rows) {
                if (format == Format.TABULAR) {
                    String[][] columnLines = new String[this.columnHeaders.length][];
                    int lines = 1;
                    for (int i = 0; i < this.columnHeaders.length; ++i) {
                        columnLines[i] = new String[]{String.format(formatter.getColumnFormat(this.columnHeaders[i], this.columnTypes[i], this.columnWidths[i]), rowValues[i])};
                        if (columnLines[i][0].length() <= this.columnWidths[i] && columnLines[i][0].indexOf(10) < 0) continue;
                        String[] lineBroken = columnLines[i][0].split("\\r?\\n");
                        String wrapped = "";
                        for (String line : lineBroken) {
                            wrapped = wrapped + WordUtils.wrap((String)line, (int)this.columnWidths[i], (String)"\n", (boolean)true);
                            wrapped = wrapped + '\n';
                        }
                        columnLines[i] = wrapped.split("\\r?\\n");
                        lines = columnLines[i].length;
                    }
                    for (int r = 0; r < lines; ++r) {
                        Object[] lineValues = new String[this.columnHeaders.length];
                        for (int c = 0; c < lineValues.length; ++c) {
                            lineValues[c] = columnLines[c].length > r ? columnLines[c][r] : "";
                        }
                        sb.append(String.format(rowFormat, lineValues));
                    }
                    continue;
                }
                sb.append(String.format(rowFormat, rowValues));
            }
            sb.append(this.getFooter(format));
        }

        private final String getRowFormatString(Format format) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (format == Format.HTML) {
                sb.append("     <tr>");
            }
            for (int i = 0; i < this.columnHeaders.length; ++i) {
                String name = this.columnHeaders[i];
                switch (format) {
                    case CSV: {
                        if (!first) {
                            sb.append(',');
                        }
                        sb.append("%s");
                        break;
                    }
                    case HTML: {
                        sb.append("<td>%s</td>");
                        break;
                    }
                    case TABULAR: {
                        sb.append('|');
                        sb.append(formatter.getColumnFormat(name, this.columnTypes[i], this.columnWidths[i]));
                    }
                }
                first = false;
            }
            switch (format) {
                case CSV: {
                    sb.append(newline);
                    break;
                }
                case HTML: {
                    sb.append("</tr>").append(newline);
                    break;
                }
                case TABULAR: {
                    sb.append("|").append(newline);
                }
            }
            return sb.toString();
        }

        private final String getHeader(Format format) {
            int i;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (format == Format.HTML) {
                sb.append("<table border=\"1\">").append(newline);
                sb.append("  <thead>\n").append(newline);
                sb.append("     <tr>").append(newline);
            }
            for (i = 0; i < this.columnHeaders.length; ++i) {
                String name = this.columnHeaders[i];
                switch (format) {
                    case CSV: {
                        if (!first) {
                            sb.append(',');
                        }
                        sb.append(name);
                        break;
                    }
                    case TABULAR: {
                        sb.append('|');
                        sb.append(String.format("%" + this.columnWidths[i] + "s", name));
                        break;
                    }
                    case HTML: {
                        sb.append("<th>").append(name).append("</th>");
                    }
                }
                first = false;
            }
            switch (format) {
                case CSV: {
                    sb.append(newline);
                    break;
                }
                case HTML: {
                    sb.append("     </tr>").append(newline);
                    sb.append("  </thead>").append(newline);
                    sb.append("  <tbody>").append(newline);
                    break;
                }
                case TABULAR: {
                    sb.append("|\n");
                    for (i = 0; i < this.columnHeaders.length; ++i) {
                        sb.append('+');
                        int length = this.columnWidths[i];
                        for (int c = 0; c < length; ++c) {
                            sb.append("-");
                        }
                    }
                    sb.append("+").append(newline);
                }
            }
            return sb.toString();
        }

        private final String getFooter(Format format) {
            StringBuilder sb = new StringBuilder();
            switch (format) {
                case CSV: {
                    break;
                }
                case HTML: {
                    sb.append("</table>").append(newline);
                    break;
                }
                case TABULAR: {
                    for (int i = 0; i < this.columnHeaders.length; ++i) {
                        sb.append('+');
                        int length = this.columnWidths[i];
                        for (int c = 0; c < length; ++c) {
                            sb.append("-");
                        }
                    }
                    sb.append("+").append(newline);
                }
            }
            return sb.toString();
        }
    }

    public static enum Format {
        TABULAR,
        CSV,
        HTML;

    }
}

