/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import sun.misc.Unsafe;

public final class UtlObject {
    private static final Unsafe UNSAFE;
    private static final int NR_BITS;
    private static final int BYTE = 8;
    private static final int WORD;
    private static final int MIN_SIZE = 16;

    private static final ObjectSizeInfo sizeof(Class<?> src, Set<Class<?>> processed) {
        if (processed.contains(src)) {
            return null;
        }
        processed.add(src);
        ObjectSizeInfo osi = new ObjectSizeInfo(src.getName());
        do {
            for (Field f : src.getDeclaredFields()) {
                if ((f.getModifiers() & 8) != 0) continue;
                Class<?> type = f.getType();
                osi.add(new FieldSizeInfo(f, UNSAFE.objectFieldOffset(f), type.isPrimitive() ? null : UtlObject.sizeof(type, processed)));
            }
        } while ((src = src.getSuperclass()) != null);
        osi.sort();
        return osi;
    }

    public static final ObjectSizeInfo sizeof(Class<?> src) {
        return UtlObject.sizeof(src, new HashSet());
    }

    public static final void main(String[] args) throws Exception {
        if (args.length == 1) {
            System.out.println(UtlObject.sizeof(Class.forName(args[0])).toString());
        } else {
            System.err.println("Usage: com.neeve.util.UtlObject <className>");
        }
    }

    static {
        NR_BITS = Integer.valueOf(System.getProperty("sun.arch.data.model"));
        WORD = NR_BITS / 8;
        Field theUnsafe = null;
        try {
            theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (Throwable thrown) {
            throw new RuntimeException(thrown);
        }
    }

    public static final class ObjectSizeInfo {
        private final String _name;
        private final List<FieldSizeInfo> _fields;

        ObjectSizeInfo(String name) {
            this._name = name;
            this._fields = new LinkedList<FieldSizeInfo>();
        }

        private final String toString(StringBuilder sb, FieldSizeInfo tfsi, String trailer) {
            sb.append(trailer);
            if (tfsi != null) {
                sb.append(tfsi._field.getName()).append(" (").append(this._name).append(")");
            } else {
                sb.append(this._name);
            }
            sb.append(" [").append(this.size()).append("] \n");
            for (FieldSizeInfo fsi : this._fields) {
                if (fsi._typeOsi == null) continue;
                fsi._typeOsi.toString(sb, fsi, trailer + "...");
            }
            return sb.toString();
        }

        final ObjectSizeInfo add(FieldSizeInfo fieldInfo) {
            this._fields.add(fieldInfo);
            return this;
        }

        final ObjectSizeInfo sort() {
            Collections.sort(this._fields);
            return this;
        }

        public final int size() {
            long maxOffset = 0L;
            for (FieldSizeInfo fsi : this._fields) {
                if (fsi._offset <= maxOffset) continue;
                maxOffset = fsi._offset;
            }
            return ((int)maxOffset / WORD + 1) * WORD;
        }

        public final String toString() {
            return this.toString(new StringBuilder(), null, "");
        }
    }

    public static final class FieldSizeInfo
    implements Comparable<FieldSizeInfo> {
        private final Field _field;
        private long _offset;
        private ObjectSizeInfo _typeOsi;

        FieldSizeInfo(Field field, long offset, ObjectSizeInfo typeOsi) {
            this._field = field;
            this._offset = offset;
            this._typeOsi = typeOsi;
        }

        @Override
        public final int compareTo(FieldSizeInfo fieldSizeInfo) {
            if (this._offset < fieldSizeInfo._offset) {
                return -1;
            }
            if (this._offset > fieldSizeInfo._offset) {
                return 1;
            }
            return 0;
        }
    }
}

