/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XShortCollection;
import com.neeve.lang.XShortCollectionBase;
import com.neeve.lang.XShortIterator;
import com.neeve.lang.XShortList;
import com.neeve.lang.XShortListIterator;
import java.util.NoSuchElementException;

public class XShortLinkedList
extends XShortCollectionBase
implements XShortList {
    private transient ShortNode _head = this.newNode();
    private transient ShortNode _tail = this.newNode();
    private transient int _size;

    public XShortLinkedList() {
        this(4);
    }

    public XShortLinkedList(int capacity) {
        this._head._next = this._tail;
        this._tail._previous = this._head;
        ShortNode previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            ShortNode newNode = this.newNode();
            newNode._previous = previous;
            previous._next = newNode;
            previous = newNode;
        }
    }

    public XShortLinkedList(XShortCollection values) {
        this(values.size());
        this.addAll(values);
    }

    public static XShortLinkedList newInstance() {
        return new XShortLinkedList();
    }

    @Override
    public final boolean add(short value) {
        this.addLast(value);
        return true;
    }

    @Override
    public final short get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return this.nodeAt(index)._value;
    }

    @Override
    public final short set(int index, short value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        ShortNode node = this.nodeAt(index);
        short previousValue = node._value;
        node._value = value;
        return previousValue;
    }

    @Override
    public final void add(int index, short value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.addBefore(this.nodeAt(index), value);
    }

    @Override
    public final boolean addAll(int index, XShortCollection values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        ShortNode indexNode = this.nodeAt(index);
        XShortIterator i = values.iterator();
        while (i.hasNext()) {
            this.addBefore(indexNode, i.next());
        }
        return values.size() != 0;
    }

    @Override
    public final short remove(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        ShortNode node = this.nodeAt(index);
        short previousValue = node._value;
        this.delete(node);
        return previousValue;
    }

    @Override
    public final int indexOf(short value) {
        int index = 0;
        ShortNode n = this._head;
        ShortNode end = this._tail;
        while ((n = n._next) != end) {
            if (value == n._value) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(short value) {
        int index = this.size() - 1;
        ShortNode n = this._tail;
        ShortNode end = this._head;
        while ((n = n._previous) != end) {
            if (value == n._value) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public XShortIterator iterator() {
        return this.listIterator();
    }

    @Override
    public XShortListIterator listIterator() {
        return XShortLinkedListIterator.valueOf(this, this._head._next, 0, this._size);
    }

    @Override
    public XShortListIterator listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return XShortLinkedListIterator.valueOf(this, this.nodeAt(index), index, this._size);
    }

    @Override
    public final XShortList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubList.valueOf(this, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
    }

    public final short getFirst() {
        ShortNode node = this._head._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final short getLast() {
        ShortNode node = this._tail._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final void addFirst(short value) {
        this.addBefore(this._head._next, value);
    }

    public void addLast(short value) {
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        this._tail._value = value;
        this._tail = this._tail._next;
        ++this._size;
    }

    public final short removeFirst() {
        ShortNode first = this._head._next;
        if (first == this._tail) {
            throw new NoSuchElementException();
        }
        short previousValue = first._value;
        this.delete(first);
        return previousValue;
    }

    public final short removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        ShortNode last = this._tail._previous;
        short previousValue = last._value;
        this._tail = last;
        last._value = (short)-1;
        return previousValue;
    }

    public final void addBefore(ShortNode next, short value) {
        ShortNode newNode;
        ShortNode tailNext;
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        if ((tailNext = (this._tail._next = (newNode = this._tail._next)._next)) != null) {
            tailNext._previous = this._tail;
        }
        ShortNode previous = next._previous;
        previous._next = newNode;
        next._previous = newNode;
        newNode._next = next;
        newNode._previous = previous;
        newNode._value = value;
        ++this._size;
    }

    private final ShortNode nodeAt(int index) {
        ShortNode node = this._head;
        int i = index;
        while (i-- >= 0) {
            node = node._next;
        }
        return node;
    }

    @Override
    public final ShortNode head() {
        return this._head;
    }

    @Override
    public final ShortNode tail() {
        return this._tail;
    }

    @Override
    public final short valueOf(XCollection.Record record) {
        return ((ShortNode)record)._value;
    }

    @Override
    public final void delete(XCollection.Record record) {
        ShortNode node = (ShortNode)record;
        --this._size;
        node._value = (short)-1;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        ShortNode next = this._tail._next;
        node._previous = this._tail;
        node._next = next;
        this._tail._next = node;
        if (next != null) {
            next._previous = node;
        }
    }

    @Override
    public final boolean contains(short value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        this._size = 0;
        this._tail = this._head._next;
    }

    @Override
    public XShortList unmodifiable() {
        return (XShortList)super.unmodifiable();
    }

    protected ShortNode newNode() {
        return new ShortNode();
    }

    private void increaseCapacity() {
        ShortNode newNode0 = this.newNode();
        this._tail._next = newNode0;
        newNode0._previous = this._tail;
        ShortNode newNode1 = this.newNode();
        newNode0._next = newNode1;
        newNode1._previous = newNode0;
        ShortNode newNode2 = this.newNode();
        newNode1._next = newNode2;
        newNode2._previous = newNode1;
        ShortNode newNode3 = this.newNode();
        newNode2._next = newNode3;
        newNode3._previous = newNode2;
    }

    public void reset() {
        this.clear();
    }

    private static final class XShortLinkedListIterator
    implements XShortListIterator {
        private XShortLinkedList _list;
        private ShortNode _nextNode;
        private ShortNode _currentNode;
        private int _length;
        private int _nextIndex;

        private XShortLinkedListIterator() {
        }

        public static XShortLinkedListIterator valueOf(XShortLinkedList list, ShortNode nextNode, int nextIndex, int size) {
            XShortLinkedListIterator itr = new XShortLinkedListIterator();
            itr._list = list;
            itr._nextNode = nextNode;
            itr._nextIndex = nextIndex;
            itr._length = size;
            return itr;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public short next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public short previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(short o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            this._list.addBefore(this._nextNode, o);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        @Override
        public void set(short o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._value = o;
        }

        @Override
        public void remove() {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            if (this._nextNode == this._currentNode) {
                this._nextNode = this._nextNode._next;
            } else {
                --this._nextIndex;
            }
            this._list.delete(this._currentNode);
            this._currentNode = null;
            --this._length;
        }

        @Override
        public final XShortLinkedListIterator toFirst() {
            this._nextNode = this._list._head._next;
            this._nextIndex = 0;
            this._length = this._list._size;
            return this;
        }
    }

    private static final class SubList
    extends XShortCollectionBase
    implements XShortList {
        private XShortLinkedList _list;
        private ShortNode _head;
        private ShortNode _tail;
        private int _size;

        private SubList() {
        }

        public static SubList valueOf(XShortLinkedList list, ShortNode head, ShortNode tail, int size) {
            SubList subList = new SubList();
            subList._list = list;
            subList._head = head;
            subList._tail = tail;
            subList._size = size;
            return subList;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public XCollection.Record head() {
            return this._head;
        }

        @Override
        public XCollection.Record tail() {
            return this._tail;
        }

        @Override
        public short valueOf(XCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(XCollection.Record record) {
            this._list.delete(record);
            if (record == this._head) {
                this._head = this._head.getNext();
            } else if (record == this._tail) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
        }

        @Override
        public boolean addAll(XShortCollection values) {
            return this.addAll(this._size, values);
        }

        @Override
        public boolean addAll(int index, XShortCollection values) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            ShortNode indexNode = this.nodeAt(index);
            XShortIterator i = values.iterator();
            while (i.hasNext()) {
                this._list.addBefore(indexNode, i.next());
            }
            if (values.size() > 0) {
                if (index == 0) {
                    this._head = this._head.getPrevious();
                } else if (index == this._size) {
                    this._tail = indexNode.getPrevious();
                }
            }
            this._size += values.size();
            return values.size() != 0;
        }

        @Override
        public short get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.nodeAt(index)._value;
        }

        @Override
        public short set(int index, short value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            ShortNode node = this.nodeAt(index);
            short previousValue = node._value;
            node._value = value;
            return previousValue;
        }

        @Override
        public boolean add(short element) {
            this.add(this._size, element);
            return true;
        }

        @Override
        public void add(int index, short element) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            this._list.addBefore(this.nodeAt(index), element);
            if (index == 0) {
                this._head = this._head.getPrevious();
            } else if (index == this._size) {
                this._tail = this._tail.getNext();
            }
            ++this._size;
        }

        @Override
        public short remove(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            ShortNode node = this.nodeAt(index);
            short previousValue = node._value;
            this._list.delete(node);
            if (index == 0) {
                this._head = this._head.getNext();
            } else if (index == this._size) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
            return previousValue;
        }

        @Override
        public int indexOf(short value) {
            int index = 0;
            ShortNode n = this._head;
            ShortNode end = this._tail;
            while ((n = n._next) != end) {
                if (value == n._value) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(short value) {
            int index = this.size() - 1;
            ShortNode n = this._tail;
            ShortNode end = this._head;
            while ((n = n._previous) != end) {
                if (value == n._value) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        @Override
        public XShortListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public XShortListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return XShortLinkedListIterator.valueOf(this._list, this.nodeAt(index), index, this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        @Override
        public XShortList subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubList subList = SubList.valueOf(this._list, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
            return subList;
        }

        private final ShortNode nodeAt(int index) {
            if (index <= this._size >> 1) {
                ShortNode node = this._head;
                int i = index;
                while (i-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            ShortNode node = this._tail;
            int i = this._size - index;
            while (i-- > 0) {
                node = node._previous;
            }
            return node;
        }

        @Override
        public void clear() {
            while (this._size > 0) {
                this.remove(0);
            }
        }
    }

    public static class ShortNode
    implements XCollection.Record {
        private ShortNode _next;
        private ShortNode _previous;
        private short _value;

        protected ShortNode() {
        }

        public final short getValue() {
            return this._value;
        }

        @Override
        public final ShortNode getNext() {
            return this._next;
        }

        @Override
        public final ShortNode getPrevious() {
            return this._previous;
        }
    }
}

