/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.build.codegen;

import com.neeve.build.codegen.CgMappable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.NullArgumentException;

public final class CgCodeSource
implements CgMappable {
    public static final int NOT_SET = -1;
    private final URL url;
    private int line = -1;
    private int columnStart = -1;
    private int columnEnd = -1;

    public CgCodeSource(int line, int columnStart) {
        this.url = null;
    }

    public CgCodeSource(URL url, int line, int columnStart) {
        if (url == null) {
            throw new NullArgumentException("'url' is required.");
        }
        this.url = url;
        this.line = line;
        this.columnStart = columnStart;
    }

    public URL getUrl() {
        return this.url;
    }

    public final File getFile() throws URISyntaxException, IOException {
        if (this.url == null) {
            throw new IllegalStateException("Cannot obtain file for src info that wasn't constructed with URL");
        }
        URI uri = this.url.toURI();
        File retVal = new File(uri);
        if (!retVal.exists()) {
            throw new IOException("File cannot be retrieved by URL " + this.url);
        }
        return retVal;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumnStart() {
        return this.columnStart;
    }

    public int getColumnEnd() {
        return this.columnEnd;
    }

    public String toString() {
        String retVal = "unknown path";
        if (this.url != null) {
            retVal = this.url.toString();
        }
        if (this.line > -1) {
            retVal = String.format("%s [%d:%d]", this.url, this.line, this.columnStart);
        }
        return retVal;
    }

    public boolean equals(Object obj) {
        boolean retVal = false;
        if (obj != null && obj instanceof CgCodeSource) {
            CgCodeSource other = (CgCodeSource)obj;
            retVal = (this.url == other.url || this.url != null && other.url != null && this.url.equals(other.url)) && this.line == other.line && this.columnStart == other.columnStart && this.columnEnd == other.columnEnd;
        }
        return retVal;
    }

    @Override
    public Map<String, Object> toMap() {
        TreeMap<String, Object> retVal = new TreeMap<String, Object>();
        retVal.put("url", this.url);
        retVal.put("line", this.line);
        retVal.put("columnStart", this.columnStart);
        retVal.put("columnEnd", this.columnEnd);
        return retVal;
    }
}

