/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.time;

import com.neeve.util.UtlTime;
import jargs.gnu.CmdLineParser;
import java.util.concurrent.CountDownLatch;

public class Benchmark
implements Runnable {
    private static final String MODE_NATIVE = "native";
    private static final String MODE_EPOCH = "epoch";
    private static final String MODE_NANO = "nano";
    private static final int WARMUPCOUNT = 10000;
    private static final int COUNT = 100000000;
    private final boolean useNanoTime;
    private final CountDownLatch startLatch;
    private final CountDownLatch joinLatch;

    Benchmark(String mode, CountDownLatch startLatch, CountDownLatch joinLatch) {
        this.startLatch = startLatch;
        this.joinLatch = joinLatch;
        if (mode.equalsIgnoreCase(MODE_NATIVE)) {
            System.setProperty("nv.time.usenative", "true");
            this.useNanoTime = false;
        } else if (mode.equalsIgnoreCase(MODE_EPOCH)) {
            System.setProperty("nv.time.usenative", "false");
            this.useNanoTime = false;
        } else if (mode.equalsIgnoreCase(MODE_NANO)) {
            this.useNanoTime = true;
        } else {
            throw new IllegalArgumentException("invalid mode '" + mode + "'");
        }
    }

    private final long runUsingNanoTime() {
        System.out.println("USING System.nanoTime()");
        for (int i = 0; i < 10000; ++i) {
            System.nanoTime();
        }
        long start = System.nanoTime();
        for (int i = 0; i < 100000000; ++i) {
            System.nanoTime();
        }
        return (System.nanoTime() - start) / 100000000L;
    }

    private final long runUsingNow() {
        System.out.println("USING UtlTime.now() [NATIVE TIME IS " + (UtlTime.isNativeTimeEnabled() ? "ENABLED" : "DISABLED") + "]");
        for (int i = 0; i < 10000; ++i) {
            UtlTime.now();
        }
        long start = UtlTime.now();
        for (int i = 0; i < 100000000; ++i) {
            UtlTime.now();
        }
        return (UtlTime.now() - start) / 100000000L;
    }

    @Override
    public final void run() {
        try {
            this.startLatch.await();
            long val = 0L;
            val = this.useNanoTime ? this.runUsingNanoTime() : this.runUsingNow();
            System.out.println("[tid " + Thread.currentThread().getId() + "] Time overhead is " + val + " nanos");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.joinLatch.countDown();
        }
    }

    private static final void printUsage() {
        System.err.println("Usage Benchmark");
        System.err.println("  [{-m, --mode} mode to use to fetch time]");
        System.err.println("    Specifies the mode used to fetch time for the benchmark. Valid options are 'native', 'epoch' and 'nano' (default='native')");
        System.err.println("  [{-t, --threads} number of concurrent threads to run]");
        System.err.println("    Specifies the number of concurrent threads to run (default=1)");
        System.err.println("  [{-h, --help} print this help string]");
    }

    public static final void main(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option modeOption = parser.addStringOption('m', "mode");
        CmdLineParser.Option numThreadsOption = parser.addIntegerOption('t', "threads");
        CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
        try {
            parser.parse(args);
            if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                String mode = (String)parser.getOptionValue(modeOption, (Object)MODE_NATIVE);
                int numThreads = (Integer)parser.getOptionValue(numThreadsOption, (Object)1);
                CountDownLatch startLatch = new CountDownLatch(1);
                CountDownLatch joinLatch = new CountDownLatch(numThreads);
                for (int i = 0; i < numThreads; ++i) {
                    Thread thread = new Thread(new Benchmark(mode, startLatch, joinLatch));
                    thread.setDaemon(true);
                    thread.start();
                }
                startLatch.countDown();
                joinLatch.await();
            } else {
                Benchmark.printUsage();
            }
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            Benchmark.printUsage();
        }
    }
}

