/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.IStoreWriter;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.log.EPktLogInvalidPositionException;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxFieldResolver;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogNode;
import com.neeve.rog.RogConfig;
import com.neeve.rog.impl.RogDirectMetadata;
import com.neeve.rog.impl.RogPacketMessageFactory;
import com.neeve.rog.impl.RogUtil;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.root.RootConfig;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class RogLogReader {
    private final RogLog log;
    private final PktRecoveryLog.MemoryMappedReader reader;
    private final PacketReceiver receiver;
    private final Stats stats;
    private final Tracer tracer;
    private final String tracePrefix;
    private boolean lazyDeserialization = false;
    private Transaction currentTransaction;

    RogLogReader(RogLog log, Tracer tracer, String tracePrefix) throws IOException {
        this.log = log;
        this.receiver = new PacketReceiver();
        this.reader = log.getPacketLog().createMemoryMappedReader((PktRecoveryLog.IPacketBufferReceiver)this.receiver);
        this.reader.reset();
        this.stats = new Stats();
        this.currentTransaction = null;
        this.tracer = tracer;
        this.tracePrefix = tracePrefix;
    }

    RogLogReader(RogLog log, int logNumber, Tracer tracer, String tracePrefix) throws IOException {
        this.log = log;
        this.receiver = new PacketReceiver();
        this.reader = log.createMemoryMappedPacketReader(logNumber, this.receiver, 256);
        this.reader.reset();
        this.stats = new Stats();
        this.currentTransaction = null;
        this.tracer = tracer;
        this.tracePrefix = tracePrefix;
    }

    private final Transaction getCurrentIfComplete() {
        Transaction transaction = null;
        if (this.currentTransaction != null && (this.currentTransaction.getId() == 0L || this.currentTransaction.isComplete())) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...transaction " + this.currentTransaction.getId() + " is complete.", Tracer.Level.DEBUG);
            }
            transaction = this.currentTransaction;
            this.currentTransaction = null;
        }
        return transaction;
    }

    private final Entry nextEntry() {
        Entry entry = null;
        if (this.reader.readOne() == null) {
            entry = this.receiver.getEntry();
        }
        return entry;
    }

    public static final void registerFactory(Object factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (factory instanceof MessageViewFactory) {
            MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)factory);
        }
        if (factory instanceof IStoreObjectFactory) {
            StoreObjectFactoryRegistry.getInstance().registerObjectFactory((IStoreObjectFactory)factory);
        }
    }

    public void setLazyDeserialization(boolean lazyDeserialization) {
        this.lazyDeserialization = lazyDeserialization;
    }

    public final RogLog log() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RogLogReader read(int count, ReadCallback cb) {
        this.receiver.setReadCallback(cb);
        try {
            this.receiver.setMaxCount(count);
            try {
                this.reader.read();
            }
            finally {
                this.receiver.clearMaxCount();
            }
        }
        finally {
            this.receiver.setReadCallback(null);
        }
        return this;
    }

    public final Entry next() throws Exception {
        Entry entry = this.nextEntry();
        if (entry != null) {
            if (!this.lazyDeserialization) {
                entry.getObject();
            }
            this.stats.update(entry);
        }
        return entry;
    }

    public final Transaction nextTransaction() throws Exception {
        Transaction transaction;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Getting next transaction...", Tracer.Level.DEBUG);
        }
        if ((transaction = this.getCurrentIfComplete()) == null) {
            Entry entry = this.next();
            while (entry != null) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "...got an entry (" + entry + ").", Tracer.Level.DEBUG);
                }
                long txnId = entry.getTransactionId();
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "...transaction id = " + txnId + ".", Tracer.Level.DEBUG);
                }
                if (txnId >= 0L) {
                    if (this.currentTransaction != null && this.currentTransaction.getId() != txnId) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "...transaction is incomplete. resetting current transaction.", Tracer.Level.DEBUG);
                        }
                        this.currentTransaction = null;
                    }
                    if ((transaction = this.currentTransaction) == null) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "...first entry of transaction. set as current transaction.", Tracer.Level.DEBUG);
                        }
                        transaction = this.currentTransaction = new Transaction(txnId, this.tracer, this.tracePrefix);
                    } else if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...current transaction already in progress.", Tracer.Level.DEBUG);
                    }
                    transaction.onNext(entry);
                    transaction = this.getCurrentIfComplete();
                    if (transaction != null) {
                        break;
                    }
                } else {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...orphaned entry.", Tracer.Level.DEBUG);
                    }
                    transaction = new Transaction(txnId, this.tracer, this.tracePrefix);
                    transaction.entries.add(entry);
                    break;
                }
                entry = this.next();
            }
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...got from working list.", Tracer.Level.DEBUG);
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RogLogReader skip(int count, SkipCallback cb) throws IOException {
        this.stats.setSkipCallback(cb);
        try {
            ReceiverAction action = this.receiver.getAction();
            this.receiver.setAction(ReceiverAction.UpdateStats);
            try {
                this.receiver.setMaxCount(count);
                try {
                    this.reader.read();
                }
                finally {
                    this.receiver.clearMaxCount();
                }
            }
            finally {
                this.receiver.setAction(action);
            }
        }
        finally {
            this.stats.setSkipCallback(null);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RogLogReader skipTransaction(int count, TransactionSkipCallback cb) throws Exception {
        for (int i = 0; i < count; ++i) {
            boolean lazy = this.lazyDeserialization;
            try {
                this.lazyDeserialization = true;
                Transaction transaction = this.nextTransaction();
                if (transaction == null) break;
                if (cb == null) continue;
                cb.onTransactionSkip(transaction);
                continue;
            }
            finally {
                this.lazyDeserialization = lazy;
            }
        }
        return this;
    }

    public final void seek(long pos) throws IOException {
        this.reader.seek(pos);
        this.currentTransaction = null;
        this.stats.reset();
    }

    public final RogLogReader rewind() throws IOException {
        this.reader.reset();
        this.currentTransaction = null;
        this.stats.reset();
        return this;
    }

    public final long getFilePosition() {
        return this.reader.filePointer();
    }

    public Stats getStats() {
        return this.stats;
    }

    public Stats computeStats() throws Exception {
        this.rewind();
        ReceiverAction action = this.receiver.getAction();
        this.receiver.setAction(ReceiverAction.UpdateStats);
        try {
            this.reader.read();
        }
        finally {
            this.receiver.setAction(action);
        }
        return this.stats;
    }

    public Entry getEntryAt(long filePosition) throws Exception {
        long currentFilePosition = this.reader.filePointer();
        try {
            if (this.reader.isValidAt(filePosition)) {
                Entry entry = this.next();
                return entry;
            }
            throw new EPktLogInvalidPositionException("invalid position '" + filePosition + "'");
        }
        finally {
            this.reader.seek(currentFilePosition);
        }
    }

    public final void close() throws Exception {
        this.reader.close();
        this.currentTransaction = null;
    }

    public static interface TransactionSkipCallback {
        public void onTransactionSkip(Transaction var1);
    }

    public static interface SkipCallback {
        public void onSkip(Entry.Type var1);
    }

    public static interface ReadCallback {
        public void onRead(Entry var1);
    }

    public static final class Transaction {
        private final long id;
        private final List<Entry> entries;
        private final Tracer tracer;
        private final String tracePrefix;
        private boolean complete;

        Transaction(long id, Tracer tracer, String tracePrefix) {
            this.id = id;
            this.entries = new ArrayList<Entry>();
            this.tracer = tracer;
            this.tracePrefix = tracePrefix;
        }

        final void onNext(Entry entry) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...(txn " + this.id + ") processing next entry (complete=" + this.complete + ", entryType=" + (Object)((Object)entry.getEntryType()) + ")...", Tracer.Level.DEBUG);
            }
            try {
                this.entries.add(entry);
                if (this.complete) {
                    throw new InternalError("Received state update when in done state");
                }
                if (entry.isCommitEnd()) {
                    this.complete = true;
                }
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "...(txn " + this.id + ") processing complete (complete=" + this.complete + ")...", Tracer.Level.DEBUG);
                }
            }
        }

        public final long getId() {
            return this.id;
        }

        public final boolean isComplete() {
            return this.complete;
        }

        @Deprecated
        public final List<Entry> getEntries(boolean sorted) {
            return this.getEntries();
        }

        public final List<Entry> getEntries() {
            return this.entries;
        }
    }

    @JsonPropertyOrder(value={"entryType", "checkpointVersion", "className", "commitStart", "commitEnd", "contentEncodingType", "entrySize", "filePosition", "id", "logName", "payloadSize", "simpleClassName", "stableTransactionId", "timestamp", "transactionId", "ofid", "otype", "metadata", "object"})
    public static final class Entry
    implements UtlPool.Item<Entry> {
        private static final IdxField<Entry, Class<?>> PAYLOAD_TYPE;
        private static final UtlPool<Entry> FACTORY;
        private static final Tracer TRACER;
        private RogLog log;
        private PktPacket packet;
        private long filePosition;
        private int sizeInFile;
        private IStoreObject object;
        private IRogMetadata metadata;
        private UtlPool<Entry> pool;
        private static final String headerRow;
        private static final String headerRowCsv = "Type,Class,ObjectId,ParentId,TxnId,StblTxId,InSeq#,OutSeq#,MsgSeq#,ChkPnt#,HasInMsg?,HasOutMsg?,PossibleDup,CommitStart,CommitEnd";

        Entry() {
        }

        private static final String prepareAbsentSubheaderTrace(PktPacket packet) {
            StringBuilder sb = new StringBuilder();
            sb.append("Detected log packet without an ODS header:!\n  ");
            IOElasticBuffer headerBuffer = packet.getHeader().getBuffer();
            IOElasticBuffer bodyBuffer = packet.getBody().getBuffer();
            sb.append(headerBuffer != null ? headerBuffer.dump("Header Buffer: ", 0, headerBuffer.getLength()) : " no header buffer!").append("\n  ");
            sb.append(bodyBuffer != null ? bodyBuffer.dump("Body Buffer: ", 0, bodyBuffer.getLength()) : " no body buffer!");
            sb.append("[ body type: ").append(packet.getBody().getClass().getSimpleName()).append("]\n  ");
            sb.append("Packet: " + packet.toString());
            return sb.toString();
        }

        public static final Entry create(RogLog log, PktPacket packet, long filePosition, int sizeInFile) throws OdsException {
            if (packet.getHeader().getODSSubheader() == null) {
                TRACER.log(Entry.prepareAbsentSubheaderTrace(packet), Tracer.Level.SEVERE);
                throw new NullPointerException();
            }
            return ((Entry)FACTORY.get(null)).init(log, packet, filePosition, sizeInFile);
        }

        private final Entry init(RogLog log, PktPacket packet, long filePosition, int sizeInFile) {
            this.log = log;
            this.packet = packet;
            this.filePosition = filePosition;
            this.sizeInFile = sizeInFile;
            return this;
        }

        private final String toCsv() {
            StringBuilder sb = new StringBuilder();
            IRogNode node = (IRogNode)this.getObject();
            sb.append(String.format("%s,%s,%s,%s,%d,%d,%d,%d,%d,%d,%s,%s,%s,%s,%s", this.getEntryType().toString(), node == null ? "" : node.getClass().getSimpleName(), this.getId() != null ? this.getId().toString() : "null", this.getMetadata().getParentId(), this.getTransactionId(), this.getStableTransactionId(), this.getMetadata().getTransactionInSequenceNumber(), this.getMetadata().getTransactionOutSequenceNumber(), this.getMetadata().getMessageSequenceNumber(), this.getCheckpointVersion(), this.getMetadata().getInMsgsInTransaction() ? "true" : "false", this.getMetadata().getOutMsgsInTransaction() ? "true" : "false", this.getMetadata().isPossibleDuplicate() ? "true" : "false", this.isCommitStart() ? "true" : "false", this.isCommitEnd() ? "true" : "false"));
            return sb.toString();
        }

        private final String toTabular() {
            StringBuilder sb = new StringBuilder();
            char type = '?';
            switch (this.getEntryType()) {
                case Put: {
                    type = 'P';
                    break;
                }
                case Remove: {
                    type = 'R';
                    break;
                }
                case Send: {
                    type = 'S';
                    break;
                }
                case Update: {
                    type = 'U';
                    break;
                }
                case Message: {
                    type = 'M';
                }
            }
            IRogNode node = (IRogNode)this.getObject();
            sb.append(String.format("%4s | %30s | %36s | %36s | %07d | %07d | %07d | %07d | %07d | %07d | %s | %s | %s | %s | %s", Character.valueOf(type), node == null ? "" : node.getClass().getSimpleName(), this.getId() != null ? this.getId().toString() : "null", this.getMetadata().getParentId(), this.getTransactionId(), this.getStableTransactionId(), this.getMetadata().getTransactionInSequenceNumber(), this.getMetadata().getTransactionOutSequenceNumber(), this.getMetadata().getMessageSequenceNumber(), this.getCheckpointVersion(), this.getMetadata().getInMsgsInTransaction() ? "T" : "F", this.getMetadata().getOutMsgsInTransaction() ? "T" : "F", this.getMetadata().isPossibleDuplicate() ? "T" : "F", this.isCommitStart() ? "T" : "F", this.isCommitEnd() ? "T" : "F"));
            return sb.toString();
        }

        static final Type toEntryType(short commitEntryType) {
            switch (commitEntryType) {
                case 1: {
                    return Type.Put;
                }
                case 2: {
                    return Type.Update;
                }
                case 3: {
                    return Type.Remove;
                }
                case 4: {
                    return Type.Send;
                }
                case 5: {
                    return Type.Message;
                }
            }
            throw new InternalError("invalid  commit entry type '" + commitEntryType + "'");
        }

        @JsonIgnore
        public final RogLog getLog() {
            return this.log;
        }

        @JsonProperty
        public final String getLogName() {
            return this.log == null ? null : this.log.getName();
        }

        @JsonIgnore
        public final PktPacket getPacket() {
            return this.packet;
        }

        @JsonProperty
        public final long getFilePosition() {
            return this.filePosition;
        }

        @JsonProperty
        public final int getEntrySize() {
            return this.sizeInFile;
        }

        @JsonProperty
        public final Type getEntryType() {
            return Entry.toEntryType(this.packet.getHeader().getODSSubheader().getCommitEntryType());
        }

        @JsonProperty
        public final String getClassName() {
            Class type = (Class)PAYLOAD_TYPE.apply(this);
            return type == null ? null : type.getCanonicalName();
        }

        @JsonProperty
        public final String getSimpleClassName() {
            Class type = (Class)PAYLOAD_TYPE.apply(this);
            return type == null ? null : type.getSimpleName();
        }

        @JsonProperty
        public final int getPayloadSize() {
            return this.getEntryType() == Type.Remove ? 0 : this.packet.getBody().getSerializedLength();
        }

        @JsonIgnore
        public final boolean isPayloadDeserialized() {
            return this.object != null;
        }

        @JsonProperty
        public final IStoreObject getObject() {
            if (this.getEntryType() == Type.Remove && this.getOtype() == 0 && this.getOfid() == 0) {
                return null;
            }
            if (this.object == null) {
                try {
                    int payloadSize = this.packet.getBody().getSerializedLength();
                    IStoreObjectFactory factory = StoreObjectFactoryRegistry.getInstance().getObjectFactory(this.getOfid());
                    this.object = factory == null ? RogPacketMessageFactory.createPacketMessage().deserializeFromPacket(this.packet.acquire()) : factory.create(this.getOtype(), this.getId(), this.getContentEncodingType(), this.packet.acquire());
                    if (this.object instanceof IRogNode) {
                        PktSubheaderODS subheaderODS = this.packet.getHeader().getODSSubheader();
                        ((IRogNode)this.object).deserializeMetadata(subheaderODS.getBuffer(), subheaderODS.getObjectMetadataOffset());
                        this.object.setCheckpointVersion(this.getCheckpointVersion());
                        this.object.setStableTransactionId(this.getStableTransactionId());
                        this.object.setTransactionId(this.getTransactionId());
                        this.metadata = null;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error deserializing transaction log entry", e);
                }
            }
            if (this.object == null && this.getEntryType() != Type.Remove) {
                throw new RuntimeException("Missing object on deserialization of packet for id=" + this.getId());
            }
            return this.object;
        }

        @JsonProperty
        @JsonSerialize(converter=RogUtil.UUIDToStringConverter.class)
        public final UUID getId() {
            return this.packet.getHeader().getODSSubheader().getObjectId();
        }

        @JsonProperty
        public short getOfid() {
            return this.packet.getHeader().getODSSubheader().getObjectFactoryId();
        }

        @JsonProperty
        public short getOtype() {
            return this.packet.getHeader().getODSSubheader().getObjectType();
        }

        @JsonProperty
        public IStoreObject.EncodingType getContentEncodingType() {
            return IStoreObject.EncodingType.fromMessageViewEncoding(this.packet.getHeader().getODSSubheader().getContentEncodingType());
        }

        @JsonProperty
        @JsonSerialize(converter=RogUtil.TimestampToDateConverter.class)
        public final long getTimestamp() {
            return this.packet.getHeader().getODSSubheader().getTimestamp();
        }

        @JsonProperty(value="commitStart")
        public final boolean isCommitStart() {
            return this.packet.getHeader().getODSSubheader().getFlagCommitStart();
        }

        @JsonProperty(value="commitEnd")
        public final boolean isCommitEnd() {
            return this.packet.getHeader().getODSSubheader().getFlagCommitEnd();
        }

        @JsonProperty
        public final long getTransactionId() {
            return this.packet.getHeader().getODSSubheader().getTransactionId();
        }

        @JsonProperty
        public final long getStableTransactionId() {
            return this.packet.getHeader().getODSSubheader().getStableTransactionId();
        }

        @JsonProperty
        public final long getCheckpointVersion() {
            return this.packet.getHeader().getODSSubheader().getCheckpointVersion();
        }

        @JsonProperty
        public IRogMetadata getMetadata() {
            if (this.object != null && this.object instanceof IRogNode) {
                return ((IRogNode)this.object).getMetadata();
            }
            if (this.metadata == null) {
                PktSubheaderODS subheaderODS = this.packet.getHeader().getODSSubheader();
                this.metadata = RogDirectMetadata.createFrom(subheaderODS.getBuffer(), subheaderODS.getObjectMetadataOffset());
            }
            return this.metadata;
        }

        public static final String getHeaderRow(boolean csv) {
            return csv ? headerRowCsv : headerRow;
        }

        public final String toString() {
            return this.toTabular();
        }

        public final String toString(boolean csv) {
            return csv ? this.toCsv() : this.toTabular();
        }

        public final void dispose() {
            if (this.packet != null) {
                this.packet.dispose();
            }
            if (this.object != null) {
                this.object.dispose();
            }
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }

        public final Entry init() {
            this.object = null;
            this.metadata = null;
            return this;
        }

        public final Entry setPool(UtlPool<Entry> pool) {
            this.pool = pool;
            return this;
        }

        public final UtlPool<Entry> getPool() {
            return this.pool;
        }

        static {
            headerRow = "I=InboundMsgsInTxn?\nO=OutboundMsgsInTxn?\nD=PossibleDup?\nS=CommitStart?\nE=CommitEnd?\n" + String.format("%4s | %30s | %36s | %36s | %7s | %8s| %7s | %7s | %7s | %7s | %s | %s | %s | %s | %s", "Type", "Class", "ObjectId", "ParentId", "TxnId", "StblTxId", "InSeq#", "OutSeq#", "MsgSeq#", "ChkPnt#", "I", "O", "D", "S", "E");
            IdxFieldResolver fieldResolver = RogLogFactory.createFieldResolver();
            PAYLOAD_TYPE = fieldResolver.getField(Entry.class, "object.class");
            FACTORY = UtlPool.create((String)"rog.log.entry", (String)"global", (UtlPool.Factory)new Factory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
            TRACER = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)RogConfig.getConfig());
        }

        public static enum Type {
            Put,
            Update,
            Remove,
            Send,
            Message;

        }

        private static final class Factory
        implements UtlPool.Factory<Entry> {
            private Factory() {
            }

            public final Entry createItem(Object object) {
                return new Entry();
            }

            public final Entry[] createItemArray(int size) {
                return new Entry[size];
            }
        }
    }

    public static final class Stats
    implements IStoreWriter.LogCounters {
        private static final String header = String.format("%12s | %12s | %12s | %12s | %12s |%12s | %12s | %12s | %12s | %12s", "TxnCount", "TxnOrphans", "TxnGaps", "TxnDups", "TxnParts", "Puts", "Updates", "Removes", "Sends", "Messages");
        private final NumberFormat format = NumberFormat.getInstance();
        private SkipCallback skipCallback;
        long lastTxnId = -1L;
        int numTransactions = 0;
        int numOrphans = 0;
        int numPuts = 0;
        int numUpdates = 0;
        int numRemoves = 0;
        int numSends = 0;
        int numMessages = 0;
        int numTxnDups = 0;
        int numTxnGaps = 0;
        int numTxnParts = 0;
        HashSet<Long> partialTxns;

        public Stats() {
            this.format.setMaximumFractionDigits(2);
        }

        final void setSkipCallback(SkipCallback cb) {
            this.skipCallback = cb;
        }

        final void update(Entry.Type type) {
            switch (type) {
                case Message: {
                    ++this.numMessages;
                    break;
                }
                case Put: {
                    ++this.numPuts;
                    break;
                }
                case Remove: {
                    ++this.numRemoves;
                    break;
                }
                case Send: {
                    ++this.numSends;
                    break;
                }
                case Update: {
                    ++this.numUpdates;
                }
            }
            if (this.skipCallback != null) {
                this.skipCallback.onSkip(type);
            }
        }

        final void update(Entry.Type type, long txnId, boolean commitEnd) {
            this.update(type);
            if (txnId == -1L) {
                ++this.numOrphans;
            } else if (commitEnd) {
                if (this.partialTxns != null && this.partialTxns.remove(txnId)) {
                    --this.numTxnParts;
                }
                boolean dup = false;
                if (txnId <= this.lastTxnId) {
                    ++this.numTxnDups;
                    dup = true;
                } else if (txnId != this.lastTxnId + 1L && this.lastTxnId != -1L) {
                    ++this.numTxnGaps;
                }
                ++this.numTransactions;
                if (!dup) {
                    this.lastTxnId = txnId;
                }
            } else {
                if (this.partialTxns == null) {
                    this.partialTxns = new HashSet();
                }
                if (!this.partialTxns.contains(txnId)) {
                    this.partialTxns.add(txnId);
                    ++this.numTxnParts;
                }
            }
        }

        final Entry update(Entry entry) {
            if (entry != null) {
                this.update(entry.getEntryType(), entry.getTransactionId(), entry.isCommitEnd());
            }
            return entry;
        }

        final void copy(Stats counters) {
            this.lastTxnId = counters.lastTxnId;
            this.numMessages = counters.numMessages;
            this.numOrphans = counters.numOrphans;
            this.numSends = counters.numSends;
            this.numPuts = counters.numPuts;
            this.numRemoves = counters.numRemoves;
            this.numTransactions = counters.numTransactions;
            this.numUpdates = counters.numUpdates;
            this.numTxnDups = counters.numTxnDups;
            this.numTxnGaps = counters.numTxnGaps;
            this.numTxnParts = counters.numTxnParts;
        }

        final void reset() {
            this.lastTxnId = -1L;
            this.numMessages = 0;
            this.numOrphans = 0;
            this.numSends = 0;
            this.numPuts = 0;
            this.numRemoves = 0;
            this.numTransactions = 0;
            this.numUpdates = 0;
            this.numTxnDups = 0;
            this.numTxnGaps = 0;
            this.numTxnParts = 0;
            this.partialTxns = null;
        }

        public static final String getHeaderRow() {
            return header;
        }

        public final Stats delta(Stats compare) {
            Stats rc = new Stats();
            rc.numMessages = compare.numMessages - this.numMessages;
            rc.numSends = compare.numSends - this.numSends;
            rc.numUpdates = compare.numUpdates - this.numUpdates;
            rc.numRemoves = compare.numRemoves - this.numRemoves;
            rc.numPuts = compare.numPuts - this.numPuts;
            rc.numTxnGaps = compare.numTxnGaps - this.numTxnGaps;
            rc.numTxnDups = compare.numTxnDups - this.numTxnDups;
            rc.numTxnParts = compare.numTxnParts - this.numTxnParts;
            rc.numOrphans = compare.numOrphans - this.numOrphans;
            rc.numTransactions = compare.numTransactions - this.numTransactions;
            return rc;
        }

        @Override
        public final int getNumOrphans() {
            return this.numOrphans;
        }

        @Override
        public final int getNumPuts() {
            return this.numPuts;
        }

        @Override
        public final int getNumUpdates() {
            return this.numUpdates;
        }

        @Override
        public final int getNumRemoves() {
            return this.numRemoves;
        }

        @Override
        public final int getNumSends() {
            return this.numSends;
        }

        @Override
        public final int getNumMessages() {
            return this.numMessages;
        }

        @Override
        public final int getNumTransactions() {
            return this.numTransactions;
        }

        @Override
        public final int getNumDupTransactions() {
            return this.numTxnDups;
        }

        @Override
        public final int getNumGapTransactions() {
            return this.numTxnGaps;
        }

        @Override
        public final int getNumPartialTransactions() {
            return this.numTxnParts;
        }

        public int getNumEntries() {
            return this.numPuts + this.numUpdates + this.numRemoves + this.numMessages + this.numSends;
        }

        public final String toString() {
            return String.format("%12s | %12s | %12s | %12s | %12s | %12s |%12s | %12s | %12s | %12s", this.format.format(this.numTransactions), this.format.format(this.numOrphans), this.format.format(this.numTxnGaps), this.format.format(this.numTxnDups), this.format.format(this.numTxnParts), this.format.format(this.numPuts), this.format.format(this.numUpdates), this.format.format(this.numRemoves), this.format.format(this.numSends), this.format.format(this.numMessages));
        }
    }

    private final class PacketReceiver
    implements PktRecoveryLog.IPacketBufferReceiver {
        private ReceiverAction action = ReceiverAction.CreateEntry;
        private int maxCount = 0;
        private int currentCount;
        private ReadCallback readCallback;
        private Entry entry;

        PacketReceiver() {
        }

        private final void updateStats(IOBuffer buffer, int bufferPosition, int packetLength, long filePosition) {
            long addr = buffer.getNativeAddress();
            int odsSubheaderOffset = PktHeader.getSubheaderOffset((long)addr, (int)bufferPosition, (int)7);
            Entry.Type entryType = Entry.toEntryType(PktSubheaderODS.getCommitEntryType((long)addr, (int)odsSubheaderOffset));
            long txnId = PktSubheaderODS.getTransactionId((long)addr, (int)odsSubheaderOffset);
            boolean commitEnd = (PktSubheaderODS.getFlags((long)addr, (int)odsSubheaderOffset) & 1) == 1;
            RogLogReader.this.stats.update(entryType, txnId, commitEnd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void createEntry(IOBuffer buffer, int bufferPosition, int packetLength, long filePosition) {
            block6: {
                int bodyType = PktHeader.getBodyType((IOBuffer)buffer, (int)bufferPosition);
                bodyType = PktFactory.getInstance().getPacketType(bodyType) != null ? bodyType : 257;
                PktPacket packet = PktFactory.getInstance().createPacket(bodyType);
                packet.deserialize(buffer, bufferPosition, true);
                try {
                    this.entry = Entry.create(RogLogReader.this.log(), packet, filePosition, packetLength);
                    if (this.readCallback == null) break block6;
                    try {
                        if (!RogLogReader.this.lazyDeserialization) {
                            this.entry.getObject();
                        }
                        this.readCallback.onRead(this.entry);
                    }
                    finally {
                        this.entry.dispose();
                    }
                }
                catch (OdsException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        final void setAction(ReceiverAction action) {
            this.action = action;
        }

        final ReceiverAction getAction() {
            return this.action;
        }

        final void setMaxCount(int val) {
            this.maxCount = val;
            this.currentCount = 0;
        }

        final void clearMaxCount() {
            this.maxCount = -1;
        }

        final void setReadCallback(ReadCallback cb) {
            this.readCallback = cb;
        }

        final Entry getEntry() {
            return this.entry;
        }

        public final void onPacket(IOBuffer buffer, int bufferPosition, int packetLength, long filePosition) {
            switch (this.action) {
                case UpdateStats: {
                    this.updateStats(buffer, bufferPosition, packetLength, filePosition);
                    break;
                }
                case CreateEntry: {
                    this.createEntry(buffer, bufferPosition, packetLength, filePosition);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown receiver action '" + (Object)((Object)this.action) + "'");
                }
            }
            if (this.maxCount > 0 && ++this.currentCount == this.maxCount) {
                RogLogReader.this.reader.stop();
            }
        }

        public final void onBufferChange(IOBuffer from, IOBuffer to) {
        }
    }

    private static enum ReceiverAction {
        UpdateStats,
        CreateEntry;

    }
}

